// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMVectorizedGetElementPtrNode#doLong}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMVectorizedGetElementPtrNode.class)
@SuppressWarnings("javadoc")
public final class LLVMVectorizedGetElementPtrNodeGen extends LLVMVectorizedGetElementPtrNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode child0_;
    @Child private LLVMExpressionNode child1_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMVectorizedGetElementPtrNode#doLong}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMVectorizedGetElementPtrNodeGen(long typeWidth, Type targetType, LLVMExpressionNode child0, LLVMExpressionNode child1) {
        super(typeWidth, targetType);
        this.child0_ = child0;
        this.child1_ = child1;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        Object child1Value_ = this.child1_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_, child1Value_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorizedGetElementPtrNode.doLong(LLVMPointerVector, LLVMI64Vector)] */ && child0Value_ instanceof LLVMPointerVector) {
            LLVMPointerVector child0Value__ = (LLVMPointerVector) child0Value_;
            if (child1Value_ instanceof LLVMI64Vector) {
                LLVMI64Vector child1Value__ = (LLVMI64Vector) child1Value_;
                return doLong(child0Value__, child1Value__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_, child1Value_);
    }

    private LLVMPointerVector executeAndSpecialize(Object child0Value, Object child1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (child0Value instanceof LLVMPointerVector) {
            LLVMPointerVector child0Value_ = (LLVMPointerVector) child0Value;
            if (child1Value instanceof LLVMI64Vector) {
                LLVMI64Vector child1Value_ = (LLVMI64Vector) child1Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.doLong(LLVMPointerVector, LLVMI64Vector)] */;
                this.state_0_ = state_0;
                return doLong(child0Value_, child1Value_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.child0_, this.child1_}, child0Value, child1Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            return NodeCost.MONOMORPHIC;
        }
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.doLong(LLVMPointerVector, LLVMI64Vector)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMVectorizedGetElementPtrNode create(long typeWidth, Type targetType, LLVMExpressionNode child0, LLVMExpressionNode child1) {
        return new LLVMVectorizedGetElementPtrNodeGen(typeWidth, targetType, child0, child1);
    }

    /**
     * Debug Info: <pre>
     *   Specialization {@link ResultVectorBroadcastNode#doPointer}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(ResultVectorBroadcastNode.class)
    @SuppressWarnings("javadoc")
    public static final class ResultVectorBroadcastNodeGen extends ResultVectorBroadcastNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode child0_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ResultVectorBroadcastNode#doPointer}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private ResultVectorBroadcastNodeGen(int vectorLength, LLVMExpressionNode child0) {
            super(vectorLength);
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(child0Value_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorizedGetElementPtrNode.ResultVectorBroadcastNode.doPointer(LLVMPointer)] */ && LLVMTypes.isPointer(child0Value_)) {
                LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
                return doPointer(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(child0Value_);
        }

        private LLVMPointerVector executeAndSpecialize(Object child0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.ResultVectorBroadcastNode.doPointer(LLVMPointer)] */;
                this.state_0_ = state_0;
                return doPointer(child0Value_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.child0_}, child0Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.ResultVectorBroadcastNode.doPointer(LLVMPointer)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ResultVectorBroadcastNode create(int vectorLength, LLVMExpressionNode child0) {
            return new ResultVectorBroadcastNodeGen(vectorLength, child0);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link IndexVectorBroadcastNode#doInt}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link IndexVectorBroadcastNode#doLong}
     *     Activation probability: 0.23095
     *     With/without class size: 6/0 bytes
     *   Specialization {@link IndexVectorBroadcastNode#doShort}
     *     Activation probability: 0.18810
     *     With/without class size: 6/0 bytes
     *   Specialization {@link IndexVectorBroadcastNode#doByte}
     *     Activation probability: 0.14524
     *     With/without class size: 5/0 bytes
     *   Specialization {@link IndexVectorBroadcastNode#doBoolean}
     *     Activation probability: 0.10238
     *     With/without class size: 5/0 bytes
     *   Specialization {@link IndexVectorBroadcastNode#doPointer}
     *     Activation probability: 0.05952
     *     With/without class size: 5/4 bytes
     * </pre>
     */
    @GeneratedBy(IndexVectorBroadcastNode.class)
    @SuppressWarnings("javadoc")
    public static final class IndexVectorBroadcastNodeGen extends IndexVectorBroadcastNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode child0_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link IndexVectorBroadcastNode#doInt}
         *   2: SpecializationActive {@link IndexVectorBroadcastNode#doLong}
         *   3: SpecializationActive {@link IndexVectorBroadcastNode#doShort}
         *   4: SpecializationActive {@link IndexVectorBroadcastNode#doByte}
         *   5: SpecializationActive {@link IndexVectorBroadcastNode#doBoolean}
         *   6: SpecializationActive {@link IndexVectorBroadcastNode#doPointer}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link IndexVectorBroadcastNode#doPointer}
         *   Parameter: {@link LLVMToNativeNode} toNative</pre>
         */
        @Child private LLVMToNativeNode pointer_toNative_;

        private IndexVectorBroadcastNodeGen(int vectorLength, LLVMExpressionNode child0) {
            super(vectorLength);
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111100) == 0 /* only-active SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doInt(int)] */ && ((state_0 & 0b1111110) != 0  /* is-not SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doInt(int)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doLong(long)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doShort(short)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doByte(byte)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doBoolean(boolean)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doPointer(LLVMPointer, LLVMToNativeNode)] */)) {
                return executeGeneric_int0(state_0, frameValue);
            } else if ((state_0 & 0b1111010) == 0 /* only-active SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doLong(long)] */ && ((state_0 & 0b1111110) != 0  /* is-not SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doInt(int)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doLong(long)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doShort(short)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doByte(byte)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doBoolean(boolean)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doPointer(LLVMPointer, LLVMToNativeNode)] */)) {
                return executeGeneric_long1(state_0, frameValue);
            } else if ((state_0 & 0b1110110) == 0 /* only-active SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doShort(short)] */ && ((state_0 & 0b1111110) != 0  /* is-not SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doInt(int)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doLong(long)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doShort(short)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doByte(byte)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doBoolean(boolean)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doPointer(LLVMPointer, LLVMToNativeNode)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b1101110) == 0 /* only-active SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doByte(byte)] */ && ((state_0 & 0b1111110) != 0  /* is-not SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doInt(int)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doLong(long)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doShort(short)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doByte(byte)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doBoolean(boolean)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doPointer(LLVMPointer, LLVMToNativeNode)] */)) {
                return executeGeneric_byte3(state_0, frameValue);
            } else if ((state_0 & 0b1011110) == 0 /* only-active SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doBoolean(boolean)] */ && ((state_0 & 0b1111110) != 0  /* is-not SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doInt(int)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doLong(long)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doShort(short)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doByte(byte)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doBoolean(boolean)] && SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doPointer(LLVMPointer, LLVMToNativeNode)] */)) {
                return executeGeneric_boolean4(state_0, frameValue);
            } else {
                return executeGeneric_generic5(state_0, frameValue);
            }
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int child0Value_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(child0Value_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doInt(int)] */;
            return doInt(child0Value_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long child0Value_;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(child0Value_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doLong(long)] */;
            return doLong(child0Value_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short child0Value_;
            try {
                child0Value_ = this.child0_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(child0Value_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doShort(short)] */;
            return doShort(child0Value_);
        }

        private Object executeGeneric_byte3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte child0Value_;
            try {
                child0Value_ = this.child0_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(child0Value_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doByte(byte)] */;
            return doByte(child0Value_);
        }

        private Object executeGeneric_boolean4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean child0Value_;
            try {
                child0Value_ = this.child0_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(child0Value_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doBoolean(boolean)] */;
            return doBoolean(child0Value_);
        }

        private Object executeGeneric_generic5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(child0Value_);
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doInt(int)] || SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doLong(long)] || SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doShort(short)] || SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doByte(byte)] || SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doBoolean(boolean)] || SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doPointer(LLVMPointer, LLVMToNativeNode)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doInt(int)] */ && child0Value_ instanceof Integer) {
                    int child0Value__ = (int) child0Value_;
                    return doInt(child0Value__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doLong(long)] */ && child0Value_ instanceof Long) {
                    long child0Value__ = (long) child0Value_;
                    return doLong(child0Value__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doShort(short)] */ && child0Value_ instanceof Short) {
                    short child0Value__ = (short) child0Value_;
                    return doShort(child0Value__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doByte(byte)] */ && child0Value_ instanceof Byte) {
                    byte child0Value__ = (byte) child0Value_;
                    return doByte(child0Value__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doBoolean(boolean)] */ && child0Value_ instanceof Boolean) {
                    boolean child0Value__ = (boolean) child0Value_;
                    return doBoolean(child0Value__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doPointer(LLVMPointer, LLVMToNativeNode)] */ && LLVMTypes.isPointer(child0Value_)) {
                    LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
                    {
                        LLVMToNativeNode toNative__ = this.pointer_toNative_;
                        if (toNative__ != null) {
                            return doPointer(child0Value__, toNative__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(child0Value_);
        }

        private LLVMI64Vector executeAndSpecialize(Object child0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof Integer) {
                int child0Value_ = (int) child0Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doInt(int)] */;
                this.state_0_ = state_0;
                return doInt(child0Value_);
            }
            if (child0Value instanceof Long) {
                long child0Value_ = (long) child0Value;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doLong(long)] */;
                this.state_0_ = state_0;
                return doLong(child0Value_);
            }
            if (child0Value instanceof Short) {
                short child0Value_ = (short) child0Value;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doShort(short)] */;
                this.state_0_ = state_0;
                return doShort(child0Value_);
            }
            if (child0Value instanceof Byte) {
                byte child0Value_ = (byte) child0Value;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doByte(byte)] */;
                this.state_0_ = state_0;
                return doByte(child0Value_);
            }
            if (child0Value instanceof Boolean) {
                boolean child0Value_ = (boolean) child0Value;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doBoolean(boolean)] */;
                this.state_0_ = state_0;
                return doBoolean(child0Value_);
            }
            if (LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                LLVMToNativeNode toNative__ = this.insert((LLVMToNativeNodeGen.create()));
                Objects.requireNonNull(toNative__, "Specialization 'doPointer(LLVMPointer, LLVMToNativeNode)' cache 'toNative' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.pointer_toNative_ = toNative__;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doPointer(LLVMPointer, LLVMToNativeNode)] */;
                this.state_0_ = state_0;
                return doPointer(child0Value_, toNative__);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.child0_}, child0Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doInt(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doLong(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doShort(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doByte(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doBoolean(boolean)] */;
            }
            {
                LLVMToNativeNode toNative__ = this.insert((LLVMToNativeNodeGen.create()));
                Objects.requireNonNull(toNative__, "Specialization 'doPointer(LLVMPointer, LLVMToNativeNode)' cache 'toNative' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.pointer_toNative_ = toNative__;
                assert NodeUtil.assertRecursion(this.pointer_toNative_, 1);
                ((GenerateAOT.Provider) this.pointer_toNative_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMVectorizedGetElementPtrNode.IndexVectorBroadcastNode.doPointer(LLVMPointer, LLVMToNativeNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_toNative_ = null;
        }

        @NeverDefault
        public static IndexVectorBroadcastNode create(int vectorLength, LLVMExpressionNode child0) {
            return new IndexVectorBroadcastNodeGen(vectorLength, child0);
        }

    }
}
