// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMI1LoadNode#doI1Native}
 *     Activation probability: 0.38500
 *     With/without class size: 8/0 bytes
 *   Specialization {@link LLVMI1LoadNode#doI1DerefHandle}
 *     Activation probability: 0.29500
 *     With/without class size: 11/8 bytes
 *   Specialization {@link LLVMI1LoadNode#doI1Managed}
 *     Activation probability: 0.20500
 *     With/without class size: 8/4 bytes
 *   Specialization {@link LLVMI1LoadNode#doI1Managed}
 *     Activation probability: 0.11500
 *     With/without class size: 5/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMI1LoadNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMI1LoadNodeGen extends LLVMI1LoadNode implements GenerateAOT.Provider {

    static final ReferenceField<I1Managed0Data> I1_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "i1Managed0_cache", I1Managed0Data.class);
    private static final LibraryFactory<LLVMManagedReadLibrary> L_L_V_M_MANAGED_READ_LIBRARY_ = LibraryFactory.resolve(LLVMManagedReadLibrary.class);

    @Child private LLVMExpressionNode address_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMI1LoadNode#doI1Native}
     *   2: SpecializationActive {@link LLVMI1LoadNode#doI1DerefHandle}
     *   3: SpecializationActive {@link LLVMI1LoadNode#doI1Managed}
     *   4: SpecializationActive {@link LLVMI1LoadNode#doI1Managed}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMI1LoadNode#doI1DerefHandle}
     *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
     */
    @Child private LLVMDerefHandleGetReceiverNode i1DerefHandle_getReceiver_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMI1LoadNode#doI1DerefHandle}
     *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
     */
    @Child private LLVMManagedReadLibrary i1DerefHandle_nativeRead_;
    @UnsafeAccessedField @Child private I1Managed0Data i1Managed0_cache;

    private LLVMI1LoadNodeGen(LLVMExpressionNode address) {
        this.address_ = address;
    }

    @ExplodeLoop
    @Override
    public Object executeWithTargetGeneric(Object addressValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Native(LLVMNativePointer)] || SpecializationActive[LLVMI1LoadNode.doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Native(LLVMNativePointer)] || SpecializationActive[LLVMI1LoadNode.doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Native(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        return doI1Native(addressValue_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.i1DerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.i1DerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue_))) {
                                    return doI1DerefHandle(addressValue_, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    I1Managed0Data s2_ = this.i1Managed0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                            return doI1Managed(addressValue_, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.i1Managed1Boundary(state_0, addressValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object i1Managed1Boundary(int state_0, LLVMManagedPointer addressValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return doI1Managed(addressValue_, nativeRead__1);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public boolean executeWithTarget(Object addressValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Native(LLVMNativePointer)] || SpecializationActive[LLVMI1LoadNode.doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Native(LLVMNativePointer)] || SpecializationActive[LLVMI1LoadNode.doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Native(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        return doI1Native(addressValue_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.i1DerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.i1DerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue_))) {
                                    return doI1DerefHandle(addressValue_, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    I1Managed0Data s2_ = this.i1Managed0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                            return doI1Managed(addressValue_, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.i1Managed1Boundary0(state_0, addressValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private boolean i1Managed1Boundary0(int state_0, LLVMManagedPointer addressValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return doI1Managed(addressValue_, nativeRead__1);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue_);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Native(LLVMNativePointer)] || SpecializationActive[LLVMI1LoadNode.doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Native(LLVMNativePointer)] || SpecializationActive[LLVMI1LoadNode.doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Native(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        return doI1Native(addressValue__);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.i1DerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.i1DerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue__))) {
                                    return doI1DerefHandle(addressValue__, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    I1Managed0Data s2_ = this.i1Managed0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue__.getObject()))) {
                            return doI1Managed(addressValue__, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.i1Managed1Boundary1(state_0, addressValue__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue_);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object i1Managed1Boundary1(int state_0, LLVMManagedPointer addressValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return doI1Managed(addressValue__, nativeRead__1);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public boolean executeI1(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue_);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Native(LLVMNativePointer)] || SpecializationActive[LLVMI1LoadNode.doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Native(LLVMNativePointer)] || SpecializationActive[LLVMI1LoadNode.doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Native(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        return doI1Native(addressValue__);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.i1DerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.i1DerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue__))) {
                                    return doI1DerefHandle(addressValue__, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    I1Managed0Data s2_ = this.i1Managed0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue__.getObject()))) {
                            return doI1Managed(addressValue__, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.i1Managed1Boundary2(state_0, addressValue__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue_);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private boolean i1Managed1Boundary2(int state_0, LLVMManagedPointer addressValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return doI1Managed(addressValue__, nativeRead__1);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    private boolean executeAndSpecialize(Object addressValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if ((!(isAutoDerefHandle(addressValue_)))) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMI1LoadNode.doI1Native(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doI1Native(addressValue_);
            }
            if ((isAutoDerefHandle(addressValue_))) {
                LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "Specialization 'doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.i1DerefHandle_getReceiver_ = getReceiver__;
                LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeRead__, "Specialization 'doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.i1DerefHandle_nativeRead_ = nativeRead__;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMI1LoadNode.doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                this.state_0_ = state_0;
                return doI1DerefHandle(addressValue_, getReceiver__, nativeRead__);
            }
        }
        if (LLVMTypes.isManagedPointer(addressValue)) {
            LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                while (true) {
                    int count2_ = 0;
                    I1Managed0Data s2_ = I1_MANAGED0_CACHE_UPDATER.getVolatile(this);
                    I1Managed0Data s2_original = s2_;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                            break;
                        }
                        count2_++;
                        s2_ = s2_.next_;
                    }
                    if (s2_ == null) {
                        // assert (s2_.nativeRead_.accepts(addressValue_.getObject()));
                        if (count2_ < (3)) {
                            s2_ = this.insert(new I1Managed0Data(s2_original));
                            LLVMManagedReadLibrary nativeRead__1 = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject())));
                            Objects.requireNonNull(nativeRead__1, "Specialization 'doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s2_.nativeRead_ = nativeRead__1;
                            if (!I1_MANAGED0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s2_ != null) {
                        return doI1Managed(addressValue_, s2_.nativeRead_);
                    }
                    break;
                }
            }
            {
                LLVMManagedReadLibrary nativeRead__1 = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                        this.i1Managed0_cache = null;
                        state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMI1LoadNode.doI1Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                        this.state_0_ = state_0;
                        return doI1Managed(addressValue_, nativeRead__1);
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                I1Managed0Data s2_ = this.i1Managed0_cache;
                if ((s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMI1LoadNode.doI1Native(LLVMNativePointer)] */;
        }
        {
            LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
            Objects.requireNonNull(getReceiver__, "Specialization 'doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.i1DerefHandle_getReceiver_ = getReceiver__;
            LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeRead__, "Specialization 'doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.i1DerefHandle_nativeRead_ = nativeRead__;
            assert NodeUtil.assertRecursion(this.i1DerefHandle_getReceiver_, 1);
            ((GenerateAOT.Provider) this.i1DerefHandle_getReceiver_).prepareForAOT(language, root);
            if (this.i1DerefHandle_nativeRead_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(this.i1DerefHandle_nativeRead_, 1);
                ((GenerateAOT.Provider) this.i1DerefHandle_nativeRead_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMI1LoadNode.doI1DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.i1DerefHandle_getReceiver_ = null;
        this.i1DerefHandle_nativeRead_ = null;
    }

    @NeverDefault
    public static LLVMI1LoadNode create(LLVMExpressionNode address) {
        return new LLVMI1LoadNodeGen(address);
    }

    @GeneratedBy(LLVMI1LoadNode.class)
    @DenyReplace
    private static final class I1Managed0Data extends Node implements SpecializationDataNode {

        @Child I1Managed0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI1LoadNode#doI1Managed}
         *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
         */
        @Child LLVMManagedReadLibrary nativeRead_;

        I1Managed0Data(I1Managed0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMI1OffsetLoadNode#doI1Native}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMI1OffsetLoadNode#doI1DerefHandle}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMI1OffsetLoadNode#doI1Managed}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMI1OffsetLoadNode#doI1Managed}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI1OffsetLoadNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI1OffsetLoadNodeGen extends LLVMI1OffsetLoadNode implements GenerateAOT.Provider {

        static final ReferenceField<I1Managed0Data> I1_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "i1Managed0_cache", I1Managed0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMI1OffsetLoadNode#doI1Native}
         *   2: SpecializationActive {@link LLVMI1OffsetLoadNode#doI1DerefHandle}
         *   3: SpecializationActive {@link LLVMI1OffsetLoadNode#doI1Managed}
         *   4: SpecializationActive {@link LLVMI1OffsetLoadNode#doI1Managed}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI1OffsetLoadNode#doI1DerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child private LLVMDerefHandleGetReceiverNode i1DerefHandle_getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI1OffsetLoadNode#doI1DerefHandle}
         *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
         */
        @Child private LLVMManagedReadLibrary i1DerefHandle_nativeRead_;
        @UnsafeAccessedField @Child private I1Managed0Data i1Managed0_cache;

        private LLVMI1OffsetLoadNodeGen() {
        }

        @ExplodeLoop
        @Override
        public Object executeWithTargetGeneric(LLVMPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Native(LLVMNativePointer, long)] || SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Native(LLVMNativePointer, long)] || SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Native(LLVMNativePointer, long)] */) {
                        if ((!(isAutoDerefHandle(arg0Value_)))) {
                            return doI1Native(arg0Value_, arg1Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.i1DerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedReadLibrary nativeRead__ = this.i1DerefHandle_nativeRead_;
                                if (nativeRead__ != null) {
                                    if ((isAutoDerefHandle(arg0Value_))) {
                                        return doI1DerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        I1Managed0Data s2_ = this.i1Managed0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                return doI1Managed(arg0Value_, arg1Value, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        return this.i1Managed1Boundary(state_0, arg0Value_, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object i1Managed1Boundary(int state_0, LLVMManagedPointer arg0Value_, long arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject()));
                    return doI1Managed(arg0Value_, arg1Value, nativeRead__1);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public boolean executeWithTarget(LLVMPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Native(LLVMNativePointer, long)] || SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Native(LLVMNativePointer, long)] || SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Native(LLVMNativePointer, long)] */) {
                        if ((!(isAutoDerefHandle(arg0Value_)))) {
                            return doI1Native(arg0Value_, arg1Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.i1DerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedReadLibrary nativeRead__ = this.i1DerefHandle_nativeRead_;
                                if (nativeRead__ != null) {
                                    if ((isAutoDerefHandle(arg0Value_))) {
                                        return doI1DerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        I1Managed0Data s2_ = this.i1Managed0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                return doI1Managed(arg0Value_, arg1Value, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        return this.i1Managed1Boundary0(state_0, arg0Value_, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private boolean i1Managed1Boundary0(int state_0, LLVMManagedPointer arg0Value_, long arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject()));
                    return doI1Managed(arg0Value_, arg1Value, nativeRead__1);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private boolean executeAndSpecialize(LLVMPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((!(isAutoDerefHandle(arg0Value_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Native(LLVMNativePointer, long)] */;
                    this.state_0_ = state_0;
                    return doI1Native(arg0Value_, arg1Value);
                }
                if ((isAutoDerefHandle(arg0Value_))) {
                    LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doI1DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.i1DerefHandle_getReceiver_ = getReceiver__;
                    LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                    Objects.requireNonNull(nativeRead__, "Specialization 'doI1DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.i1DerefHandle_nativeRead_ = nativeRead__;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                    this.state_0_ = state_0;
                    return doI1DerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                }
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        I1Managed0Data s2_ = I1_MANAGED0_CACHE_UPDATER.getVolatile(this);
                        I1Managed0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            // assert (s2_.nativeRead_.accepts(arg0Value_.getObject()));
                            if (count2_ < (3)) {
                                s2_ = this.insert(new I1Managed0Data(s2_original));
                                LLVMManagedReadLibrary nativeRead__1 = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(arg0Value_.getObject())));
                                Objects.requireNonNull(nativeRead__1, "Specialization 'doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.nativeRead_ = nativeRead__1;
                                if (!I1_MANAGED0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            return doI1Managed(arg0Value_, arg1Value, s2_.nativeRead_);
                        }
                        break;
                    }
                }
                {
                    LLVMManagedReadLibrary nativeRead__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject()));
                            this.i1Managed0_cache = null;
                            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return doI1Managed(arg0Value_, arg1Value, nativeRead__1);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    I1Managed0Data s2_ = this.i1Managed0_cache;
                    if ((s2_ == null || s2_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1Native(LLVMNativePointer, long)] */;
            }
            {
                LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "Specialization 'doI1DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.i1DerefHandle_getReceiver_ = getReceiver__;
                LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeRead__, "Specialization 'doI1DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.i1DerefHandle_nativeRead_ = nativeRead__;
                assert NodeUtil.assertRecursion(this.i1DerefHandle_getReceiver_, 1);
                ((GenerateAOT.Provider) this.i1DerefHandle_getReceiver_).prepareForAOT(language, root);
                if (this.i1DerefHandle_nativeRead_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.i1DerefHandle_nativeRead_, 1);
                    ((GenerateAOT.Provider) this.i1DerefHandle_nativeRead_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMI1LoadNode.LLVMI1OffsetLoadNode.doI1DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.i1DerefHandle_getReceiver_ = null;
            this.i1DerefHandle_nativeRead_ = null;
        }

        @NeverDefault
        public static LLVMI1OffsetLoadNode create() {
            return new LLVMI1OffsetLoadNodeGen();
        }

        @NeverDefault
        public static LLVMI1OffsetLoadNode getUncached() {
            return LLVMI1OffsetLoadNodeGen.UNCACHED;
        }

        @GeneratedBy(LLVMI1OffsetLoadNode.class)
        @DenyReplace
        private static final class I1Managed0Data extends Node implements SpecializationDataNode {

            @Child I1Managed0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMI1OffsetLoadNode#doI1Managed}
             *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
             */
            @Child LLVMManagedReadLibrary nativeRead_;

            I1Managed0Data(I1Managed0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMI1OffsetLoadNode.class)
        @DenyReplace
        private static final class Uncached extends LLVMI1OffsetLoadNode {

            @TruffleBoundary
            @Override
            public Object executeWithTargetGeneric(LLVMPointer arg0Value, long arg1Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((!(isAutoDerefHandle(arg0Value_)))) {
                        return doI1Native(arg0Value_, arg1Value);
                    }
                    if ((isAutoDerefHandle(arg0Value_))) {
                        return doI1DerefHandle(arg0Value_, arg1Value, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached()));
                    }
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return doI1Managed(arg0Value_, arg1Value, (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject())));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean executeWithTarget(LLVMPointer arg0Value, long arg1Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((!(isAutoDerefHandle(arg0Value_)))) {
                        return doI1Native(arg0Value_, arg1Value);
                    }
                    if ((isAutoDerefHandle(arg0Value_))) {
                        return doI1DerefHandle(arg0Value_, arg1Value, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached()));
                    }
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return doI1Managed(arg0Value_, arg1Value, (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject())));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
