// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMI64StoreNode#doOp(LLVMNativePointer, long)}
 *     Activation probability: 0.21250
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMI64StoreNode#doOpDerefHandleI64}
 *     Activation probability: 0.18750
 *     With/without class size: 8/8 bytes
 *   Specialization {@link LLVMI64StoreNode#doOpDerefHandle}
 *     Activation probability: 0.16250
 *     With/without class size: 7/8 bytes
 *   Specialization {@link LLVMI64StoreNode#doOpNative}
 *     Activation probability: 0.13750
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMI64StoreNode#doOp(LLVMNativePointer, Object, LLVMToNativeNode)}
 *     Activation probability: 0.11250
 *     With/without class size: 6/4 bytes
 *   Specialization {@link LLVMI64StoreNode#doOpManagedI64}
 *     Activation probability: 0.08750
 *     With/without class size: 6/4 bytes
 *   Specialization {@link LLVMI64StoreNode#doOpManaged}
 *     Activation probability: 0.06250
 *     With/without class size: 5/4 bytes
 *   Specialization {@link LLVMI64StoreNode#doOpManaged}
 *     Activation probability: 0.03750
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMI64StoreNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMI64StoreNodeGen extends LLVMI64StoreNode implements GenerateAOT.Provider {

    static final ReferenceField<OpManagedI64Data> OP_MANAGED_I64_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "opManagedI64_cache", OpManagedI64Data.class);
    static final ReferenceField<OpManaged0Data> OP_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "opManaged0_cache", OpManaged0Data.class);
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);

    @Child private LLVMExpressionNode address_;
    @Child private LLVMExpressionNode value_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMI64StoreNode#doOp(LLVMNativePointer, long)}
     *   2: SpecializationActive {@link LLVMI64StoreNode#doOpDerefHandleI64}
     *   3: SpecializationActive {@link LLVMI64StoreNode#doOpDerefHandle}
     *   4: SpecializationActive {@link LLVMI64StoreNode#doOpNative}
     *   5: SpecializationActive {@link LLVMI64StoreNode#doOp(LLVMNativePointer, Object, LLVMToNativeNode)}
     *   6: SpecializationActive {@link LLVMI64StoreNode#doOpManagedI64}
     *   7: SpecializationActive {@link LLVMI64StoreNode#doOpManaged}
     *   8: SpecializationActive {@link LLVMI64StoreNode#doOpManaged}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMI64StoreNode#doOpDerefHandleI64}
     *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
     */
    @Child private LLVMDerefHandleGetReceiverNode opDerefHandleI64_getReceiver_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMI64StoreNode#doOpDerefHandleI64}
     *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
     */
    @Child private LLVMManagedWriteLibrary opDerefHandleI64_nativeWrite_;
    @Child private OpDerefHandleData opDerefHandle_cache;
    @Child private Op1Data op1_cache;
    @UnsafeAccessedField @Child private OpManagedI64Data opManagedI64_cache;
    @UnsafeAccessedField @Child private OpManaged0Data opManaged0_cache;

    private LLVMI64StoreNodeGen(LLVMExpressionNode address, LLVMExpressionNode value) {
        this.address_ = address;
        this.value_ = value;
    }

    @ExplodeLoop
    @Override
    public void executeWithTarget(Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0b111111110) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpNative(LLVMNativePointer, LLVMNativePointer)] || SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, Object, LLVMToNativeNode)] || SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpNative(LLVMNativePointer, LLVMNativePointer)] || SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, Object, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && valueValue instanceof Long) {
                    long valueValue_ = (long) valueValue;
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] */) {
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            doOp(addressValue_, valueValue_);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandleI64_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandleI64_nativeWrite_;
                                if (nativeWrite__ != null) {
                                    if ((isAutoDerefHandle(addressValue_))) {
                                        LLVMI64StoreNode.doOpDerefHandleI64(addressValue_, valueValue_, getReceiver__, nativeWrite__);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                    OpDerefHandleData s2_ = this.opDerefHandle_cache;
                    if (s2_ != null) {
                        if ((isAutoDerefHandle(addressValue_))) {
                            LLVMI64StoreNode.doOpDerefHandle(addressValue_, valueValue, s2_.getReceiver_, s2_.nativeWrite_);
                            return;
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpNative(LLVMNativePointer, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(valueValue)) {
                    LLVMNativePointer valueValue_ = LLVMTypes.asNativePointer(valueValue);
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        doOpNative(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, Object, LLVMToNativeNode)] */) {
                    Op1Data s4_ = this.op1_cache;
                    if (s4_ != null) {
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            doOp(addressValue_, valueValue, s4_.toAddress_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0b111000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] */ && valueValue instanceof Long) {
                    long valueValue_ = (long) valueValue;
                    OpManagedI64Data s5_ = this.opManagedI64_cache;
                    while (s5_ != null) {
                        if ((s5_.nativeWrite_.accepts(addressValue_.getObject()))) {
                            LLVMI64StoreNode.doOpManagedI64(addressValue_, valueValue_, s5_.nativeWrite_);
                            return;
                        }
                        s5_ = s5_.next_;
                    }
                }
                if ((state_0 & 0b110000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */) {
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */) {
                        OpManaged0Data s6_ = this.opManaged0_cache;
                        while (s6_ != null) {
                            if ((s6_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                LLVMI64StoreNode.doOpManaged(addressValue_, valueValue, s6_.nativeWrite_);
                                return;
                            }
                            s6_ = s6_.next_;
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */) {
                        this.opManaged1Boundary(state_0, addressValue_, valueValue);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue, valueValue);
        return;
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void opManaged1Boundary(int state_0, LLVMManagedPointer addressValue_, Object valueValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                LLVMI64StoreNode.doOpManaged(addressValue_, valueValue, nativeWrite__1);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public void executeWithTarget(LLVMPointer addressValue, long valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0b111101110) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, Object, LLVMToNativeNode)] || SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b101110) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, Object, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] */) {
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            doOp(addressValue_, valueValue);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandleI64_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandleI64_nativeWrite_;
                                if (nativeWrite__ != null) {
                                    if ((isAutoDerefHandle(addressValue_))) {
                                        LLVMI64StoreNode.doOpDerefHandleI64(addressValue_, valueValue, getReceiver__, nativeWrite__);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b101000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, Object, LLVMToNativeNode)] */) {
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        OpDerefHandleData s2_ = this.opDerefHandle_cache;
                        if (s2_ != null) {
                            if ((isAutoDerefHandle(addressValue_))) {
                                LLVMI64StoreNode.doOpDerefHandle(addressValue_, valueValue, s2_.getReceiver_, s2_.nativeWrite_);
                                return;
                            }
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, Object, LLVMToNativeNode)] */) {
                        Op1Data s4_ = this.op1_cache;
                        if (s4_ != null) {
                            if ((!(isAutoDerefHandle(addressValue_)))) {
                                doOp(addressValue_, valueValue, s4_.toAddress_);
                                return;
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b111000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] */) {
                    OpManagedI64Data s5_ = this.opManagedI64_cache;
                    while (s5_ != null) {
                        if ((s5_.nativeWrite_.accepts(addressValue_.getObject()))) {
                            LLVMI64StoreNode.doOpManagedI64(addressValue_, valueValue, s5_.nativeWrite_);
                            return;
                        }
                        s5_ = s5_.next_;
                    }
                }
                if ((state_0 & 0b110000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */) {
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */) {
                        OpManaged0Data s6_ = this.opManaged0_cache;
                        while (s6_ != null) {
                            if ((s6_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                LLVMI64StoreNode.doOpManaged(addressValue_, valueValue, s6_.nativeWrite_);
                                return;
                            }
                            s6_ = s6_.next_;
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */) {
                        this.opManaged1Boundary0(state_0, addressValue_, valueValue);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue, valueValue);
        return;
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void opManaged1Boundary0(int state_0, LLVMManagedPointer addressValue_, long valueValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                LLVMI64StoreNode.doOpManaged(addressValue_, valueValue, nativeWrite__1);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110111000) == 0 /* only-active SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] && SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] && SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMI64StoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMI64StoreNode.doOpNative(LLVMNativePointer, LLVMNativePointer)] && SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, Object, LLVMToNativeNode)] && SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */)) {
            execute_long0(state_0, frameValue);
            return;
        } else {
            execute_generic1(state_0, frameValue);
            return;
        }
    }

    @ExplodeLoop
    private void execute_long0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        long valueValue_;
        try {
            valueValue_ = this.value_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(addressValue_, ex.getResult());
            return;
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue_, valueValue_);
            return;
        }
        if ((state_0 & 0b1000110) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] */) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        doOp(addressValue__, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandleI64_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandleI64_nativeWrite_;
                            if (nativeWrite__ != null) {
                                if ((isAutoDerefHandle(addressValue__))) {
                                    LLVMI64StoreNode.doOpDerefHandleI64(addressValue__, valueValue_, getReceiver__, nativeWrite__);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                OpManagedI64Data s5_ = this.opManagedI64_cache;
                while (s5_ != null) {
                    if ((s5_.nativeWrite_.accepts(addressValue__.getObject()))) {
                        LLVMI64StoreNode.doOpManagedI64(addressValue__, valueValue_, s5_.nativeWrite_);
                        return;
                    }
                    s5_ = s5_.next_;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue_, valueValue_);
        return;
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void opManaged1Boundary1(int state_0, LLVMManagedPointer addressValue__, Object valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
                LLVMI64StoreNode.doOpManaged(addressValue__, valueValue_, nativeWrite__1);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    private void execute_generic1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue_, valueValue_);
            return;
        }
        if ((state_0 & 0b111111110) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpNative(LLVMNativePointer, LLVMNativePointer)] || SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, Object, LLVMToNativeNode)] || SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpNative(LLVMNativePointer, LLVMNativePointer)] || SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, Object, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] || SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof Long) {
                    long valueValue__ = (long) valueValue_;
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] */) {
                        if ((!(isAutoDerefHandle(addressValue__)))) {
                            doOp(addressValue__, valueValue__);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandleI64_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandleI64_nativeWrite_;
                                if (nativeWrite__ != null) {
                                    if ((isAutoDerefHandle(addressValue__))) {
                                        LLVMI64StoreNode.doOpDerefHandleI64(addressValue__, valueValue__, getReceiver__, nativeWrite__);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                    OpDerefHandleData s2_ = this.opDerefHandle_cache;
                    if (s2_ != null) {
                        if ((isAutoDerefHandle(addressValue__))) {
                            LLVMI64StoreNode.doOpDerefHandle(addressValue__, valueValue_, s2_.getReceiver_, s2_.nativeWrite_);
                            return;
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpNative(LLVMNativePointer, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(valueValue_)) {
                    LLVMNativePointer valueValue__ = LLVMTypes.asNativePointer(valueValue_);
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        doOpNative(addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, Object, LLVMToNativeNode)] */) {
                    Op1Data s4_ = this.op1_cache;
                    if (s4_ != null) {
                        if ((!(isAutoDerefHandle(addressValue__)))) {
                            doOp(addressValue__, valueValue_, s4_.toAddress_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0b111000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof Long) {
                    long valueValue__ = (long) valueValue_;
                    OpManagedI64Data s5_ = this.opManagedI64_cache;
                    while (s5_ != null) {
                        if ((s5_.nativeWrite_.accepts(addressValue__.getObject()))) {
                            LLVMI64StoreNode.doOpManagedI64(addressValue__, valueValue__, s5_.nativeWrite_);
                            return;
                        }
                        s5_ = s5_.next_;
                    }
                }
                if ((state_0 & 0b110000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */) {
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */) {
                        OpManaged0Data s6_ = this.opManaged0_cache;
                        while (s6_ != null) {
                            if ((s6_.nativeWrite_.accepts(addressValue__.getObject()))) {
                                LLVMI64StoreNode.doOpManaged(addressValue__, valueValue_, s6_.nativeWrite_);
                                return;
                            }
                            s6_ = s6_.next_;
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */) {
                        this.opManaged1Boundary1(state_0, addressValue__, valueValue_);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue_, valueValue_);
        return;
    }

    private void executeAndSpecialize(Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if (valueValue instanceof Long) {
                long valueValue_ = (long) valueValue;
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] */;
                    this.state_0_ = state_0;
                    doOp(addressValue_, valueValue_);
                    return;
                }
                if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMI64StoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                    if ((isAutoDerefHandle(addressValue_))) {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                        Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.opDerefHandleI64_getReceiver_ = getReceiver__;
                        LLVMManagedWriteLibrary nativeWrite__ = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                        Objects.requireNonNull(nativeWrite__, "Specialization 'doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.opDerefHandleI64_nativeWrite_ = nativeWrite__;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                        this.state_0_ = state_0;
                        LLVMI64StoreNode.doOpDerefHandleI64(addressValue_, valueValue_, getReceiver__, nativeWrite__);
                        return;
                    }
                }
            }
            if ((isAutoDerefHandle(addressValue_))) {
                OpDerefHandleData s2_ = this.insert(new OpDerefHandleData());
                LLVMDerefHandleGetReceiverNode getReceiver__1 = s2_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__1, "Specialization 'doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s2_.getReceiver_ = getReceiver__1;
                LLVMManagedWriteLibrary nativeWrite__2 = s2_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeWrite__2, "Specialization 'doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s2_.nativeWrite_ = nativeWrite__2;
                VarHandle.storeStoreFence();
                this.opDerefHandle_cache = s2_;
                this.opDerefHandleI64_getReceiver_ = null;
                this.opDerefHandleI64_nativeWrite_ = null;
                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMI64StoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                this.state_0_ = state_0;
                LLVMI64StoreNode.doOpDerefHandle(addressValue_, valueValue, getReceiver__1, nativeWrite__2);
                return;
            }
            if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, Object, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(valueValue)) {
                LLVMNativePointer valueValue_ = LLVMTypes.asNativePointer(valueValue);
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMI64StoreNode.doOpNative(LLVMNativePointer, LLVMNativePointer)] */;
                    this.state_0_ = state_0;
                    doOpNative(addressValue_, valueValue_);
                    return;
                }
            }
            if ((!(isAutoDerefHandle(addressValue_)))) {
                Op1Data s4_ = this.insert(new Op1Data());
                s4_.toAddress_ = s4_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.op1_cache = s4_;
                state_0 = state_0 & 0xffffffef /* remove SpecializationActive[LLVMI64StoreNode.doOpNative(LLVMNativePointer, LLVMNativePointer)] */;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, Object, LLVMToNativeNode)] */;
                this.state_0_ = state_0;
                doOp(addressValue_, valueValue, s4_.toAddress_);
                return;
            }
        }
        if (LLVMTypes.isManagedPointer(addressValue)) {
            LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            if (((state_0 & 0b110000000)) == 0 /* is-not SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */ && valueValue instanceof Long) {
                long valueValue_ = (long) valueValue;
                while (true) {
                    int count5_ = 0;
                    OpManagedI64Data s5_ = OP_MANAGED_I64_CACHE_UPDATER.getVolatile(this);
                    OpManagedI64Data s5_original = s5_;
                    while (s5_ != null) {
                        if ((s5_.nativeWrite_.accepts(addressValue_.getObject()))) {
                            break;
                        }
                        count5_++;
                        s5_ = s5_.next_;
                    }
                    if (s5_ == null) {
                        // assert (s5_.nativeWrite_.accepts(addressValue_.getObject()));
                        if (count5_ < (3)) {
                            s5_ = this.insert(new OpManagedI64Data(s5_original));
                            LLVMManagedWriteLibrary nativeWrite__3 = s5_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject())));
                            Objects.requireNonNull(nativeWrite__3, "Specialization 'doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s5_.nativeWrite_ = nativeWrite__3;
                            if (!OP_MANAGED_I64_CACHE_UPDATER.compareAndSet(this, s5_original, s5_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s5_ != null) {
                        LLVMI64StoreNode.doOpManagedI64(addressValue_, valueValue_, s5_.nativeWrite_);
                        return;
                    }
                    break;
                }
            }
            if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */) {
                while (true) {
                    int count6_ = 0;
                    OpManaged0Data s6_ = OP_MANAGED0_CACHE_UPDATER.getVolatile(this);
                    OpManaged0Data s6_original = s6_;
                    while (s6_ != null) {
                        if ((s6_.nativeWrite_.accepts(addressValue_.getObject()))) {
                            break;
                        }
                        count6_++;
                        s6_ = s6_.next_;
                    }
                    if (s6_ == null) {
                        // assert (s6_.nativeWrite_.accepts(addressValue_.getObject()));
                        if (count6_ < (3)) {
                            s6_ = this.insert(new OpManaged0Data(s6_original));
                            LLVMManagedWriteLibrary nativeWrite__1 = s6_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject())));
                            Objects.requireNonNull(nativeWrite__1, "Specialization 'doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s6_.nativeWrite_ = nativeWrite__1;
                            if (!OP_MANAGED0_CACHE_UPDATER.compareAndSet(this, s6_original, s6_)) {
                                continue;
                            }
                            this.opManagedI64_cache = null;
                            state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)] */;
                            state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s6_ != null) {
                        LLVMI64StoreNode.doOpManaged(addressValue_, valueValue, s6_.nativeWrite_);
                        return;
                    }
                    break;
                }
            }
            {
                LLVMManagedWriteLibrary nativeWrite__1 = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                        this.opManagedI64_cache = null;
                        this.opManaged0_cache = null;
                        state_0 = state_0 & 0xffffff3f /* remove SpecializationActive[LLVMI64StoreNode.doOpManagedI64(LLVMManagedPointer, long, LLVMManagedWriteLibrary)], SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */;
                        state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMI64StoreNode.doOpManaged(LLVMManagedPointer, Object, LLVMManagedWriteLibrary)] */;
                        this.state_0_ = state_0;
                        LLVMI64StoreNode.doOpManaged(addressValue_, valueValue, nativeWrite__1);
                        return;
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_, this.value_}, addressValue, valueValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111111110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b111111110) & ((state_0 & 0b111111110) - 1)) == 0 /* is-single  */) {
                OpManagedI64Data s5_ = this.opManagedI64_cache;
                OpManaged0Data s6_ = this.opManaged0_cache;
                if ((s5_ == null || s5_.next_ == null) && (s6_ == null || s6_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, long)] */;
        }
        {
            OpDerefHandleData s2_ = this.insert(new OpDerefHandleData());
            LLVMDerefHandleGetReceiverNode getReceiver__1 = s2_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
            Objects.requireNonNull(getReceiver__1, "Specialization 'doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s2_.getReceiver_ = getReceiver__1;
            LLVMManagedWriteLibrary nativeWrite__2 = s2_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeWrite__2, "Specialization 'doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s2_.nativeWrite_ = nativeWrite__2;
            VarHandle.storeStoreFence();
            this.opDerefHandle_cache = s2_;
            this.opDerefHandleI64_getReceiver_ = null;
            this.opDerefHandleI64_nativeWrite_ = null;
            this.state_0_ = state_0_ & 0xfffffffb /* remove SpecializationActive[LLVMI64StoreNode.doOpDerefHandleI64(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
            assert NodeUtil.assertRecursion(s2_.getReceiver_, 1);
            ((GenerateAOT.Provider) s2_.getReceiver_).prepareForAOT(language, root);
            if (s2_.nativeWrite_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(s2_.nativeWrite_, 1);
                ((GenerateAOT.Provider) s2_.nativeWrite_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMI64StoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
        }
        {
            Op1Data s4_ = this.insert(new Op1Data());
            s4_.toAddress_ = s4_.insert((LLVMToNativeNode.createToNativeWithTarget()));
            VarHandle.storeStoreFence();
            this.op1_cache = s4_;
            this.state_0_ = state_0_ & 0xffffffef /* remove SpecializationActive[LLVMI64StoreNode.doOpNative(LLVMNativePointer, LLVMNativePointer)] */;
            assert NodeUtil.assertRecursion(s4_.toAddress_, 1);
            ((GenerateAOT.Provider) s4_.toAddress_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMI64StoreNode.doOp(LLVMNativePointer, Object, LLVMToNativeNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.opDerefHandle_cache = null;
        this.op1_cache = null;
    }

    @NeverDefault
    public static LLVMI64StoreNode create(LLVMExpressionNode address, LLVMExpressionNode value) {
        return new LLVMI64StoreNodeGen(address, value);
    }

    @GeneratedBy(LLVMI64StoreNode.class)
    @DenyReplace
    private static final class OpDerefHandleData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64StoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child LLVMDerefHandleGetReceiverNode getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64StoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        OpDerefHandleData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMI64StoreNode.class)
    @DenyReplace
    private static final class Op1Data extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64StoreNode#doOp(LLVMNativePointer, Object, LLVMToNativeNode)}
         *   Parameter: {@link LLVMToNativeNode} toAddress</pre>
         */
        @Child LLVMToNativeNode toAddress_;

        Op1Data() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMI64StoreNode.class)
    @DenyReplace
    private static final class OpManagedI64Data extends Node implements SpecializationDataNode {

        @Child OpManagedI64Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64StoreNode#doOpManagedI64}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        OpManagedI64Data(OpManagedI64Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMI64StoreNode.class)
    @DenyReplace
    private static final class OpManaged0Data extends Node implements SpecializationDataNode {

        @Child OpManaged0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64StoreNode#doOpManaged}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        OpManaged0Data(OpManaged0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMI64OffsetStoreNode#doOp(LLVMNativePointer, long, long)}
     *     Activation probability: 0.21250
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMI64OffsetStoreNode#doOpDerefHandleI64}
     *     Activation probability: 0.18750
     *     With/without class size: 8/8 bytes
     *   Specialization {@link LLVMI64OffsetStoreNode#doOpDerefHandle}
     *     Activation probability: 0.16250
     *     With/without class size: 7/8 bytes
     *   Specialization {@link LLVMI64OffsetStoreNode#doOpNative}
     *     Activation probability: 0.13750
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMI64OffsetStoreNode#doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)}
     *     Activation probability: 0.11250
     *     With/without class size: 6/4 bytes
     *   Specialization {@link LLVMI64OffsetStoreNode#doOpManagedI64}
     *     Activation probability: 0.08750
     *     With/without class size: 6/4 bytes
     *   Specialization {@link LLVMI64OffsetStoreNode#doOpManaged}
     *     Activation probability: 0.06250
     *     With/without class size: 5/4 bytes
     *   Specialization {@link LLVMI64OffsetStoreNode#doOpManaged}
     *     Activation probability: 0.03750
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI64OffsetStoreNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI64OffsetStoreNodeGen extends LLVMI64OffsetStoreNode implements GenerateAOT.Provider {

        static final ReferenceField<OpManagedI64Data> OP_MANAGED_I64_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "opManagedI64_cache", OpManagedI64Data.class);
        static final ReferenceField<OpManaged0Data> OP_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "opManaged0_cache", OpManaged0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private LLVMExpressionNode target_;
        @Child private LLVMExpressionNode offset_;
        @Child private LLVMExpressionNode value_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMI64OffsetStoreNode#doOp(LLVMNativePointer, long, long)}
         *   2: SpecializationActive {@link LLVMI64OffsetStoreNode#doOpDerefHandleI64}
         *   3: SpecializationActive {@link LLVMI64OffsetStoreNode#doOpDerefHandle}
         *   4: SpecializationActive {@link LLVMI64OffsetStoreNode#doOpNative}
         *   5: SpecializationActive {@link LLVMI64OffsetStoreNode#doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)}
         *   6: SpecializationActive {@link LLVMI64OffsetStoreNode#doOpManagedI64}
         *   7: SpecializationActive {@link LLVMI64OffsetStoreNode#doOpManaged}
         *   8: SpecializationActive {@link LLVMI64OffsetStoreNode#doOpManaged}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64OffsetStoreNode#doOpDerefHandleI64}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child private LLVMDerefHandleGetReceiverNode opDerefHandleI64_getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64OffsetStoreNode#doOpDerefHandleI64}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child private LLVMManagedWriteLibrary opDerefHandleI64_nativeWrite_;
        @Child private OpDerefHandleData opDerefHandle_cache;
        @Child private Op1Data op1_cache;
        @UnsafeAccessedField @Child private OpManagedI64Data opManagedI64_cache;
        @UnsafeAccessedField @Child private OpManaged0Data opManaged0_cache;

        private LLVMI64OffsetStoreNodeGen(LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            this.target_ = target;
            this.offset_ = offset;
            this.value_ = value;
        }

        @ExplodeLoop
        @Override
        public void executeWithTargetGeneric(LLVMPointer targetValue, long offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue);
                return;
            }
            if ((state_0 & 0b111111110) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpNative(LLVMNativePointer, long, LLVMNativePointer)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */) {
                if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpNative(LLVMNativePointer, long, LLVMNativePointer)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && valueValue instanceof Long) {
                        long valueValue_ = (long) valueValue;
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] */) {
                            if ((!(isAutoDerefHandle(targetValue_)))) {
                                doOp(targetValue_, offsetValue, valueValue_);
                                return;
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                            {
                                LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandleI64_getReceiver_;
                                if (getReceiver__ != null) {
                                    LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandleI64_nativeWrite_;
                                    if (nativeWrite__ != null) {
                                        if ((isAutoDerefHandle(targetValue_))) {
                                            LLVMI64OffsetStoreNode.doOpDerefHandleI64(targetValue_, offsetValue, valueValue_, getReceiver__, nativeWrite__);
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        OpDerefHandleData s2_ = this.opDerefHandle_cache;
                        if (s2_ != null) {
                            if ((isAutoDerefHandle(targetValue_))) {
                                LLVMI64OffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue, s2_.getReceiver_, s2_.nativeWrite_);
                                return;
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpNative(LLVMNativePointer, long, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(valueValue)) {
                        LLVMNativePointer valueValue_ = LLVMTypes.asNativePointer(valueValue);
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOpNative(targetValue_, offsetValue, valueValue_);
                            return;
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)] */) {
                        Op1Data s4_ = this.op1_cache;
                        if (s4_ != null) {
                            if ((!(isAutoDerefHandle(targetValue_)))) {
                                doOp(targetValue_, offsetValue, valueValue, s4_.toAddress_);
                                return;
                            }
                        }
                    }
                }
                if ((state_0 & 0b111000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] */ && valueValue instanceof Long) {
                        long valueValue_ = (long) valueValue;
                        OpManagedI64Data s5_ = this.opManagedI64_cache;
                        while (s5_ != null) {
                            if ((s5_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVMI64OffsetStoreNode.doOpManagedI64(targetValue_, offsetValue, valueValue_, s5_.nativeWrite_);
                                return;
                            }
                            s5_ = s5_.next_;
                        }
                    }
                    if ((state_0 & 0b110000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */) {
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */) {
                            OpManaged0Data s6_ = this.opManaged0_cache;
                            while (s6_ != null) {
                                if ((s6_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                    LLVMI64OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue, s6_.nativeWrite_);
                                    return;
                                }
                                s6_ = s6_.next_;
                            }
                        }
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */) {
                            this.opManaged1Boundary(state_0, targetValue_, offsetValue, valueValue);
                            return;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void opManaged1Boundary(int state_0, LLVMManagedPointer targetValue_, long offsetValue, Object valueValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                    LLVMI64OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue, nativeWrite__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public void executeWithTarget(LLVMPointer targetValue, long offsetValue, long valueValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue);
                return;
            }
            if ((state_0 & 0b111101110) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */) {
                if ((state_0 & 0b101110) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] */) {
                            if ((!(isAutoDerefHandle(targetValue_)))) {
                                doOp(targetValue_, offsetValue, valueValue);
                                return;
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                            {
                                LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandleI64_getReceiver_;
                                if (getReceiver__ != null) {
                                    LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandleI64_nativeWrite_;
                                    if (nativeWrite__ != null) {
                                        if ((isAutoDerefHandle(targetValue_))) {
                                            LLVMI64OffsetStoreNode.doOpDerefHandleI64(targetValue_, offsetValue, valueValue, getReceiver__, nativeWrite__);
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b101000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)] */) {
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                            OpDerefHandleData s2_ = this.opDerefHandle_cache;
                            if (s2_ != null) {
                                if ((isAutoDerefHandle(targetValue_))) {
                                    LLVMI64OffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue, s2_.getReceiver_, s2_.nativeWrite_);
                                    return;
                                }
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)] */) {
                            Op1Data s4_ = this.op1_cache;
                            if (s4_ != null) {
                                if ((!(isAutoDerefHandle(targetValue_)))) {
                                    doOp(targetValue_, offsetValue, valueValue, s4_.toAddress_);
                                    return;
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b111000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] */) {
                        OpManagedI64Data s5_ = this.opManagedI64_cache;
                        while (s5_ != null) {
                            if ((s5_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVMI64OffsetStoreNode.doOpManagedI64(targetValue_, offsetValue, valueValue, s5_.nativeWrite_);
                                return;
                            }
                            s5_ = s5_.next_;
                        }
                    }
                    if ((state_0 & 0b110000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */) {
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */) {
                            OpManaged0Data s6_ = this.opManaged0_cache;
                            while (s6_ != null) {
                                if ((s6_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                    LLVMI64OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue, s6_.nativeWrite_);
                                    return;
                                }
                                s6_ = s6_.next_;
                            }
                        }
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */) {
                            this.opManaged1Boundary0(state_0, targetValue_, offsetValue, valueValue);
                            return;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void opManaged1Boundary0(int state_0, LLVMManagedPointer targetValue_, long offsetValue, long valueValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                    LLVMI64OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue, nativeWrite__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110111000) == 0 /* only-active SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] && SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] && SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpNative(LLVMNativePointer, long, LLVMNativePointer)] && SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)] && SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */)) {
                executeWithTarget_long0(state_0, frameValue, targetValue, offsetValue);
                return;
            } else {
                executeWithTarget_generic1(state_0, frameValue, targetValue, offsetValue);
                return;
            }
        }

        @ExplodeLoop
        private void executeWithTarget_long0(int state_0__, VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
            int state_0 = state_0__;
            long valueValue_;
            try {
                valueValue_ = this.value_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(targetValue, offsetValue, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue_);
                return;
            }
            if ((state_0 & 0b1000110) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] */) {
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue_);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandleI64_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandleI64_nativeWrite_;
                                if (nativeWrite__ != null) {
                                    if ((isAutoDerefHandle(targetValue_))) {
                                        LLVMI64OffsetStoreNode.doOpDerefHandleI64(targetValue_, offsetValue, valueValue_, getReceiver__, nativeWrite__);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    OpManagedI64Data s5_ = this.opManagedI64_cache;
                    while (s5_ != null) {
                        if ((s5_.nativeWrite_.accepts(targetValue_.getObject()))) {
                            LLVMI64OffsetStoreNode.doOpManagedI64(targetValue_, offsetValue, valueValue_, s5_.nativeWrite_);
                            return;
                        }
                        s5_ = s5_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue_);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void opManaged1Boundary1(int state_0, LLVMManagedPointer targetValue_, long offsetValue, Object valueValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                    LLVMI64OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, nativeWrite__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        private void executeWithTarget_generic1(int state_0__, VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
            int state_0 = state_0__;
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue_);
                return;
            }
            if ((state_0 & 0b111111110) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpNative(LLVMNativePointer, long, LLVMNativePointer)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */) {
                if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpNative(LLVMNativePointer, long, LLVMNativePointer)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof Long) {
                        long valueValue__ = (long) valueValue_;
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] */) {
                            if ((!(isAutoDerefHandle(targetValue_)))) {
                                doOp(targetValue_, offsetValue, valueValue__);
                                return;
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                            {
                                LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandleI64_getReceiver_;
                                if (getReceiver__ != null) {
                                    LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandleI64_nativeWrite_;
                                    if (nativeWrite__ != null) {
                                        if ((isAutoDerefHandle(targetValue_))) {
                                            LLVMI64OffsetStoreNode.doOpDerefHandleI64(targetValue_, offsetValue, valueValue__, getReceiver__, nativeWrite__);
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        OpDerefHandleData s2_ = this.opDerefHandle_cache;
                        if (s2_ != null) {
                            if ((isAutoDerefHandle(targetValue_))) {
                                LLVMI64OffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue_, s2_.getReceiver_, s2_.nativeWrite_);
                                return;
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpNative(LLVMNativePointer, long, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(valueValue_)) {
                        LLVMNativePointer valueValue__ = LLVMTypes.asNativePointer(valueValue_);
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOpNative(targetValue_, offsetValue, valueValue__);
                            return;
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)] */) {
                        Op1Data s4_ = this.op1_cache;
                        if (s4_ != null) {
                            if ((!(isAutoDerefHandle(targetValue_)))) {
                                doOp(targetValue_, offsetValue, valueValue_, s4_.toAddress_);
                                return;
                            }
                        }
                    }
                }
                if ((state_0 & 0b111000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof Long) {
                        long valueValue__ = (long) valueValue_;
                        OpManagedI64Data s5_ = this.opManagedI64_cache;
                        while (s5_ != null) {
                            if ((s5_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVMI64OffsetStoreNode.doOpManagedI64(targetValue_, offsetValue, valueValue__, s5_.nativeWrite_);
                                return;
                            }
                            s5_ = s5_.next_;
                        }
                    }
                    if ((state_0 & 0b110000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */) {
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */) {
                            OpManaged0Data s6_ = this.opManaged0_cache;
                            while (s6_ != null) {
                                if ((s6_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                    LLVMI64OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, s6_.nativeWrite_);
                                    return;
                                }
                                s6_ = s6_.next_;
                            }
                        }
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */) {
                            this.opManaged1Boundary1(state_0, targetValue_, offsetValue, valueValue_);
                            return;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue_);
            return;
        }

        private void executeAndSpecialize(Object targetValue, Object offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (offsetValue instanceof Long) {
                long offsetValue_ = (long) offsetValue;
                if (LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if (valueValue instanceof Long) {
                        long valueValue_ = (long) valueValue;
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] */;
                            this.state_0_ = state_0;
                            doOp(targetValue_, offsetValue_, valueValue_);
                            return;
                        }
                        if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                            if ((isAutoDerefHandle(targetValue_))) {
                                LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                                Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.opDerefHandleI64_getReceiver_ = getReceiver__;
                                LLVMManagedWriteLibrary nativeWrite__ = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                                Objects.requireNonNull(nativeWrite__, "Specialization 'doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.opDerefHandleI64_nativeWrite_ = nativeWrite__;
                                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                                this.state_0_ = state_0;
                                LLVMI64OffsetStoreNode.doOpDerefHandleI64(targetValue_, offsetValue_, valueValue_, getReceiver__, nativeWrite__);
                                return;
                            }
                        }
                    }
                    if ((isAutoDerefHandle(targetValue_))) {
                        OpDerefHandleData s2_ = this.insert(new OpDerefHandleData());
                        LLVMDerefHandleGetReceiverNode getReceiver__1 = s2_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                        Objects.requireNonNull(getReceiver__1, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s2_.getReceiver_ = getReceiver__1;
                        LLVMManagedWriteLibrary nativeWrite__2 = s2_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                        Objects.requireNonNull(nativeWrite__2, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s2_.nativeWrite_ = nativeWrite__2;
                        VarHandle.storeStoreFence();
                        this.opDerefHandle_cache = s2_;
                        this.opDerefHandleI64_getReceiver_ = null;
                        this.opDerefHandleI64_nativeWrite_ = null;
                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                        this.state_0_ = state_0;
                        LLVMI64OffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue_, valueValue, getReceiver__1, nativeWrite__2);
                        return;
                    }
                    if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(valueValue)) {
                        LLVMNativePointer valueValue_ = LLVMTypes.asNativePointer(valueValue);
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpNative(LLVMNativePointer, long, LLVMNativePointer)] */;
                            this.state_0_ = state_0;
                            doOpNative(targetValue_, offsetValue_, valueValue_);
                            return;
                        }
                    }
                    if ((!(isAutoDerefHandle(targetValue_)))) {
                        Op1Data s4_ = this.insert(new Op1Data());
                        s4_.toAddress_ = s4_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                        VarHandle.storeStoreFence();
                        this.op1_cache = s4_;
                        state_0 = state_0 & 0xffffffef /* remove SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpNative(LLVMNativePointer, long, LLVMNativePointer)] */;
                        state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)] */;
                        this.state_0_ = state_0;
                        doOp(targetValue_, offsetValue_, valueValue, s4_.toAddress_);
                        return;
                    }
                }
                if (LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if (((state_0 & 0b110000000)) == 0 /* is-not SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */ && valueValue instanceof Long) {
                        long valueValue_ = (long) valueValue;
                        while (true) {
                            int count5_ = 0;
                            OpManagedI64Data s5_ = OP_MANAGED_I64_CACHE_UPDATER.getVolatile(this);
                            OpManagedI64Data s5_original = s5_;
                            while (s5_ != null) {
                                if ((s5_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                    break;
                                }
                                count5_++;
                                s5_ = s5_.next_;
                            }
                            if (s5_ == null) {
                                // assert (s5_.nativeWrite_.accepts(targetValue_.getObject()));
                                if (count5_ < (3)) {
                                    s5_ = this.insert(new OpManagedI64Data(s5_original));
                                    LLVMManagedWriteLibrary nativeWrite__3 = s5_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(targetValue_.getObject())));
                                    Objects.requireNonNull(nativeWrite__3, "Specialization 'doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s5_.nativeWrite_ = nativeWrite__3;
                                    if (!OP_MANAGED_I64_CACHE_UPDATER.compareAndSet(this, s5_original, s5_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s5_ != null) {
                                LLVMI64OffsetStoreNode.doOpManagedI64(targetValue_, offsetValue_, valueValue_, s5_.nativeWrite_);
                                return;
                            }
                            break;
                        }
                    }
                    if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */) {
                        while (true) {
                            int count6_ = 0;
                            OpManaged0Data s6_ = OP_MANAGED0_CACHE_UPDATER.getVolatile(this);
                            OpManaged0Data s6_original = s6_;
                            while (s6_ != null) {
                                if ((s6_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                    break;
                                }
                                count6_++;
                                s6_ = s6_.next_;
                            }
                            if (s6_ == null) {
                                // assert (s6_.nativeWrite_.accepts(targetValue_.getObject()));
                                if (count6_ < (3)) {
                                    s6_ = this.insert(new OpManaged0Data(s6_original));
                                    LLVMManagedWriteLibrary nativeWrite__1 = s6_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(targetValue_.getObject())));
                                    Objects.requireNonNull(nativeWrite__1, "Specialization 'doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s6_.nativeWrite_ = nativeWrite__1;
                                    if (!OP_MANAGED0_CACHE_UPDATER.compareAndSet(this, s6_original, s6_)) {
                                        continue;
                                    }
                                    this.opManagedI64_cache = null;
                                    state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)] */;
                                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s6_ != null) {
                                LLVMI64OffsetStoreNode.doOpManaged(targetValue_, offsetValue_, valueValue, s6_.nativeWrite_);
                                return;
                            }
                            break;
                        }
                    }
                    {
                        LLVMManagedWriteLibrary nativeWrite__1 = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                                this.opManagedI64_cache = null;
                                this.opManaged0_cache = null;
                                state_0 = state_0 & 0xffffff3f /* remove SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManagedI64(LLVMManagedPointer, long, long, LLVMManagedWriteLibrary)], SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */;
                                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, Object, LLVMManagedWriteLibrary)] */;
                                this.state_0_ = state_0;
                                LLVMI64OffsetStoreNode.doOpManaged(targetValue_, offsetValue_, valueValue, nativeWrite__1);
                                return;
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.target_, this.offset_, this.value_}, targetValue, offsetValue, valueValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b111111110) & ((state_0 & 0b111111110) - 1)) == 0 /* is-single  */) {
                    OpManagedI64Data s5_ = this.opManagedI64_cache;
                    OpManaged0Data s6_ = this.opManaged0_cache;
                    if ((s5_ == null || s5_.next_ == null) && (s6_ == null || s6_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, long)] */;
            }
            {
                OpDerefHandleData s2_ = this.insert(new OpDerefHandleData());
                LLVMDerefHandleGetReceiverNode getReceiver__1 = s2_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__1, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s2_.getReceiver_ = getReceiver__1;
                LLVMManagedWriteLibrary nativeWrite__2 = s2_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeWrite__2, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s2_.nativeWrite_ = nativeWrite__2;
                VarHandle.storeStoreFence();
                this.opDerefHandle_cache = s2_;
                this.opDerefHandleI64_getReceiver_ = null;
                this.opDerefHandleI64_nativeWrite_ = null;
                this.state_0_ = state_0_ & 0xfffffffb /* remove SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandleI64(LLVMNativePointer, long, long, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                assert NodeUtil.assertRecursion(s2_.getReceiver_, 1);
                ((GenerateAOT.Provider) s2_.getReceiver_).prepareForAOT(language, root);
                if (s2_.nativeWrite_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(s2_.nativeWrite_, 1);
                    ((GenerateAOT.Provider) s2_.nativeWrite_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
            }
            {
                Op1Data s4_ = this.insert(new Op1Data());
                s4_.toAddress_ = s4_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.op1_cache = s4_;
                this.state_0_ = state_0_ & 0xffffffef /* remove SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOpNative(LLVMNativePointer, long, LLVMNativePointer)] */;
                assert NodeUtil.assertRecursion(s4_.toAddress_, 1);
                ((GenerateAOT.Provider) s4_.toAddress_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMI64StoreNode.LLVMI64OffsetStoreNode.doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.opDerefHandle_cache = null;
            this.op1_cache = null;
        }

        @NeverDefault
        public static LLVMI64OffsetStoreNode create(LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            return new LLVMI64OffsetStoreNodeGen(target, offset, value);
        }

        @NeverDefault
        public static LLVMI64OffsetStoreNode getUncached() {
            return LLVMI64OffsetStoreNodeGen.UNCACHED;
        }

        @GeneratedBy(LLVMI64OffsetStoreNode.class)
        @DenyReplace
        private static final class OpDerefHandleData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMI64OffsetStoreNode#doOpDerefHandle}
             *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
             */
            @Child LLVMDerefHandleGetReceiverNode getReceiver_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMI64OffsetStoreNode#doOpDerefHandle}
             *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
             */
            @Child LLVMManagedWriteLibrary nativeWrite_;

            OpDerefHandleData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMI64OffsetStoreNode.class)
        @DenyReplace
        private static final class Op1Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMI64OffsetStoreNode#doOp(LLVMNativePointer, long, Object, LLVMToNativeNode)}
             *   Parameter: {@link LLVMToNativeNode} toAddress</pre>
             */
            @Child LLVMToNativeNode toAddress_;

            Op1Data() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMI64OffsetStoreNode.class)
        @DenyReplace
        private static final class OpManagedI64Data extends Node implements SpecializationDataNode {

            @Child OpManagedI64Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMI64OffsetStoreNode#doOpManagedI64}
             *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
             */
            @Child LLVMManagedWriteLibrary nativeWrite_;

            OpManagedI64Data(OpManagedI64Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMI64OffsetStoreNode.class)
        @DenyReplace
        private static final class OpManaged0Data extends Node implements SpecializationDataNode {

            @Child OpManaged0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMI64OffsetStoreNode#doOpManaged}
             *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
             */
            @Child LLVMManagedWriteLibrary nativeWrite_;

            OpManaged0Data(OpManaged0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMI64OffsetStoreNode.class)
        @DenyReplace
        private static final class Uncached extends LLVMI64OffsetStoreNode {

            @TruffleBoundary
            @Override
            public void executeWithTargetGeneric(LLVMPointer targetValue, long offsetValue, Object valueValue) {
                if (LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if (valueValue instanceof Long) {
                        long valueValue_ = (long) valueValue;
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue_);
                            return;
                        }
                    }
                    if ((isAutoDerefHandle(targetValue_))) {
                        LLVMI64OffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                        return;
                    }
                    if ((!(isAutoDerefHandle(targetValue_)))) {
                        doOp(targetValue_, offsetValue, valueValue, (LLVMToNativeNodeGen.getUncached()));
                        return;
                    }
                }
                if (LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    LLVMI64OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue, (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject())));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, targetValue, offsetValue, valueValue);
            }

            @TruffleBoundary
            @Override
            public void executeWithTarget(LLVMPointer targetValue, long offsetValue, long valueValue) {
                if (LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((!(isAutoDerefHandle(targetValue_)))) {
                        doOp(targetValue_, offsetValue, valueValue);
                        return;
                    }
                    if ((isAutoDerefHandle(targetValue_))) {
                        LLVMI64OffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                        return;
                    }
                    if ((!(isAutoDerefHandle(targetValue_)))) {
                        doOp(targetValue_, offsetValue, valueValue, (LLVMToNativeNodeGen.getUncached()));
                        return;
                    }
                }
                if (LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    LLVMI64OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue, (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject())));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, targetValue, offsetValue, valueValue);
            }

            @Override
            public void executeWithTarget(VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
                throw CompilerDirectives.shouldNotReachHere("This execute method cannot be used for uncached node versions as it requires child nodes to be present. Use an execute method that takes all arguments as parameters.");
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
