// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesLongPointerGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport.ToNativePointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory.ToNativePointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshl_I16;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshl_I16Vector;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshl_I32;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshl_I32Vector;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshl_I64;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshl_I64Vector;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshl_I8;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshl_I8Vector;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshr_I16;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshr_I16Vector;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshr_I32;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshr_I32Vector;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshr_I64;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshr_I64Vector;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshr_I8;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode.Fshr_I8Vector;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMFunnelShiftNode.class)
@SuppressWarnings("javadoc")
public final class LLVMFunnelShiftNodeFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshl_I8#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshl_I8.class)
    @SuppressWarnings("javadoc")
    public static final class Fshl_I8NodeGen extends Fshl_I8 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshl_I8#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshl_I8NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            byte shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I8.doFshl(byte, byte, byte)] */) {
                return doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            byte shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I8.doFshl(byte, byte, byte)] */) {
                return doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private byte executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Byte) {
                byte leftValue_ = (byte) leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (byte) rightValue;
                    if (shiftValue instanceof Byte) {
                        byte shiftValue_ = (byte) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I8.doFshl(byte, byte, byte)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I8.doFshl(byte, byte, byte)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshl_I8 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I8NodeGen(left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshl_I8Vector#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshl_I8Vector.class)
    @SuppressWarnings("javadoc")
    public static final class Fshl_I8VectorNodeGen extends Fshl_I8Vector implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshl_I8Vector#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshl_I8VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I8Vector.doFshl(LLVMI8Vector, LLVMI8Vector, LLVMI8Vector)] */ && leftValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector leftValue__ = (LLVMI8Vector) leftValue_;
                if (rightValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector rightValue__ = (LLVMI8Vector) rightValue_;
                    if (shiftValue_ instanceof LLVMI8Vector) {
                        LLVMI8Vector shiftValue__ = (LLVMI8Vector) shiftValue_;
                        return doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI8Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI8Vector) {
                LLVMI8Vector leftValue_ = (LLVMI8Vector) leftValue;
                if (rightValue instanceof LLVMI8Vector) {
                    LLVMI8Vector rightValue_ = (LLVMI8Vector) rightValue;
                    if (shiftValue instanceof LLVMI8Vector) {
                        LLVMI8Vector shiftValue_ = (LLVMI8Vector) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I8Vector.doFshl(LLVMI8Vector, LLVMI8Vector, LLVMI8Vector)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I8Vector.doFshl(LLVMI8Vector, LLVMI8Vector, LLVMI8Vector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshl_I8Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I8VectorNodeGen(vectorSize, left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshl_I16#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshl_I16.class)
    @SuppressWarnings("javadoc")
    public static final class Fshl_I16NodeGen extends Fshl_I16 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshl_I16#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshl_I16NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            short shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I16.doFshl(short, short, short)] */) {
                return doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            short shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I16.doFshl(short, short, short)] */) {
                return doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private short executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Short) {
                short leftValue_ = (short) leftValue;
                if (rightValue instanceof Short) {
                    short rightValue_ = (short) rightValue;
                    if (shiftValue instanceof Short) {
                        short shiftValue_ = (short) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I16.doFshl(short, short, short)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I16.doFshl(short, short, short)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshl_I16 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I16NodeGen(left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshl_I16Vector#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshl_I16Vector.class)
    @SuppressWarnings("javadoc")
    public static final class Fshl_I16VectorNodeGen extends Fshl_I16Vector implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshl_I16Vector#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshl_I16VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I16Vector.doFshl(LLVMI16Vector, LLVMI16Vector, LLVMI16Vector)] */ && leftValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector leftValue__ = (LLVMI16Vector) leftValue_;
                if (rightValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector rightValue__ = (LLVMI16Vector) rightValue_;
                    if (shiftValue_ instanceof LLVMI16Vector) {
                        LLVMI16Vector shiftValue__ = (LLVMI16Vector) shiftValue_;
                        return doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI16Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI16Vector) {
                LLVMI16Vector leftValue_ = (LLVMI16Vector) leftValue;
                if (rightValue instanceof LLVMI16Vector) {
                    LLVMI16Vector rightValue_ = (LLVMI16Vector) rightValue;
                    if (shiftValue instanceof LLVMI16Vector) {
                        LLVMI16Vector shiftValue_ = (LLVMI16Vector) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I16Vector.doFshl(LLVMI16Vector, LLVMI16Vector, LLVMI16Vector)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I16Vector.doFshl(LLVMI16Vector, LLVMI16Vector, LLVMI16Vector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshl_I16Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I16VectorNodeGen(vectorSize, left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshl_I32#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshl_I32.class)
    @SuppressWarnings("javadoc")
    public static final class Fshl_I32NodeGen extends Fshl_I32 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshl_I32#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshl_I32NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            int shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I32.doFshl(int, int, int)] */) {
                return doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            int shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I32.doFshl(int, int, int)] */) {
                return doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private int executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Integer) {
                int leftValue_ = (int) leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (int) rightValue;
                    if (shiftValue instanceof Integer) {
                        int shiftValue_ = (int) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I32.doFshl(int, int, int)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I32.doFshl(int, int, int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshl_I32 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I32NodeGen(left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshl_I32Vector#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshl_I32Vector.class)
    @SuppressWarnings("javadoc")
    public static final class Fshl_I32VectorNodeGen extends Fshl_I32Vector implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshl_I32Vector#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshl_I32VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I32Vector.doFshl(LLVMI32Vector, LLVMI32Vector, LLVMI32Vector)] */ && leftValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector leftValue__ = (LLVMI32Vector) leftValue_;
                if (rightValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector rightValue__ = (LLVMI32Vector) rightValue_;
                    if (shiftValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector shiftValue__ = (LLVMI32Vector) shiftValue_;
                        return doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI32Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI32Vector) {
                LLVMI32Vector leftValue_ = (LLVMI32Vector) leftValue;
                if (rightValue instanceof LLVMI32Vector) {
                    LLVMI32Vector rightValue_ = (LLVMI32Vector) rightValue;
                    if (shiftValue instanceof LLVMI32Vector) {
                        LLVMI32Vector shiftValue_ = (LLVMI32Vector) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I32Vector.doFshl(LLVMI32Vector, LLVMI32Vector, LLVMI32Vector)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I32Vector.doFshl(LLVMI32Vector, LLVMI32Vector, LLVMI32Vector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshl_I32Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I32VectorNodeGen(vectorSize, left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshl_I64#doFshl(long, long, long)}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link Fshl_I64#doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)}
     *     Activation probability: 0.35000
     *     With/without class size: 12/8 bytes
     * </pre>
     */
    @GeneratedBy(Fshl_I64.class)
    @SuppressWarnings("javadoc")
    public static final class Fshl_I64NodeGen extends Fshl_I64 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshl_I64#doFshl(long, long, long)}
         *   2: SpecializationActive {@link Fshl_I64#doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)}
         *   3-4: ImplicitCast[type=LLVMPointer, index=0]
         *   5-6: ImplicitCast[type=LLVMPointer, index=1]
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link Fshl_I64#doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)}
         *   Parameter: {@link ToNativePointerNode} toNativePointerLeft</pre>
         */
        @Child private ToNativePointerNode fshl1_toNativePointerLeft_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link Fshl_I64#doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)}
         *   Parameter: {@link ToNativePointerNode} toNativePointerRight</pre>
         */
        @Child private ToNativePointerNode fshl1_toNativePointerRight_;

        private Fshl_I64NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(long, long, long)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(long, long, long)] && SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)] */)) {
                return executeGeneric_long_long_long0(state_0, frameValue);
            } else if ((state_0 & 0b10) == 0 /* only-active SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(long, long, long)] && SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)] */)) {
                return executeGeneric_long1(state_0, frameValue);
            } else {
                return executeGeneric_generic2(state_0, frameValue);
            }
        }

        private Object executeGeneric_long_long_long0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            long shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(long, long, long)] */;
            return doFshl(leftValue_, rightValue_, shiftValue_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            long shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)] */;
            if (LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=LLVMPointer, index=0] */, leftValue_)) {
                LLVMPointer leftValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=LLVMPointer, index=0] */, leftValue_);
                if (LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=LLVMPointer, index=1] */, rightValue_)) {
                    LLVMPointer rightValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=LLVMPointer, index=1] */, rightValue_);
                    {
                        ToNativePointerNode toNativePointerLeft__ = this.fshl1_toNativePointerLeft_;
                        if (toNativePointerLeft__ != null) {
                            ToNativePointerNode toNativePointerRight__ = this.fshl1_toNativePointerRight_;
                            if (toNativePointerRight__ != null) {
                                return doFshl(leftValue__, rightValue__, shiftValue_, toNativePointerLeft__, toNativePointerRight__);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            long shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(long, long, long)] || SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(long, long, long)] */ && leftValue_ instanceof Long) {
                    long leftValue__ = (long) leftValue_;
                    if (rightValue_ instanceof Long) {
                        long rightValue__ = (long) rightValue_;
                        return doFshl(leftValue__, rightValue__, shiftValue_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)] */ && LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=LLVMPointer, index=0] */, leftValue_)) {
                    LLVMPointer leftValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=LLVMPointer, index=0] */, leftValue_);
                    if (LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=LLVMPointer, index=1] */, rightValue_)) {
                        LLVMPointer rightValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=LLVMPointer, index=1] */, rightValue_);
                        {
                            ToNativePointerNode toNativePointerLeft__ = this.fshl1_toNativePointerLeft_;
                            if (toNativePointerLeft__ != null) {
                                ToNativePointerNode toNativePointerRight__ = this.fshl1_toNativePointerRight_;
                                if (toNativePointerRight__ != null) {
                                    return doFshl(leftValue__, rightValue__, shiftValue_, toNativePointerLeft__, toNativePointerRight__);
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(long, long, long)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(long, long, long)] && SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)] */)) {
                return executeI64_long_long_long3(state_0, frameValue);
            } else if ((state_0 & 0b10) == 0 /* only-active SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(long, long, long)] && SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)] */)) {
                return executeI64_long4(state_0, frameValue);
            } else {
                return executeI64_generic5(state_0, frameValue);
            }
        }

        private long executeI64_long_long_long3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            long shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(long, long, long)] */;
            return doFshl(leftValue_, rightValue_, shiftValue_);
        }

        private long executeI64_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            long shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)] */;
            if (LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=LLVMPointer, index=0] */, leftValue_)) {
                LLVMPointer leftValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=LLVMPointer, index=0] */, leftValue_);
                if (LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=LLVMPointer, index=1] */, rightValue_)) {
                    LLVMPointer rightValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=LLVMPointer, index=1] */, rightValue_);
                    {
                        ToNativePointerNode toNativePointerLeft__ = this.fshl1_toNativePointerLeft_;
                        if (toNativePointerLeft__ != null) {
                            ToNativePointerNode toNativePointerRight__ = this.fshl1_toNativePointerRight_;
                            if (toNativePointerRight__ != null) {
                                return doFshl(leftValue__, rightValue__, shiftValue_, toNativePointerLeft__, toNativePointerRight__);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private long executeI64_generic5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            long shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(long, long, long)] || SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(long, long, long)] */ && leftValue_ instanceof Long) {
                    long leftValue__ = (long) leftValue_;
                    if (rightValue_ instanceof Long) {
                        long rightValue__ = (long) rightValue_;
                        return doFshl(leftValue__, rightValue__, shiftValue_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)] */ && LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=LLVMPointer, index=0] */, leftValue_)) {
                    LLVMPointer leftValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=LLVMPointer, index=0] */, leftValue_);
                    if (LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=LLVMPointer, index=1] */, rightValue_)) {
                        LLVMPointer rightValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=LLVMPointer, index=1] */, rightValue_);
                        {
                            ToNativePointerNode toNativePointerLeft__ = this.fshl1_toNativePointerLeft_;
                            if (toNativePointerLeft__ != null) {
                                ToNativePointerNode toNativePointerRight__ = this.fshl1_toNativePointerRight_;
                                if (toNativePointerRight__ != null) {
                                    return doFshl(leftValue__, rightValue__, shiftValue_, toNativePointerLeft__, toNativePointerRight__);
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private long executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (shiftValue instanceof Long) {
                long shiftValue_ = (long) shiftValue;
                if (leftValue instanceof Long) {
                    long leftValue_ = (long) leftValue;
                    if (rightValue instanceof Long) {
                        long rightValue_ = (long) rightValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(long, long, long)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
                {
                    int lLVMPointerCast0;
                    if ((lLVMPointerCast0 = LLVMTypesLongPointerGen.specializeImplicitLLVMPointer(leftValue)) != 0) {
                        LLVMPointer leftValue_ = LLVMTypesLongPointerGen.asImplicitLLVMPointer(lLVMPointerCast0, leftValue);
                        int lLVMPointerCast1;
                        if ((lLVMPointerCast1 = LLVMTypesLongPointerGen.specializeImplicitLLVMPointer(rightValue)) != 0) {
                            LLVMPointer rightValue_ = LLVMTypesLongPointerGen.asImplicitLLVMPointer(lLVMPointerCast1, rightValue);
                            ToNativePointerNode toNativePointerLeft__ = this.insert((ToNativePointerNodeGen.create()));
                            Objects.requireNonNull(toNativePointerLeft__, "Specialization 'doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)' cache 'toNativePointerLeft' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            VarHandle.storeStoreFence();
                            this.fshl1_toNativePointerLeft_ = toNativePointerLeft__;
                            ToNativePointerNode toNativePointerRight__ = this.insert((ToNativePointerNodeGen.create()));
                            Objects.requireNonNull(toNativePointerRight__, "Specialization 'doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)' cache 'toNativePointerRight' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            VarHandle.storeStoreFence();
                            this.fshl1_toNativePointerRight_ = toNativePointerRight__;
                            state_0 = (state_0 | (lLVMPointerCast0 << 3) /* set-int ImplicitCast[type=LLVMPointer, index=0] */);
                            state_0 = (state_0 | (lLVMPointerCast1 << 5) /* set-int ImplicitCast[type=LLVMPointer, index=1] */);
                            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)] */;
                            this.state_0_ = state_0;
                            return doFshl(leftValue_, rightValue_, shiftValue_, toNativePointerLeft__, toNativePointerRight__);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(long, long, long)] */;
            }
            {
                ToNativePointerNode toNativePointerLeft__ = this.insert((ToNativePointerNodeGen.create()));
                Objects.requireNonNull(toNativePointerLeft__, "Specialization 'doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)' cache 'toNativePointerLeft' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.fshl1_toNativePointerLeft_ = toNativePointerLeft__;
                ToNativePointerNode toNativePointerRight__ = this.insert((ToNativePointerNodeGen.create()));
                Objects.requireNonNull(toNativePointerRight__, "Specialization 'doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)' cache 'toNativePointerRight' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.fshl1_toNativePointerRight_ = toNativePointerRight__;
                assert NodeUtil.assertRecursion(this.fshl1_toNativePointerLeft_, 1);
                ((GenerateAOT.Provider) this.fshl1_toNativePointerLeft_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(this.fshl1_toNativePointerRight_, 1);
                ((GenerateAOT.Provider) this.fshl1_toNativePointerRight_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I64.doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            state_0 = state_0 | 0b1111000 /* add ImplicitCast[type=LLVMPointer, index=0], ImplicitCast[type=LLVMPointer, index=1] */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.fshl1_toNativePointerLeft_ = null;
            this.fshl1_toNativePointerRight_ = null;
        }

        @NeverDefault
        public static Fshl_I64 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I64NodeGen(left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshl_I64Vector#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshl_I64Vector.class)
    @SuppressWarnings("javadoc")
    public static final class Fshl_I64VectorNodeGen extends Fshl_I64Vector implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshl_I64Vector#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshl_I64VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshl_I64Vector.doFshl(LLVMI64Vector, LLVMI64Vector, LLVMI64Vector)] */ && leftValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector leftValue__ = (LLVMI64Vector) leftValue_;
                if (rightValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector rightValue__ = (LLVMI64Vector) rightValue_;
                    if (shiftValue_ instanceof LLVMI64Vector) {
                        LLVMI64Vector shiftValue__ = (LLVMI64Vector) shiftValue_;
                        return doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI64Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI64Vector) {
                LLVMI64Vector leftValue_ = (LLVMI64Vector) leftValue;
                if (rightValue instanceof LLVMI64Vector) {
                    LLVMI64Vector rightValue_ = (LLVMI64Vector) rightValue;
                    if (shiftValue instanceof LLVMI64Vector) {
                        LLVMI64Vector shiftValue_ = (LLVMI64Vector) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I64Vector.doFshl(LLVMI64Vector, LLVMI64Vector, LLVMI64Vector)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshl_I64Vector.doFshl(LLVMI64Vector, LLVMI64Vector, LLVMI64Vector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshl_I64Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I64VectorNodeGen(vectorSize, left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshr_I8#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshr_I8.class)
    @SuppressWarnings("javadoc")
    public static final class Fshr_I8NodeGen extends Fshr_I8 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshr_I8#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshr_I8NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            byte shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshr_I8.doFshl(byte, byte, byte)] */) {
                return doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            byte shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshr_I8.doFshl(byte, byte, byte)] */) {
                return doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private byte executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Byte) {
                byte leftValue_ = (byte) leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (byte) rightValue;
                    if (shiftValue instanceof Byte) {
                        byte shiftValue_ = (byte) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I8.doFshl(byte, byte, byte)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I8.doFshl(byte, byte, byte)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshr_I8 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I8NodeGen(left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshr_I8Vector#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshr_I8Vector.class)
    @SuppressWarnings("javadoc")
    public static final class Fshr_I8VectorNodeGen extends Fshr_I8Vector implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshr_I8Vector#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshr_I8VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshr_I8Vector.doFshl(LLVMI8Vector, LLVMI8Vector, LLVMI8Vector)] */ && leftValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector leftValue__ = (LLVMI8Vector) leftValue_;
                if (rightValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector rightValue__ = (LLVMI8Vector) rightValue_;
                    if (shiftValue_ instanceof LLVMI8Vector) {
                        LLVMI8Vector shiftValue__ = (LLVMI8Vector) shiftValue_;
                        return doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI8Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI8Vector) {
                LLVMI8Vector leftValue_ = (LLVMI8Vector) leftValue;
                if (rightValue instanceof LLVMI8Vector) {
                    LLVMI8Vector rightValue_ = (LLVMI8Vector) rightValue;
                    if (shiftValue instanceof LLVMI8Vector) {
                        LLVMI8Vector shiftValue_ = (LLVMI8Vector) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I8Vector.doFshl(LLVMI8Vector, LLVMI8Vector, LLVMI8Vector)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I8Vector.doFshl(LLVMI8Vector, LLVMI8Vector, LLVMI8Vector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshr_I8Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I8VectorNodeGen(vectorSize, left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshr_I16#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshr_I16.class)
    @SuppressWarnings("javadoc")
    public static final class Fshr_I16NodeGen extends Fshr_I16 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshr_I16#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshr_I16NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            short shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshr_I16.doFshl(short, short, short)] */) {
                return doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            short shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshr_I16.doFshl(short, short, short)] */) {
                return doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private short executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Short) {
                short leftValue_ = (short) leftValue;
                if (rightValue instanceof Short) {
                    short rightValue_ = (short) rightValue;
                    if (shiftValue instanceof Short) {
                        short shiftValue_ = (short) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I16.doFshl(short, short, short)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I16.doFshl(short, short, short)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshr_I16 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I16NodeGen(left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshr_I16Vector#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshr_I16Vector.class)
    @SuppressWarnings("javadoc")
    public static final class Fshr_I16VectorNodeGen extends Fshr_I16Vector implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshr_I16Vector#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshr_I16VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshr_I16Vector.doFshl(LLVMI16Vector, LLVMI16Vector, LLVMI16Vector)] */ && leftValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector leftValue__ = (LLVMI16Vector) leftValue_;
                if (rightValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector rightValue__ = (LLVMI16Vector) rightValue_;
                    if (shiftValue_ instanceof LLVMI16Vector) {
                        LLVMI16Vector shiftValue__ = (LLVMI16Vector) shiftValue_;
                        return doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI16Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI16Vector) {
                LLVMI16Vector leftValue_ = (LLVMI16Vector) leftValue;
                if (rightValue instanceof LLVMI16Vector) {
                    LLVMI16Vector rightValue_ = (LLVMI16Vector) rightValue;
                    if (shiftValue instanceof LLVMI16Vector) {
                        LLVMI16Vector shiftValue_ = (LLVMI16Vector) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I16Vector.doFshl(LLVMI16Vector, LLVMI16Vector, LLVMI16Vector)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I16Vector.doFshl(LLVMI16Vector, LLVMI16Vector, LLVMI16Vector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshr_I16Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I16VectorNodeGen(vectorSize, left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshr_I32#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshr_I32.class)
    @SuppressWarnings("javadoc")
    public static final class Fshr_I32NodeGen extends Fshr_I32 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshr_I32#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshr_I32NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            int shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshr_I32.doFshl(int, int, int)] */) {
                return doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            int shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshr_I32.doFshl(int, int, int)] */) {
                return doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private int executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Integer) {
                int leftValue_ = (int) leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (int) rightValue;
                    if (shiftValue instanceof Integer) {
                        int shiftValue_ = (int) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I32.doFshl(int, int, int)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I32.doFshl(int, int, int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshr_I32 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I32NodeGen(left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshr_I32Vector#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshr_I32Vector.class)
    @SuppressWarnings("javadoc")
    public static final class Fshr_I32VectorNodeGen extends Fshr_I32Vector implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshr_I32Vector#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshr_I32VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshr_I32Vector.doFshl(LLVMI32Vector, LLVMI32Vector, LLVMI32Vector)] */ && leftValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector leftValue__ = (LLVMI32Vector) leftValue_;
                if (rightValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector rightValue__ = (LLVMI32Vector) rightValue_;
                    if (shiftValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector shiftValue__ = (LLVMI32Vector) shiftValue_;
                        return doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI32Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI32Vector) {
                LLVMI32Vector leftValue_ = (LLVMI32Vector) leftValue;
                if (rightValue instanceof LLVMI32Vector) {
                    LLVMI32Vector rightValue_ = (LLVMI32Vector) rightValue;
                    if (shiftValue instanceof LLVMI32Vector) {
                        LLVMI32Vector shiftValue_ = (LLVMI32Vector) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I32Vector.doFshl(LLVMI32Vector, LLVMI32Vector, LLVMI32Vector)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I32Vector.doFshl(LLVMI32Vector, LLVMI32Vector, LLVMI32Vector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshr_I32Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I32VectorNodeGen(vectorSize, left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshr_I64#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshr_I64.class)
    @SuppressWarnings("javadoc")
    public static final class Fshr_I64NodeGen extends Fshr_I64 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshr_I64#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshr_I64NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            long shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshr_I64.doFshl(long, long, long)] */) {
                return doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            long shiftValue_;
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshr_I64.doFshl(long, long, long)] */) {
                return doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private long executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Long) {
                long leftValue_ = (long) leftValue;
                if (rightValue instanceof Long) {
                    long rightValue_ = (long) rightValue;
                    if (shiftValue instanceof Long) {
                        long shiftValue_ = (long) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I64.doFshl(long, long, long)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I64.doFshl(long, long, long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshr_I64 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I64NodeGen(left, right, shift);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Fshr_I64Vector#doFshl}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Fshr_I64Vector.class)
    @SuppressWarnings("javadoc")
    public static final class Fshr_I64VectorNodeGen extends Fshr_I64Vector implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode shift_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link Fshr_I64Vector#doFshl}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private Fshr_I64VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunnelShiftNode.Fshr_I64Vector.doFshl(LLVMI64Vector, LLVMI64Vector, LLVMI64Vector)] */ && leftValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector leftValue__ = (LLVMI64Vector) leftValue_;
                if (rightValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector rightValue__ = (LLVMI64Vector) rightValue_;
                    if (shiftValue_ instanceof LLVMI64Vector) {
                        LLVMI64Vector shiftValue__ = (LLVMI64Vector) shiftValue_;
                        return doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI64Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI64Vector) {
                LLVMI64Vector leftValue_ = (LLVMI64Vector) leftValue;
                if (rightValue instanceof LLVMI64Vector) {
                    LLVMI64Vector rightValue_ = (LLVMI64Vector) rightValue;
                    if (shiftValue instanceof LLVMI64Vector) {
                        LLVMI64Vector shiftValue_ = (LLVMI64Vector) shiftValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I64Vector.doFshl(LLVMI64Vector, LLVMI64Vector, LLVMI64Vector)] */;
                        this.state_0_ = state_0;
                        return doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.shift_}, leftValue, rightValue, shiftValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFunnelShiftNode.Fshr_I64Vector.doFshl(LLVMI64Vector, LLVMI64Vector, LLVMI64Vector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static Fshr_I64Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I64VectorNodeGen(vectorSize, left, right, shift);
        }

    }
}
