// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMVectorArithmeticNode#doI1}
 *     Activation probability: 0.23929
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMVectorArithmeticNode#doI8}
 *     Activation probability: 0.20714
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMVectorArithmeticNode#doI16}
 *     Activation probability: 0.17500
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMVectorArithmeticNode#doI32}
 *     Activation probability: 0.14286
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMVectorArithmeticNode#doI64}
 *     Activation probability: 0.11071
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMVectorArithmeticNode#doFloat}
 *     Activation probability: 0.07857
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMVectorArithmeticNode#doDouble}
 *     Activation probability: 0.04643
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMVectorArithmeticNode.class)
@SuppressWarnings("javadoc")
public final class LLVMVectorArithmeticNodeGen extends LLVMVectorArithmeticNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode leftNode_;
    @Child private LLVMExpressionNode rightNode_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMVectorArithmeticNode#doI1}
     *   2: SpecializationActive {@link LLVMVectorArithmeticNode#doI8}
     *   3: SpecializationActive {@link LLVMVectorArithmeticNode#doI16}
     *   4: SpecializationActive {@link LLVMVectorArithmeticNode#doI32}
     *   5: SpecializationActive {@link LLVMVectorArithmeticNode#doI64}
     *   6: SpecializationActive {@link LLVMVectorArithmeticNode#doFloat}
     *   7: SpecializationActive {@link LLVMVectorArithmeticNode#doDouble}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMVectorArithmeticNodeGen(int vectorLength, LLVMArithmeticNode arithmeticNode, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
        super(vectorLength, arithmeticNode);
        this.leftNode_ = leftNode;
        this.rightNode_ = rightNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
        Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }
        if ((state_0 & 0b11111110) != 0 /* is SpecializationActive[LLVMVectorArithmeticNode.doI1(LLVMI1Vector, LLVMI1Vector)] || SpecializationActive[LLVMVectorArithmeticNode.doI8(LLVMI8Vector, LLVMI8Vector)] || SpecializationActive[LLVMVectorArithmeticNode.doI16(LLVMI16Vector, LLVMI16Vector)] || SpecializationActive[LLVMVectorArithmeticNode.doI32(LLVMI32Vector, LLVMI32Vector)] || SpecializationActive[LLVMVectorArithmeticNode.doI64(LLVMI64Vector, LLVMI64Vector)] || SpecializationActive[LLVMVectorArithmeticNode.doFloat(LLVMFloatVector, LLVMFloatVector)] || SpecializationActive[LLVMVectorArithmeticNode.doDouble(LLVMDoubleVector, LLVMDoubleVector)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorArithmeticNode.doI1(LLVMI1Vector, LLVMI1Vector)] */ && leftNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector leftNodeValue__ = (LLVMI1Vector) leftNodeValue_;
                if (rightNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector rightNodeValue__ = (LLVMI1Vector) rightNodeValue_;
                    return doI1(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMVectorArithmeticNode.doI8(LLVMI8Vector, LLVMI8Vector)] */ && leftNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector leftNodeValue__ = (LLVMI8Vector) leftNodeValue_;
                if (rightNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector rightNodeValue__ = (LLVMI8Vector) rightNodeValue_;
                    return doI8(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMVectorArithmeticNode.doI16(LLVMI16Vector, LLVMI16Vector)] */ && leftNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector leftNodeValue__ = (LLVMI16Vector) leftNodeValue_;
                if (rightNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector rightNodeValue__ = (LLVMI16Vector) rightNodeValue_;
                    return doI16(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMVectorArithmeticNode.doI32(LLVMI32Vector, LLVMI32Vector)] */ && leftNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector leftNodeValue__ = (LLVMI32Vector) leftNodeValue_;
                if (rightNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector rightNodeValue__ = (LLVMI32Vector) rightNodeValue_;
                    return doI32(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMVectorArithmeticNode.doI64(LLVMI64Vector, LLVMI64Vector)] */ && leftNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector leftNodeValue__ = (LLVMI64Vector) leftNodeValue_;
                if (rightNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector rightNodeValue__ = (LLVMI64Vector) rightNodeValue_;
                    return doI64(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMVectorArithmeticNode.doFloat(LLVMFloatVector, LLVMFloatVector)] */ && leftNodeValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector leftNodeValue__ = (LLVMFloatVector) leftNodeValue_;
                if (rightNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector rightNodeValue__ = (LLVMFloatVector) rightNodeValue_;
                    return doFloat(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMVectorArithmeticNode.doDouble(LLVMDoubleVector, LLVMDoubleVector)] */ && leftNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector leftNodeValue__ = (LLVMDoubleVector) leftNodeValue_;
                if (rightNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector rightNodeValue__ = (LLVMDoubleVector) rightNodeValue_;
                    return doDouble(leftNodeValue__, rightNodeValue__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private LLVMVector executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (leftNodeValue instanceof LLVMI1Vector) {
            LLVMI1Vector leftNodeValue_ = (LLVMI1Vector) leftNodeValue;
            if (rightNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector rightNodeValue_ = (LLVMI1Vector) rightNodeValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMVectorArithmeticNode.doI1(LLVMI1Vector, LLVMI1Vector)] */;
                this.state_0_ = state_0;
                return doI1(leftNodeValue_, rightNodeValue_);
            }
        }
        if (leftNodeValue instanceof LLVMI8Vector) {
            LLVMI8Vector leftNodeValue_ = (LLVMI8Vector) leftNodeValue;
            if (rightNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector rightNodeValue_ = (LLVMI8Vector) rightNodeValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMVectorArithmeticNode.doI8(LLVMI8Vector, LLVMI8Vector)] */;
                this.state_0_ = state_0;
                return doI8(leftNodeValue_, rightNodeValue_);
            }
        }
        if (leftNodeValue instanceof LLVMI16Vector) {
            LLVMI16Vector leftNodeValue_ = (LLVMI16Vector) leftNodeValue;
            if (rightNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector rightNodeValue_ = (LLVMI16Vector) rightNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMVectorArithmeticNode.doI16(LLVMI16Vector, LLVMI16Vector)] */;
                this.state_0_ = state_0;
                return doI16(leftNodeValue_, rightNodeValue_);
            }
        }
        if (leftNodeValue instanceof LLVMI32Vector) {
            LLVMI32Vector leftNodeValue_ = (LLVMI32Vector) leftNodeValue;
            if (rightNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector rightNodeValue_ = (LLVMI32Vector) rightNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMVectorArithmeticNode.doI32(LLVMI32Vector, LLVMI32Vector)] */;
                this.state_0_ = state_0;
                return doI32(leftNodeValue_, rightNodeValue_);
            }
        }
        if (leftNodeValue instanceof LLVMI64Vector) {
            LLVMI64Vector leftNodeValue_ = (LLVMI64Vector) leftNodeValue;
            if (rightNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector rightNodeValue_ = (LLVMI64Vector) rightNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMVectorArithmeticNode.doI64(LLVMI64Vector, LLVMI64Vector)] */;
                this.state_0_ = state_0;
                return doI64(leftNodeValue_, rightNodeValue_);
            }
        }
        if (leftNodeValue instanceof LLVMFloatVector) {
            LLVMFloatVector leftNodeValue_ = (LLVMFloatVector) leftNodeValue;
            if (rightNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector rightNodeValue_ = (LLVMFloatVector) rightNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMVectorArithmeticNode.doFloat(LLVMFloatVector, LLVMFloatVector)] */;
                this.state_0_ = state_0;
                return doFloat(leftNodeValue_, rightNodeValue_);
            }
        }
        if (leftNodeValue instanceof LLVMDoubleVector) {
            LLVMDoubleVector leftNodeValue_ = (LLVMDoubleVector) leftNodeValue;
            if (rightNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector rightNodeValue_ = (LLVMDoubleVector) rightNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMVectorArithmeticNode.doDouble(LLVMDoubleVector, LLVMDoubleVector)] */;
                this.state_0_ = state_0;
                return doDouble(leftNodeValue_, rightNodeValue_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.leftNode_, this.rightNode_}, leftNodeValue, rightNodeValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11111110) & ((state_0 & 0b11111110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMVectorArithmeticNode.doI1(LLVMI1Vector, LLVMI1Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMVectorArithmeticNode.doI8(LLVMI8Vector, LLVMI8Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMVectorArithmeticNode.doI16(LLVMI16Vector, LLVMI16Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMVectorArithmeticNode.doI32(LLVMI32Vector, LLVMI32Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMVectorArithmeticNode.doI64(LLVMI64Vector, LLVMI64Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMVectorArithmeticNode.doFloat(LLVMFloatVector, LLVMFloatVector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMVectorArithmeticNode.doDouble(LLVMDoubleVector, LLVMDoubleVector)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMVectorArithmeticNode create(int vectorLength, LLVMArithmeticNode arithmeticNode, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
        return new LLVMVectorArithmeticNodeGen(vectorLength, arithmeticNode, leftNode, rightNode);
    }

}
