/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.elf;

import com.oracle.truffle.llvm.parser.elf.ElfReader;

public final class ElfHeader {
    private final short type;
    private final short machine;
    private final int version;
    private final long entry;
    private final long phoff;
    private final long shoff;
    private final int flags;
    private final short ehsize;
    private final short phentsize;
    private final short phnum;
    private final short shentsize;
    private final short shnum;
    private final short shstrndx;

    private ElfHeader(short type, short machine, int version, long entry, long phoff, long shoff, int flags, short ehsize, short phentsize, short phnum, short shentsize, short shnum, short shstrndx) {
        this.type = type;
        this.machine = machine;
        this.version = version;
        this.entry = entry;
        this.phoff = phoff;
        this.shoff = shoff;
        this.flags = flags;
        this.ehsize = ehsize;
        this.phentsize = phentsize;
        this.phnum = phnum;
        this.shentsize = shentsize;
        this.shnum = shnum;
        this.shstrndx = shstrndx;
    }

    public short getType() {
        return this.type;
    }

    public short getMachine() {
        return this.machine;
    }

    public long getEntry() {
        return this.entry;
    }

    public long getPhoff() {
        return this.phoff;
    }

    public long getShoff() {
        return this.shoff;
    }

    public int getFlags() {
        return this.flags;
    }

    public short getEhsize() {
        return this.ehsize;
    }

    public short getPhentsize() {
        return this.phentsize;
    }

    public short getPhnum() {
        return this.phnum;
    }

    public short getShentsize() {
        return this.shentsize;
    }

    public short getShnum() {
        return this.shnum;
    }

    public short getShstrndx() {
        return this.shstrndx;
    }

    public int getVersion() {
        return this.version;
    }

    public static ElfHeader create(ElfReader buffer) {
        if (buffer.is64Bit()) {
            return ElfHeader.readHeader64(buffer);
        }
        return ElfHeader.readHeader32(buffer);
    }

    private static ElfHeader readHeader32(ElfReader buffer) {
        short type = buffer.getShort();
        short machine = buffer.getShort();
        int version = buffer.getInt();
        long entry = buffer.getInt();
        long phoff = buffer.getInt();
        long shoff = buffer.getInt();
        int flags = buffer.getInt();
        short ehsize = buffer.getShort();
        short phentsize = buffer.getShort();
        short phnum = buffer.getShort();
        short shentsize = buffer.getShort();
        short shnum = buffer.getShort();
        short shstrndx = buffer.getShort();
        return new ElfHeader(type, machine, version, entry, phoff, shoff, flags, ehsize, phentsize, phnum, shentsize, shnum, shstrndx);
    }

    private static ElfHeader readHeader64(ElfReader buffer) {
        short type = buffer.getShort();
        short machine = buffer.getShort();
        int version = buffer.getInt();
        long entry = buffer.getLong();
        long phoff = buffer.getLong();
        long shoff = buffer.getLong();
        int flags = buffer.getInt();
        short ehsize = buffer.getShort();
        short phentsize = buffer.getShort();
        short phnum = buffer.getShort();
        short shentsize = buffer.getShort();
        short shnum = buffer.getShort();
        short shstrndx = buffer.getShort();
        return new ElfHeader(type, machine, version, entry, phoff, shoff, flags, ehsize, phentsize, phnum, shentsize, shnum, shstrndx);
    }
}

