/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class VaArgInstruction
extends ValueInstruction {
    private SymbolImpl source;

    private VaArgInstruction(Type type) {
        super(type);
    }

    public static VaArgInstruction fromSymbols(SymbolTable symbols, Type type, int source) {
        VaArgInstruction inst = new VaArgInstruction(type);
        inst.source = symbols.getForwardReferenced(source, inst);
        return inst;
    }

    public SymbolImpl getSource() {
        return this.source;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.source == original) {
            this.source = replacement;
        }
    }
}

