/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMCopyTargetLibrary;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMCopyTargetLibrary.class)
final class LLVMCopyTargetLibraryGen
extends LibraryFactory<LLVMCopyTargetLibrary> {
    private static final Class<LLVMCopyTargetLibrary> LIBRARY_CLASS = LLVMCopyTargetLibraryGen.lazyLibraryClass();
    private static final Message CAN_COPY_FROM = new MessageImpl("canCopyFrom", 0, false, Boolean.TYPE, Object.class, Object.class, Long.TYPE);
    private static final Message COPY_FROM = new MessageImpl("copyFrom", 1, false, Void.TYPE, Object.class, Object.class, Long.TYPE);
    private static final LLVMCopyTargetLibraryGen INSTANCE = new LLVMCopyTargetLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private LLVMCopyTargetLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(CAN_COPY_FROM, COPY_FROM)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return LLVMCopyTargetLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected LLVMCopyTargetLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected LLVMCopyTargetLibrary createDelegate(LLVMCopyTargetLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        LLVMCopyTargetLibrary lib = (LLVMCopyTargetLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.canCopyFrom(receiver, args[offset], (Long)args[offset + 1]);
            }
            case 1: {
                lib.copyFrom(receiver, args[offset], (Long)args[offset + 1]);
                return null;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected LLVMCopyTargetLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected LLVMCopyTargetLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<LLVMCopyTargetLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.llvm.runtime.library.internal.LLVMCopyTargetLibrary", false, LLVMCopyTargetLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=LLVMCopyTargetLibrary.class)
    private static final class Proxy
    extends LLVMCopyTargetLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean canCopyFrom(Object receiver_, Object source, long length) {
            try {
                return (Boolean)this.lib.send(receiver_, CAN_COPY_FROM, new Object[]{source, length});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void copyFrom(Object receiver_, Object source, long length) {
            try {
                this.lib.send(receiver_, COPY_FROM, new Object[]{source, length});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=LLVMCopyTargetLibrary.class)
    private static final class Delegate
    extends LLVMCopyTargetLibrary {
        @Node.Child
        private LLVMCopyTargetLibrary delegateLibrary;

        Delegate(LLVMCopyTargetLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean canCopyFrom(Object receiver_, Object source, long length) {
            if (LLVMCopyTargetLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = LLVMCopyTargetLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMCopyTargetLibrary)LLVMCopyTargetLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).canCopyFrom(delegate, source, length);
            }
            return this.delegateLibrary.canCopyFrom(receiver_, source, length);
        }

        @Override
        public void copyFrom(Object receiver_, Object source, long length) {
            if (LLVMCopyTargetLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = LLVMCopyTargetLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((LLVMCopyTargetLibrary)LLVMCopyTargetLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).copyFrom(delegate, source, length);
                return;
            }
            this.delegateLibrary.copyFrom(receiver_, source, length);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=LLVMCopyTargetLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch
    implements GenerateAOT.Provider {
        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(LLVMCopyTargetLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport export : INSTANCE.getAOTExports()) {
                LLVMCopyTargetLibrary exportLibrary = (LLVMCopyTargetLibrary)INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = (LLVMCopyTargetLibrary)this.insert((Node)exportLibrary);
                    continue;
                }
                this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext(exportLibrary, this.next));
            }
            this.aot_ = true;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=LLVMCopyTargetLibrary.class)
    private static abstract class CachedDispatch
    extends LLVMCopyTargetLibrary {
        @Node.Child
        LLVMCopyTargetLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(LLVMCopyTargetLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean var1);

        @Override
        @ExplodeLoop
        public boolean canCopyFrom(Object receiver_, Object source, long length) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMCopyTargetLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.canCopyFrom(receiver_, source, length);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void copyFrom(Object receiver_, Object source, long length) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMCopyTargetLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.copyFrom(receiver_, source, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                if (this.isAOT()) {
                    this.library = null;
                    this.next = null;
                    this.setAOT(false);
                }
                CachedDispatch current = this;
                LLVMCopyTargetLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (LLVMCopyTargetLibrary)this.insert((Node)((LLVMCopyTargetLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        LLVMCopyTargetLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (LLVMCopyTargetLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((LLVMCopyTargetLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=LLVMCopyTargetLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends LLVMCopyTargetLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean canCopyFrom(Object receiver_, Object source, long length) {
            return ((LLVMCopyTargetLibrary)INSTANCE.getUncached(receiver_)).canCopyFrom(receiver_, source, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void copyFrom(Object receiver_, Object source, long length) {
            ((LLVMCopyTargetLibrary)INSTANCE.getUncached(receiver_)).copyFrom(receiver_, source, length);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMCopyTargetLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=LLVMCopyTargetLibrary.class)
    private static final class Default
    extends LibraryExport<LLVMCopyTargetLibrary> {
        private Default() {
            super(LLVMCopyTargetLibrary.class, Object.class, false, false, 0);
        }

        protected LLVMCopyTargetLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMCopyTargetLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMCopyTargetLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMCopyTargetLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean canCopyFrom(Object receiver, Object source, long length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.canCopyFrom(receiver, source, length);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void copyFrom(Object receiver, Object source, long length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.copyFrom(receiver, source, length);
            }
        }

        @GeneratedBy(value=LLVMCopyTargetLibrary.class)
        private static final class Cached
        extends LLVMCopyTargetLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean canCopyFrom(Object receiver, Object source, long length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.canCopyFrom(this.dynamicDispatch_.cast(receiver), source, length);
            }

            @Override
            public void copyFrom(Object receiver, Object source, long length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.copyFrom(this.dynamicDispatch_.cast(receiver), source, length);
            }
        }
    }

    @GeneratedBy(value=LLVMCopyTargetLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(LLVMCopyTargetLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=LLVMCopyTargetLibrary.class)
    private static final class CachedToUncachedDispatch
    extends LLVMCopyTargetLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean canCopyFrom(Object receiver_, Object source, long length) {
            assert (LLVMCopyTargetLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((LLVMCopyTargetLibrary)INSTANCE.getUncached(receiver_)).canCopyFrom(receiver_, source, length);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void copyFrom(Object receiver_, Object source, long length) {
            assert (LLVMCopyTargetLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((LLVMCopyTargetLibrary)INSTANCE.getUncached(receiver_)).copyFrom(receiver_, source, length);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

