/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode;

@NodeChildren(value={@NodeChild(value="left"), @NodeChild(value="right")})
public abstract class LLVMAMD64AndNode
extends LLVMExpressionNode {
    @Node.Child
    protected LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode flags;

    private LLVMAMD64AndNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode flags) {
        this.flags = flags;
    }

    public static abstract class LLVMAMD64AndqNode
    extends LLVMAMD64AndNode {
        public LLVMAMD64AndqNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected long doI64(VirtualFrame frame, long left, long right) {
            long result = left & right;
            this.flags.execute(frame, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64AndlNode
    extends LLVMAMD64AndNode {
        public LLVMAMD64AndlNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected int doI32(VirtualFrame frame, int left, int right) {
            int result = left & right;
            this.flags.execute(frame, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64AndwNode
    extends LLVMAMD64AndNode {
        public LLVMAMD64AndwNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected short doI16(VirtualFrame frame, short left, short right) {
            short result = (short)(left & right);
            this.flags.execute(frame, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64AndbNode
    extends LLVMAMD64AndNode {
        public LLVMAMD64AndbNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected byte doI8(VirtualFrame frame, byte left, byte right) {
            byte result = (byte)(left & right);
            this.flags.execute(frame, result);
            return result;
        }
    }
}

