/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMUserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMFrameNullerUtil;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMBrUnconditionalNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMCatchReturnNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMCleanupReturnNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMConditionalBranchNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMIndirectBranchNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMSwitchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCatchSwitchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMInvokeNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMResumeNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMUnreachableNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.types.symbols.LocalVariableDebugInfo;

public abstract class LLVMDispatchBasicBlockNode
extends LLVMExpressionNode
implements BytecodeOSRNode {
    private final int exceptionValueSlot;
    private final LocalVariableDebugInfo debugInfo;
    @Node.Children
    private final LLVMBasicBlockNode[] bodyNodes;
    private final SulongEngineOption.OSRMode osrMode;
    @CompilerDirectives.CompilationFinal
    private Object osrMetadata;

    public LLVMDispatchBasicBlockNode(int exceptionValueSlot, LLVMBasicBlockNode[] bodyNodes, LocalVariableDebugInfo debugInfo, SulongEngineOption.OSRMode osrMode) {
        this.exceptionValueSlot = exceptionValueSlot;
        this.bodyNodes = bodyNodes;
        this.debugInfo = debugInfo;
        this.osrMode = osrMode;
    }

    @Override
    public String toString() {
        return this.getRootNode() != null ? this.getRootNode().toString() : "<OSR>";
    }

    public LocalVariableDebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    @Specialization
    public Object doDispatch(VirtualFrame frame) {
        return this.dispatchFromBasicBlock(frame, 0, new Counters());
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    private Object dispatchFromBasicBlock(VirtualFrame frame, int bci, Counters counters) {
        Object returnValue = null;
        int basicBlockIndex = bci;
        CompilerAsserts.partialEvaluationConstant((int)this.bodyNodes.length);
        block2: while (basicBlockIndex != -1) {
            LLVMControlFlowNode returnNode;
            int i;
            LLVMControlFlowNode switchNode;
            CompilerAsserts.partialEvaluationConstant((int)basicBlockIndex);
            if (CompilerDirectives.hasNextTier()) {
                if (basicBlockIndex <= counters.previousBasicBlockIndex) {
                    TruffleSafepoint.poll((Node)this);
                    ++counters.backEdgeCounter;
                    if (CompilerDirectives.inInterpreter() && this.osrMode == SulongEngineOption.OSRMode.BYTECODE && BytecodeOSRNode.pollOSRBackEdge((BytecodeOSRNode)this)) {
                        LLVMDispatchBasicBlockNode.ensureAllFrameSlotsInitialized(frame);
                        returnValue = BytecodeOSRNode.tryOSR((BytecodeOSRNode)this, (int)basicBlockIndex, (Object)counters, null, (VirtualFrame)frame);
                        if (returnValue != null) break;
                    }
                }
                counters.previousBasicBlockIndex = basicBlockIndex;
            }
            LLVMBasicBlockNode bb = this.bodyNodes[basicBlockIndex];
            bb.execute(frame);
            LLVMControlFlowNode controlFlowNode = bb.getTerminatingInstruction();
            if (controlFlowNode instanceof LLVMConditionalBranchNode) {
                LLVMConditionalBranchNode conditionalBranchNode = (LLVMConditionalBranchNode)controlFlowNode;
                boolean condition = conditionalBranchNode.executeCondition(frame);
                if (CompilerDirectives.injectBranchProbability((double)bb.getBranchProbability(0), (boolean)condition)) {
                    bb.enterSuccessor(0);
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                    LLVMDispatchBasicBlockNode.executePhis(frame, conditionalBranchNode, 0);
                    basicBlockIndex = conditionalBranchNode.getTrueSuccessor();
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                    continue;
                }
                bb.enterSuccessor(1);
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                LLVMDispatchBasicBlockNode.executePhis(frame, conditionalBranchNode, 1);
                basicBlockIndex = conditionalBranchNode.getFalseSuccessor();
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                continue;
            }
            if (controlFlowNode instanceof LLVMCatchSwitchNode) {
                int i2;
                switchNode = (LLVMCatchSwitchNode)controlFlowNode;
                Object condition = ((LLVMCatchSwitchNode)switchNode).executeCondition(frame);
                int[] successors = switchNode.getSuccessors();
                int successorCount = ((LLVMCatchSwitchNode)switchNode).getConditionalSuccessorCount();
                for (i2 = 0; i2 < successorCount; ++i2) {
                    if (!CompilerDirectives.injectBranchProbability((double)bb.getBranchProbability(i2), (boolean)((LLVMCatchSwitchNode)switchNode).checkCase(frame, i2, condition))) continue;
                    bb.enterSuccessor(i2);
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                    LLVMDispatchBasicBlockNode.executePhis(frame, switchNode, i2);
                    basicBlockIndex = successors[i2];
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                    continue block2;
                }
                if (((LLVMCatchSwitchNode)switchNode).hasDefaultBlock()) {
                    i2 = successors.length - 1;
                    bb.enterSuccessor(i2);
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                    LLVMDispatchBasicBlockNode.executePhis(frame, switchNode, i2);
                    basicBlockIndex = successors[i2];
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                    continue;
                }
                ((LLVMCatchSwitchNode)switchNode).throwException(frame);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("must not reach here");
            }
            if (controlFlowNode instanceof LLVMSwitchNode) {
                switchNode = (LLVMSwitchNode)controlFlowNode;
                Object condition = ((LLVMSwitchNode)switchNode).executeCondition(frame);
                int[] successors = switchNode.getSuccessors();
                for (i = 0; i < successors.length - 1; ++i) {
                    if (!CompilerDirectives.injectBranchProbability((double)bb.getBranchProbability(i), (boolean)((LLVMSwitchNode)switchNode).checkCase(frame, i, condition))) continue;
                    bb.enterSuccessor(i);
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                    LLVMDispatchBasicBlockNode.executePhis(frame, switchNode, i);
                    basicBlockIndex = successors[i];
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                    continue block2;
                }
                i = successors.length - 1;
                bb.enterSuccessor(i);
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                LLVMDispatchBasicBlockNode.executePhis(frame, switchNode, i);
                basicBlockIndex = successors[i];
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                continue;
            }
            if (controlFlowNode instanceof LLVMIndirectBranchNode) {
                LLVMIndirectBranchNode indirectBranchNode = (LLVMIndirectBranchNode)controlFlowNode;
                int[] successors = indirectBranchNode.getSuccessors();
                int successorBasicBlockIndex = indirectBranchNode.executeCondition(frame);
                for (i = 0; i < successors.length - 1; ++i) {
                    if (!CompilerDirectives.injectBranchProbability((double)bb.getBranchProbability(i), (successors[i] == successorBasicBlockIndex ? (byte)1 : 0) != 0)) continue;
                    bb.enterSuccessor(i);
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                    LLVMDispatchBasicBlockNode.executePhis(frame, indirectBranchNode, i);
                    basicBlockIndex = successors[i];
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                    continue block2;
                }
                i = successors.length - 1;
                assert (successorBasicBlockIndex == successors[i]);
                bb.enterSuccessor(i);
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                LLVMDispatchBasicBlockNode.executePhis(frame, indirectBranchNode, i);
                basicBlockIndex = successors[i];
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                continue;
            }
            if (controlFlowNode instanceof LLVMBrUnconditionalNode) {
                LLVMBrUnconditionalNode unconditionalNode = (LLVMBrUnconditionalNode)controlFlowNode;
                unconditionalNode.execute(frame);
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                LLVMDispatchBasicBlockNode.executePhis(frame, unconditionalNode, 0);
                basicBlockIndex = unconditionalNode.getSuccessor();
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                continue;
            }
            if (controlFlowNode instanceof LLVMCatchReturnNode) {
                returnNode = (LLVMCatchReturnNode)controlFlowNode;
                ((LLVMCatchReturnNode)returnNode).execute(frame);
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                LLVMDispatchBasicBlockNode.executePhis(frame, returnNode, 0);
                basicBlockIndex = ((LLVMCatchReturnNode)returnNode).getSuccessor();
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                continue;
            }
            if (controlFlowNode instanceof LLVMCleanupReturnNode) {
                returnNode = (LLVMCleanupReturnNode)controlFlowNode;
                ((LLVMCleanupReturnNode)returnNode).execute(frame);
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                LLVMDispatchBasicBlockNode.executePhis(frame, returnNode, 0);
                basicBlockIndex = ((LLVMCleanupReturnNode)returnNode).getSuccessor();
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                continue;
            }
            if (controlFlowNode instanceof LLVMInvokeNode) {
                LLVMInvokeNode invokeNode = (LLVMInvokeNode)controlFlowNode;
                try {
                    invokeNode.execute(frame);
                    bb.enterSuccessor(0);
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                    LLVMDispatchBasicBlockNode.executePhis(frame, invokeNode, 0);
                    basicBlockIndex = invokeNode.getNormalSuccessor();
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                }
                catch (LLVMUserException e) {
                    bb.enterSuccessor(1);
                    frame.setObject(this.exceptionValueSlot, (Object)e);
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                    LLVMDispatchBasicBlockNode.executePhis(frame, invokeNode, 1);
                    basicBlockIndex = invokeNode.getUnwindSuccessor();
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                }
                continue;
            }
            if (controlFlowNode instanceof LLVMRetNode) {
                LLVMRetNode retNode = (LLVMRetNode)controlFlowNode;
                returnValue = retNode.execute(frame);
                assert (LLVMDispatchBasicBlockNode.noPhisNecessary(retNode));
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                basicBlockIndex = retNode.getSuccessor();
                continue;
            }
            if (controlFlowNode instanceof LLVMResumeNode) {
                LLVMResumeNode resumeNode = (LLVMResumeNode)controlFlowNode;
                assert (LLVMDispatchBasicBlockNode.noPhisNecessary(resumeNode));
                resumeNode.execute(frame);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("must not reach here");
            }
            if (controlFlowNode instanceof LLVMUnreachableNode) {
                LLVMUnreachableNode unreachableNode = (LLVMUnreachableNode)controlFlowNode;
                assert (LLVMDispatchBasicBlockNode.noPhisNecessary(unreachableNode));
                unreachableNode.execute(frame);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("must not reach here");
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedOperationException("unexpected controlFlowNode type: " + String.valueOf((Object)controlFlowNode));
        }
        if (CompilerDirectives.hasNextTier() && counters.backEdgeCounter != 0) {
            LoopNode.reportLoopCount((Node)this, (int)(counters.backEdgeCounter > 0 ? counters.backEdgeCounter : Integer.MAX_VALUE));
        }
        assert (returnValue != null);
        return returnValue;
    }

    private static void ensureAllFrameSlotsInitialized(VirtualFrame frame) {
        FrameDescriptor frameDescriptor = frame.getFrameDescriptor();
        block9: for (int i = 0; i < frameDescriptor.getNumberOfSlots(); ++i) {
            if (frame.getTag(i) != 0 || frameDescriptor.getSlotKind((int)i).tag == 0) continue;
            switch (frameDescriptor.getSlotKind(i)) {
                case Object: {
                    frame.setObject(i, null);
                    continue block9;
                }
                case Long: {
                    frame.setLong(i, 0L);
                    continue block9;
                }
                case Int: {
                    frame.setInt(i, 0);
                    continue block9;
                }
                case Double: {
                    frame.setDouble(i, 0.0);
                    continue block9;
                }
                case Float: {
                    frame.setFloat(i, 0.0f);
                    continue block9;
                }
                case Boolean: {
                    frame.setBoolean(i, false);
                    continue block9;
                }
                case Byte: {
                    frame.setByte(i, (byte)0);
                }
            }
        }
    }

    @ExplodeLoop
    public static void executePhis(VirtualFrame frame, LLVMControlFlowNode controlFlowNode, int successorIndex) {
        LLVMStatementNode phi = controlFlowNode.getPhiNode(successorIndex);
        if (phi != null) {
            phi.execute(frame);
        }
    }

    @ExplodeLoop
    public static void nullDeadSlots(VirtualFrame frame, int[] frameSlotsToNull) {
        if (frameSlotsToNull != null) {
            assert (frameSlotsToNull.length > 0);
            for (int i = 0; i < frameSlotsToNull.length; ++i) {
                LLVMFrameNullerUtil.nullFrameSlot(frame, frameSlotsToNull[i]);
            }
        }
    }

    private static boolean noPhisNecessary(LLVMControlFlowNode controlFlowNode) {
        return controlFlowNode.getSuccessorCount() == 0 || controlFlowNode.getSuccessorCount() == 1 && controlFlowNode.getPhiNode(0) == null;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.StatementTag.class) {
            return false;
        }
        if (tag == StandardTags.RootBodyTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public final Object executeOSR(VirtualFrame osrFrame, int target, Object interpreterState) {
        return this.dispatchFromBasicBlock(osrFrame, target, (Counters)interpreterState);
    }

    public final Object[] storeParentFrameInArguments(VirtualFrame parentFrame) {
        Object[] args = parentFrame.getArguments();
        args[0] = parentFrame;
        return args;
    }

    public final Frame restoreParentFrameFromArguments(Object[] arguments) {
        return (Frame)arguments[0];
    }

    public Object getOSRMetadata() {
        return this.osrMetadata;
    }

    public void setOSRMetadata(Object osrMetadata) {
        this.osrMetadata = osrMetadata;
    }

    public void restoreParentFrame(VirtualFrame osrFrame, VirtualFrame parentFrame) {
        parentFrame.setObject(0, osrFrame.getObject(0));
        parentFrame.setObject(1, osrFrame.getObject(1));
        if (osrFrame.isLong(2)) {
            parentFrame.setLong(2, osrFrame.getLong(2));
        }
        int nr = this.getRootNode().getFrameDescriptor().getNumberOfSlots();
        for (int i = 3; i < nr; ++i) {
            parentFrame.clear(i);
        }
    }

    private static final class Counters {
        int backEdgeCounter;
        int previousBasicBlockIndex = Integer.MIN_VALUE;

        private Counters() {
        }
    }
}

