/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.options;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Locale;

public class TargetStream
extends PrintStream {
    private boolean needsDisposal = false;
    private static final String FILE_TARGET_PREFIX = "file://";

    public TargetStream(TruffleLanguage.Env env, String target) {
        super(TargetStream.makeStream(env, target));
        this.needsDisposal = TargetStream.needsDisposal(target);
    }

    public void dispose() {
        this.flush();
        if (this.needsDisposal) {
            this.close();
        }
    }

    private static boolean needsDisposal(String target) {
        switch (target.toLowerCase(Locale.ROOT)) {
            case "true": 
            case "stdout": 
            case "stderr": {
                return false;
            }
        }
        return true;
    }

    private static OutputStream makeStream(TruffleLanguage.Env env, String target) {
        if (target == null) {
            throw new IllegalArgumentException("Target unspecified!");
        }
        switch (target.toLowerCase(Locale.ROOT)) {
            case "true": 
            case "stdout": {
                return env.out();
            }
            case "stderr": {
                return env.err();
            }
        }
        if (target.startsWith(FILE_TARGET_PREFIX)) {
            String fileName = target.substring(FILE_TARGET_PREFIX.length());
            try {
                TruffleFile file = env.getPublicTruffleFile(fileName);
                return new BufferedOutputStream(file.newOutputStream(new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING}));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid file: " + fileName, e);
            }
        }
        throw new IllegalArgumentException("Invalid target: " + target);
    }
}

