// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link DebugExprSizeofNode#getSize}
 *     Activation probability: 1.00000
 *     With/without class size: 20/4 bytes
 * </pre>
 */
@GeneratedBy(DebugExprSizeofNode.class)
@SuppressWarnings("javadoc")
public final class DebugExprSizeofNodeGen extends DebugExprSizeofNode implements GenerateAOT.Provider {

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link DebugExprSizeofNode#getSize}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link DebugExprSizeofNode#getSize}
     *   Parameter: {@link BranchProfile} exception</pre>
     */
    @CompilationFinal private BranchProfile exception_;

    private DebugExprSizeofNodeGen(long typeSize) {
        super(typeSize);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize();
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[DebugExprSizeofNode.getSize(BranchProfile)] */) {
            {
                BranchProfile exception__ = this.exception_;
                if (exception__ != null) {
                    return getSize(exception__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize();
    }

    @Override
    public long executeI64(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize();
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[DebugExprSizeofNode.getSize(BranchProfile)] */) {
            {
                BranchProfile exception__ = this.exception_;
                if (exception__ != null) {
                    return getSize(exception__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize();
    }

    private long executeAndSpecialize() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        BranchProfile exception__ = (BranchProfile.create());
        Objects.requireNonNull(exception__, "Specialization 'getSize(BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.exception_ = exception__;
        state_0 = state_0 | 0b10 /* add SpecializationActive[DebugExprSizeofNode.getSize(BranchProfile)] */;
        this.state_0_ = state_0;
        return getSize(exception__);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            return NodeCost.MONOMORPHIC;
        }
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            BranchProfile exception__ = (BranchProfile.create());
            Objects.requireNonNull(exception__, "Specialization 'getSize(BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.exception_ = exception__;
            this.exception_.disable();
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[DebugExprSizeofNode.getSize(BranchProfile)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.exception_.reset();
    }

    @NeverDefault
    public static DebugExprSizeofNode create(long typeSize) {
        return new DebugExprSizeofNodeGen(typeSize);
    }

}
