// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMInteropVtableAccessNode#doPointer}
 *     Activation probability: 1.00000
 *     With/without class size: 28/8 bytes
 * </pre>
 */
@GeneratedBy(LLVMInteropVtableAccessNode.class)
@SuppressWarnings("javadoc")
public final class LLVMInteropVtableAccessNodeGen extends LLVMInteropVtableAccessNode implements GenerateAOT.Provider {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMInteropVtableAccessNode#doPointer}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMInteropVtableAccessNode#doPointer}
     *   Parameter: {@link LLVMForeignReadNode} read</pre>
     */
    @Child private LLVMForeignReadNode read_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMInteropVtableAccessNode#doPointer}
     *   Parameter: {@link InteropLibrary} interop</pre>
     */
    @Child private InteropLibrary interop_;

    private LLVMInteropVtableAccessNodeGen() {
    }

    @Override
    Object execute(Object arg0Value, long arg1Value, Object[] arg2Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropVtableAccessNode.doPointer(LLVMPointer, long, Object[], LLVMForeignReadNode, InteropLibrary)] */ && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            {
                LLVMForeignReadNode read__ = this.read_;
                if (read__ != null) {
                    InteropLibrary interop__ = this.interop_;
                    if (interop__ != null) {
                        return doPointer(arg0Value_, arg1Value, arg2Value, read__, interop__);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private Object executeAndSpecialize(Object arg0Value, long arg1Value, Object[] arg2Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            LLVMForeignReadNode read__ = this.insert((LLVMForeignReadNodeGen.create()));
            Objects.requireNonNull(read__, "Specialization 'doPointer(LLVMPointer, long, Object[], LLVMForeignReadNode, InteropLibrary)' cache 'read' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.read_ = read__;
            InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(5)));
            Objects.requireNonNull(interop__, "Specialization 'doPointer(LLVMPointer, long, Object[], LLVMForeignReadNode, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.interop_ = interop__;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMInteropVtableAccessNode.doPointer(LLVMPointer, long, Object[], LLVMForeignReadNode, InteropLibrary)] */;
            this.state_0_ = state_0;
            return doPointer(arg0Value_, arg1Value, arg2Value, read__, interop__);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            return NodeCost.MONOMORPHIC;
        }
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMInteropVtableAccessNode create() {
        return new LLVMInteropVtableAccessNodeGen();
    }

    @NeverDefault
    public static LLVMInteropVtableAccessNode getUncached() {
        return LLVMInteropVtableAccessNodeGen.UNCACHED;
    }

    @GeneratedBy(LLVMInteropVtableAccessNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMInteropVtableAccessNode {

        @TruffleBoundary
        @Override
        Object execute(Object arg0Value, long arg1Value, Object[] arg2Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                return doPointer(arg0Value_, arg1Value, arg2Value, (LLVMForeignReadNodeGen.getUncached()), (INTEROP_LIBRARY_.getUncached()));
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
