// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.export;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Value;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.ValueKind;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMOffsetLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMForeignReadNode#doStructured}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMForeignReadNode#doValue}
 *     Activation probability: 0.35000
 *     With/without class size: 15/12 bytes
 * </pre>
 */
@GeneratedBy(LLVMForeignReadNode.class)
@SuppressWarnings("javadoc")
public final class LLVMForeignReadNodeGen extends LLVMForeignReadNode implements GenerateAOT.Provider {

    static final ReferenceField<ValueData> VALUE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "value_cache", ValueData.class);
    private static final Uncached UNCACHED = new Uncached();
    @CompilationFinal(dimensions = 1) private static final ValueKind[] VALUE_KIND_VALUES = DSLSupport.lookupEnumConstants(ValueKind.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMForeignReadNode#doStructured}
     *   2: SpecializationActive {@link LLVMForeignReadNode#doValue}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @Child private ValueData value_cache;

    private LLVMForeignReadNodeGen() {
    }

    @ExplodeLoop
    @Override
    public Object execute(LLVMPointer arg0Value, LLVMInteropType arg1Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value, arg1Value);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMForeignReadNode.doStructured(LLVMPointer, Structured)] || SpecializationActive[LLVMForeignReadNode.doValue(LLVMPointer, Value, ValueKind, LLVMOffsetLoadNode, LLVMDataEscapeNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMForeignReadNode.doStructured(LLVMPointer, Structured)] */ && arg1Value instanceof Structured) {
                Structured arg1Value_ = (Structured) arg1Value;
                return LLVMForeignReadNode.doStructured(arg0Value, arg1Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMForeignReadNode.doValue(LLVMPointer, Value, ValueKind, LLVMOffsetLoadNode, LLVMDataEscapeNode)] */ && arg1Value instanceof Value) {
                Value arg1Value_ = (Value) arg1Value;
                ValueData s1_ = this.value_cache;
                while (s1_ != null) {
                    if ((arg1Value_.kind == decodeValueKind((s1_.value_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMForeignReadNode.doValue(..., ValueKind cachedKind, ...)] */) - 2))) {
                        return LLVMForeignReadNode.doValue(arg0Value, arg1Value_, decodeValueKind((s1_.value_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMForeignReadNode.doValue(..., ValueKind cachedKind, ...)] */) - 2), s1_.load_, s1_.dataEscape_);
                    }
                    s1_ = s1_.next_;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    private Object executeAndSpecialize(LLVMPointer arg0Value, LLVMInteropType arg1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg1Value instanceof Structured) {
            Structured arg1Value_ = (Structured) arg1Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMForeignReadNode.doStructured(LLVMPointer, Structured)] */;
            this.state_0_ = state_0;
            return LLVMForeignReadNode.doStructured(arg0Value, arg1Value_);
        }
        if (arg1Value instanceof Value) {
            Value arg1Value_ = (Value) arg1Value;
            while (true) {
                int count1_ = 0;
                ValueData s1_ = VALUE_CACHE_UPDATER.getVolatile(this);
                ValueData s1_original = s1_;
                while (s1_ != null) {
                    if ((arg1Value_.kind == decodeValueKind((s1_.value_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMForeignReadNode.doValue(..., ValueKind cachedKind, ...)] */) - 2))) {
                        break;
                    }
                    count1_++;
                    s1_ = s1_.next_;
                }
                if (s1_ == null) {
                    // assert (arg1Value_.kind == decodeValueKind((s1_.value_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMForeignReadNode.doValue(..., ValueKind cachedKind, ...)] */) - 2));
                    if (count1_ < (LLVMForeignReadNode.VALUE_KIND_COUNT)) {
                        s1_ = this.insert(new ValueData(s1_original));
                        s1_.value_state_0_ = (s1_.value_state_0_ | ((encodeValueKind((arg1Value_.kind)) + 2) << 0) /* set-int EncodedEnum[cache=LLVMForeignReadNode.doValue(..., ValueKind cachedKind, ...)] */);
                        s1_.load_ = s1_.insert((LLVMOffsetLoadNode.create(decodeValueKind((s1_.value_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMForeignReadNode.doValue(..., ValueKind cachedKind, ...)] */) - 2))));
                        s1_.dataEscape_ = s1_.insert((LLVMDataEscapeNode.create(decodeValueKind((s1_.value_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMForeignReadNode.doValue(..., ValueKind cachedKind, ...)] */) - 2).foreignToLLVMType)));
                        if (!VALUE_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMForeignReadNode.doValue(LLVMPointer, Value, ValueKind, LLVMOffsetLoadNode, LLVMDataEscapeNode)] */;
                        this.state_0_ = state_0;
                    }
                }
                if (s1_ != null) {
                    return LLVMForeignReadNode.doValue(arg0Value, arg1Value_, decodeValueKind((s1_.value_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMForeignReadNode.doValue(..., ValueKind cachedKind, ...)] */) - 2), s1_.load_, s1_.dataEscape_);
                }
                break;
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                ValueData s1_ = this.value_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMForeignReadNode.doStructured(LLVMPointer, Structured)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMForeignReadNode create() {
        return new LLVMForeignReadNodeGen();
    }

    @NeverDefault
    public static LLVMForeignReadNode getUncached() {
        return LLVMForeignReadNodeGen.UNCACHED;
    }

    private static ValueKind decodeValueKind(int state) {
        if (state >= 0) {
            return VALUE_KIND_VALUES[state];
        } else {
            return null;
        }
    }

    private static int encodeValueKind(ValueKind e) {
        if (e != null) {
            return e.ordinal();
        } else {
            return -1;
        }
    }

    @GeneratedBy(LLVMForeignReadNode.class)
    @DenyReplace
    private static final class ValueData extends Node implements SpecializationDataNode {

        @Child ValueData next_;
        /**
         * State Info: <pre>
         *   0-3: EncodedEnum[cache=LLVMForeignReadNode.doValue(..., ValueKind cachedKind, ...)]
         * </pre>
         */
        @CompilationFinal private int value_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMForeignReadNode#doValue}
         *   Parameter: {@link LLVMOffsetLoadNode} load</pre>
         */
        @Child LLVMOffsetLoadNode load_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMForeignReadNode#doValue}
         *   Parameter: {@link LLVMDataEscapeNode} dataEscape</pre>
         */
        @Child LLVMDataEscapeNode dataEscape_;

        ValueData(ValueData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMForeignReadNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMForeignReadNode {

        @TruffleBoundary
        @Override
        public Object execute(LLVMPointer arg0Value, LLVMInteropType arg1Value) {
            if (arg1Value instanceof Structured) {
                Structured arg1Value_ = (Structured) arg1Value;
                return LLVMForeignReadNode.doStructured(arg0Value, arg1Value_);
            }
            if (arg1Value instanceof Value) {
                Value arg1Value_ = (Value) arg1Value;
                // assert (arg1Value_.kind == (arg1Value_.kind));
                return LLVMForeignReadNode.doValue(arg0Value, arg1Value_, (arg1Value_.kind), (LLVMOffsetLoadNode.getUncached((arg1Value_.kind))), (LLVMDataEscapeNode.getUncached((arg1Value_.kind).foreignToLLVMType)));
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
