// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode.FP128FromNativeToLLVMNode;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode.FP80FromNativeToLLVMNode;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode.I1FromNativeToLLVMNode;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode.Id;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode.NativeToAddress;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMNativeConvertNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMNativeConvertNodeFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * Debug Info: <pre>
     *   Specialization {@link NativeToAddress#doLong}
     *     Activation probability: 0.32000
     *     With/without class size: 7/0 bytes
     *   Specialization {@link NativeToAddress#doPointer}
     *     Activation probability: 0.26000
     *     With/without class size: 10/4 bytes
     *   Specialization {@link NativeToAddress#doFunction}
     *     Activation probability: 0.20000
     *     With/without class size: 8/4 bytes
     *   Specialization {@link NativeToAddress#doGeneric}
     *     Activation probability: 0.14000
     *     With/without class size: 7/4 bytes
     *   Specialization {@link NativeToAddress#doGeneric}
     *     Activation probability: 0.08000
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(NativeToAddress.class)
    @SuppressWarnings("javadoc")
    protected static final class NativeToAddressNodeGen extends NativeToAddress implements GenerateAOT.Provider {

        static final ReferenceField<PointerData> POINTER_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "pointer_cache", PointerData.class);
        static final ReferenceField<FunctionData> FUNCTION_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "function_cache", FunctionData.class);
        static final ReferenceField<Generic0Data> GENERIC0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "generic0_cache", Generic0Data.class);

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link NativeToAddress#doLong}
         *   2: SpecializationActive {@link NativeToAddress#doPointer}
         *   3: SpecializationExcluded {@link NativeToAddress#doPointer}
         *   4: SpecializationActive {@link NativeToAddress#doGeneric}
         *   5: SpecializationActive {@link NativeToAddress#doGeneric}
         *   6: SpecializationActive {@link NativeToAddress#doFunction}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private PointerData pointer_cache;
        @UnsafeAccessedField @Child private FunctionData function_cache;
        @UnsafeAccessedField @Child private Generic0Data generic0_cache;

        private NativeToAddressNodeGen() {
        }

        @ExplodeLoop
        @Override
        public Object executeConvert(Object arg0Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value);
            }
            if ((state_0 & 0b1110110) != 0 /* is SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doLong(long)] || SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doPointer(Object, InteropLibrary)] || SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doFunction(Object, InteropLibrary)] || SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doGeneric(Object, InteropLibrary)] || SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doGeneric(Object, InteropLibrary)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doLong(long)] */ && arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    return doLong(arg0Value_);
                }
                if ((state_0 & 0b1110100) != 0 /* is SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doPointer(Object, InteropLibrary)] || SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doFunction(Object, InteropLibrary)] || SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doGeneric(Object, InteropLibrary)] || SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doGeneric(Object, InteropLibrary)] */) {
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doPointer(Object, InteropLibrary)] */) {
                        PointerData s1_ = this.pointer_cache;
                        while (s1_ != null) {
                            if ((s1_.interop_.accepts(arg0Value)) && (s1_.interop_.isPointer(arg0Value))) {
                                try {
                                    return doPointer(arg0Value, s1_.interop_);
                                } catch (UnsupportedMessageException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doPointer(Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    this.pointer_cache = null;
                                    return executeAndSpecialize(arg0Value);
                                }
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doFunction(Object, InteropLibrary)] */) {
                        FunctionData s2_ = this.function_cache;
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arg0Value)) && (!(s2_.interop_.isPointer(arg0Value)))) {
                                return doFunction(arg0Value, s2_.interop_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doGeneric(Object, InteropLibrary)] */) {
                        Generic0Data s3_ = this.generic0_cache;
                        while (s3_ != null) {
                            if ((s3_.interop_.accepts(arg0Value))) {
                                return doGeneric(arg0Value, s3_.interop_);
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doGeneric(Object, InteropLibrary)] */) {
                        return this.generic1Boundary(state_0, arg0Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object generic1Boundary(int state_0, Object arg0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return doGeneric(arg0Value, interop__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("unused")
        private LLVMPointer executeAndSpecialize(Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doLong(long)] */;
                this.state_0_ = state_0;
                return doLong(arg0Value_);
            }
            if (((state_0 & 0b110000)) == 0 /* is-not SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doGeneric(Object, InteropLibrary)] && SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doGeneric(Object, InteropLibrary)] */ && ((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                while (true) {
                    int count1_ = 0;
                    PointerData s1_ = POINTER_CACHE_UPDATER.getVolatile(this);
                    PointerData s1_original = s1_;
                    while (s1_ != null) {
                        if ((s1_.interop_.accepts(arg0Value)) && (s1_.interop_.isPointer(arg0Value))) {
                            break;
                        }
                        count1_++;
                        s1_ = s1_.next_;
                    }
                    if (s1_ == null) {
                        {
                            InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            // assert (s1_.interop_.accepts(arg0Value));
                            if ((interop__1.isPointer(arg0Value)) && count1_ < (3)) {
                                s1_ = this.insert(new PointerData(s1_original));
                                Objects.requireNonNull(s1_.insert(interop__1), "Specialization 'doPointer(Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s1_.interop_ = interop__1;
                                if (!POINTER_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doPointer(Object, InteropLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                    if (s1_ != null) {
                        try {
                            return doPointer(arg0Value, s1_.interop_);
                        } catch (UnsupportedMessageException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doPointer(Object, InteropLibrary)] */;
                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.pointer_cache = null;
                            return executeAndSpecialize(arg0Value);
                        }
                    }
                    break;
                }
            }
            if (((state_0 & 0b110000)) == 0 /* is-not SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doGeneric(Object, InteropLibrary)] && SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doGeneric(Object, InteropLibrary)] */) {
                while (true) {
                    int count2_ = 0;
                    FunctionData s2_ = FUNCTION_CACHE_UPDATER.getVolatile(this);
                    FunctionData s2_original = s2_;
                    while (s2_ != null) {
                        if ((s2_.interop_.accepts(arg0Value)) && (!(s2_.interop_.isPointer(arg0Value)))) {
                            break;
                        }
                        count2_++;
                        s2_ = s2_.next_;
                    }
                    if (s2_ == null) {
                        {
                            InteropLibrary interop__2 = this.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            // assert (s2_.interop_.accepts(arg0Value));
                            if ((!(interop__2.isPointer(arg0Value))) && count2_ < (3)) {
                                s2_ = this.insert(new FunctionData(s2_original));
                                Objects.requireNonNull(s2_.insert(interop__2), "Specialization 'doFunction(Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.interop_ = interop__2;
                                if (!FUNCTION_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doFunction(Object, InteropLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                    if (s2_ != null) {
                        return doFunction(arg0Value, s2_.interop_);
                    }
                    break;
                }
            }
            if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doGeneric(Object, InteropLibrary)] */) {
                while (true) {
                    int count3_ = 0;
                    Generic0Data s3_ = GENERIC0_CACHE_UPDATER.getVolatile(this);
                    Generic0Data s3_original = s3_;
                    while (s3_ != null) {
                        if ((s3_.interop_.accepts(arg0Value))) {
                            break;
                        }
                        count3_++;
                        s3_ = s3_.next_;
                    }
                    if (s3_ == null) {
                        // assert (s3_.interop_.accepts(arg0Value));
                        if (count3_ < (3)) {
                            s3_ = this.insert(new Generic0Data(s3_original));
                            InteropLibrary interop__ = s3_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            Objects.requireNonNull(interop__, "Specialization 'doGeneric(Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s3_.interop_ = interop__;
                            if (!GENERIC0_CACHE_UPDATER.compareAndSet(this, s3_original, s3_)) {
                                continue;
                            }
                            this.pointer_cache = null;
                            this.function_cache = null;
                            state_0 = state_0 & 0xffffffbb /* remove SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doPointer(Object, InteropLibrary)], SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doFunction(Object, InteropLibrary)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doGeneric(Object, InteropLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s3_ != null) {
                        return doGeneric(arg0Value, s3_.interop_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__ = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        interop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                        this.pointer_cache = null;
                        this.function_cache = null;
                        this.generic0_cache = null;
                        state_0 = state_0 & 0xffffffab /* remove SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doPointer(Object, InteropLibrary)], SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doFunction(Object, InteropLibrary)], SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doGeneric(Object, InteropLibrary)] */;
                        state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doGeneric(Object, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doGeneric(arg0Value, interop__);
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1110110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1110110) & ((state_0 & 0b1110110) - 1)) == 0 /* is-single  */) {
                    PointerData s1_ = this.pointer_cache;
                    FunctionData s2_ = this.function_cache;
                    Generic0Data s3_ = this.generic0_cache;
                    if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null) && (s3_ == null || s3_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMNativeConvertNode.NativeToAddress.doLong(long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static NativeToAddress create() {
            return new NativeToAddressNodeGen();
        }

        @GeneratedBy(NativeToAddress.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            @Child PointerData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NativeToAddress#doPointer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            PointerData(PointerData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(NativeToAddress.class)
        @DenyReplace
        private static final class FunctionData extends Node implements SpecializationDataNode {

            @Child FunctionData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NativeToAddress#doFunction}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            FunctionData(FunctionData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(NativeToAddress.class)
        @DenyReplace
        private static final class Generic0Data extends Node implements SpecializationDataNode {

            @Child Generic0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NativeToAddress#doGeneric}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            Generic0Data(Generic0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Id#doConvert}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(Id.class)
    @SuppressWarnings("javadoc")
    protected static final class IdNodeGen extends Id implements GenerateAOT.Provider {

        private IdNodeGen() {
        }

        @Override
        public Object executeConvert(Object arg0Value) {
            return doConvert(arg0Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            {
            }
        }

        @NeverDefault
        public static Id create() {
            return new IdNodeGen();
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link I1FromNativeToLLVMNode#convert(byte)}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link I1FromNativeToLLVMNode#convert(boolean)}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(I1FromNativeToLLVMNode.class)
    @SuppressWarnings("javadoc")
    static final class I1FromNativeToLLVMNodeGen extends I1FromNativeToLLVMNode implements GenerateAOT.Provider {

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link I1FromNativeToLLVMNode#convert(byte)}
         *   2: SpecializationActive {@link I1FromNativeToLLVMNode#convert(boolean)}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private I1FromNativeToLLVMNodeGen() {
        }

        @Override
        public Object executeConvert(Object arg0Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMNativeConvertNode.I1FromNativeToLLVMNode.convert(byte)] || SpecializationActive[LLVMNativeConvertNode.I1FromNativeToLLVMNode.convert(boolean)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMNativeConvertNode.I1FromNativeToLLVMNode.convert(byte)] */ && arg0Value instanceof Byte) {
                    byte arg0Value_ = (byte) arg0Value;
                    return convert(arg0Value_);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMNativeConvertNode.I1FromNativeToLLVMNode.convert(boolean)] */ && arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (boolean) arg0Value;
                    return convert(arg0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMNativeConvertNode.I1FromNativeToLLVMNode.convert(byte)] */;
                this.state_0_ = state_0;
                return convert(arg0Value_);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMNativeConvertNode.I1FromNativeToLLVMNode.convert(boolean)] */;
                this.state_0_ = state_0;
                return convert(arg0Value_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMNativeConvertNode.I1FromNativeToLLVMNode.convert(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMNativeConvertNode.I1FromNativeToLLVMNode.convert(boolean)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static I1FromNativeToLLVMNode create() {
            return new I1FromNativeToLLVMNodeGen();
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link FP80FromNativeToLLVMNode#convert}
     *     Activation probability: 0.65000
     *     With/without class size: 17/4 bytes
     *   Specialization {@link FP80FromNativeToLLVMNode#convert}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(FP80FromNativeToLLVMNode.class)
    @SuppressWarnings("javadoc")
    static final class FP80FromNativeToLLVMNodeGen extends FP80FromNativeToLLVMNode implements GenerateAOT.Provider {

        static final ReferenceField<Convert0Data> CONVERT0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "convert0_cache", Convert0Data.class);

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link FP80FromNativeToLLVMNode#convert}
         *   2: SpecializationActive {@link FP80FromNativeToLLVMNode#convert}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Convert0Data convert0_cache;

        private FP80FromNativeToLLVMNodeGen() {
        }

        @Override
        public Object executeConvert(Object arg0Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMNativeConvertNode.FP80FromNativeToLLVMNode.convert(Object, InteropLibrary)] || SpecializationActive[LLVMNativeConvertNode.FP80FromNativeToLLVMNode.convert(Object, InteropLibrary)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMNativeConvertNode.FP80FromNativeToLLVMNode.convert(Object, InteropLibrary)] */) {
                    Convert0Data s0_ = this.convert0_cache;
                    if (s0_ != null) {
                        if ((s0_.interop_.accepts(arg0Value))) {
                            return convert(arg0Value, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMNativeConvertNode.FP80FromNativeToLLVMNode.convert(Object, InteropLibrary)] */) {
                    return this.convert1Boundary(state_0, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object convert1Boundary(int state_0, Object arg0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return convert(arg0Value, interop__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private LLVM80BitFloat executeAndSpecialize(Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMNativeConvertNode.FP80FromNativeToLLVMNode.convert(Object, InteropLibrary)] */) {
                while (true) {
                    int count0_ = 0;
                    Convert0Data s0_ = CONVERT0_CACHE_UPDATER.getVolatile(this);
                    Convert0Data s0_original = s0_;
                    while (s0_ != null) {
                        if ((s0_.interop_.accepts(arg0Value))) {
                            break;
                        }
                        count0_++;
                        s0_ = null;
                        break;
                    }
                    if (s0_ == null && count0_ < 1) {
                        // assert (s0_.interop_.accepts(arg0Value));
                        s0_ = this.insert(new Convert0Data());
                        InteropLibrary interop__ = s0_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                        Objects.requireNonNull(interop__, "Specialization 'convert(Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.interop_ = interop__;
                        if (!CONVERT0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMNativeConvertNode.FP80FromNativeToLLVMNode.convert(Object, InteropLibrary)] */;
                        this.state_0_ = state_0;
                    }
                    if (s0_ != null) {
                        return convert(arg0Value, s0_.interop_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__ = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        interop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                        this.convert0_cache = null;
                        state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMNativeConvertNode.FP80FromNativeToLLVMNode.convert(Object, InteropLibrary)] */;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMNativeConvertNode.FP80FromNativeToLLVMNode.convert(Object, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return convert(arg0Value, interop__);
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static FP80FromNativeToLLVMNode create() {
            return new FP80FromNativeToLLVMNodeGen();
        }

        @GeneratedBy(FP80FromNativeToLLVMNode.class)
        @DenyReplace
        private static final class Convert0Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link FP80FromNativeToLLVMNode#convert}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            Convert0Data() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link FP128FromNativeToLLVMNode#convert}
     *     Activation probability: 0.65000
     *     With/without class size: 17/4 bytes
     *   Specialization {@link FP128FromNativeToLLVMNode#convert}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(FP128FromNativeToLLVMNode.class)
    @SuppressWarnings("javadoc")
    static final class FP128FromNativeToLLVMNodeGen extends FP128FromNativeToLLVMNode implements GenerateAOT.Provider {

        static final ReferenceField<Convert0Data> CONVERT0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "convert0_cache", Convert0Data.class);

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link FP128FromNativeToLLVMNode#convert}
         *   2: SpecializationActive {@link FP128FromNativeToLLVMNode#convert}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Convert0Data convert0_cache;

        private FP128FromNativeToLLVMNodeGen() {
        }

        @Override
        public Object executeConvert(Object arg0Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMNativeConvertNode.FP128FromNativeToLLVMNode.convert(Object, InteropLibrary)] || SpecializationActive[LLVMNativeConvertNode.FP128FromNativeToLLVMNode.convert(Object, InteropLibrary)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMNativeConvertNode.FP128FromNativeToLLVMNode.convert(Object, InteropLibrary)] */) {
                    Convert0Data s0_ = this.convert0_cache;
                    if (s0_ != null) {
                        if ((s0_.interop_.accepts(arg0Value))) {
                            return convert(arg0Value, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMNativeConvertNode.FP128FromNativeToLLVMNode.convert(Object, InteropLibrary)] */) {
                    return this.convert1Boundary(state_0, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object convert1Boundary(int state_0, Object arg0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return convert(arg0Value, interop__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private LLVM128BitFloat executeAndSpecialize(Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMNativeConvertNode.FP128FromNativeToLLVMNode.convert(Object, InteropLibrary)] */) {
                while (true) {
                    int count0_ = 0;
                    Convert0Data s0_ = CONVERT0_CACHE_UPDATER.getVolatile(this);
                    Convert0Data s0_original = s0_;
                    while (s0_ != null) {
                        if ((s0_.interop_.accepts(arg0Value))) {
                            break;
                        }
                        count0_++;
                        s0_ = null;
                        break;
                    }
                    if (s0_ == null && count0_ < 1) {
                        // assert (s0_.interop_.accepts(arg0Value));
                        s0_ = this.insert(new Convert0Data());
                        InteropLibrary interop__ = s0_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                        Objects.requireNonNull(interop__, "Specialization 'convert(Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.interop_ = interop__;
                        if (!CONVERT0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMNativeConvertNode.FP128FromNativeToLLVMNode.convert(Object, InteropLibrary)] */;
                        this.state_0_ = state_0;
                    }
                    if (s0_ != null) {
                        return convert(arg0Value, s0_.interop_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__ = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        interop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                        this.convert0_cache = null;
                        state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMNativeConvertNode.FP128FromNativeToLLVMNode.convert(Object, InteropLibrary)] */;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMNativeConvertNode.FP128FromNativeToLLVMNode.convert(Object, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return convert(arg0Value, interop__);
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static FP128FromNativeToLLVMNode create() {
            return new FP128FromNativeToLLVMNodeGen();
        }

        @GeneratedBy(FP128FromNativeToLLVMNode.class)
        @DenyReplace
        private static final class Convert0Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link FP128FromNativeToLLVMNode#convert}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            Convert0Data() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
}
