// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMGetStackFromThreadNode;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeWrapper.CallbackHelperNode;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMNativeWrapper.class)
@SuppressWarnings("javadoc")
public final class LLVMNativeWrapperFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link CallbackHelperNode#doCached}
     *     Activation probability: 1.00000
     *     With/without class size: 36/16 bytes
     * </pre>
     */
    @GeneratedBy(CallbackHelperNode.class)
    @SuppressWarnings("javadoc")
    static final class CallbackHelperNodeGen extends CallbackHelperNode implements GenerateAOT.Provider {

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link CallbackHelperNode#doCached}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private CachedData cached_cache;

        private CallbackHelperNodeGen(LLVMNativeWrapper wrapper) {
            super(wrapper);
        }

        @Override
        Object execute(Object[] arg0Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMNativeWrapper.CallbackHelperNode.doCached(Object[], LLVMGetStackFromThreadNode, DirectCallNode, LLVMNativeConvertNode[], LLVMNativeConvertNode)] */) {
                CachedData s0_ = this.cached_cache;
                if (s0_ != null) {
                    return doCached(arg0Value, s0_.getStack_, s0_.call_, s0_.convertArgs_, s0_.convertRet_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(Object[] arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            CachedData s0_ = this.insert(new CachedData());
            s0_.getStack_ = s0_.insert((LLVMGetStackFromThreadNode.create()));
            s0_.call_ = s0_.insert((createCallNode()));
            s0_.convertArgs_ = s0_.insert((createFromNativeNodes()));
            s0_.convertRet_ = s0_.insert((LLVMNativeConvertNode.createToNative(wrapper.code.getLLVMFunction().getType().getReturnType())));
            VarHandle.storeStoreFence();
            this.cached_cache = s0_;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMNativeWrapper.CallbackHelperNode.doCached(Object[], LLVMGetStackFromThreadNode, DirectCallNode, LLVMNativeConvertNode[], LLVMNativeConvertNode)] */;
            this.state_0_ = state_0;
            return doCached(arg0Value, s0_.getStack_, s0_.call_, s0_.convertArgs_, s0_.convertRet_);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CachedData s0_ = this.insert(new CachedData());
                s0_.getStack_ = s0_.insert((LLVMGetStackFromThreadNode.create()));
                s0_.call_ = s0_.insert((createCallNode()));
                s0_.convertArgs_ = s0_.insert((createFromNativeNodes()));
                s0_.convertRet_ = s0_.insert((LLVMNativeConvertNode.createToNative(wrapper.code.getLLVMFunction().getType().getReturnType())));
                VarHandle.storeStoreFence();
                this.cached_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.getStack_, 1);
                ((GenerateAOT.Provider) s0_.getStack_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMNativeWrapper.CallbackHelperNode.doCached(Object[], LLVMGetStackFromThreadNode, DirectCallNode, LLVMNativeConvertNode[], LLVMNativeConvertNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.cached_cache = null;
        }

        @NeverDefault
        public static CallbackHelperNode create(LLVMNativeWrapper wrapper) {
            return new CallbackHelperNodeGen(wrapper);
        }

        @GeneratedBy(CallbackHelperNode.class)
        @DenyReplace
        private static final class CachedData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link CallbackHelperNode#doCached}
             *   Parameter: {@link LLVMGetStackFromThreadNode} getStack</pre>
             */
            @Child LLVMGetStackFromThreadNode getStack_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CallbackHelperNode#doCached}
             *   Parameter: {@link DirectCallNode} call</pre>
             */
            @Child DirectCallNode call_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CallbackHelperNode#doCached}
             *   Parameter: {@link LLVMNativeConvertNode} convertArgs</pre>
             */
            @Children LLVMNativeConvertNode[] convertArgs_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CallbackHelperNode#doCached}
             *   Parameter: {@link LLVMNativeConvertNode} convertRet</pre>
             */
            @Child LLVMNativeConvertNode convertRet_;

            CachedData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
}
