// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibraryDefaults.DefaultAsForeignLibrary;

@GeneratedBy(DefaultAsForeignLibrary.class)
final class DefaultAsForeignLibraryGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(DefaultAsForeignLibrary.class, new LLVMAsForeignLibraryExports());
    }

    private DefaultAsForeignLibraryGen() {
    }

    @GeneratedBy(DefaultAsForeignLibrary.class)
    private static final class LLVMAsForeignLibraryExports extends LibraryExport<LLVMAsForeignLibrary> {

        private LLVMAsForeignLibraryExports() {
            super(LLVMAsForeignLibrary.class, Object.class, true, false, 0);
        }

        @Override
        protected LLVMAsForeignLibrary createUncached(Object receiver) {
            LLVMAsForeignLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected LLVMAsForeignLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(DefaultAsForeignLibrary.class)
        private static final class Cached extends LLVMAsForeignLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isForeign(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return DefaultAsForeignLibrary.isForeign((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public Object asForeign(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return DefaultAsForeignLibrary.asForeign((dynamicDispatch_.cast(receiver)));
            }

        }
        @GeneratedBy(DefaultAsForeignLibrary.class)
        @DenyReplace
        private static final class Uncached extends LLVMAsForeignLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isForeign(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return DefaultAsForeignLibrary.isForeign(receiver);
            }

            @TruffleBoundary
            @Override
            public Object asForeign(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return DefaultAsForeignLibrary.asForeign(receiver);
            }

        }
    }
}
