// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults.FallbackRead;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults.VirtualAlloc;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMManagedReadLibrary.class)
final class LLVMManagedReadLibraryGen extends LibraryFactory<LLVMManagedReadLibrary> {

    private static final Class<LLVMManagedReadLibrary> LIBRARY_CLASS = LLVMManagedReadLibraryGen.lazyLibraryClass();
    private static final Message IS_READABLE = new MessageImpl("isReadable", 0, false, boolean.class, Object.class);
    private static final Message READ_I8 = new MessageImpl("readI8", 1, false, byte.class, Object.class, long.class);
    private static final Message READ_I16 = new MessageImpl("readI16", 2, false, short.class, Object.class, long.class);
    private static final Message READ_I32 = new MessageImpl("readI32", 3, false, int.class, Object.class, long.class);
    private static final Message READ_FLOAT = new MessageImpl("readFloat", 4, false, float.class, Object.class, long.class);
    private static final Message READ_I64 = new MessageImpl("readI64", 5, false, long.class, Object.class, long.class);
    private static final Message READ_DOUBLE = new MessageImpl("readDouble", 6, false, double.class, Object.class, long.class);
    private static final Message READ_POINTER = new MessageImpl("readPointer", 7, false, LLVMPointer.class, Object.class, long.class);
    private static final Message READ_GENERIC_I64 = new MessageImpl("readGenericI64", 8, false, Object.class, Object.class, long.class);
    private static final LLVMManagedReadLibraryGen INSTANCE = new LLVMManagedReadLibraryGen();

    static  {
        LibraryFactory.register(LLVMManagedReadLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private LLVMManagedReadLibraryGen() {
        super(LLVMManagedReadLibraryGen.LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(LLVMManagedReadLibraryGen.IS_READABLE, LLVMManagedReadLibraryGen.READ_I8, LLVMManagedReadLibraryGen.READ_I16, LLVMManagedReadLibraryGen.READ_I32, LLVMManagedReadLibraryGen.READ_FLOAT, LLVMManagedReadLibraryGen.READ_I64, LLVMManagedReadLibraryGen.READ_DOUBLE, LLVMManagedReadLibraryGen.READ_POINTER, LLVMManagedReadLibraryGen.READ_GENERIC_I64)));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof byte[]) {
            return VirtualAlloc.class;
        } else {
            return FallbackRead.class;
        }
    }

    @Override
    protected Lookup getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    protected LLVMManagedReadLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected LLVMManagedReadLibrary createDelegate(LLVMManagedReadLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        LLVMManagedReadLibrary lib = (LLVMManagedReadLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                return lib.isReadable(receiver);
            case 1 :
                return lib.readI8(receiver, (long) args[offset]);
            case 2 :
                return lib.readI16(receiver, (long) args[offset]);
            case 3 :
                return lib.readI32(receiver, (long) args[offset]);
            case 4 :
                return lib.readFloat(receiver, (long) args[offset]);
            case 5 :
                return lib.readI64(receiver, (long) args[offset]);
            case 6 :
                return lib.readDouble(receiver, (long) args[offset]);
            case 7 :
                return lib.readPointer(receiver, (long) args[offset]);
            case 8 :
                return lib.readGenericI64(receiver, (long) args[offset]);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected LLVMManagedReadLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected LLVMManagedReadLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<LLVMManagedReadLibrary> lazyLibraryClass() {
        try {
            return (Class<LLVMManagedReadLibrary>) Class.forName("com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary", false, LLVMManagedReadLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(LLVMManagedReadLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(LLVMManagedReadLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(LLVMManagedReadLibrary.class)
    private static final class Proxy extends LLVMManagedReadLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isReadable(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, LLVMManagedReadLibraryGen.IS_READABLE);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public byte readI8(Object receiver_, long offset) {
            try {
                return (byte) lib.send(receiver_, LLVMManagedReadLibraryGen.READ_I8, offset);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public short readI16(Object receiver_, long offset) {
            try {
                return (short) lib.send(receiver_, LLVMManagedReadLibraryGen.READ_I16, offset);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public int readI32(Object receiver_, long offset) {
            try {
                return (int) lib.send(receiver_, LLVMManagedReadLibraryGen.READ_I32, offset);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public float readFloat(Object receiver_, long offset) {
            try {
                return (float) lib.send(receiver_, LLVMManagedReadLibraryGen.READ_FLOAT, offset);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public long readI64(Object receiver_, long offset) throws UnexpectedResultException {
            try {
                return (long) lib.send(receiver_, LLVMManagedReadLibraryGen.READ_I64, offset);
            } catch (UnexpectedResultException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public double readDouble(Object receiver_, long offset) {
            try {
                return (double) lib.send(receiver_, LLVMManagedReadLibraryGen.READ_DOUBLE, offset);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public LLVMPointer readPointer(Object receiver_, long offset) {
            try {
                return (LLVMPointer) lib.send(receiver_, LLVMManagedReadLibraryGen.READ_POINTER, offset);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Object readGenericI64(Object receiver_, long offset) {
            try {
                return lib.send(receiver_, LLVMManagedReadLibraryGen.READ_GENERIC_I64, offset);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(LLVMManagedReadLibrary.class)
    private static final class Delegate extends LLVMManagedReadLibrary {

        @Child private LLVMManagedReadLibrary delegateLibrary;

        Delegate(LLVMManagedReadLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isReadable(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).isReadable(delegate);
            } else {
                return this.delegateLibrary.isReadable(receiver_);
            }
        }

        @Override
        public byte readI8(Object receiver_, long offset) {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readI8(delegate, offset);
            } else {
                return this.delegateLibrary.readI8(receiver_, offset);
            }
        }

        @Override
        public short readI16(Object receiver_, long offset) {
            if (LibraryFactory.isDelegated(delegateLibrary, 2)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readI16(delegate, offset);
            } else {
                return this.delegateLibrary.readI16(receiver_, offset);
            }
        }

        @Override
        public int readI32(Object receiver_, long offset) {
            if (LibraryFactory.isDelegated(delegateLibrary, 3)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readI32(delegate, offset);
            } else {
                return this.delegateLibrary.readI32(receiver_, offset);
            }
        }

        @Override
        public float readFloat(Object receiver_, long offset) {
            if (LibraryFactory.isDelegated(delegateLibrary, 4)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readFloat(delegate, offset);
            } else {
                return this.delegateLibrary.readFloat(receiver_, offset);
            }
        }

        @Override
        public long readI64(Object receiver_, long offset) throws UnexpectedResultException {
            if (LibraryFactory.isDelegated(delegateLibrary, 5)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readI64(delegate, offset);
            } else {
                return this.delegateLibrary.readI64(receiver_, offset);
            }
        }

        @Override
        public double readDouble(Object receiver_, long offset) {
            if (LibraryFactory.isDelegated(delegateLibrary, 6)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readDouble(delegate, offset);
            } else {
                return this.delegateLibrary.readDouble(receiver_, offset);
            }
        }

        @Override
        public LLVMPointer readPointer(Object receiver_, long offset) {
            if (LibraryFactory.isDelegated(delegateLibrary, 7)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readPointer(delegate, offset);
            } else {
                return this.delegateLibrary.readPointer(receiver_, offset);
            }
        }

        @Override
        public Object readGenericI64(Object receiver_, long offset) {
            if (LibraryFactory.isDelegated(delegateLibrary, 8)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readGenericI64(delegate, offset);
            } else {
                return this.delegateLibrary.readGenericI64(receiver_, offset);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(LLVMManagedReadLibrary.class)
    private static final class CachedToUncachedDispatch extends LLVMManagedReadLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public boolean isReadable(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).isReadable(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public byte readI8(Object receiver_, long offset) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readI8(receiver_, offset);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public short readI16(Object receiver_, long offset) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readI16(receiver_, offset);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public int readI32(Object receiver_, long offset) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readI32(receiver_, offset);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public float readFloat(Object receiver_, long offset) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readFloat(receiver_, offset);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public long readI64(Object receiver_, long offset) throws UnexpectedResultException {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readI64(receiver_, offset);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public double readDouble(Object receiver_, long offset) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readDouble(receiver_, offset);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public LLVMPointer readPointer(Object receiver_, long offset) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readPointer(receiver_, offset);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Object readGenericI64(Object receiver_, long offset) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readGenericI64(receiver_, offset);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(LLVMManagedReadLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends LLVMManagedReadLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public boolean isReadable(Object receiver_) {
            return INSTANCE.getUncached(receiver_).isReadable(receiver_);
        }

        @TruffleBoundary
        @Override
        public byte readI8(Object receiver_, long offset) {
            return INSTANCE.getUncached(receiver_).readI8(receiver_, offset);
        }

        @TruffleBoundary
        @Override
        public short readI16(Object receiver_, long offset) {
            return INSTANCE.getUncached(receiver_).readI16(receiver_, offset);
        }

        @TruffleBoundary
        @Override
        public int readI32(Object receiver_, long offset) {
            return INSTANCE.getUncached(receiver_).readI32(receiver_, offset);
        }

        @TruffleBoundary
        @Override
        public float readFloat(Object receiver_, long offset) {
            return INSTANCE.getUncached(receiver_).readFloat(receiver_, offset);
        }

        @TruffleBoundary
        @Override
        public long readI64(Object receiver_, long offset) throws UnexpectedResultException {
            return INSTANCE.getUncached(receiver_).readI64(receiver_, offset);
        }

        @TruffleBoundary
        @Override
        public double readDouble(Object receiver_, long offset) {
            return INSTANCE.getUncached(receiver_).readDouble(receiver_, offset);
        }

        @TruffleBoundary
        @Override
        public LLVMPointer readPointer(Object receiver_, long offset) {
            return INSTANCE.getUncached(receiver_).readPointer(receiver_, offset);
        }

        @TruffleBoundary
        @Override
        public Object readGenericI64(Object receiver_, long offset) {
            return INSTANCE.getUncached(receiver_).readGenericI64(receiver_, offset);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(LLVMManagedReadLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(LLVMManagedReadLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMManagedReadLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch implements GenerateAOT.Provider {

        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(LLVMManagedReadLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport<LLVMManagedReadLibrary> export : INSTANCE.getAOTExports()) {
                LLVMManagedReadLibrary exportLibrary = INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = insert(exportLibrary);
                } else {
                    this.next = insert(new CachedDispatchNext(exportLibrary, this.next));
                }
            }
            this.aot_ = true;
        }

        @Override
        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library != null) {
                    count++;
                }
                current = current.next;
            } while (current != null);
            return NodeCost.fromCount(count);
        }

    }
    @GeneratedBy(LLVMManagedReadLibrary.class)
    private abstract static class CachedDispatch extends LLVMManagedReadLibrary {

        @Child LLVMManagedReadLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(LLVMManagedReadLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean value);

        @ExplodeLoop
        @Override
        public boolean isReadable(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.isReadable(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public byte readI8(Object receiver_, long offset) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readI8(receiver_, offset);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public short readI16(Object receiver_, long offset) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readI16(receiver_, offset);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public int readI32(Object receiver_, long offset) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readI32(receiver_, offset);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public float readFloat(Object receiver_, long offset) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readFloat(receiver_, offset);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public long readI64(Object receiver_, long offset) throws UnexpectedResultException {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readI64(receiver_, offset);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public double readDouble(Object receiver_, long offset) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readDouble(receiver_, offset);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public LLVMPointer readPointer(Object receiver_, long offset) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readPointer(receiver_, offset);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Object readGenericI64(Object receiver_, long offset) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readGenericI64(receiver_, offset);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                if (isAOT()) {
                    this.library = null;
                    this.next = null;
                    setAOT(false);
                }
                CachedDispatch current = this;
                LLVMManagedReadLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        LLVMManagedReadLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
