// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMAMD64LockedInstructionNode#doNative}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMAMD64LockedInstructionNode#doManaged}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMAMD64LockedInstructionNode.class)
@SuppressWarnings("javadoc")
public final class LLVMAMD64LockedInstructionNodeGen extends LLVMAMD64LockedInstructionNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode address_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMAMD64LockedInstructionNode#doNative}
     *   2: SpecializationActive {@link LLVMAMD64LockedInstructionNode#doManaged}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMAMD64LockedInstructionNodeGen(LLVMStatementNode statement, LLVMExpressionNode address) {
        super(statement);
        this.address_ = address;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(frameValue, addressValue_);
            return;
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMAMD64LockedInstructionNode.doNative(VirtualFrame, LLVMNativePointer)] || SpecializationActive[LLVMAMD64LockedInstructionNode.doManaged(VirtualFrame, LLVMManagedPointer)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64LockedInstructionNode.doNative(VirtualFrame, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                doNative(frameValue, addressValue__);
                return;
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64LockedInstructionNode.doManaged(VirtualFrame, LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                doManaged(frameValue, addressValue__);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(frameValue, addressValue_);
        return;
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object addressValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64LockedInstructionNode.doNative(VirtualFrame, LLVMNativePointer)] */;
            this.state_0_ = state_0;
            doNative(frameValue, addressValue_);
            return;
        }
        if (LLVMTypes.isManagedPointer(addressValue)) {
            LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64LockedInstructionNode.doManaged(VirtualFrame, LLVMManagedPointer)] */;
            this.state_0_ = state_0;
            doManaged(frameValue, addressValue_);
            return;
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64LockedInstructionNode.doNative(VirtualFrame, LLVMNativePointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64LockedInstructionNode.doManaged(VirtualFrame, LLVMManagedPointer)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMAMD64LockedInstructionNode create(LLVMStatementNode statement, LLVMExpressionNode address) {
        return new LLVMAMD64LockedInstructionNodeGen(statement, address);
    }

}
