// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMToI64Node#doNative}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMToI64Node#doManaged}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMToI64Node.class)
@SuppressWarnings("javadoc")
public final class LLVMToI64NodeGen extends LLVMToI64Node implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode fromNode_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMToI64Node#doNative}
     *   2: SpecializationActive {@link LLVMToI64Node#doManaged}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMToI64NodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    @Override
    public Object executeWithTarget(Object fromNodeValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] || SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(fromNodeValue)) {
                LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                return doNative(fromNodeValue_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                return doManaged(fromNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] || SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(fromNodeValue_)) {
                LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                return doNative(fromNodeValue__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                return doManaged(fromNodeValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue_);
    }

    @Override
    public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */) {
            return LLVMTypesGen.expectLong(executeGeneric(frameValue));
        }
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(fromNodeValue_)) {
            LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
            return doNative(fromNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
    }

    private Object executeAndSpecialize(Object fromNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(fromNodeValue)) {
            LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */;
            this.state_0_ = state_0;
            return doNative(fromNodeValue_);
        }
        if (LLVMTypes.isManagedPointer(fromNodeValue)) {
            LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */;
            this.state_0_ = state_0;
            return doManaged(fromNodeValue_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMToI64Node create(LLVMExpressionNode fromNode) {
        return new LLVMToI64NodeGen(fromNode);
    }

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToI64Node#doNative}
     *     Activation probability: 0.14679
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMToI64Node#doManaged}
     *     Activation probability: 0.13526
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToI64Node#doI64(boolean)}
     *     Activation probability: 0.12372
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToI64Node#doI64(byte)}
     *     Activation probability: 0.11218
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToI64Node#doI64(short)}
     *     Activation probability: 0.10064
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToI64Node#doI64(int)}
     *     Activation probability: 0.08910
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToI64Node#doI64(long)}
     *     Activation probability: 0.07756
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI64Node#doI64(LLVMIVarBit)}
     *     Activation probability: 0.06603
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI64Node#doI64(float)}
     *     Activation probability: 0.05449
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI64Node#doI64(double)}
     *     Activation probability: 0.04295
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI64Node#doI64(LLVM80BitFloat)}
     *     Activation probability: 0.03141
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI64Node#doI64(LLVM128BitFloat)}
     *     Activation probability: 0.01987
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMSignedCastToI64Node.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMSignedCastToI64NodeGen extends LLVMSignedCastToI64Node implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToI64Node#doNative}
         *   2: SpecializationActive {@link LLVMToI64Node#doManaged}
         *   3: SpecializationActive {@link LLVMSignedCastToI64Node#doI64(boolean)}
         *   4: SpecializationActive {@link LLVMSignedCastToI64Node#doI64(byte)}
         *   5: SpecializationActive {@link LLVMSignedCastToI64Node#doI64(short)}
         *   6: SpecializationActive {@link LLVMSignedCastToI64Node#doI64(int)}
         *   7: SpecializationActive {@link LLVMSignedCastToI64Node#doI64(long)}
         *   8: SpecializationActive {@link LLVMSignedCastToI64Node#doI64(LLVMIVarBit)}
         *   9: SpecializationActive {@link LLVMSignedCastToI64Node#doI64(float)}
         *   10: SpecializationActive {@link LLVMSignedCastToI64Node#doI64(double)}
         *   11: SpecializationActive {@link LLVMSignedCastToI64Node#doI64(LLVM80BitFloat)}
         *   12: SpecializationActive {@link LLVMSignedCastToI64Node#doI64(LLVM128BitFloat)}
         *   13-15: ImplicitCast[type=LLVMIVarBit, index=0]
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMSignedCastToI64NodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeWithTarget(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0b1111111111110) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] || SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(fromNodeValue)) {
                    LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                    return doNative(fromNodeValue_);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(fromNodeValue)) {
                    LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                    return doManaged(fromNodeValue_);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] */ && fromNodeValue instanceof Boolean) {
                    boolean fromNodeValue_ = (boolean) fromNodeValue;
                    return doI64(fromNodeValue_);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] */ && fromNodeValue instanceof Byte) {
                    byte fromNodeValue_ = (byte) fromNodeValue;
                    return doI64(fromNodeValue_);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] */ && fromNodeValue instanceof Short) {
                    short fromNodeValue_ = (short) fromNodeValue;
                    return doI64(fromNodeValue_);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] */ && fromNodeValue instanceof Integer) {
                    int fromNodeValue_ = (int) fromNodeValue;
                    return doI64(fromNodeValue_);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] */ && fromNodeValue instanceof Long) {
                    long fromNodeValue_ = (long) fromNodeValue;
                    return doI64(fromNodeValue_);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue)) {
                    LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue);
                    return doI64(fromNodeValue_);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] */ && fromNodeValue instanceof Float) {
                    float fromNodeValue_ = (float) fromNodeValue;
                    return doI64(fromNodeValue_);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] */ && fromNodeValue instanceof Double) {
                    double fromNodeValue_ = (double) fromNodeValue;
                    return doI64(fromNodeValue_);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] */ && fromNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat) fromNodeValue;
                    return doI64(fromNodeValue_);
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */ && fromNodeValue instanceof LLVM128BitFloat) {
                    LLVM128BitFloat fromNodeValue_ = (LLVM128BitFloat) fromNodeValue;
                    return doI64(fromNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111111110110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else if ((state_0 & 0b1111111101110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */)) {
                return executeGeneric_byte1(state_0, frameValue);
            } else if ((state_0 & 0b1111111011110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b1111110111110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */)) {
                return executeGeneric_int3(state_0, frameValue);
            } else if ((state_0 & 0b1111101111110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */)) {
                return executeGeneric_long4(state_0, frameValue);
            } else if ((state_0 & 0b1110111111110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */)) {
                return executeGeneric_float5(state_0, frameValue);
            } else if ((state_0 & 0b1101111111110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */)) {
                return executeGeneric_double6(state_0, frameValue);
            } else {
                return executeGeneric_generic7(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] */;
            return doI64(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] */;
            return doI64(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] */;
            return doI64(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] */;
            return doI64(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] */;
            return doI64(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] */;
            return doI64(fromNodeValue_);
        }

        private Object executeGeneric_double6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] */;
            return doI64(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b1111111111110) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] || SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    return doNative(fromNodeValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    return doManaged(fromNodeValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_);
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */ && fromNodeValue_ instanceof LLVM128BitFloat) {
                    LLVM128BitFloat fromNodeValue__ = (LLVM128BitFloat) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */) {
                return LLVMTypesGen.expectLong(executeGeneric(frameValue));
            }
            if ((state_0 & 0b1111111110010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] */ && ((state_0 & 0b1111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */)) {
                return executeI64_boolean8(state_0, frameValue);
            } else if ((state_0 & 0b1111111101010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] */ && ((state_0 & 0b1111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */)) {
                return executeI64_byte9(state_0, frameValue);
            } else if ((state_0 & 0b1111111011010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] */ && ((state_0 & 0b1111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */)) {
                return executeI64_short10(state_0, frameValue);
            } else if ((state_0 & 0b1111110111010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] */ && ((state_0 & 0b1111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */)) {
                return executeI64_int11(state_0, frameValue);
            } else if ((state_0 & 0b1111101111010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] */ && ((state_0 & 0b1111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */)) {
                return executeI64_long12(state_0, frameValue);
            } else if ((state_0 & 0b1110111111010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] */ && ((state_0 & 0b1111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */)) {
                return executeI64_float13(state_0, frameValue);
            } else if ((state_0 & 0b1101111111010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] */ && ((state_0 & 0b1111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] && SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */)) {
                return executeI64_double14(state_0, frameValue);
            } else {
                return executeI64_generic15(state_0, frameValue);
            }
        }

        private long executeI64_boolean8(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] */;
            return doI64(fromNodeValue_);
        }

        private long executeI64_byte9(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] */;
            return doI64(fromNodeValue_);
        }

        private long executeI64_short10(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] */;
            return doI64(fromNodeValue_);
        }

        private long executeI64_int11(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] */;
            return doI64(fromNodeValue_);
        }

        private long executeI64_long12(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] */;
            return doI64(fromNodeValue_);
        }

        private long executeI64_float13(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] */;
            return doI64(fromNodeValue_);
        }

        private long executeI64_double14(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] */;
            return doI64(fromNodeValue_);
        }

        private long executeI64_generic15(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            if ((state_0 & 0b1111111111010) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] || SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    return doNative(fromNodeValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_);
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */ && fromNodeValue_ instanceof LLVM128BitFloat) {
                    LLVM128BitFloat fromNodeValue__ = (LLVM128BitFloat) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
        }

        private Object executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(fromNodeValue)) {
                LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doNative(fromNodeValue_);
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */;
                this.state_0_ = state_0;
                return doManaged(fromNodeValue_);
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (short) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            {
                int lLVMIVarBitCast0;
                if ((lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(fromNodeValue)) != 0) {
                    LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, fromNodeValue);
                    state_0 = (state_0 | (lLVMIVarBitCast0 << 13) /* set-int ImplicitCast[type=LLVMIVarBit, index=0] */);
                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] */;
                    this.state_0_ = state_0;
                    return doI64(fromNodeValue_);
                }
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat) fromNodeValue;
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat fromNodeValue_ = (LLVM128BitFloat) fromNodeValue;
                state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111111111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111111111110) & ((state_0 & 0b1111111111110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVMIVarBit)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(float)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(double)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM80BitFloat)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000000 /* add SpecializationActive[LLVMToI64Node.LLVMSignedCastToI64Node.doI64(LLVM128BitFloat)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            state_0 = state_0 | 0b1110000000000000 /* add ImplicitCast[type=LLVMIVarBit, index=0] */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMSignedCastToI64Node create(LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToI64NodeGen(fromNode);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToI64Node#doNative}
     *     Activation probability: 0.15909
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMToI64Node#doManaged}
     *     Activation probability: 0.14545
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToI64Node#doI1}
     *     Activation probability: 0.13182
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToI64Node#doI8}
     *     Activation probability: 0.11818
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToI64Node#doI16}
     *     Activation probability: 0.10455
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToI64Node#doI32}
     *     Activation probability: 0.09091
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToI64Node#doI64}
     *     Activation probability: 0.07727
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMUnsignedCastToI64Node#doIVarBit}
     *     Activation probability: 0.06364
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMUnsignedCastToI64Node#doFloat}
     *     Activation probability: 0.05000
     *     With/without class size: 4/4 bytes
     *   Specialization {@link LLVMUnsignedCastToI64Node#doDouble}
     *     Activation probability: 0.03636
     *     With/without class size: 4/4 bytes
     *   Specialization {@link LLVMUnsignedCastToI64Node#do80LLVMBitFloat}
     *     Activation probability: 0.02273
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMUnsignedCastToI64Node.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMUnsignedCastToI64NodeGen extends LLVMUnsignedCastToI64Node implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToI64Node#doNative}
         *   2: SpecializationActive {@link LLVMToI64Node#doManaged}
         *   3: SpecializationActive {@link LLVMUnsignedCastToI64Node#doI1}
         *   4: SpecializationActive {@link LLVMUnsignedCastToI64Node#doI8}
         *   5: SpecializationActive {@link LLVMUnsignedCastToI64Node#doI16}
         *   6: SpecializationActive {@link LLVMUnsignedCastToI64Node#doI32}
         *   7: SpecializationActive {@link LLVMUnsignedCastToI64Node#doI64}
         *   8: SpecializationActive {@link LLVMUnsignedCastToI64Node#doIVarBit}
         *   9: SpecializationActive {@link LLVMUnsignedCastToI64Node#doFloat}
         *   10: SpecializationActive {@link LLVMUnsignedCastToI64Node#doDouble}
         *   11: SpecializationActive {@link LLVMUnsignedCastToI64Node#do80LLVMBitFloat}
         *   12-14: ImplicitCast[type=LLVMIVarBit, index=0]
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMUnsignedCastToI64Node#doFloat}
         *   Parameter: {@link ConditionProfile} profile</pre>
         */
        @CompilationFinal private ConditionProfile float_profile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMUnsignedCastToI64Node#doDouble}
         *   Parameter: {@link ConditionProfile} profile</pre>
         */
        @CompilationFinal private ConditionProfile double_profile_;

        private LLVMUnsignedCastToI64NodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeWithTarget(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0b111111111110) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] || SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(fromNodeValue)) {
                    LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                    return doNative(fromNodeValue_);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(fromNodeValue)) {
                    LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                    return doManaged(fromNodeValue_);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] */ && fromNodeValue instanceof Boolean) {
                    boolean fromNodeValue_ = (boolean) fromNodeValue;
                    return doI1(fromNodeValue_);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] */ && fromNodeValue instanceof Byte) {
                    byte fromNodeValue_ = (byte) fromNodeValue;
                    return doI8(fromNodeValue_);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] */ && fromNodeValue instanceof Short) {
                    short fromNodeValue_ = (short) fromNodeValue;
                    return doI16(fromNodeValue_);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] */ && fromNodeValue instanceof Integer) {
                    int fromNodeValue_ = (int) fromNodeValue;
                    return doI32(fromNodeValue_);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] */ && fromNodeValue instanceof Long) {
                    long fromNodeValue_ = (long) fromNodeValue;
                    return doI64(fromNodeValue_);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue)) {
                    LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue);
                    return doIVarBit(fromNodeValue_);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] */ && fromNodeValue instanceof Float) {
                    float fromNodeValue_ = (float) fromNodeValue;
                    {
                        ConditionProfile profile__ = this.float_profile_;
                        if (profile__ != null) {
                            return doFloat(fromNodeValue_, profile__);
                        }
                    }
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] */ && fromNodeValue instanceof Double) {
                    double fromNodeValue_ = (double) fromNodeValue;
                    {
                        ConditionProfile profile__1 = this.double_profile_;
                        if (profile__1 != null) {
                            return doDouble(fromNodeValue_, profile__1);
                        }
                    }
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */ && fromNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat) fromNodeValue;
                    return do80LLVMBitFloat(fromNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111111110110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else if ((state_0 & 0b111111101110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_byte1(state_0, frameValue);
            } else if ((state_0 & 0b111111011110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b111110111110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_int3(state_0, frameValue);
            } else if ((state_0 & 0b111101111110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_long4(state_0, frameValue);
            } else if ((state_0 & 0b110111111110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_float5(state_0, frameValue);
            } else if ((state_0 & 0b101111111110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_double6(state_0, frameValue);
            } else {
                return executeGeneric_generic7(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] */;
            return doI1(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] */;
            return doI8(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] */;
            return doI16(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] */;
            return doI32(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] */;
            return doI64(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] */;
            {
                ConditionProfile profile__ = this.float_profile_;
                if (profile__ != null) {
                    return doFloat(fromNodeValue_, profile__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        private Object executeGeneric_double6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] */;
            {
                ConditionProfile profile__1 = this.double_profile_;
                if (profile__1 != null) {
                    return doDouble(fromNodeValue_, profile__1);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b111111111110) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] || SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    return doNative(fromNodeValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    return doManaged(fromNodeValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doI1(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doI16(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doI32(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_);
                    return doIVarBit(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    {
                        ConditionProfile profile__ = this.float_profile_;
                        if (profile__ != null) {
                            return doFloat(fromNodeValue__, profile__);
                        }
                    }
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    {
                        ConditionProfile profile__1 = this.double_profile_;
                        if (profile__1 != null) {
                            return doDouble(fromNodeValue__, profile__1);
                        }
                    }
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return do80LLVMBitFloat(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */) {
                return LLVMTypesGen.expectLong(executeGeneric(frameValue));
            }
            if ((state_0 & 0b111111110010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] */ && ((state_0 & 0b111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */)) {
                return executeI64_boolean8(state_0, frameValue);
            } else if ((state_0 & 0b111111101010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] */ && ((state_0 & 0b111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */)) {
                return executeI64_byte9(state_0, frameValue);
            } else if ((state_0 & 0b111111011010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] */ && ((state_0 & 0b111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */)) {
                return executeI64_short10(state_0, frameValue);
            } else if ((state_0 & 0b111110111010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] */ && ((state_0 & 0b111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */)) {
                return executeI64_int11(state_0, frameValue);
            } else if ((state_0 & 0b111101111010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] */ && ((state_0 & 0b111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */)) {
                return executeI64_long12(state_0, frameValue);
            } else if ((state_0 & 0b110111111010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] */ && ((state_0 & 0b111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */)) {
                return executeI64_float13(state_0, frameValue);
            } else if ((state_0 & 0b101111111010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] */ && ((state_0 & 0b111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] && SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */)) {
                return executeI64_double14(state_0, frameValue);
            } else {
                return executeI64_generic15(state_0, frameValue);
            }
        }

        private long executeI64_boolean8(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] */;
            return doI1(fromNodeValue_);
        }

        private long executeI64_byte9(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] */;
            return doI8(fromNodeValue_);
        }

        private long executeI64_short10(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] */;
            return doI16(fromNodeValue_);
        }

        private long executeI64_int11(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] */;
            return doI32(fromNodeValue_);
        }

        private long executeI64_long12(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] */;
            return doI64(fromNodeValue_);
        }

        private long executeI64_float13(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] */;
            {
                ConditionProfile profile__ = this.float_profile_;
                if (profile__ != null) {
                    return doFloat(fromNodeValue_, profile__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
        }

        private long executeI64_double14(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] */;
            {
                ConditionProfile profile__1 = this.double_profile_;
                if (profile__1 != null) {
                    return doDouble(fromNodeValue_, profile__1);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
        }

        private long executeI64_generic15(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            if ((state_0 & 0b111111111010) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] || SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    return doNative(fromNodeValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doI1(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doI16(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doI32(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_);
                    return doIVarBit(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    {
                        ConditionProfile profile__ = this.float_profile_;
                        if (profile__ != null) {
                            return doFloat(fromNodeValue__, profile__);
                        }
                    }
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    {
                        ConditionProfile profile__1 = this.double_profile_;
                        if (profile__1 != null) {
                            return doDouble(fromNodeValue__, profile__1);
                        }
                    }
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return do80LLVMBitFloat(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
        }

        private Object executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(fromNodeValue)) {
                LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doNative(fromNodeValue_);
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */;
                this.state_0_ = state_0;
                return doManaged(fromNodeValue_);
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] */;
                this.state_0_ = state_0;
                return doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] */;
                this.state_0_ = state_0;
                return doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (short) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] */;
                this.state_0_ = state_0;
                return doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] */;
                this.state_0_ = state_0;
                return doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            {
                int lLVMIVarBitCast0;
                if ((lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(fromNodeValue)) != 0) {
                    LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, fromNodeValue);
                    state_0 = (state_0 | (lLVMIVarBitCast0 << 12) /* set-int ImplicitCast[type=LLVMIVarBit, index=0] */);
                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] */;
                    this.state_0_ = state_0;
                    return doIVarBit(fromNodeValue_);
                }
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                ConditionProfile profile__ = (ConditionProfile.create());
                Objects.requireNonNull(profile__, "Specialization 'doFloat(float, ConditionProfile)' cache 'profile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.float_profile_ = profile__;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_, profile__);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                ConditionProfile profile__1 = (ConditionProfile.create());
                Objects.requireNonNull(profile__1, "Specialization 'doDouble(double, ConditionProfile)' cache 'profile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.double_profile_ = profile__1;
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_, profile__1);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat) fromNodeValue;
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */;
                this.state_0_ = state_0;
                return do80LLVMBitFloat(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111111111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b111111111110) & ((state_0 & 0b111111111110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI1(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI8(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI16(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI32(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doI64(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doIVarBit(LLVMIVarBit)] */;
            }
            {
                ConditionProfile profile__ = (ConditionProfile.create());
                Objects.requireNonNull(profile__, "Specialization 'doFloat(float, ConditionProfile)' cache 'profile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.float_profile_ = profile__;
                this.float_profile_.disable();
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doFloat(float, ConditionProfile)] */;
            }
            {
                ConditionProfile profile__1 = (ConditionProfile.create());
                Objects.requireNonNull(profile__1, "Specialization 'doDouble(double, ConditionProfile)' cache 'profile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.double_profile_ = profile__1;
                this.double_profile_.disable();
                this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.doDouble(double, ConditionProfile)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000000 /* add SpecializationActive[LLVMToI64Node.LLVMUnsignedCastToI64Node.do80LLVMBitFloat(LLVM80BitFloat)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            state_0 = state_0 | 0b111000000000000 /* add ImplicitCast[type=LLVMIVarBit, index=0] */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.float_profile_.reset();
            this.double_profile_.reset();
        }

        @NeverDefault
        public static LLVMUnsignedCastToI64Node create(LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToI64NodeGen(fromNode);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToI64Node#doNative}
     *     Activation probability: 0.15909
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMToI64Node#doManaged}
     *     Activation probability: 0.14545
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToI64Node#doI64(double)}
     *     Activation probability: 0.13182
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToI64Node#doI64(long)}
     *     Activation probability: 0.11818
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToI64Node#doI1Vector}
     *     Activation probability: 0.10455
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToI64Node#doI8Vector}
     *     Activation probability: 0.09091
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToI64Node#doI16Vector}
     *     Activation probability: 0.07727
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToI64Node#doI32Vector}
     *     Activation probability: 0.06364
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToI64Node#doFloatVector}
     *     Activation probability: 0.05000
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToI64Node#doI64Vector}
     *     Activation probability: 0.03636
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToI64Node#doDoubleVector}
     *     Activation probability: 0.02273
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMBitcastToI64Node.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMBitcastToI64NodeGen extends LLVMBitcastToI64Node implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToI64Node#doNative}
         *   2: SpecializationActive {@link LLVMToI64Node#doManaged}
         *   3: SpecializationActive {@link LLVMBitcastToI64Node#doI64(double)}
         *   4: SpecializationActive {@link LLVMBitcastToI64Node#doI64(long)}
         *   5: SpecializationActive {@link LLVMBitcastToI64Node#doI1Vector}
         *   6: SpecializationActive {@link LLVMBitcastToI64Node#doI8Vector}
         *   7: SpecializationActive {@link LLVMBitcastToI64Node#doI16Vector}
         *   8: SpecializationActive {@link LLVMBitcastToI64Node#doI32Vector}
         *   9: SpecializationActive {@link LLVMBitcastToI64Node#doFloatVector}
         *   10: SpecializationActive {@link LLVMBitcastToI64Node#doI64Vector}
         *   11: SpecializationActive {@link LLVMBitcastToI64Node#doDoubleVector}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMBitcastToI64NodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeWithTarget(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0b111111111110) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] || SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI1Vector(LLVMI1Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI8Vector(LLVMI8Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI16Vector(LLVMI16Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI32Vector(LLVMI32Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doFloatVector(LLVMFloatVector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64Vector(LLVMI64Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doDoubleVector(LLVMDoubleVector)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(fromNodeValue)) {
                    LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                    return doNative(fromNodeValue_);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(fromNodeValue)) {
                    LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                    return doManaged(fromNodeValue_);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] */ && fromNodeValue instanceof Double) {
                    double fromNodeValue_ = (double) fromNodeValue;
                    return doI64(fromNodeValue_);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] */ && fromNodeValue instanceof Long) {
                    long fromNodeValue_ = (long) fromNodeValue;
                    return doI64(fromNodeValue_);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI1Vector(LLVMI1Vector)] */ && fromNodeValue instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue_ = (LLVMI1Vector) fromNodeValue;
                    return doI1Vector(fromNodeValue_);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI8Vector(LLVMI8Vector)] */ && fromNodeValue instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue_ = (LLVMI8Vector) fromNodeValue;
                    return doI8Vector(fromNodeValue_);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI16Vector(LLVMI16Vector)] */ && fromNodeValue instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue_ = (LLVMI16Vector) fromNodeValue;
                    return doI16Vector(fromNodeValue_);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI32Vector(LLVMI32Vector)] */ && fromNodeValue instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue_ = (LLVMI32Vector) fromNodeValue;
                    return doI32Vector(fromNodeValue_);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doFloatVector(LLVMFloatVector)] */ && fromNodeValue instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue_ = (LLVMFloatVector) fromNodeValue;
                    return doFloatVector(fromNodeValue_);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64Vector(LLVMI64Vector)] */ && fromNodeValue instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue_ = (LLVMI64Vector) fromNodeValue;
                    return doI64Vector(fromNodeValue_);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doDoubleVector(LLVMDoubleVector)] */ && fromNodeValue instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector) fromNodeValue;
                    return doDoubleVector(fromNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111111110110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI16Vector(LLVMI16Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI32Vector(LLVMI32Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doFloatVector(LLVMFloatVector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64Vector(LLVMI64Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doDoubleVector(LLVMDoubleVector)] */)) {
                return executeGeneric_double0(state_0, frameValue);
            } else if ((state_0 & 0b111111101110) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI16Vector(LLVMI16Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI32Vector(LLVMI32Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doFloatVector(LLVMFloatVector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64Vector(LLVMI64Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doDoubleVector(LLVMDoubleVector)] */)) {
                return executeGeneric_long1(state_0, frameValue);
            } else {
                return executeGeneric_generic2(state_0, frameValue);
            }
        }

        private Object executeGeneric_double0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] */;
            return doI64(fromNodeValue_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] */;
            return doI64(fromNodeValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b111111111110) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] || SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI1Vector(LLVMI1Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI8Vector(LLVMI8Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI16Vector(LLVMI16Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI32Vector(LLVMI32Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doFloatVector(LLVMFloatVector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64Vector(LLVMI64Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doDoubleVector(LLVMDoubleVector)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    return doNative(fromNodeValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    return doManaged(fromNodeValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI1Vector(LLVMI1Vector)] */ && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector) fromNodeValue_;
                    return doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI8Vector(LLVMI8Vector)] */ && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector) fromNodeValue_;
                    return doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI16Vector(LLVMI16Vector)] */ && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector) fromNodeValue_;
                    return doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI32Vector(LLVMI32Vector)] */ && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector) fromNodeValue_;
                    return doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doFloatVector(LLVMFloatVector)] */ && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector) fromNodeValue_;
                    return doFloatVector(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64Vector(LLVMI64Vector)] */ && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector) fromNodeValue_;
                    return doI64Vector(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doDoubleVector(LLVMDoubleVector)] */ && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector) fromNodeValue_;
                    return doDoubleVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */) {
                return LLVMTypesGen.expectLong(executeGeneric(frameValue));
            }
            if ((state_0 & 0b111111110010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] */ && ((state_0 & 0b111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI16Vector(LLVMI16Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI32Vector(LLVMI32Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doFloatVector(LLVMFloatVector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64Vector(LLVMI64Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doDoubleVector(LLVMDoubleVector)] */)) {
                return executeI64_double3(state_0, frameValue);
            } else if ((state_0 & 0b111111101010) == 0 /* only-active SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] */ && ((state_0 & 0b111111111010) != 0  /* is-not SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI16Vector(LLVMI16Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI32Vector(LLVMI32Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doFloatVector(LLVMFloatVector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64Vector(LLVMI64Vector)] && SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doDoubleVector(LLVMDoubleVector)] */)) {
                return executeI64_long4(state_0, frameValue);
            } else {
                return executeI64_generic5(state_0, frameValue);
            }
        }

        private long executeI64_double3(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] */;
            return doI64(fromNodeValue_);
        }

        private long executeI64_long4(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] */;
            return doI64(fromNodeValue_);
        }

        private long executeI64_generic5(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
            }
            if ((state_0 & 0b111111111010) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI1Vector(LLVMI1Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI8Vector(LLVMI8Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI16Vector(LLVMI16Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI32Vector(LLVMI32Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doFloatVector(LLVMFloatVector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64Vector(LLVMI64Vector)] || SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doDoubleVector(LLVMDoubleVector)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    return doNative(fromNodeValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI1Vector(LLVMI1Vector)] */ && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector) fromNodeValue_;
                    return doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI8Vector(LLVMI8Vector)] */ && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector) fromNodeValue_;
                    return doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI16Vector(LLVMI16Vector)] */ && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector) fromNodeValue_;
                    return doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI32Vector(LLVMI32Vector)] */ && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector) fromNodeValue_;
                    return doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doFloatVector(LLVMFloatVector)] */ && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector) fromNodeValue_;
                    return doFloatVector(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64Vector(LLVMI64Vector)] */ && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector) fromNodeValue_;
                    return doI64Vector(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doDoubleVector(LLVMDoubleVector)] */ && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector) fromNodeValue_;
                    return doDoubleVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(fromNodeValue_));
        }

        private Object executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(fromNodeValue)) {
                LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doNative(fromNodeValue_);
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */;
                this.state_0_ = state_0;
                return doManaged(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI1Vector(LLVMI1Vector)] */;
                this.state_0_ = state_0;
                return doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI8Vector(LLVMI8Vector)] */;
                this.state_0_ = state_0;
                return doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI16Vector(LLVMI16Vector)] */;
                this.state_0_ = state_0;
                return doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector) fromNodeValue;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI32Vector(LLVMI32Vector)] */;
                this.state_0_ = state_0;
                return doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector) fromNodeValue;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doFloatVector(LLVMFloatVector)] */;
                this.state_0_ = state_0;
                return doFloatVector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector) fromNodeValue;
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64Vector(LLVMI64Vector)] */;
                this.state_0_ = state_0;
                return doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector) fromNodeValue;
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doDoubleVector(LLVMDoubleVector)] */;
                this.state_0_ = state_0;
                return doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111111111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b111111111110) & ((state_0 & 0b111111111110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMToI64Node.doNative(LLVMNativePointer)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToI64Node.doManaged(LLVMManagedPointer)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(double)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI1Vector(LLVMI1Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI8Vector(LLVMI8Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI16Vector(LLVMI16Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI32Vector(LLVMI32Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doFloatVector(LLVMFloatVector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doI64Vector(LLVMI64Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000000 /* add SpecializationActive[LLVMToI64Node.LLVMBitcastToI64Node.doDoubleVector(LLVMDoubleVector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMBitcastToI64Node create(LLVMExpressionNode fromNode) {
            return new LLVMBitcastToI64NodeGen(fromNode);
        }

    }
}
