// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMIndirectBranchNode.LLVMIndirectBranchNodeImpl;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMIndirectBranchNode.class)
@SuppressWarnings("javadoc")
public final class LLVMIndirectBranchNodeFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMIndirectBranchNodeImpl#doCondition}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMIndirectBranchNodeImpl.class)
    @SuppressWarnings("javadoc")
    static final class LLVMIndirectBranchNodeImplNodeGen extends LLVMIndirectBranchNodeImpl implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode branchAddress_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMIndirectBranchNodeImpl#doCondition}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMIndirectBranchNodeImplNodeGen(int[] indices, LLVMStatementNode[] phiWriteNodes, LLVMExpressionNode branchAddress) {
            super(indices, phiWriteNodes);
            this.branchAddress_ = branchAddress;
        }

        @Override
        public int executeCondition(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object branchAddressValue_ = this.branchAddress_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(branchAddressValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMIndirectBranchNode.LLVMIndirectBranchNodeImpl.doCondition(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(branchAddressValue_)) {
                LLVMNativePointer branchAddressValue__ = LLVMTypes.asNativePointer(branchAddressValue_);
                return doCondition(branchAddressValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(branchAddressValue_);
        }

        private int executeAndSpecialize(Object branchAddressValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(branchAddressValue)) {
                LLVMNativePointer branchAddressValue_ = LLVMTypes.asNativePointer(branchAddressValue);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMIndirectBranchNode.LLVMIndirectBranchNodeImpl.doCondition(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doCondition(branchAddressValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.branchAddress_}, branchAddressValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMIndirectBranchNode.LLVMIndirectBranchNodeImpl.doCondition(LLVMNativePointer)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMIndirectBranchNodeImpl create(int[] indices, LLVMStatementNode[] phiWriteNodes, LLVMExpressionNode branchAddress) {
            return new LLVMIndirectBranchNodeImplNodeGen(indices, phiWriteNodes, branchAddress);
        }

    }
}
