// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.InstrumentableNode.WrapperNode;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;

@GeneratedBy(LLVMCatchSwitchNode.class)
final class LLVMCatchSwitchNodeWrapper extends LLVMCatchSwitchNode implements WrapperNode {

    @Child private LLVMCatchSwitchNode delegateNode;
    @Child private ProbeNode probeNode;

    LLVMCatchSwitchNodeWrapper(LLVMCatchSwitchNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    @Override
    public LLVMCatchSwitchNode getDelegateNode() {
        return delegateNode;
    }

    @Override
    public ProbeNode getProbeNode() {
        return probeNode;
    }

    @Override
    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    public Object executeCondition(VirtualFrame frame) {
        Object returnValue;
        for (;;) {
            boolean wasOnReturnExecuted = false;
            try {
                probeNode.onEnter(frame);
                returnValue = delegateNode.executeCondition(frame);
                wasOnReturnExecuted = true;
                probeNode.onReturnValue(frame, returnValue);
                break;
            } catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    continue;
                } else if (result != null) {
                    returnValue = result;
                    break;
                }
                throw t;
            }
        }
        return returnValue;
    }

    @Override
    public int getSuccessorCount() {
        return this.delegateNode.getSuccessorCount();
    }

    @Override
    public int[] getSuccessors() {
        return this.delegateNode.getSuccessors();
    }

    @Override
    public LLVMStatementNode getPhiNode(int successorIndex) {
        return this.delegateNode.getPhiNode(successorIndex);
    }

    @Override
    public boolean checkCase(VirtualFrame frame, int i, Object value) {
        return this.delegateNode.checkCase(frame, i, value);
    }

    @Override
    public int getConditionalSuccessorCount() {
        return this.delegateNode.getConditionalSuccessorCount();
    }

    @Override
    public boolean hasDefaultBlock() {
        return this.delegateNode.hasDefaultBlock();
    }

    @Override
    public void throwException(VirtualFrame frame) {
        this.delegateNode.throwException(frame);
    }

    @Override
    public void setCatchPadEntryNode(CatchPadEntryNode node) {
        this.delegateNode.setCatchPadEntryNode(node);
    }

}
