// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMRaiseExceptionWindows#doNull}
 *     Activation probability: 0.48333
 *     With/without class size: 9/0 bytes
 *   Specialization {@link LLVMRaiseExceptionWindows#doRaise}
 *     Activation probability: 0.33333
 *     With/without class size: 12/8 bytes
 *   Specialization {@link LLVMRaiseExceptionWindows#doFallback}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMRaiseExceptionWindows.class)
@SuppressWarnings("javadoc")
public final class LLVMRaiseExceptionWindowsNodeGen extends LLVMRaiseExceptionWindows implements GenerateAOT.Provider {

    static final ReferenceField<RaiseData> RAISE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "raise_cache", RaiseData.class);

    @Child private LLVMExpressionNode exceptionObject_;
    @Child private LLVMExpressionNode throwInfo_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMRaiseExceptionWindows#doNull}
     *   2: SpecializationActive {@link LLVMRaiseExceptionWindows#doRaise}
     *   3: SpecializationActive {@link LLVMRaiseExceptionWindows#doFallback}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @CompilationFinal private RaiseData raise_cache;

    private LLVMRaiseExceptionWindowsNodeGen(LLVMExpressionNode exceptionObject, LLVMExpressionNode throwInfo) {
        this.exceptionObject_ = exceptionObject;
        this.throwInfo_ = throwInfo;
    }

    @ExplodeLoop
    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object exceptionObjectValue_ = this.exceptionObject_.executeGeneric(frameValue);
        Object throwInfoValue_ = this.throwInfo_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(exceptionObjectValue_, throwInfoValue_);
        }
        if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVMRaiseExceptionWindows.doNull(LLVMPointer, LLVMPointer)] || SpecializationActive[LLVMRaiseExceptionWindows.doRaise(LLVMPointer, LLVMPointer, LLVMPointer, LLVMPointer)] || SpecializationActive[LLVMRaiseExceptionWindows.doFallback(LLVMPointer, LLVMPointer)] */ && LLVMTypes.isPointer(exceptionObjectValue_)) {
            LLVMPointer exceptionObjectValue__ = LLVMTypes.asPointer(exceptionObjectValue_);
            if (LLVMTypes.isPointer(throwInfoValue_)) {
                LLVMPointer throwInfoValue__ = LLVMTypes.asPointer(throwInfoValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRaiseExceptionWindows.doNull(LLVMPointer, LLVMPointer)] */) {
                    if ((throwInfoValue__.isNull()) && (exceptionObjectValue__.isNull())) {
                        return doNull(exceptionObjectValue__, throwInfoValue__);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMRaiseExceptionWindows.doRaise(LLVMPointer, LLVMPointer, LLVMPointer, LLVMPointer)] */ && (!(throwInfoValue__.isNull()))) {
                    RaiseData s1_ = this.raise_cache;
                    while (s1_ != null) {
                        if ((throwInfoValue__.isSame(s1_.cachedThrowInfo_))) {
                            return doRaise(exceptionObjectValue__, throwInfoValue__, s1_.cachedThrowInfo_, s1_.imageBase_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMRaiseExceptionWindows.doFallback(LLVMPointer, LLVMPointer)] */) {
                    if ((!(throwInfoValue__.isNull()))) {
                        return doFallback(exceptionObjectValue__, throwInfoValue__);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(exceptionObjectValue_, throwInfoValue_);
    }

    private Object executeAndSpecialize(Object exceptionObjectValue, Object throwInfoValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(exceptionObjectValue)) {
            LLVMPointer exceptionObjectValue_ = LLVMTypes.asPointer(exceptionObjectValue);
            if (LLVMTypes.isPointer(throwInfoValue)) {
                LLVMPointer throwInfoValue_ = LLVMTypes.asPointer(throwInfoValue);
                if ((throwInfoValue_.isNull()) && (exceptionObjectValue_.isNull())) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMRaiseExceptionWindows.doNull(LLVMPointer, LLVMPointer)] */;
                    this.state_0_ = state_0;
                    return doNull(exceptionObjectValue_, throwInfoValue_);
                }
                if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMRaiseExceptionWindows.doFallback(LLVMPointer, LLVMPointer)] */ && (!(throwInfoValue_.isNull()))) {
                    while (true) {
                        int count1_ = 0;
                        RaiseData s1_ = RAISE_CACHE_UPDATER.getVolatile(this);
                        RaiseData s1_original = s1_;
                        while (s1_ != null) {
                            if ((throwInfoValue_.isSame(s1_.cachedThrowInfo_))) {
                                break;
                            }
                            count1_++;
                            s1_ = s1_.next_;
                        }
                        if (s1_ == null) {
                            {
                                LLVMPointer cachedThrowInfo__ = (throwInfoValue_);
                                if ((throwInfoValue_.isSame(cachedThrowInfo__)) && count1_ < (3)) {
                                    s1_ = new RaiseData(s1_original);
                                    s1_.cachedThrowInfo_ = cachedThrowInfo__;
                                    s1_.imageBase_ = (getImageBase(cachedThrowInfo__));
                                    if (!RAISE_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMRaiseExceptionWindows.doRaise(LLVMPointer, LLVMPointer, LLVMPointer, LLVMPointer)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s1_ != null) {
                            return doRaise(exceptionObjectValue_, throwInfoValue_, s1_.cachedThrowInfo_, s1_.imageBase_);
                        }
                        break;
                    }
                }
                if ((!(throwInfoValue_.isNull()))) {
                    this.raise_cache = null;
                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMRaiseExceptionWindows.doRaise(LLVMPointer, LLVMPointer, LLVMPointer, LLVMPointer)] */;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMRaiseExceptionWindows.doFallback(LLVMPointer, LLVMPointer)] */;
                    this.state_0_ = state_0;
                    return doFallback(exceptionObjectValue_, throwInfoValue_);
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.exceptionObject_, this.throwInfo_}, exceptionObjectValue, throwInfoValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b1110) & ((state_0 & 0b1110) - 1)) == 0 /* is-single  */) {
                RaiseData s1_ = this.raise_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMRaiseExceptionWindows.doNull(LLVMPointer, LLVMPointer)] */;
        }
        {
            this.raise_cache = null;
            this.state_0_ = state_0_ & 0xfffffffb /* remove SpecializationActive[LLVMRaiseExceptionWindows.doRaise(LLVMPointer, LLVMPointer, LLVMPointer, LLVMPointer)] */;
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMRaiseExceptionWindows.doFallback(LLVMPointer, LLVMPointer)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMRaiseExceptionWindows create(LLVMExpressionNode exceptionObject, LLVMExpressionNode throwInfo) {
        return new LLVMRaiseExceptionWindowsNodeGen(exceptionObject, throwInfo);
    }

    @GeneratedBy(LLVMRaiseExceptionWindows.class)
    @DenyReplace
    private static final class RaiseData implements SpecializationDataNode {

        @CompilationFinal final RaiseData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMRaiseExceptionWindows#doRaise}
         *   Parameter: {@link LLVMPointer} cachedThrowInfo</pre>
         */
        @CompilationFinal LLVMPointer cachedThrowInfo_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMRaiseExceptionWindows#doRaise}
         *   Parameter: {@link LLVMPointer} imageBase</pre>
         */
        @CompilationFinal LLVMPointer imageBase_;

        RaiseData(RaiseData next_) {
            this.next_ = next_;
        }

    }
}
