// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMTypeIdForExceptionNode#doGeneric}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMTypeIdForExceptionNode.class)
@SuppressWarnings("javadoc")
public final class LLVMTypeIdForExceptionNodeGen extends LLVMTypeIdForExceptionNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode thrownTypeID_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMTypeIdForExceptionNode#doGeneric}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMTypeIdForExceptionNodeGen(LLVMExpressionNode thrownTypeID) {
        this.thrownTypeID_ = thrownTypeID;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object thrownTypeIDValue_ = this.thrownTypeID_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(thrownTypeIDValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMTypeIdForExceptionNode.doGeneric(LLVMPointer)] */ && LLVMTypes.isPointer(thrownTypeIDValue_)) {
            LLVMPointer thrownTypeIDValue__ = LLVMTypes.asPointer(thrownTypeIDValue_);
            return doGeneric(thrownTypeIDValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(thrownTypeIDValue_);
    }

    private Object executeAndSpecialize(Object thrownTypeIDValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(thrownTypeIDValue)) {
            LLVMPointer thrownTypeIDValue_ = LLVMTypes.asPointer(thrownTypeIDValue);
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMTypeIdForExceptionNode.doGeneric(LLVMPointer)] */;
            this.state_0_ = state_0;
            return doGeneric(thrownTypeIDValue_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.thrownTypeID_}, thrownTypeIDValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            return NodeCost.MONOMORPHIC;
        }
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMTypeIdForExceptionNode.doGeneric(LLVMPointer)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMTypeIdForExceptionNode create(LLVMExpressionNode thrownTypeID) {
        return new LLVMTypeIdForExceptionNodeGen(thrownTypeID);
    }

}
