// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link GraalVMPointsToHandleSpace#doLongCase}
 *     Activation probability: 0.48333
 *     With/without class size: 9/0 bytes
 *   Specialization {@link GraalVMPointsToHandleSpace#doPointerCase}
 *     Activation probability: 0.33333
 *     With/without class size: 8/0 bytes
 *   Specialization {@link GraalVMPointsToHandleSpace#doGeneric}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre>
 */
@GeneratedBy(GraalVMPointsToHandleSpace.class)
@SuppressWarnings("javadoc")
public final class GraalVMPointsToHandleSpaceNodeGen extends GraalVMPointsToHandleSpace implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode child0_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link GraalVMPointsToHandleSpace#doLongCase}
     *   2: SpecializationActive {@link GraalVMPointsToHandleSpace#doPointerCase}
     *   3: SpecializationActive {@link GraalVMPointsToHandleSpace#doGeneric}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private GraalVMPointsToHandleSpaceNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object child0Value) {
        if (!((state_0 & 0b10) != 0 /* is SpecializationActive[GraalVMPointsToHandleSpace.doLongCase(long)] */) && child0Value instanceof Long) {
            return false;
        }
        if (!((state_0 & 0b100) != 0 /* is SpecializationActive[GraalVMPointsToHandleSpace.doPointerCase(LLVMNativePointer)] */) && LLVMTypes.isNativePointer(child0Value)) {
            return false;
        }
        return true;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1100) == 0 /* only-active SpecializationActive[GraalVMPointsToHandleSpace.doLongCase(long)] */ && ((state_0 & 0b1110) != 0  /* is-not SpecializationActive[GraalVMPointsToHandleSpace.doLongCase(long)] && SpecializationActive[GraalVMPointsToHandleSpace.doPointerCase(LLVMNativePointer)] && SpecializationActive[GraalVMPointsToHandleSpace.doGeneric(Object)] */)) {
            return executeGeneric_long0(state_0, frameValue);
        } else {
            return executeGeneric_generic1(state_0, frameValue);
        }
    }

    private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        long child0Value_;
        try {
            child0Value_ = this.child0_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_);
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[GraalVMPointsToHandleSpace.doLongCase(long)] */;
        return doLongCase(child0Value_);
    }

    private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_);
        }
        if ((state_0 & 0b1110) != 0 /* is SpecializationActive[GraalVMPointsToHandleSpace.doLongCase(long)] || SpecializationActive[GraalVMPointsToHandleSpace.doPointerCase(LLVMNativePointer)] || SpecializationActive[GraalVMPointsToHandleSpace.doGeneric(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[GraalVMPointsToHandleSpace.doLongCase(long)] */ && child0Value_ instanceof Long) {
                long child0Value__ = (long) child0Value_;
                return doLongCase(child0Value__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[GraalVMPointsToHandleSpace.doPointerCase(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                return doPointerCase(child0Value__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[GraalVMPointsToHandleSpace.doGeneric(Object)] */) {
                if (fallbackGuard_(state_0, child0Value_)) {
                    return doGeneric(child0Value_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_);
    }

    @Override
    public boolean executeI1(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1100) == 0 /* only-active SpecializationActive[GraalVMPointsToHandleSpace.doLongCase(long)] */ && ((state_0 & 0b1110) != 0  /* is-not SpecializationActive[GraalVMPointsToHandleSpace.doLongCase(long)] && SpecializationActive[GraalVMPointsToHandleSpace.doPointerCase(LLVMNativePointer)] && SpecializationActive[GraalVMPointsToHandleSpace.doGeneric(Object)] */)) {
            return executeI1_long2(state_0, frameValue);
        } else {
            return executeI1_generic3(state_0, frameValue);
        }
    }

    private boolean executeI1_long2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        long child0Value_;
        try {
            child0Value_ = this.child0_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_);
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[GraalVMPointsToHandleSpace.doLongCase(long)] */;
        return doLongCase(child0Value_);
    }

    private boolean executeI1_generic3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_);
        }
        if ((state_0 & 0b1110) != 0 /* is SpecializationActive[GraalVMPointsToHandleSpace.doLongCase(long)] || SpecializationActive[GraalVMPointsToHandleSpace.doPointerCase(LLVMNativePointer)] || SpecializationActive[GraalVMPointsToHandleSpace.doGeneric(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[GraalVMPointsToHandleSpace.doLongCase(long)] */ && child0Value_ instanceof Long) {
                long child0Value__ = (long) child0Value_;
                return doLongCase(child0Value__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[GraalVMPointsToHandleSpace.doPointerCase(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                return doPointerCase(child0Value__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[GraalVMPointsToHandleSpace.doGeneric(Object)] */) {
                if (fallbackGuard_(state_0, child0Value_)) {
                    return doGeneric(child0Value_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_);
    }

    private boolean executeAndSpecialize(Object child0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (child0Value instanceof Long) {
            long child0Value_ = (long) child0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[GraalVMPointsToHandleSpace.doLongCase(long)] */;
            this.state_0_ = state_0;
            return doLongCase(child0Value_);
        }
        if (LLVMTypes.isNativePointer(child0Value)) {
            LLVMNativePointer child0Value_ = LLVMTypes.asNativePointer(child0Value);
            state_0 = state_0 | 0b100 /* add SpecializationActive[GraalVMPointsToHandleSpace.doPointerCase(LLVMNativePointer)] */;
            this.state_0_ = state_0;
            return doPointerCase(child0Value_);
        }
        state_0 = state_0 | 0b1000 /* add SpecializationActive[GraalVMPointsToHandleSpace.doGeneric(Object)] */;
        this.state_0_ = state_0;
        return doGeneric(child0Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b1110) & ((state_0 & 0b1110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[GraalVMPointsToHandleSpace.doLongCase(long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[GraalVMPointsToHandleSpace.doPointerCase(LLVMNativePointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[GraalVMPointsToHandleSpace.doGeneric(Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static GraalVMPointsToHandleSpace create(LLVMExpressionNode child0) {
        return new GraalVMPointsToHandleSpaceNodeGen(child0);
    }

}
