// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMPolyglotInvoke#doIntrinsic}
 *     Activation probability: 0.65000
 *     With/without class size: 17/4 bytes
 *   Specialization {@link LLVMPolyglotInvoke#fallback}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMPolyglotInvoke.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMPolyglotInvokeNodeGen extends LLVMPolyglotInvoke implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode child0_;
    @Child private LLVMExpressionNode child1_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMPolyglotInvoke#doIntrinsic}
     *   2: SpecializationActive {@link LLVMPolyglotInvoke#fallback}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private IntrinsicData intrinsic_cache;

    private LLVMPolyglotInvokeNodeGen(ForeignToLLVM toLLVM, LLVMExpressionNode[] args, Type[] argTypes, LLVMExpressionNode child0, LLVMExpressionNode child1) {
        super(toLLVM, args, argTypes);
        this.child0_ = child0;
        this.child1_ = child1;
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object child0Value, Object child1Value) {
        if (!((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPolyglotInvoke.doIntrinsic(VirtualFrame, LLVMManagedPointer, Object, LLVMReadStringNode)] */) && LLVMTypes.isManagedPointer(child0Value)) {
            return false;
        }
        return true;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        Object child1Value_ = this.child1_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, child0Value_, child1Value_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMPolyglotInvoke.doIntrinsic(VirtualFrame, LLVMManagedPointer, Object, LLVMReadStringNode)] || SpecializationActive[LLVMPolyglotInvoke.fallback(Object, Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPolyglotInvoke.doIntrinsic(VirtualFrame, LLVMManagedPointer, Object, LLVMReadStringNode)] */ && LLVMTypes.isManagedPointer(child0Value_)) {
                LLVMManagedPointer child0Value__ = LLVMTypes.asManagedPointer(child0Value_);
                IntrinsicData s0_ = this.intrinsic_cache;
                if (s0_ != null) {
                    return doIntrinsic(frameValue, child0Value__, child1Value_, s0_.readStr_);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPolyglotInvoke.fallback(Object, Object)] */) {
                if (fallbackGuard_(state_0, child0Value_, child1Value_)) {
                    return fallback(child0Value_, child1Value_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, child0Value_, child1Value_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object child0Value, Object child1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isManagedPointer(child0Value)) {
            LLVMManagedPointer child0Value_ = LLVMTypes.asManagedPointer(child0Value);
            IntrinsicData s0_ = this.insert(new IntrinsicData());
            s0_.readStr_ = s0_.insert((createReadString()));
            VarHandle.storeStoreFence();
            this.intrinsic_cache = s0_;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPolyglotInvoke.doIntrinsic(VirtualFrame, LLVMManagedPointer, Object, LLVMReadStringNode)] */;
            this.state_0_ = state_0;
            return doIntrinsic(frameValue, child0Value_, child1Value, s0_.readStr_);
        }
        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMPolyglotInvoke.fallback(Object, Object)] */;
        this.state_0_ = state_0;
        return fallback(child0Value, child1Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            IntrinsicData s0_ = this.insert(new IntrinsicData());
            s0_.readStr_ = s0_.insert((createReadString()));
            VarHandle.storeStoreFence();
            this.intrinsic_cache = s0_;
            assert NodeUtil.assertRecursion(s0_.readStr_, 1);
            ((GenerateAOT.Provider) s0_.readStr_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPolyglotInvoke.doIntrinsic(VirtualFrame, LLVMManagedPointer, Object, LLVMReadStringNode)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMPolyglotInvoke.fallback(Object, Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.intrinsic_cache = null;
    }

    @NeverDefault
    public static LLVMPolyglotInvoke create(ForeignToLLVM toLLVM, LLVMExpressionNode[] args, Type[] argTypes, LLVMExpressionNode child0, LLVMExpressionNode child1) {
        return new LLVMPolyglotInvokeNodeGen(toLLVM, args, argTypes, child0, child1);
    }

    @GeneratedBy(LLVMPolyglotInvoke.class)
    @DenyReplace
    private static final class IntrinsicData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPolyglotInvoke#doIntrinsic}
         *   Parameter: {@link LLVMReadStringNode} readStr</pre>
         */
        @Child LLVMReadStringNode readStr_;

        IntrinsicData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
}
