// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Value;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMPolyglotFromTyped#doPointer}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMPolyglotFromTyped#doError}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMPolyglotFromTyped.class)
@SuppressWarnings("javadoc")
public final class LLVMPolyglotFromTypedNodeGen extends LLVMPolyglotFromTyped implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode ptr_;
    @Child private LLVMExpressionNode typeid_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMPolyglotFromTyped#doPointer}
     *   2: SpecializationActive {@link LLVMPolyglotFromTyped#doError}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMPolyglotFromTypedNodeGen(LLVMExpressionNode ptr, LLVMExpressionNode typeid) {
        this.ptr_ = ptr;
        this.typeid_ = typeid;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object ptrValue_ = this.ptr_.executeGeneric(frameValue);
        Object typeidValue_ = this.typeid_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(ptrValue_, typeidValue_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMPolyglotFromTyped.doPointer(LLVMPointer, Structured)] || SpecializationActive[LLVMPolyglotFromTyped.doError(LLVMPointer, Value)] */ && LLVMTypes.isPointer(ptrValue_)) {
            LLVMPointer ptrValue__ = LLVMTypes.asPointer(ptrValue_);
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPolyglotFromTyped.doPointer(LLVMPointer, Structured)] */ && typeidValue_ instanceof Structured) {
                Structured typeidValue__ = (Structured) typeidValue_;
                return doPointer(ptrValue__, typeidValue__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPolyglotFromTyped.doError(LLVMPointer, Value)] */ && typeidValue_ instanceof Value) {
                Value typeidValue__ = (Value) typeidValue_;
                return doError(ptrValue__, typeidValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(ptrValue_, typeidValue_);
    }

    private LLVMPointer executeAndSpecialize(Object ptrValue, Object typeidValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(ptrValue)) {
            LLVMPointer ptrValue_ = LLVMTypes.asPointer(ptrValue);
            if (typeidValue instanceof Structured) {
                Structured typeidValue_ = (Structured) typeidValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPolyglotFromTyped.doPointer(LLVMPointer, Structured)] */;
                this.state_0_ = state_0;
                return doPointer(ptrValue_, typeidValue_);
            }
            if (typeidValue instanceof Value) {
                Value typeidValue_ = (Value) typeidValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMPolyglotFromTyped.doError(LLVMPointer, Value)] */;
                this.state_0_ = state_0;
                return doError(ptrValue_, typeidValue_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.ptr_, this.typeid_}, ptrValue, typeidValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPolyglotFromTyped.doPointer(LLVMPointer, Structured)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMPolyglotFromTyped.doError(LLVMPointer, Value)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMPolyglotFromTyped create(LLVMExpressionNode ptr, LLVMExpressionNode typeid) {
        return new LLVMPolyglotFromTypedNodeGen(ptr, typeid);
    }

}
