// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMVarArgCompoundValue;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMStructByValueNode#byValue(VirtualFrame, LLVMPointer)}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMStructByValueNode#byValue(VirtualFrame, LLVMVarArgCompoundValue)}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMStructByValueNode.class)
@SuppressWarnings("javadoc")
public final class LLVMStructByValueNodeGen extends LLVMStructByValueNode implements GenerateAOT.Provider {

    private final long length;
    @Child private LLVMExpressionNode source_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMStructByValueNode#byValue(VirtualFrame, LLVMPointer)}
     *   2: SpecializationActive {@link LLVMStructByValueNode#byValue(VirtualFrame, LLVMVarArgCompoundValue)}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMStructByValueNodeGen(LLVMMemMoveNode memMove, LLVMExpressionNode stackAllocationNode, LLVMExpressionNode source, long length) {
        super(memMove, stackAllocationNode);
        this.length = length;
        this.source_ = source;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object sourceValue_ = this.source_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, sourceValue_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMStructByValueNode.byValue(VirtualFrame, LLVMPointer)] || SpecializationActive[LLVMStructByValueNode.byValue(VirtualFrame, LLVMVarArgCompoundValue)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMStructByValueNode.byValue(VirtualFrame, LLVMPointer)] */ && LLVMTypes.isPointer(sourceValue_)) {
                LLVMPointer sourceValue__ = LLVMTypes.asPointer(sourceValue_);
                return byValue(frameValue, sourceValue__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMStructByValueNode.byValue(VirtualFrame, LLVMVarArgCompoundValue)] */ && sourceValue_ instanceof LLVMVarArgCompoundValue) {
                LLVMVarArgCompoundValue sourceValue__ = (LLVMVarArgCompoundValue) sourceValue_;
                return byValue(frameValue, sourceValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, sourceValue_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object sourceValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(sourceValue)) {
            LLVMPointer sourceValue_ = LLVMTypes.asPointer(sourceValue);
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMStructByValueNode.byValue(VirtualFrame, LLVMPointer)] */;
            this.state_0_ = state_0;
            return byValue(frameValue, sourceValue_);
        }
        if (sourceValue instanceof LLVMVarArgCompoundValue) {
            LLVMVarArgCompoundValue sourceValue_ = (LLVMVarArgCompoundValue) sourceValue;
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMStructByValueNode.byValue(VirtualFrame, LLVMVarArgCompoundValue)] */;
            this.state_0_ = state_0;
            return byValue(frameValue, sourceValue_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.source_}, sourceValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMStructByValueNode.byValue(VirtualFrame, LLVMPointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMStructByValueNode.byValue(VirtualFrame, LLVMVarArgCompoundValue)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMStructByValueNode create(LLVMMemMoveNode memMove, LLVMExpressionNode stackAllocationNode, LLVMExpressionNode source, long length) {
        return new LLVMStructByValueNodeGen(memMove, stackAllocationNode, source, length);
    }

}
