// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMStructArrayLiteralNode#writeDouble}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMStructArrayLiteralNode#doVoid}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMStructArrayLiteralNode.class)
@SuppressWarnings("javadoc")
public final class LLVMStructArrayLiteralNodeGen extends LLVMStructArrayLiteralNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode address_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMStructArrayLiteralNode#writeDouble}
     *   2: SpecializationActive {@link LLVMStructArrayLiteralNode#doVoid}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMStructArrayLiteralNodeGen(LLVMExpressionNode[] values, LLVMMemMoveNode memMove, long stride, LLVMExpressionNode address) {
        super(values, memMove, stride);
        this.address_ = address;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, addressValue_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMStructArrayLiteralNode.writeDouble(VirtualFrame, LLVMNativePointer)] || SpecializationActive[LLVMStructArrayLiteralNode.doVoid(VirtualFrame, LLVMManagedPointer)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMStructArrayLiteralNode.writeDouble(VirtualFrame, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                return writeDouble(frameValue, addressValue__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMStructArrayLiteralNode.doVoid(VirtualFrame, LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((noOffset(addressValue__))) {
                    return doVoid(frameValue, addressValue__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, addressValue_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object addressValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMStructArrayLiteralNode.writeDouble(VirtualFrame, LLVMNativePointer)] */;
            this.state_0_ = state_0;
            return writeDouble(frameValue, addressValue_);
        }
        if (LLVMTypes.isManagedPointer(addressValue)) {
            LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            if ((noOffset(addressValue_))) {
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMStructArrayLiteralNode.doVoid(VirtualFrame, LLVMManagedPointer)] */;
                this.state_0_ = state_0;
                return doVoid(frameValue, addressValue_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMStructArrayLiteralNode.writeDouble(VirtualFrame, LLVMNativePointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMStructArrayLiteralNode.doVoid(VirtualFrame, LLVMManagedPointer)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMStructArrayLiteralNode create(LLVMExpressionNode[] values, LLVMMemMoveNode memMove, long stride, LLVMExpressionNode address) {
        return new LLVMStructArrayLiteralNodeGen(values, memMove, stride, address);
    }

}
