// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNode.LLVMLoadDoubleVectorNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNode.LLVMLoadFloatVectorNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNode.LLVMLoadI16VectorNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNode.LLVMLoadI1VectorNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNode.LLVMLoadI32VectorNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNode.LLVMLoadI64VectorNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNode.LLVMLoadI8VectorNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNode.LLVMLoadPointerVectorNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMLoadVectorNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMLoadVectorNodeFactory {

    private static final LibraryFactory<LLVMManagedReadLibrary> L_L_V_M_MANAGED_READ_LIBRARY_ = LibraryFactory.resolve(LLVMManagedReadLibrary.class);

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMLoadI1VectorNode#doI1VectorNative}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMLoadI1VectorNode#doI1VectorDerefHandle}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMLoadI1VectorNode#doForeign}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMLoadI1VectorNode#doForeign}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMLoadI1VectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMLoadI1VectorNodeGen extends LLVMLoadI1VectorNode implements GenerateAOT.Provider {

        static final ReferenceField<Foreign0Data> FOREIGN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "foreign0_cache", Foreign0Data.class);

        private final int vectorLength;
        @Child private LLVMExpressionNode address_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMLoadI1VectorNode#doI1VectorNative}
         *   2: SpecializationActive {@link LLVMLoadI1VectorNode#doI1VectorDerefHandle}
         *   3: SpecializationActive {@link LLVMLoadI1VectorNode#doForeign}
         *   4: SpecializationActive {@link LLVMLoadI1VectorNode#doForeign}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private I1VectorDerefHandleData i1VectorDerefHandle_cache;
        @UnsafeAccessedField @Child private Foreign0Data foreign0_cache;

        private LLVMLoadI1VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        private LLVMLoadI1VectorNodeGen(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            super(isRecursive);
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @ExplodeLoop
        @Override
        public Object executeWithTargetGeneric(Object addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI1VectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI1VectorNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                    LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorNative(LLVMNativePointer)] */) {
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            return doI1VectorNative(addressValue_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI1VectorNode)] */) {
                        I1VectorDerefHandleData s1_ = this.i1VectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue_))) {
                                return doI1VectorDerefHandle(addressValue_, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                    LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        Foreign0Data s2_ = this.foreign0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                return doForeign(addressValue_, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreign1Boundary(state_0, addressValue_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object foreign1Boundary(int state_0, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                    return doForeign(addressValue_, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public LLVMI1Vector executeWithTarget(LLVMManagedPointer addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    Foreign0Data s2_ = this.foreign0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue.getObject()))) {
                            return doForeign(addressValue, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.foreign1Boundary0(state_0, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private LLVMI1Vector foreign1Boundary0(int state_0, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                    return doForeign(addressValue, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI1VectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI1VectorNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                    LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorNative(LLVMNativePointer)] */) {
                        if ((!(isAutoDerefHandle(addressValue__)))) {
                            return doI1VectorNative(addressValue__);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI1VectorNode)] */) {
                        I1VectorDerefHandleData s1_ = this.i1VectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue__))) {
                                return doI1VectorDerefHandle(addressValue__, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                    LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        Foreign0Data s2_ = this.foreign0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue__.getObject()))) {
                                return doForeign(addressValue__, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreign1Boundary1(state_0, addressValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue_);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object foreign1Boundary1(int state_0, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                    return doForeign(addressValue__, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private LLVMI1Vector executeAndSpecialize(Object addressValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorNative(LLVMNativePointer)] */;
                    this.state_0_ = state_0;
                    return doI1VectorNative(addressValue_);
                }
                if ((!(isRecursive)) && (isAutoDerefHandle(addressValue_))) {
                    I1VectorDerefHandleData s1_ = this.insert(new I1VectorDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doI1VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI1VectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.i1VectorDerefHandle_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI1VectorNode)] */;
                    this.state_0_ = state_0;
                    return doI1VectorDerefHandle(addressValue_, getReceiver__, s1_.load_);
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        Foreign0Data s2_ = FOREIGN0_CACHE_UPDATER.getVolatile(this);
                        Foreign0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            // assert (s2_.nativeRead_.accepts(addressValue_.getObject()));
                            if (count2_ < (3)) {
                                s2_ = this.insert(new Foreign0Data(s2_original));
                                LLVMManagedReadLibrary nativeRead__ = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeRead__, "Specialization 'doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.nativeRead_ = nativeRead__;
                                if (!FOREIGN0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            return doForeign(addressValue_, s2_.nativeRead_);
                        }
                        break;
                    }
                }
                {
                    LLVMManagedReadLibrary nativeRead__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.foreign0_cache = null;
                            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return doForeign(addressValue_, nativeRead__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    Foreign0Data s2_ = this.foreign0_cache;
                    if ((s2_ == null || s2_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorNative(LLVMNativePointer)] */;
            }
            {
                if ((!(isRecursive))) {
                    I1VectorDerefHandleData s1_ = this.insert(new I1VectorDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doI1VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI1VectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.i1VectorDerefHandle_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                    ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.load_, 1);
                    ((GenerateAOT.Provider) s1_.load_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI1VectorNode.doI1VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI1VectorNode)] */;
                }
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.i1VectorDerefHandle_cache = null;
        }

        @NeverDefault
        public static LLVMLoadI1VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI1VectorNodeGen(address, vectorLength);
        }

        @NeverDefault
        public static LLVMLoadI1VectorNode create(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI1VectorNodeGen(isRecursive, address, vectorLength);
        }

        @GeneratedBy(LLVMLoadI1VectorNode.class)
        @DenyReplace
        private static final class I1VectorDerefHandleData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI1VectorNode#doI1VectorDerefHandle}
             *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
             */
            @Child LLVMDerefHandleGetReceiverNode getReceiver_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI1VectorNode#doI1VectorDerefHandle}
             *   Parameter: {@link LLVMLoadI1VectorNode} load</pre>
             */
            @Child LLVMLoadI1VectorNode load_;

            I1VectorDerefHandleData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMLoadI1VectorNode.class)
        @DenyReplace
        private static final class Foreign0Data extends Node implements SpecializationDataNode {

            @Child Foreign0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI1VectorNode#doForeign}
             *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
             */
            @Child LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMLoadI8VectorNode#doI8VectorNative}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMLoadI8VectorNode#doI8VectorDerefHandle}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMLoadI8VectorNode#doForeign}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMLoadI8VectorNode#doForeign}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMLoadI8VectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMLoadI8VectorNodeGen extends LLVMLoadI8VectorNode implements GenerateAOT.Provider {

        static final ReferenceField<Foreign0Data> FOREIGN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "foreign0_cache", Foreign0Data.class);

        private final int vectorLength;
        @Child private LLVMExpressionNode address_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMLoadI8VectorNode#doI8VectorNative}
         *   2: SpecializationActive {@link LLVMLoadI8VectorNode#doI8VectorDerefHandle}
         *   3: SpecializationActive {@link LLVMLoadI8VectorNode#doForeign}
         *   4: SpecializationActive {@link LLVMLoadI8VectorNode#doForeign}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private I8VectorDerefHandleData i8VectorDerefHandle_cache;
        @UnsafeAccessedField @Child private Foreign0Data foreign0_cache;

        private LLVMLoadI8VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        private LLVMLoadI8VectorNodeGen(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            super(isRecursive);
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @ExplodeLoop
        @Override
        public Object executeWithTargetGeneric(Object addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI8VectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI8VectorNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                    LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorNative(LLVMNativePointer)] */) {
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            return doI8VectorNative(addressValue_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI8VectorNode)] */) {
                        I8VectorDerefHandleData s1_ = this.i8VectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue_))) {
                                return doI8VectorDerefHandle(addressValue_, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                    LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        Foreign0Data s2_ = this.foreign0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                return doForeign(addressValue_, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreign1Boundary(state_0, addressValue_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object foreign1Boundary(int state_0, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                    return doForeign(addressValue_, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public LLVMI8Vector executeWithTarget(LLVMManagedPointer addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    Foreign0Data s2_ = this.foreign0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue.getObject()))) {
                            return doForeign(addressValue, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.foreign1Boundary0(state_0, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private LLVMI8Vector foreign1Boundary0(int state_0, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                    return doForeign(addressValue, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI8VectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI8VectorNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                    LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorNative(LLVMNativePointer)] */) {
                        if ((!(isAutoDerefHandle(addressValue__)))) {
                            return doI8VectorNative(addressValue__);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI8VectorNode)] */) {
                        I8VectorDerefHandleData s1_ = this.i8VectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue__))) {
                                return doI8VectorDerefHandle(addressValue__, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                    LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        Foreign0Data s2_ = this.foreign0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue__.getObject()))) {
                                return doForeign(addressValue__, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreign1Boundary1(state_0, addressValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue_);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object foreign1Boundary1(int state_0, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                    return doForeign(addressValue__, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private LLVMI8Vector executeAndSpecialize(Object addressValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorNative(LLVMNativePointer)] */;
                    this.state_0_ = state_0;
                    return doI8VectorNative(addressValue_);
                }
                if ((!(isRecursive)) && (isAutoDerefHandle(addressValue_))) {
                    I8VectorDerefHandleData s1_ = this.insert(new I8VectorDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doI8VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI8VectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.i8VectorDerefHandle_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI8VectorNode)] */;
                    this.state_0_ = state_0;
                    return doI8VectorDerefHandle(addressValue_, getReceiver__, s1_.load_);
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        Foreign0Data s2_ = FOREIGN0_CACHE_UPDATER.getVolatile(this);
                        Foreign0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            // assert (s2_.nativeRead_.accepts(addressValue_.getObject()));
                            if (count2_ < (3)) {
                                s2_ = this.insert(new Foreign0Data(s2_original));
                                LLVMManagedReadLibrary nativeRead__ = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeRead__, "Specialization 'doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.nativeRead_ = nativeRead__;
                                if (!FOREIGN0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            return doForeign(addressValue_, s2_.nativeRead_);
                        }
                        break;
                    }
                }
                {
                    LLVMManagedReadLibrary nativeRead__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.foreign0_cache = null;
                            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return doForeign(addressValue_, nativeRead__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    Foreign0Data s2_ = this.foreign0_cache;
                    if ((s2_ == null || s2_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorNative(LLVMNativePointer)] */;
            }
            {
                if ((!(isRecursive))) {
                    I8VectorDerefHandleData s1_ = this.insert(new I8VectorDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doI8VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI8VectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.i8VectorDerefHandle_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                    ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.load_, 1);
                    ((GenerateAOT.Provider) s1_.load_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI8VectorNode.doI8VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI8VectorNode)] */;
                }
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.i8VectorDerefHandle_cache = null;
        }

        @NeverDefault
        public static LLVMLoadI8VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI8VectorNodeGen(address, vectorLength);
        }

        @NeverDefault
        public static LLVMLoadI8VectorNode create(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI8VectorNodeGen(isRecursive, address, vectorLength);
        }

        @GeneratedBy(LLVMLoadI8VectorNode.class)
        @DenyReplace
        private static final class I8VectorDerefHandleData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI8VectorNode#doI8VectorDerefHandle}
             *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
             */
            @Child LLVMDerefHandleGetReceiverNode getReceiver_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI8VectorNode#doI8VectorDerefHandle}
             *   Parameter: {@link LLVMLoadI8VectorNode} load</pre>
             */
            @Child LLVMLoadI8VectorNode load_;

            I8VectorDerefHandleData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMLoadI8VectorNode.class)
        @DenyReplace
        private static final class Foreign0Data extends Node implements SpecializationDataNode {

            @Child Foreign0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI8VectorNode#doForeign}
             *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
             */
            @Child LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMLoadI16VectorNode#doI16VectorNative}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMLoadI16VectorNode#doI16VectorDerefHandle}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMLoadI16VectorNode#doForeign}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMLoadI16VectorNode#doForeign}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMLoadI16VectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMLoadI16VectorNodeGen extends LLVMLoadI16VectorNode implements GenerateAOT.Provider {

        static final ReferenceField<Foreign0Data> FOREIGN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "foreign0_cache", Foreign0Data.class);

        private final int vectorLength;
        @Child private LLVMExpressionNode address_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMLoadI16VectorNode#doI16VectorNative}
         *   2: SpecializationActive {@link LLVMLoadI16VectorNode#doI16VectorDerefHandle}
         *   3: SpecializationActive {@link LLVMLoadI16VectorNode#doForeign}
         *   4: SpecializationActive {@link LLVMLoadI16VectorNode#doForeign}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private I16VectorDerefHandleData i16VectorDerefHandle_cache;
        @UnsafeAccessedField @Child private Foreign0Data foreign0_cache;

        private LLVMLoadI16VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        private LLVMLoadI16VectorNodeGen(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            super(isRecursive);
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @ExplodeLoop
        @Override
        public Object executeWithTargetGeneric(Object addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI16VectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI16VectorNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                    LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorNative(LLVMNativePointer)] */) {
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            return doI16VectorNative(addressValue_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI16VectorNode)] */) {
                        I16VectorDerefHandleData s1_ = this.i16VectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue_))) {
                                return doI16VectorDerefHandle(addressValue_, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                    LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        Foreign0Data s2_ = this.foreign0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                return doForeign(addressValue_, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreign1Boundary(state_0, addressValue_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object foreign1Boundary(int state_0, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                    return doForeign(addressValue_, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public LLVMI16Vector executeWithTarget(LLVMManagedPointer addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    Foreign0Data s2_ = this.foreign0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue.getObject()))) {
                            return doForeign(addressValue, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.foreign1Boundary0(state_0, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private LLVMI16Vector foreign1Boundary0(int state_0, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                    return doForeign(addressValue, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI16VectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI16VectorNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                    LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorNative(LLVMNativePointer)] */) {
                        if ((!(isAutoDerefHandle(addressValue__)))) {
                            return doI16VectorNative(addressValue__);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI16VectorNode)] */) {
                        I16VectorDerefHandleData s1_ = this.i16VectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue__))) {
                                return doI16VectorDerefHandle(addressValue__, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                    LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        Foreign0Data s2_ = this.foreign0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue__.getObject()))) {
                                return doForeign(addressValue__, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreign1Boundary1(state_0, addressValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue_);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object foreign1Boundary1(int state_0, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                    return doForeign(addressValue__, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private LLVMI16Vector executeAndSpecialize(Object addressValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorNative(LLVMNativePointer)] */;
                    this.state_0_ = state_0;
                    return doI16VectorNative(addressValue_);
                }
                if ((!(isRecursive)) && (isAutoDerefHandle(addressValue_))) {
                    I16VectorDerefHandleData s1_ = this.insert(new I16VectorDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doI16VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI16VectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.i16VectorDerefHandle_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI16VectorNode)] */;
                    this.state_0_ = state_0;
                    return doI16VectorDerefHandle(addressValue_, getReceiver__, s1_.load_);
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        Foreign0Data s2_ = FOREIGN0_CACHE_UPDATER.getVolatile(this);
                        Foreign0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            // assert (s2_.nativeRead_.accepts(addressValue_.getObject()));
                            if (count2_ < (3)) {
                                s2_ = this.insert(new Foreign0Data(s2_original));
                                LLVMManagedReadLibrary nativeRead__ = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeRead__, "Specialization 'doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.nativeRead_ = nativeRead__;
                                if (!FOREIGN0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            return doForeign(addressValue_, s2_.nativeRead_);
                        }
                        break;
                    }
                }
                {
                    LLVMManagedReadLibrary nativeRead__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.foreign0_cache = null;
                            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return doForeign(addressValue_, nativeRead__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    Foreign0Data s2_ = this.foreign0_cache;
                    if ((s2_ == null || s2_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorNative(LLVMNativePointer)] */;
            }
            {
                if ((!(isRecursive))) {
                    I16VectorDerefHandleData s1_ = this.insert(new I16VectorDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doI16VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI16VectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.i16VectorDerefHandle_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                    ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.load_, 1);
                    ((GenerateAOT.Provider) s1_.load_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI16VectorNode.doI16VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI16VectorNode)] */;
                }
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.i16VectorDerefHandle_cache = null;
        }

        @NeverDefault
        public static LLVMLoadI16VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI16VectorNodeGen(address, vectorLength);
        }

        @NeverDefault
        public static LLVMLoadI16VectorNode create(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI16VectorNodeGen(isRecursive, address, vectorLength);
        }

        @GeneratedBy(LLVMLoadI16VectorNode.class)
        @DenyReplace
        private static final class I16VectorDerefHandleData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI16VectorNode#doI16VectorDerefHandle}
             *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
             */
            @Child LLVMDerefHandleGetReceiverNode getReceiver_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI16VectorNode#doI16VectorDerefHandle}
             *   Parameter: {@link LLVMLoadI16VectorNode} load</pre>
             */
            @Child LLVMLoadI16VectorNode load_;

            I16VectorDerefHandleData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMLoadI16VectorNode.class)
        @DenyReplace
        private static final class Foreign0Data extends Node implements SpecializationDataNode {

            @Child Foreign0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI16VectorNode#doForeign}
             *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
             */
            @Child LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMLoadI32VectorNode#doI32VectorNative}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMLoadI32VectorNode#doI32VectorDerefHandle}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMLoadI32VectorNode#doForeign}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMLoadI32VectorNode#doForeign}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMLoadI32VectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMLoadI32VectorNodeGen extends LLVMLoadI32VectorNode implements GenerateAOT.Provider {

        static final ReferenceField<Foreign0Data> FOREIGN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "foreign0_cache", Foreign0Data.class);

        private final int vectorLength;
        @Child private LLVMExpressionNode address_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMLoadI32VectorNode#doI32VectorNative}
         *   2: SpecializationActive {@link LLVMLoadI32VectorNode#doI32VectorDerefHandle}
         *   3: SpecializationActive {@link LLVMLoadI32VectorNode#doForeign}
         *   4: SpecializationActive {@link LLVMLoadI32VectorNode#doForeign}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private I32VectorDerefHandleData i32VectorDerefHandle_cache;
        @UnsafeAccessedField @Child private Foreign0Data foreign0_cache;

        private LLVMLoadI32VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        private LLVMLoadI32VectorNodeGen(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            super(isRecursive);
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @ExplodeLoop
        @Override
        public Object executeWithTargetGeneric(Object addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI32VectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI32VectorNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                    LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorNative(LLVMNativePointer)] */) {
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            return doI32VectorNative(addressValue_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI32VectorNode)] */) {
                        I32VectorDerefHandleData s1_ = this.i32VectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue_))) {
                                return doI32VectorDerefHandle(addressValue_, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                    LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        Foreign0Data s2_ = this.foreign0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                return doForeign(addressValue_, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreign1Boundary(state_0, addressValue_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object foreign1Boundary(int state_0, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                    return doForeign(addressValue_, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public LLVMI32Vector executeWithTarget(LLVMManagedPointer addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    Foreign0Data s2_ = this.foreign0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue.getObject()))) {
                            return doForeign(addressValue, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.foreign1Boundary0(state_0, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private LLVMI32Vector foreign1Boundary0(int state_0, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                    return doForeign(addressValue, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI32VectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI32VectorNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                    LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorNative(LLVMNativePointer)] */) {
                        if ((!(isAutoDerefHandle(addressValue__)))) {
                            return doI32VectorNative(addressValue__);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI32VectorNode)] */) {
                        I32VectorDerefHandleData s1_ = this.i32VectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue__))) {
                                return doI32VectorDerefHandle(addressValue__, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                    LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        Foreign0Data s2_ = this.foreign0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue__.getObject()))) {
                                return doForeign(addressValue__, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreign1Boundary1(state_0, addressValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue_);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object foreign1Boundary1(int state_0, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                    return doForeign(addressValue__, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private LLVMI32Vector executeAndSpecialize(Object addressValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorNative(LLVMNativePointer)] */;
                    this.state_0_ = state_0;
                    return doI32VectorNative(addressValue_);
                }
                if ((!(isRecursive)) && (isAutoDerefHandle(addressValue_))) {
                    I32VectorDerefHandleData s1_ = this.insert(new I32VectorDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doI32VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI32VectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.i32VectorDerefHandle_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI32VectorNode)] */;
                    this.state_0_ = state_0;
                    return doI32VectorDerefHandle(addressValue_, getReceiver__, s1_.load_);
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        Foreign0Data s2_ = FOREIGN0_CACHE_UPDATER.getVolatile(this);
                        Foreign0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            // assert (s2_.nativeRead_.accepts(addressValue_.getObject()));
                            if (count2_ < (3)) {
                                s2_ = this.insert(new Foreign0Data(s2_original));
                                LLVMManagedReadLibrary nativeRead__ = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeRead__, "Specialization 'doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.nativeRead_ = nativeRead__;
                                if (!FOREIGN0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            return doForeign(addressValue_, s2_.nativeRead_);
                        }
                        break;
                    }
                }
                {
                    LLVMManagedReadLibrary nativeRead__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.foreign0_cache = null;
                            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return doForeign(addressValue_, nativeRead__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    Foreign0Data s2_ = this.foreign0_cache;
                    if ((s2_ == null || s2_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorNative(LLVMNativePointer)] */;
            }
            {
                if ((!(isRecursive))) {
                    I32VectorDerefHandleData s1_ = this.insert(new I32VectorDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doI32VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI32VectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.i32VectorDerefHandle_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                    ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.load_, 1);
                    ((GenerateAOT.Provider) s1_.load_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI32VectorNode.doI32VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI32VectorNode)] */;
                }
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.i32VectorDerefHandle_cache = null;
        }

        @NeverDefault
        public static LLVMLoadI32VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI32VectorNodeGen(address, vectorLength);
        }

        @NeverDefault
        public static LLVMLoadI32VectorNode create(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI32VectorNodeGen(isRecursive, address, vectorLength);
        }

        @GeneratedBy(LLVMLoadI32VectorNode.class)
        @DenyReplace
        private static final class I32VectorDerefHandleData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI32VectorNode#doI32VectorDerefHandle}
             *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
             */
            @Child LLVMDerefHandleGetReceiverNode getReceiver_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI32VectorNode#doI32VectorDerefHandle}
             *   Parameter: {@link LLVMLoadI32VectorNode} load</pre>
             */
            @Child LLVMLoadI32VectorNode load_;

            I32VectorDerefHandleData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMLoadI32VectorNode.class)
        @DenyReplace
        private static final class Foreign0Data extends Node implements SpecializationDataNode {

            @Child Foreign0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI32VectorNode#doForeign}
             *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
             */
            @Child LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMLoadI64VectorNode#doI64VectorNative}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMLoadI64VectorNode#doI64VectorDerefHandle}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMLoadI64VectorNode#doI64Vector}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMLoadI64VectorNode#doPointerVector}
     *     Activation probability: 0.11500
     *     With/without class size: 6/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMLoadI64VectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMLoadI64VectorNodeGen extends LLVMLoadI64VectorNode implements GenerateAOT.Provider {

        static final ReferenceField<I64VectorData> I64_VECTOR_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "i64Vector_cache", I64VectorData.class);

        private final int vectorLength;
        @Child private LLVMExpressionNode address_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMLoadI64VectorNode#doI64VectorNative}
         *   2: SpecializationActive {@link LLVMLoadI64VectorNode#doI64VectorDerefHandle}
         *   3: SpecializationActive {@link LLVMLoadI64VectorNode#doI64Vector}
         *   4: SpecializationExcluded {@link LLVMLoadI64VectorNode#doI64Vector}
         *   5: SpecializationActive {@link LLVMLoadI64VectorNode#doPointerVector}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private I64VectorDerefHandleData i64VectorDerefHandle_cache;
        @UnsafeAccessedField @Child private I64VectorData i64Vector_cache;
        @Child private PointerVectorData pointerVector_cache;

        private LLVMLoadI64VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        private LLVMLoadI64VectorNodeGen(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            super(isRecursive);
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @ExplodeLoop
        @Override
        public Object executeWithTargetGeneric(Object addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b101110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI64VectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doPointerVector(LLVMManagedPointer, LLVMLoadPointerVectorNode)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI64VectorNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                    LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorNative(LLVMNativePointer)] */) {
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            return doI64VectorNative(addressValue_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI64VectorNode)] */) {
                        I64VectorDerefHandleData s1_ = this.i64VectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue_))) {
                                return doI64VectorDerefHandle(addressValue_, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b101000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doPointerVector(LLVMManagedPointer, LLVMLoadPointerVectorNode)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                    LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        I64VectorData s2_ = this.i64Vector_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                try {
                                    return doI64Vector(addressValue_, s2_.nativeRead_);
                                } catch (UnexpectedResultException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    this.i64Vector_cache = null;
                                    return ex.getResult();
                                }
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doPointerVector(LLVMManagedPointer, LLVMLoadPointerVectorNode)] */) {
                        PointerVectorData s3_ = this.pointerVector_cache;
                        if (s3_ != null) {
                            return doPointerVector(addressValue_, s3_.load_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @ExplodeLoop
        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue_);
            }
            if ((state_0 & 0b101110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI64VectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doPointerVector(LLVMManagedPointer, LLVMLoadPointerVectorNode)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI64VectorNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                    LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorNative(LLVMNativePointer)] */) {
                        if ((!(isAutoDerefHandle(addressValue__)))) {
                            return doI64VectorNative(addressValue__);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI64VectorNode)] */) {
                        I64VectorDerefHandleData s1_ = this.i64VectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue__))) {
                                return doI64VectorDerefHandle(addressValue__, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b101000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doPointerVector(LLVMManagedPointer, LLVMLoadPointerVectorNode)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                    LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        I64VectorData s2_ = this.i64Vector_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue__.getObject()))) {
                                try {
                                    return doI64Vector(addressValue__, s2_.nativeRead_);
                                } catch (UnexpectedResultException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    this.i64Vector_cache = null;
                                    return ex.getResult();
                                }
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doPointerVector(LLVMManagedPointer, LLVMLoadPointerVectorNode)] */) {
                        PointerVectorData s3_ = this.pointerVector_cache;
                        if (s3_ != null) {
                            return doPointerVector(addressValue__, s3_.load_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue_);
        }

        @ExplodeLoop
        @Override
        public LLVMVector executeWithTarget(LLVMManagedPointer addressValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b101000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doPointerVector(LLVMManagedPointer, LLVMLoadPointerVectorNode)] */) {
                return (LLVMVector) executeWithTargetGeneric(addressValue);
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return (LLVMVector) executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b101000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doPointerVector(LLVMManagedPointer, LLVMLoadPointerVectorNode)] */) {
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    I64VectorData s2_ = this.i64Vector_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue.getObject()))) {
                            try {
                                return doI64Vector(addressValue, s2_.nativeRead_);
                            } catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                                state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.i64Vector_cache = null;
                                return (LLVMVector) ex.getResult();
                            }
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doPointerVector(LLVMManagedPointer, LLVMLoadPointerVectorNode)] */) {
                    PointerVectorData s3_ = this.pointerVector_cache;
                    if (s3_ != null) {
                        return doPointerVector(addressValue, s3_.load_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return (LLVMVector) executeAndSpecialize(addressValue);
        }

        private Object executeAndSpecialize(Object addressValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorNative(LLVMNativePointer)] */;
                    this.state_0_ = state_0;
                    return doI64VectorNative(addressValue_);
                }
                if ((!(isRecursive)) && (isAutoDerefHandle(addressValue_))) {
                    I64VectorDerefHandleData s1_ = this.insert(new I64VectorDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doI64VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI64VectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.i64VectorDerefHandle_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI64VectorNode)] */;
                    this.state_0_ = state_0;
                    return doI64VectorDerefHandle(addressValue_, getReceiver__, s1_.load_);
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doPointerVector(LLVMManagedPointer, LLVMLoadPointerVectorNode)] */ && ((state_0 & 0b10000)) == 0 /* is-not SpecializationExcluded  */) {
                    while (true) {
                        int count2_ = 0;
                        I64VectorData s2_ = I64_VECTOR_CACHE_UPDATER.getVolatile(this);
                        I64VectorData s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            // assert (s2_.nativeRead_.accepts(addressValue_.getObject()));
                            if (count2_ < (3)) {
                                s2_ = this.insert(new I64VectorData(s2_original));
                                LLVMManagedReadLibrary nativeRead__ = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeRead__, "Specialization 'doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.nativeRead_ = nativeRead__;
                                if (!I64_VECTOR_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            try {
                                return doI64Vector(addressValue_, s2_.nativeRead_);
                            } catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                                state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.i64Vector_cache = null;
                                return ex.getResult();
                            }
                        }
                        break;
                    }
                }
                PointerVectorData s3_ = this.insert(new PointerVectorData());
                s3_.load_ = s3_.insert((LLVMLoadPointerVectorNode.create(getVectorLength())));
                VarHandle.storeStoreFence();
                this.pointerVector_cache = s3_;
                this.i64Vector_cache = null;
                state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doPointerVector(LLVMManagedPointer, LLVMLoadPointerVectorNode)] */;
                this.state_0_ = state_0;
                return doPointerVector(addressValue_, s3_.load_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b101110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b101110) & ((state_0 & 0b101110) - 1)) == 0 /* is-single  */) {
                    I64VectorData s2_ = this.i64Vector_cache;
                    if ((s2_ == null || s2_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorNative(LLVMNativePointer)] */;
            }
            {
                if ((!(isRecursive))) {
                    I64VectorDerefHandleData s1_ = this.insert(new I64VectorDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doI64VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI64VectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.i64VectorDerefHandle_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                    ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.load_, 1);
                    ((GenerateAOT.Provider) s1_.load_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64VectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadI64VectorNode)] */;
                }
            }
            {
                PointerVectorData s3_ = this.insert(new PointerVectorData());
                s3_.load_ = s3_.insert((LLVMLoadPointerVectorNode.create(getVectorLength())));
                VarHandle.storeStoreFence();
                this.pointerVector_cache = s3_;
                this.i64Vector_cache = null;
                this.state_0_ = state_0_ & 0xfffffff7 /* remove SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doI64Vector(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                assert NodeUtil.assertRecursion(s3_.load_, 1);
                ((GenerateAOT.Provider) s3_.load_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadI64VectorNode.doPointerVector(LLVMManagedPointer, LLVMLoadPointerVectorNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.i64VectorDerefHandle_cache = null;
            this.pointerVector_cache = null;
        }

        @NeverDefault
        public static LLVMLoadI64VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI64VectorNodeGen(address, vectorLength);
        }

        @NeverDefault
        public static LLVMLoadI64VectorNode create(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI64VectorNodeGen(isRecursive, address, vectorLength);
        }

        @GeneratedBy(LLVMLoadI64VectorNode.class)
        @DenyReplace
        private static final class I64VectorDerefHandleData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI64VectorNode#doI64VectorDerefHandle}
             *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
             */
            @Child LLVMDerefHandleGetReceiverNode getReceiver_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI64VectorNode#doI64VectorDerefHandle}
             *   Parameter: {@link LLVMLoadI64VectorNode} load</pre>
             */
            @Child LLVMLoadI64VectorNode load_;

            I64VectorDerefHandleData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMLoadI64VectorNode.class)
        @DenyReplace
        private static final class I64VectorData extends Node implements SpecializationDataNode {

            @Child I64VectorData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI64VectorNode#doI64Vector}
             *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
             */
            @Child LLVMManagedReadLibrary nativeRead_;

            I64VectorData(I64VectorData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMLoadI64VectorNode.class)
        @DenyReplace
        private static final class PointerVectorData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadI64VectorNode#doPointerVector}
             *   Parameter: {@link LLVMLoadPointerVectorNode} load</pre>
             */
            @Child LLVMLoadPointerVectorNode load_;

            PointerVectorData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMLoadPointerVectorNode#doPointerVectorNative}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMLoadPointerVectorNode#doPointerVectorDerefHandle}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMLoadPointerVectorNode#doForeignPointers}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMLoadPointerVectorNode#doForeignPointers}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMLoadPointerVectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMLoadPointerVectorNodeGen extends LLVMLoadPointerVectorNode implements GenerateAOT.Provider {

        static final ReferenceField<ForeignPointers0Data> FOREIGN_POINTERS0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "foreignPointers0_cache", ForeignPointers0Data.class);

        private final int vectorLength;
        @Child private LLVMExpressionNode address_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMLoadPointerVectorNode#doPointerVectorNative}
         *   2: SpecializationActive {@link LLVMLoadPointerVectorNode#doPointerVectorDerefHandle}
         *   3: SpecializationActive {@link LLVMLoadPointerVectorNode#doForeignPointers}
         *   4: SpecializationActive {@link LLVMLoadPointerVectorNode#doForeignPointers}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private PointerVectorDerefHandleData pointerVectorDerefHandle_cache;
        @UnsafeAccessedField @Child private ForeignPointers0Data foreignPointers0_cache;

        private LLVMLoadPointerVectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        private LLVMLoadPointerVectorNodeGen(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            super(isRecursive);
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @ExplodeLoop
        @Override
        public Object executeWithTargetGeneric(Object addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadPointerVectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadPointerVectorNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                    LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorNative(LLVMNativePointer)] */) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            return doPointerVectorNative(addressValue_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadPointerVectorNode)] */) {
                        PointerVectorDerefHandleData s1_ = this.pointerVectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue_))) {
                                return doPointerVectorDerefHandle(addressValue_, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                    LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        ForeignPointers0Data s2_ = this.foreignPointers0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                return doForeignPointers(addressValue_, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreignPointers1Boundary(state_0, addressValue_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object foreignPointers1Boundary(int state_0, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                    return doForeignPointers(addressValue_, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public LLVMPointerVector executeWithTarget(Object addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadPointerVectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadPointerVectorNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                    LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorNative(LLVMNativePointer)] */) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            return doPointerVectorNative(addressValue_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadPointerVectorNode)] */) {
                        PointerVectorDerefHandleData s1_ = this.pointerVectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue_))) {
                                return doPointerVectorDerefHandle(addressValue_, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                    LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        ForeignPointers0Data s2_ = this.foreignPointers0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                return doForeignPointers(addressValue_, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreignPointers1Boundary0(state_0, addressValue_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private LLVMPointerVector foreignPointers1Boundary0(int state_0, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                    return doForeignPointers(addressValue_, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadPointerVectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadPointerVectorNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                    LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorNative(LLVMNativePointer)] */) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        if ((!(isAutoDerefHandle(addressValue__)))) {
                            return doPointerVectorNative(addressValue__);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadPointerVectorNode)] */) {
                        PointerVectorDerefHandleData s1_ = this.pointerVectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue__))) {
                                return doPointerVectorDerefHandle(addressValue__, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                    LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        ForeignPointers0Data s2_ = this.foreignPointers0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue__.getObject()))) {
                                return doForeignPointers(addressValue__, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreignPointers1Boundary1(state_0, addressValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue_);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object foreignPointers1Boundary1(int state_0, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                    return doForeignPointers(addressValue__, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private LLVMPointerVector executeAndSpecialize(Object addressValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((!(isRecursive)) && (!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorNative(LLVMNativePointer)] */;
                    this.state_0_ = state_0;
                    return doPointerVectorNative(addressValue_);
                }
                if ((!(isRecursive)) && (isAutoDerefHandle(addressValue_))) {
                    PointerVectorDerefHandleData s1_ = this.insert(new PointerVectorDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doPointerVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadPointerVectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((LLVMLoadPointerVectorNode.createRecursive(getVectorLength())));
                    VarHandle.storeStoreFence();
                    this.pointerVectorDerefHandle_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadPointerVectorNode)] */;
                    this.state_0_ = state_0;
                    return doPointerVectorDerefHandle(addressValue_, getReceiver__, s1_.load_);
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        ForeignPointers0Data s2_ = FOREIGN_POINTERS0_CACHE_UPDATER.getVolatile(this);
                        ForeignPointers0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            // assert (s2_.nativeRead_.accepts(addressValue_.getObject()));
                            if (count2_ < (3)) {
                                s2_ = this.insert(new ForeignPointers0Data(s2_original));
                                LLVMManagedReadLibrary nativeRead__ = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeRead__, "Specialization 'doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.nativeRead_ = nativeRead__;
                                if (!FOREIGN_POINTERS0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            return doForeignPointers(addressValue_, s2_.nativeRead_);
                        }
                        break;
                    }
                }
                {
                    LLVMManagedReadLibrary nativeRead__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.foreignPointers0_cache = null;
                            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doForeignPointers(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return doForeignPointers(addressValue_, nativeRead__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    ForeignPointers0Data s2_ = this.foreignPointers0_cache;
                    if ((s2_ == null || s2_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorNative(LLVMNativePointer)] */;
                }
            }
            {
                if ((!(isRecursive))) {
                    PointerVectorDerefHandleData s1_ = this.insert(new PointerVectorDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doPointerVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadPointerVectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((LLVMLoadPointerVectorNode.createRecursive(getVectorLength())));
                    VarHandle.storeStoreFence();
                    this.pointerVectorDerefHandle_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                    ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.load_, 1);
                    ((GenerateAOT.Provider) s1_.load_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadPointerVectorNode.doPointerVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadPointerVectorNode)] */;
                }
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointerVectorDerefHandle_cache = null;
        }

        @NeverDefault
        public static LLVMLoadPointerVectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadPointerVectorNodeGen(address, vectorLength);
        }

        @NeverDefault
        public static LLVMLoadPointerVectorNode create(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadPointerVectorNodeGen(isRecursive, address, vectorLength);
        }

        @GeneratedBy(LLVMLoadPointerVectorNode.class)
        @DenyReplace
        private static final class PointerVectorDerefHandleData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadPointerVectorNode#doPointerVectorDerefHandle}
             *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
             */
            @Child LLVMDerefHandleGetReceiverNode getReceiver_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadPointerVectorNode#doPointerVectorDerefHandle}
             *   Parameter: {@link LLVMLoadPointerVectorNode} load</pre>
             */
            @Child LLVMLoadPointerVectorNode load_;

            PointerVectorDerefHandleData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMLoadPointerVectorNode.class)
        @DenyReplace
        private static final class ForeignPointers0Data extends Node implements SpecializationDataNode {

            @Child ForeignPointers0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadPointerVectorNode#doForeignPointers}
             *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
             */
            @Child LLVMManagedReadLibrary nativeRead_;

            ForeignPointers0Data(ForeignPointers0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMLoadFloatVectorNode#doFloatVectorNative}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMLoadFloatVectorNode#doFloatVectorDerefHandle}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMLoadFloatVectorNode#doForeign}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMLoadFloatVectorNode#doForeign}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMLoadFloatVectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMLoadFloatVectorNodeGen extends LLVMLoadFloatVectorNode implements GenerateAOT.Provider {

        static final ReferenceField<Foreign0Data> FOREIGN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "foreign0_cache", Foreign0Data.class);

        private final int vectorLength;
        @Child private LLVMExpressionNode address_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMLoadFloatVectorNode#doFloatVectorNative}
         *   2: SpecializationActive {@link LLVMLoadFloatVectorNode#doFloatVectorDerefHandle}
         *   3: SpecializationActive {@link LLVMLoadFloatVectorNode#doForeign}
         *   4: SpecializationActive {@link LLVMLoadFloatVectorNode#doForeign}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private FloatVectorDerefHandleData floatVectorDerefHandle_cache;
        @UnsafeAccessedField @Child private Foreign0Data foreign0_cache;

        private LLVMLoadFloatVectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        private LLVMLoadFloatVectorNodeGen(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            super(isRecursive);
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @ExplodeLoop
        @Override
        public Object executeWithTargetGeneric(Object addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadFloatVectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadFloatVectorNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                    LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorNative(LLVMNativePointer)] */) {
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            return doFloatVectorNative(addressValue_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadFloatVectorNode)] */) {
                        FloatVectorDerefHandleData s1_ = this.floatVectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue_))) {
                                return doFloatVectorDerefHandle(addressValue_, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                    LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        Foreign0Data s2_ = this.foreign0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                return doForeign(addressValue_, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreign1Boundary(state_0, addressValue_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object foreign1Boundary(int state_0, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                    return doForeign(addressValue_, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public LLVMFloatVector executeWithTarget(LLVMManagedPointer addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    Foreign0Data s2_ = this.foreign0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue.getObject()))) {
                            return doForeign(addressValue, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.foreign1Boundary0(state_0, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private LLVMFloatVector foreign1Boundary0(int state_0, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                    return doForeign(addressValue, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadFloatVectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadFloatVectorNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                    LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorNative(LLVMNativePointer)] */) {
                        if ((!(isAutoDerefHandle(addressValue__)))) {
                            return doFloatVectorNative(addressValue__);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadFloatVectorNode)] */) {
                        FloatVectorDerefHandleData s1_ = this.floatVectorDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue__))) {
                                return doFloatVectorDerefHandle(addressValue__, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                    LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        Foreign0Data s2_ = this.foreign0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue__.getObject()))) {
                                return doForeign(addressValue__, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreign1Boundary1(state_0, addressValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue_);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object foreign1Boundary1(int state_0, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                    return doForeign(addressValue__, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private LLVMFloatVector executeAndSpecialize(Object addressValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorNative(LLVMNativePointer)] */;
                    this.state_0_ = state_0;
                    return doFloatVectorNative(addressValue_);
                }
                if ((!(isRecursive)) && (isAutoDerefHandle(addressValue_))) {
                    FloatVectorDerefHandleData s1_ = this.insert(new FloatVectorDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doFloatVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadFloatVectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.floatVectorDerefHandle_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadFloatVectorNode)] */;
                    this.state_0_ = state_0;
                    return doFloatVectorDerefHandle(addressValue_, getReceiver__, s1_.load_);
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        Foreign0Data s2_ = FOREIGN0_CACHE_UPDATER.getVolatile(this);
                        Foreign0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            // assert (s2_.nativeRead_.accepts(addressValue_.getObject()));
                            if (count2_ < (3)) {
                                s2_ = this.insert(new Foreign0Data(s2_original));
                                LLVMManagedReadLibrary nativeRead__ = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeRead__, "Specialization 'doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.nativeRead_ = nativeRead__;
                                if (!FOREIGN0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            return doForeign(addressValue_, s2_.nativeRead_);
                        }
                        break;
                    }
                }
                {
                    LLVMManagedReadLibrary nativeRead__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.foreign0_cache = null;
                            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return doForeign(addressValue_, nativeRead__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    Foreign0Data s2_ = this.foreign0_cache;
                    if ((s2_ == null || s2_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorNative(LLVMNativePointer)] */;
            }
            {
                if ((!(isRecursive))) {
                    FloatVectorDerefHandleData s1_ = this.insert(new FloatVectorDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doFloatVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadFloatVectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.floatVectorDerefHandle_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                    ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.load_, 1);
                    ((GenerateAOT.Provider) s1_.load_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadFloatVectorNode.doFloatVectorDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadFloatVectorNode)] */;
                }
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.floatVectorDerefHandle_cache = null;
        }

        @NeverDefault
        public static LLVMLoadFloatVectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadFloatVectorNodeGen(address, vectorLength);
        }

        @NeverDefault
        public static LLVMLoadFloatVectorNode create(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadFloatVectorNodeGen(isRecursive, address, vectorLength);
        }

        @GeneratedBy(LLVMLoadFloatVectorNode.class)
        @DenyReplace
        private static final class FloatVectorDerefHandleData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadFloatVectorNode#doFloatVectorDerefHandle}
             *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
             */
            @Child LLVMDerefHandleGetReceiverNode getReceiver_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadFloatVectorNode#doFloatVectorDerefHandle}
             *   Parameter: {@link LLVMLoadFloatVectorNode} load</pre>
             */
            @Child LLVMLoadFloatVectorNode load_;

            FloatVectorDerefHandleData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMLoadFloatVectorNode.class)
        @DenyReplace
        private static final class Foreign0Data extends Node implements SpecializationDataNode {

            @Child Foreign0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadFloatVectorNode#doForeign}
             *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
             */
            @Child LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMLoadDoubleVectorNode#doDoubleVectorNative}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMLoadDoubleVectorNode#doDoubleVector}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMLoadDoubleVectorNode#doForeign}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMLoadDoubleVectorNode#doForeign}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMLoadDoubleVectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMLoadDoubleVectorNodeGen extends LLVMLoadDoubleVectorNode implements GenerateAOT.Provider {

        static final ReferenceField<Foreign0Data> FOREIGN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "foreign0_cache", Foreign0Data.class);

        private final int vectorLength;
        @Child private LLVMExpressionNode address_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMLoadDoubleVectorNode#doDoubleVectorNative}
         *   2: SpecializationActive {@link LLVMLoadDoubleVectorNode#doDoubleVector}
         *   3: SpecializationActive {@link LLVMLoadDoubleVectorNode#doForeign}
         *   4: SpecializationActive {@link LLVMLoadDoubleVectorNode#doForeign}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private DoubleVectorData doubleVector_cache;
        @UnsafeAccessedField @Child private Foreign0Data foreign0_cache;

        private LLVMLoadDoubleVectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        private LLVMLoadDoubleVectorNodeGen(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            super(isRecursive);
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @ExplodeLoop
        @Override
        public Object executeWithTargetGeneric(Object addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVector(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadDoubleVectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVector(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadDoubleVectorNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                    LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVectorNative(LLVMNativePointer)] */) {
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            return doDoubleVectorNative(addressValue_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVector(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadDoubleVectorNode)] */) {
                        DoubleVectorData s1_ = this.doubleVector_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue_))) {
                                return doDoubleVector(addressValue_, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                    LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        Foreign0Data s2_ = this.foreign0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                return doForeign(addressValue_, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreign1Boundary(state_0, addressValue_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object foreign1Boundary(int state_0, LLVMManagedPointer addressValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                    return doForeign(addressValue_, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public LLVMDoubleVector executeWithTarget(LLVMManagedPointer addressValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue);
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    Foreign0Data s2_ = this.foreign0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue.getObject()))) {
                            return doForeign(addressValue, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.foreign1Boundary0(state_0, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private LLVMDoubleVector foreign1Boundary0(int state_0, LLVMManagedPointer addressValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                    return doForeign(addressValue, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(addressValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVector(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadDoubleVectorNode)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVectorNative(LLVMNativePointer)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVector(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadDoubleVectorNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                    LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVectorNative(LLVMNativePointer)] */) {
                        if ((!(isAutoDerefHandle(addressValue__)))) {
                            return doDoubleVectorNative(addressValue__);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVector(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadDoubleVectorNode)] */) {
                        DoubleVectorData s1_ = this.doubleVector_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(addressValue__))) {
                                return doDoubleVector(addressValue__, s1_.getReceiver_, s1_.load_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                    LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        Foreign0Data s2_ = this.foreign0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue__.getObject()))) {
                                return doForeign(addressValue__, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                        return this.foreign1Boundary1(state_0, addressValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue_);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object foreign1Boundary1(int state_0, LLVMManagedPointer addressValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                    return doForeign(addressValue__, nativeRead__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private LLVMDoubleVector executeAndSpecialize(Object addressValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVectorNative(LLVMNativePointer)] */;
                    this.state_0_ = state_0;
                    return doDoubleVectorNative(addressValue_);
                }
                if ((!(isRecursive)) && (isAutoDerefHandle(addressValue_))) {
                    DoubleVectorData s1_ = this.insert(new DoubleVectorData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doDoubleVector(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadDoubleVectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.doubleVector_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVector(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadDoubleVectorNode)] */;
                    this.state_0_ = state_0;
                    return doDoubleVector(addressValue_, getReceiver__, s1_.load_);
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        Foreign0Data s2_ = FOREIGN0_CACHE_UPDATER.getVolatile(this);
                        Foreign0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            // assert (s2_.nativeRead_.accepts(addressValue_.getObject()));
                            if (count2_ < (3)) {
                                s2_ = this.insert(new Foreign0Data(s2_original));
                                LLVMManagedReadLibrary nativeRead__ = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeRead__, "Specialization 'doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.nativeRead_ = nativeRead__;
                                if (!FOREIGN0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            return doForeign(addressValue_, s2_.nativeRead_);
                        }
                        break;
                    }
                }
                {
                    LLVMManagedReadLibrary nativeRead__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeRead__ = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.foreign0_cache = null;
                            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return doForeign(addressValue_, nativeRead__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    Foreign0Data s2_ = this.foreign0_cache;
                    if ((s2_ == null || s2_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVectorNative(LLVMNativePointer)] */;
            }
            {
                if ((!(isRecursive))) {
                    DoubleVectorData s1_ = this.insert(new DoubleVectorData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doDoubleVector(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadDoubleVectorNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.load_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.doubleVector_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                    ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.load_, 1);
                    ((GenerateAOT.Provider) s1_.load_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.doDoubleVector(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMLoadDoubleVectorNode)] */;
                }
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.doubleVector_cache = null;
        }

        @NeverDefault
        public static LLVMLoadDoubleVectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadDoubleVectorNodeGen(address, vectorLength);
        }

        @NeverDefault
        public static LLVMLoadDoubleVectorNode create(boolean isRecursive, LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadDoubleVectorNodeGen(isRecursive, address, vectorLength);
        }

        @GeneratedBy(LLVMLoadDoubleVectorNode.class)
        @DenyReplace
        private static final class DoubleVectorData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadDoubleVectorNode#doDoubleVector}
             *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
             */
            @Child LLVMDerefHandleGetReceiverNode getReceiver_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadDoubleVectorNode#doDoubleVector}
             *   Parameter: {@link LLVMLoadDoubleVectorNode} load</pre>
             */
            @Child LLVMLoadDoubleVectorNode load_;

            DoubleVectorData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMLoadDoubleVectorNode.class)
        @DenyReplace
        private static final class Foreign0Data extends Node implements SpecializationDataNode {

            @Child Foreign0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMLoadDoubleVectorNode#doForeign}
             *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
             */
            @Child LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
}
