// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVM80BitFloatStoreNode#doOp}
 *     Activation probability: 0.48333
 *     With/without class size: 9/0 bytes
 *   Specialization {@link LLVM80BitFloatStoreNode#doOpDerefHandle}
 *     Activation probability: 0.33333
 *     With/without class size: 12/8 bytes
 *   Specialization {@link LLVM80BitFloatStoreNode#doForeign}
 *     Activation probability: 0.18333
 *     With/without class size: 7/4 bytes
 * </pre>
 */
@GeneratedBy(LLVM80BitFloatStoreNode.class)
@SuppressWarnings("javadoc")
public final class LLVM80BitFloatStoreNodeGen extends LLVM80BitFloatStoreNode implements GenerateAOT.Provider {

    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);

    @Child private LLVMExpressionNode address_;
    @Child private LLVMExpressionNode value_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVM80BitFloatStoreNode#doOp}
     *   2: SpecializationActive {@link LLVM80BitFloatStoreNode#doOpDerefHandle}
     *   3: SpecializationActive {@link LLVM80BitFloatStoreNode#doForeign}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private OpDerefHandleData opDerefHandle_cache;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVM80BitFloatStoreNode#doForeign}
     *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
     */
    @Child private LLVMManagedWriteLibrary foreign_nativeWrite_;

    private LLVM80BitFloatStoreNodeGen(LLVMExpressionNode address, LLVMExpressionNode value) {
        this.address_ = address;
        this.value_ = value;
    }

    private LLVM80BitFloatStoreNodeGen(boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value) {
        super(isRecursive);
        this.address_ = address;
        this.value_ = value;
    }

    @Override
    public void executeWithTarget(Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doOp(LLVMNativePointer, LLVM80BitFloat)] || SpecializationActive[LLVM80BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVM80BitFloatStoreNode)] || SpecializationActive[LLVM80BitFloatStoreNode.doForeign(LLVMManagedPointer, LLVM80BitFloat, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVM80BitFloat) {
            LLVM80BitFloat valueValue_ = (LLVM80BitFloat) valueValue;
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doOp(LLVMNativePointer, LLVM80BitFloat)] || SpecializationActive[LLVM80BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVM80BitFloatStoreNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doOp(LLVMNativePointer, LLVM80BitFloat)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        doOp(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVM80BitFloatStoreNode)] */) {
                    OpDerefHandleData s1_ = this.opDerefHandle_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        if ((isAutoDerefHandle(addressValue_))) {
                            LLVM80BitFloatStoreNode.doOpDerefHandle(addressValue_, valueValue_, s1_.getReceiver_, s1_.store_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doForeign(LLVMManagedPointer, LLVM80BitFloat, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                {
                    LLVMManagedWriteLibrary nativeWrite__ = this.foreign_nativeWrite_;
                    if (nativeWrite__ != null) {
                        LLVM80BitFloatStoreNode.doForeign(addressValue_, valueValue_, nativeWrite__);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue, valueValue);
        return;
    }

    @Override
    public void executeWithTarget(LLVMPointer addressValue, LLVM80BitFloat valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doOp(LLVMNativePointer, LLVM80BitFloat)] || SpecializationActive[LLVM80BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVM80BitFloatStoreNode)] || SpecializationActive[LLVM80BitFloatStoreNode.doForeign(LLVMManagedPointer, LLVM80BitFloat, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doOp(LLVMNativePointer, LLVM80BitFloat)] || SpecializationActive[LLVM80BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVM80BitFloatStoreNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doOp(LLVMNativePointer, LLVM80BitFloat)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        doOp(addressValue_, valueValue);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVM80BitFloatStoreNode)] */) {
                    OpDerefHandleData s1_ = this.opDerefHandle_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        if ((isAutoDerefHandle(addressValue_))) {
                            LLVM80BitFloatStoreNode.doOpDerefHandle(addressValue_, valueValue, s1_.getReceiver_, s1_.store_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doForeign(LLVMManagedPointer, LLVM80BitFloat, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                {
                    LLVMManagedWriteLibrary nativeWrite__ = this.foreign_nativeWrite_;
                    if (nativeWrite__ != null) {
                        LLVM80BitFloatStoreNode.doForeign(addressValue_, valueValue, nativeWrite__);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue, valueValue);
        return;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue_, valueValue_);
            return;
        }
        if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doOp(LLVMNativePointer, LLVM80BitFloat)] || SpecializationActive[LLVM80BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVM80BitFloatStoreNode)] || SpecializationActive[LLVM80BitFloatStoreNode.doForeign(LLVMManagedPointer, LLVM80BitFloat, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof LLVM80BitFloat) {
            LLVM80BitFloat valueValue__ = (LLVM80BitFloat) valueValue_;
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doOp(LLVMNativePointer, LLVM80BitFloat)] || SpecializationActive[LLVM80BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVM80BitFloatStoreNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doOp(LLVMNativePointer, LLVM80BitFloat)] */) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        doOp(addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVM80BitFloatStoreNode)] */) {
                    OpDerefHandleData s1_ = this.opDerefHandle_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        if ((isAutoDerefHandle(addressValue__))) {
                            LLVM80BitFloatStoreNode.doOpDerefHandle(addressValue__, valueValue__, s1_.getReceiver_, s1_.store_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.doForeign(LLVMManagedPointer, LLVM80BitFloat, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                {
                    LLVMManagedWriteLibrary nativeWrite__ = this.foreign_nativeWrite_;
                    if (nativeWrite__ != null) {
                        LLVM80BitFloatStoreNode.doForeign(addressValue__, valueValue__, nativeWrite__);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue_, valueValue_);
        return;
    }

    private void executeAndSpecialize(Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (valueValue instanceof LLVM80BitFloat) {
            LLVM80BitFloat valueValue_ = (LLVM80BitFloat) valueValue;
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVM80BitFloatStoreNode.doOp(LLVMNativePointer, LLVM80BitFloat)] */;
                    this.state_0_ = state_0;
                    doOp(addressValue_, valueValue_);
                    return;
                }
                if ((!(isRecursive)) && (isAutoDerefHandle(addressValue_))) {
                    OpDerefHandleData s1_ = this.insert(new OpDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVM80BitFloatStoreNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.store_ = s1_.insert((LLVM80BitFloatStoreNode.createRecursive()));
                    VarHandle.storeStoreFence();
                    this.opDerefHandle_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVM80BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVM80BitFloatStoreNode)] */;
                    this.state_0_ = state_0;
                    LLVM80BitFloatStoreNode.doOpDerefHandle(addressValue_, valueValue_, getReceiver__, s1_.store_);
                    return;
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                LLVMManagedWriteLibrary nativeWrite__ = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeWrite__, "Specialization 'doForeign(LLVMManagedPointer, LLVM80BitFloat, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.foreign_nativeWrite_ = nativeWrite__;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVM80BitFloatStoreNode.doForeign(LLVMManagedPointer, LLVM80BitFloat, LLVMManagedWriteLibrary)] */;
                this.state_0_ = state_0;
                LLVM80BitFloatStoreNode.doForeign(addressValue_, valueValue_, nativeWrite__);
                return;
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_, this.value_}, addressValue, valueValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b1110) & ((state_0 & 0b1110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVM80BitFloatStoreNode.doOp(LLVMNativePointer, LLVM80BitFloat)] */;
        }
        {
            if ((!(isRecursive))) {
                OpDerefHandleData s1_ = this.insert(new OpDerefHandleData());
                LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVM80BitFloatStoreNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s1_.getReceiver_ = getReceiver__;
                s1_.store_ = s1_.insert((LLVM80BitFloatStoreNode.createRecursive()));
                VarHandle.storeStoreFence();
                this.opDerefHandle_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s1_.store_, 1);
                ((GenerateAOT.Provider) s1_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVM80BitFloatStoreNode.doOpDerefHandle(LLVMNativePointer, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVM80BitFloatStoreNode)] */;
            }
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.opDerefHandle_cache = null;
    }

    @NeverDefault
    public static LLVM80BitFloatStoreNode create(LLVMExpressionNode address, LLVMExpressionNode value) {
        return new LLVM80BitFloatStoreNodeGen(address, value);
    }

    @NeverDefault
    public static LLVM80BitFloatStoreNode create(boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value) {
        return new LLVM80BitFloatStoreNodeGen(isRecursive, address, value);
    }

    @GeneratedBy(LLVM80BitFloatStoreNode.class)
    @DenyReplace
    private static final class OpDerefHandleData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVM80BitFloatStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child LLVMDerefHandleGetReceiverNode getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVM80BitFloatStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVM80BitFloatStoreNode} store</pre>
         */
        @Child LLVM80BitFloatStoreNode store_;

        OpDerefHandleData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVM80BitFloatOffsetStoreNode#doOp}
     *     Activation probability: 0.48333
     *     With/without class size: 9/0 bytes
     *   Specialization {@link LLVM80BitFloatOffsetStoreNode#doOpDerefHandle}
     *     Activation probability: 0.33333
     *     With/without class size: 12/8 bytes
     *   Specialization {@link LLVM80BitFloatOffsetStoreNode#doOpManaged}
     *     Activation probability: 0.18333
     *     With/without class size: 7/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVM80BitFloatOffsetStoreNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVM80BitFloatOffsetStoreNodeGen extends LLVM80BitFloatOffsetStoreNode implements GenerateAOT.Provider {

        private static final Uncached UNCACHED = new Uncached();

        @Child private LLVMExpressionNode target_;
        @Child private LLVMExpressionNode offset_;
        @Child private LLVMExpressionNode value_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVM80BitFloatOffsetStoreNode#doOp}
         *   2: SpecializationActive {@link LLVM80BitFloatOffsetStoreNode#doOpDerefHandle}
         *   3: SpecializationActive {@link LLVM80BitFloatOffsetStoreNode#doOpManaged}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVM80BitFloatOffsetStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child private LLVMDerefHandleGetReceiverNode opDerefHandle_getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVM80BitFloatOffsetStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child private LLVMManagedWriteLibrary opDerefHandle_nativeWrite_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVM80BitFloatOffsetStoreNode#doOpManaged}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child private LLVMManagedWriteLibrary opManaged_nativeWrite_;

        private LLVM80BitFloatOffsetStoreNodeGen(LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            this.target_ = target;
            this.offset_ = offset;
            this.value_ = value;
        }

        @Override
        public void executeWithTargetGeneric(LLVMPointer targetValue, long offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue);
                return;
            }
            if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM80BitFloat)] || SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM80BitFloat, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat valueValue_ = (LLVM80BitFloat) valueValue;
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM80BitFloat)] || SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM80BitFloat)] */) {
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue_);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandle_nativeWrite_;
                                if (nativeWrite__ != null) {
                                    if ((isAutoDerefHandle(targetValue_))) {
                                        LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue_, getReceiver__, nativeWrite__);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM80BitFloat, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    {
                        LLVMManagedWriteLibrary nativeWrite__1 = this.opManaged_nativeWrite_;
                        if (nativeWrite__1 != null) {
                            LLVM80BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, nativeWrite__1);
                            return;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue);
            return;
        }

        @Override
        public void executeWithTarget(LLVMPointer targetValue, long offsetValue, LLVM80BitFloat valueValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue);
                return;
            }
            if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM80BitFloat)] || SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM80BitFloat, LLVMManagedWriteLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM80BitFloat)] || SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM80BitFloat)] */) {
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandle_nativeWrite_;
                                if (nativeWrite__ != null) {
                                    if ((isAutoDerefHandle(targetValue_))) {
                                        LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue, getReceiver__, nativeWrite__);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM80BitFloat, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    {
                        LLVMManagedWriteLibrary nativeWrite__1 = this.opManaged_nativeWrite_;
                        if (nativeWrite__1 != null) {
                            LLVM80BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue, nativeWrite__1);
                            return;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue);
            return;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
            int state_0 = this.state_0_;
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue_);
                return;
            }
            if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM80BitFloat)] || SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM80BitFloat, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat valueValue__ = (LLVM80BitFloat) valueValue_;
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM80BitFloat)] || SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM80BitFloat)] */) {
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue__);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandle_nativeWrite_;
                                if (nativeWrite__ != null) {
                                    if ((isAutoDerefHandle(targetValue_))) {
                                        LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue__, getReceiver__, nativeWrite__);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM80BitFloat, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    {
                        LLVMManagedWriteLibrary nativeWrite__1 = this.opManaged_nativeWrite_;
                        if (nativeWrite__1 != null) {
                            LLVM80BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue__, nativeWrite__1);
                            return;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue_);
            return;
        }

        private void executeAndSpecialize(Object targetValue, Object offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (offsetValue instanceof Long) {
                long offsetValue_ = (long) offsetValue;
                if (valueValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat valueValue_ = (LLVM80BitFloat) valueValue;
                    if (LLVMTypes.isNativePointer(targetValue)) {
                        LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM80BitFloat)] */;
                            this.state_0_ = state_0;
                            doOp(targetValue_, offsetValue_, valueValue_);
                            return;
                        }
                        if ((isAutoDerefHandle(targetValue_))) {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                            Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            VarHandle.storeStoreFence();
                            this.opDerefHandle_getReceiver_ = getReceiver__;
                            LLVMManagedWriteLibrary nativeWrite__ = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                            Objects.requireNonNull(nativeWrite__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            VarHandle.storeStoreFence();
                            this.opDerefHandle_nativeWrite_ = nativeWrite__;
                            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue_, valueValue_, getReceiver__, nativeWrite__);
                            return;
                        }
                    }
                    if (LLVMTypes.isManagedPointer(targetValue)) {
                        LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                        LLVMManagedWriteLibrary nativeWrite__1 = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                        Objects.requireNonNull(nativeWrite__1, "Specialization 'doOpManaged(LLVMManagedPointer, long, LLVM80BitFloat, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.opManaged_nativeWrite_ = nativeWrite__1;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVM80BitFloat, LLVMManagedWriteLibrary)] */;
                        this.state_0_ = state_0;
                        LLVM80BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue_, valueValue_, nativeWrite__1);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.target_, this.offset_, this.value_}, targetValue, offsetValue, valueValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1110) & ((state_0 & 0b1110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOp(LLVMNativePointer, long, LLVM80BitFloat)] */;
            }
            {
                LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.opDerefHandle_getReceiver_ = getReceiver__;
                LLVMManagedWriteLibrary nativeWrite__ = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeWrite__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.opDerefHandle_nativeWrite_ = nativeWrite__;
                assert NodeUtil.assertRecursion(this.opDerefHandle_getReceiver_, 1);
                ((GenerateAOT.Provider) this.opDerefHandle_getReceiver_).prepareForAOT(language, root);
                if (this.opDerefHandle_nativeWrite_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.opDerefHandle_nativeWrite_, 1);
                    ((GenerateAOT.Provider) this.opDerefHandle_nativeWrite_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVM80BitFloat, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.opDerefHandle_getReceiver_ = null;
            this.opDerefHandle_nativeWrite_ = null;
        }

        @NeverDefault
        public static LLVM80BitFloatOffsetStoreNode create(LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            return new LLVM80BitFloatOffsetStoreNodeGen(target, offset, value);
        }

        @NeverDefault
        public static LLVM80BitFloatOffsetStoreNode getUncached() {
            return LLVM80BitFloatOffsetStoreNodeGen.UNCACHED;
        }

        @GeneratedBy(LLVM80BitFloatOffsetStoreNode.class)
        @DenyReplace
        private static final class Uncached extends LLVM80BitFloatOffsetStoreNode {

            @TruffleBoundary
            @Override
            public void executeWithTargetGeneric(LLVMPointer targetValue, long offsetValue, Object valueValue) {
                if (valueValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat valueValue_ = (LLVM80BitFloat) valueValue;
                    if (LLVMTypes.isNativePointer(targetValue)) {
                        LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue_);
                            return;
                        }
                        if ((isAutoDerefHandle(targetValue_))) {
                            LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue_, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                            return;
                        }
                    }
                    if (LLVMTypes.isManagedPointer(targetValue)) {
                        LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                        LLVM80BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, targetValue, offsetValue, valueValue);
            }

            @TruffleBoundary
            @Override
            public void executeWithTarget(LLVMPointer targetValue, long offsetValue, LLVM80BitFloat valueValue) {
                if (LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((!(isAutoDerefHandle(targetValue_)))) {
                        doOp(targetValue_, offsetValue, valueValue);
                        return;
                    }
                    if ((isAutoDerefHandle(targetValue_))) {
                        LLVM80BitFloatOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                        return;
                    }
                }
                if (LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    LLVM80BitFloatOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue, (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, targetValue, offsetValue, valueValue);
            }

            @Override
            public void executeWithTarget(VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
                throw CompilerDirectives.shouldNotReachHere("This execute method cannot be used for uncached node versions as it requires child nodes to be present. Use an execute method that takes all arguments as parameters.");
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
