// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMVectorUnaryNode#doI1}
 *     Activation probability: 0.23929
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMVectorUnaryNode#doI8}
 *     Activation probability: 0.20714
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMVectorUnaryNode#doI16}
 *     Activation probability: 0.17500
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMVectorUnaryNode#doI32}
 *     Activation probability: 0.14286
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMVectorUnaryNode#doI64}
 *     Activation probability: 0.11071
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMVectorUnaryNode#doFloat}
 *     Activation probability: 0.07857
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMVectorUnaryNode#doDouble}
 *     Activation probability: 0.04643
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMVectorUnaryNode.class)
@SuppressWarnings("javadoc")
public final class LLVMVectorUnaryNodeGen extends LLVMVectorUnaryNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode operandNode_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMVectorUnaryNode#doI1}
     *   2: SpecializationActive {@link LLVMVectorUnaryNode#doI8}
     *   3: SpecializationActive {@link LLVMVectorUnaryNode#doI16}
     *   4: SpecializationActive {@link LLVMVectorUnaryNode#doI32}
     *   5: SpecializationActive {@link LLVMVectorUnaryNode#doI64}
     *   6: SpecializationActive {@link LLVMVectorUnaryNode#doFloat}
     *   7: SpecializationActive {@link LLVMVectorUnaryNode#doDouble}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMVectorUnaryNodeGen(int vectorLength, LLVMUnaryNode unaryNode, LLVMExpressionNode operandNode) {
        super(vectorLength, unaryNode);
        this.operandNode_ = operandNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object operandNodeValue_ = this.operandNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(operandNodeValue_);
        }
        if ((state_0 & 0b11111110) != 0 /* is SpecializationActive[LLVMVectorUnaryNode.doI1(LLVMI1Vector)] || SpecializationActive[LLVMVectorUnaryNode.doI8(LLVMI8Vector)] || SpecializationActive[LLVMVectorUnaryNode.doI16(LLVMI16Vector)] || SpecializationActive[LLVMVectorUnaryNode.doI32(LLVMI32Vector)] || SpecializationActive[LLVMVectorUnaryNode.doI64(LLVMI64Vector)] || SpecializationActive[LLVMVectorUnaryNode.doFloat(LLVMFloatVector)] || SpecializationActive[LLVMVectorUnaryNode.doDouble(LLVMDoubleVector)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorUnaryNode.doI1(LLVMI1Vector)] */ && operandNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector operandNodeValue__ = (LLVMI1Vector) operandNodeValue_;
                return doI1(operandNodeValue__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMVectorUnaryNode.doI8(LLVMI8Vector)] */ && operandNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector operandNodeValue__ = (LLVMI8Vector) operandNodeValue_;
                return doI8(operandNodeValue__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMVectorUnaryNode.doI16(LLVMI16Vector)] */ && operandNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector operandNodeValue__ = (LLVMI16Vector) operandNodeValue_;
                return doI16(operandNodeValue__);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMVectorUnaryNode.doI32(LLVMI32Vector)] */ && operandNodeValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector operandNodeValue__ = (LLVMI32Vector) operandNodeValue_;
                return doI32(operandNodeValue__);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMVectorUnaryNode.doI64(LLVMI64Vector)] */ && operandNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector operandNodeValue__ = (LLVMI64Vector) operandNodeValue_;
                return doI64(operandNodeValue__);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMVectorUnaryNode.doFloat(LLVMFloatVector)] */ && operandNodeValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector operandNodeValue__ = (LLVMFloatVector) operandNodeValue_;
                return doFloat(operandNodeValue__);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMVectorUnaryNode.doDouble(LLVMDoubleVector)] */ && operandNodeValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector operandNodeValue__ = (LLVMDoubleVector) operandNodeValue_;
                return doDouble(operandNodeValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue_);
    }

    private LLVMVector executeAndSpecialize(Object operandNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (operandNodeValue instanceof LLVMI1Vector) {
            LLVMI1Vector operandNodeValue_ = (LLVMI1Vector) operandNodeValue;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMVectorUnaryNode.doI1(LLVMI1Vector)] */;
            this.state_0_ = state_0;
            return doI1(operandNodeValue_);
        }
        if (operandNodeValue instanceof LLVMI8Vector) {
            LLVMI8Vector operandNodeValue_ = (LLVMI8Vector) operandNodeValue;
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMVectorUnaryNode.doI8(LLVMI8Vector)] */;
            this.state_0_ = state_0;
            return doI8(operandNodeValue_);
        }
        if (operandNodeValue instanceof LLVMI16Vector) {
            LLVMI16Vector operandNodeValue_ = (LLVMI16Vector) operandNodeValue;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMVectorUnaryNode.doI16(LLVMI16Vector)] */;
            this.state_0_ = state_0;
            return doI16(operandNodeValue_);
        }
        if (operandNodeValue instanceof LLVMI32Vector) {
            LLVMI32Vector operandNodeValue_ = (LLVMI32Vector) operandNodeValue;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMVectorUnaryNode.doI32(LLVMI32Vector)] */;
            this.state_0_ = state_0;
            return doI32(operandNodeValue_);
        }
        if (operandNodeValue instanceof LLVMI64Vector) {
            LLVMI64Vector operandNodeValue_ = (LLVMI64Vector) operandNodeValue;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMVectorUnaryNode.doI64(LLVMI64Vector)] */;
            this.state_0_ = state_0;
            return doI64(operandNodeValue_);
        }
        if (operandNodeValue instanceof LLVMFloatVector) {
            LLVMFloatVector operandNodeValue_ = (LLVMFloatVector) operandNodeValue;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMVectorUnaryNode.doFloat(LLVMFloatVector)] */;
            this.state_0_ = state_0;
            return doFloat(operandNodeValue_);
        }
        if (operandNodeValue instanceof LLVMDoubleVector) {
            LLVMDoubleVector operandNodeValue_ = (LLVMDoubleVector) operandNodeValue;
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMVectorUnaryNode.doDouble(LLVMDoubleVector)] */;
            this.state_0_ = state_0;
            return doDouble(operandNodeValue_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.operandNode_}, operandNodeValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11111110) & ((state_0 & 0b11111110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMVectorUnaryNode.doI1(LLVMI1Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMVectorUnaryNode.doI8(LLVMI8Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMVectorUnaryNode.doI16(LLVMI16Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMVectorUnaryNode.doI32(LLVMI32Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMVectorUnaryNode.doI64(LLVMI64Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMVectorUnaryNode.doFloat(LLVMFloatVector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMVectorUnaryNode.doDouble(LLVMDoubleVector)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMVectorUnaryNode create(int vectorLength, LLVMUnaryNode unaryNode, LLVMExpressionNode operandNode) {
        return new LLVMVectorUnaryNodeGen(vectorLength, unaryNode, operandNode);
    }

}
