// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.pointer.ManagedPointerLibraries.ForeignIdentityHashNode;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(ManagedPointerLibraries.class)
@SuppressWarnings({"javadoc", "unused"})
final class ManagedPointerLibrariesFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignIdentityHashNode#doUnchecked}
     *     Activation probability: 0.38500
     *     With/without class size: 13/4 bytes
     *   Specialization {@link ForeignIdentityHashNode#doNoIdentity}
     *     Activation probability: 0.29500
     *     With/without class size: 11/4 bytes
     *   Specialization {@link ForeignIdentityHashNode#doChecked}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link ForeignIdentityHashNode#doChecked}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(ForeignIdentityHashNode.class)
    @SuppressWarnings("javadoc")
    static final class ForeignIdentityHashNodeGen extends ForeignIdentityHashNode implements GenerateAOT.Provider {

        static final ReferenceField<UncheckedData> UNCHECKED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "unchecked_cache", UncheckedData.class);
        static final ReferenceField<NoIdentityData> NO_IDENTITY_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "noIdentity_cache", NoIdentityData.class);
        static final ReferenceField<Checked0Data> CHECKED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "checked0_cache", Checked0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignIdentityHashNode#doUnchecked}
         *   2: SpecializationExcluded {@link ForeignIdentityHashNode#doUnchecked}
         *   3: SpecializationActive {@link ForeignIdentityHashNode#doNoIdentity}
         *   4: SpecializationActive {@link ForeignIdentityHashNode#doChecked}
         *   5: SpecializationActive {@link ForeignIdentityHashNode#doChecked}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private UncheckedData unchecked_cache;
        @UnsafeAccessedField @Child private NoIdentityData noIdentity_cache;
        @UnsafeAccessedField @Child private Checked0Data checked0_cache;

        private ForeignIdentityHashNodeGen() {
        }

        @ExplodeLoop
        @Override
        int execute(Object arg0Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value);
            }
            if ((state_0 & 0b111010) != 0 /* is SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doUnchecked(Object, InteropLibrary)] || SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doNoIdentity(Object, InteropLibrary)] || SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doChecked(Object, InteropLibrary)] || SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doChecked(Object, InteropLibrary)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doUnchecked(Object, InteropLibrary)] */) {
                    UncheckedData s0_ = this.unchecked_cache;
                    while (s0_ != null) {
                        if ((s0_.interop_.accepts(arg0Value))) {
                            try {
                                return doUnchecked(arg0Value, s0_.interop_);
                            } catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doUnchecked(Object, InteropLibrary)] */;
                                state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.unchecked_cache = null;
                                return executeAndSpecialize(arg0Value);
                            }
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doNoIdentity(Object, InteropLibrary)] */) {
                    NoIdentityData s1_ = this.noIdentity_cache;
                    while (s1_ != null) {
                        if ((s1_.interop_.accepts(arg0Value)) && (!(s1_.interop_.hasIdentity(arg0Value)))) {
                            return doNoIdentity(arg0Value, s1_.interop_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doChecked(Object, InteropLibrary)] */) {
                    Checked0Data s2_ = this.checked0_cache;
                    while (s2_ != null) {
                        if ((s2_.interop_.accepts(arg0Value))) {
                            return doChecked(arg0Value, s2_.interop_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doChecked(Object, InteropLibrary)] */) {
                    return this.checked1Boundary(state_0, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private int checked1Boundary(int state_0, Object arg0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return doChecked(arg0Value, interop__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("unused")
        private int executeAndSpecialize(Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (((state_0 & 0b111000)) == 0 /* is-not SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doNoIdentity(Object, InteropLibrary)] && SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doChecked(Object, InteropLibrary)] && SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doChecked(Object, InteropLibrary)] */ && ((state_0 & 0b100)) == 0 /* is-not SpecializationExcluded  */) {
                while (true) {
                    int count0_ = 0;
                    UncheckedData s0_ = UNCHECKED_CACHE_UPDATER.getVolatile(this);
                    UncheckedData s0_original = s0_;
                    while (s0_ != null) {
                        if ((s0_.interop_.accepts(arg0Value))) {
                            break;
                        }
                        count0_++;
                        s0_ = s0_.next_;
                    }
                    if (s0_ == null) {
                        // assert (s0_.interop_.accepts(arg0Value));
                        if (count0_ < (3)) {
                            s0_ = this.insert(new UncheckedData(s0_original));
                            InteropLibrary interop__1 = s0_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            Objects.requireNonNull(interop__1, "Specialization 'doUnchecked(Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s0_.interop_ = interop__1;
                            if (!UNCHECKED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doUnchecked(Object, InteropLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s0_ != null) {
                        try {
                            return doUnchecked(arg0Value, s0_.interop_);
                        } catch (UnsupportedMessageException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doUnchecked(Object, InteropLibrary)] */;
                            state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.unchecked_cache = null;
                            return executeAndSpecialize(arg0Value);
                        }
                    }
                    break;
                }
            }
            if (((state_0 & 0b110000)) == 0 /* is-not SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doChecked(Object, InteropLibrary)] && SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doChecked(Object, InteropLibrary)] */) {
                while (true) {
                    int count1_ = 0;
                    NoIdentityData s1_ = NO_IDENTITY_CACHE_UPDATER.getVolatile(this);
                    NoIdentityData s1_original = s1_;
                    while (s1_ != null) {
                        if ((s1_.interop_.accepts(arg0Value)) && (!(s1_.interop_.hasIdentity(arg0Value)))) {
                            break;
                        }
                        count1_++;
                        s1_ = s1_.next_;
                    }
                    if (s1_ == null) {
                        {
                            InteropLibrary interop__2 = this.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            // assert (s1_.interop_.accepts(arg0Value));
                            if ((!(interop__2.hasIdentity(arg0Value))) && count1_ < (3)) {
                                s1_ = this.insert(new NoIdentityData(s1_original));
                                Objects.requireNonNull(s1_.insert(interop__2), "Specialization 'doNoIdentity(Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s1_.interop_ = interop__2;
                                if (!NO_IDENTITY_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                    continue;
                                }
                                this.unchecked_cache = null;
                                state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doUnchecked(Object, InteropLibrary)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doNoIdentity(Object, InteropLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                    if (s1_ != null) {
                        return doNoIdentity(arg0Value, s1_.interop_);
                    }
                    break;
                }
            }
            if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doChecked(Object, InteropLibrary)] */) {
                while (true) {
                    int count2_ = 0;
                    Checked0Data s2_ = CHECKED0_CACHE_UPDATER.getVolatile(this);
                    Checked0Data s2_original = s2_;
                    while (s2_ != null) {
                        if ((s2_.interop_.accepts(arg0Value))) {
                            break;
                        }
                        count2_++;
                        s2_ = s2_.next_;
                    }
                    if (s2_ == null) {
                        // assert (s2_.interop_.accepts(arg0Value));
                        if (count2_ < (3)) {
                            s2_ = this.insert(new Checked0Data(s2_original));
                            InteropLibrary interop__ = s2_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            Objects.requireNonNull(interop__, "Specialization 'doChecked(Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s2_.interop_ = interop__;
                            if (!CHECKED0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                continue;
                            }
                            this.unchecked_cache = null;
                            this.noIdentity_cache = null;
                            state_0 = state_0 & 0xfffffff5 /* remove SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doUnchecked(Object, InteropLibrary)], SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doNoIdentity(Object, InteropLibrary)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doChecked(Object, InteropLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s2_ != null) {
                        return doChecked(arg0Value, s2_.interop_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__ = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        interop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                        this.unchecked_cache = null;
                        this.noIdentity_cache = null;
                        this.checked0_cache = null;
                        state_0 = state_0 & 0xffffffe5 /* remove SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doUnchecked(Object, InteropLibrary)], SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doNoIdentity(Object, InteropLibrary)], SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doChecked(Object, InteropLibrary)] */;
                        state_0 = state_0 | 0b100000 /* add SpecializationActive[ManagedPointerLibraries.ForeignIdentityHashNode.doChecked(Object, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doChecked(arg0Value, interop__);
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111010) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b111010) & ((state_0 & 0b111010) - 1)) == 0 /* is-single  */) {
                    UncheckedData s0_ = this.unchecked_cache;
                    NoIdentityData s1_ = this.noIdentity_cache;
                    Checked0Data s2_ = this.checked0_cache;
                    if ((s0_ == null || s0_.next_ == null) && (s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ForeignIdentityHashNode create() {
            return new ForeignIdentityHashNodeGen();
        }

        @NeverDefault
        public static ForeignIdentityHashNode getUncached() {
            return ForeignIdentityHashNodeGen.UNCACHED;
        }

        @GeneratedBy(ForeignIdentityHashNode.class)
        @DenyReplace
        private static final class UncheckedData extends Node implements SpecializationDataNode {

            @Child UncheckedData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignIdentityHashNode#doUnchecked}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            UncheckedData(UncheckedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignIdentityHashNode.class)
        @DenyReplace
        private static final class NoIdentityData extends Node implements SpecializationDataNode {

            @Child NoIdentityData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignIdentityHashNode#doNoIdentity}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            NoIdentityData(NoIdentityData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignIdentityHashNode.class)
        @DenyReplace
        private static final class Checked0Data extends Node implements SpecializationDataNode {

            @Child Checked0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignIdentityHashNode#doChecked}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            Checked0Data(Checked0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignIdentityHashNode.class)
        @DenyReplace
        private static final class Uncached extends ForeignIdentityHashNode {

            @TruffleBoundary
            @Override
            int execute(Object arg0Value) {
                return doChecked(arg0Value, (INTEROP_LIBRARY_.getUncached(arg0Value)));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
