/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.initialization.AllocExternalSymbolNode;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMScopeChain;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMThreadLocalSymbol;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMDLOpen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.ArrayList;

public final class InitializeExternalNode
extends LLVMNode {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMFunction[] functions;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMGlobal[] globals;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMThreadLocalSymbol[] threadLocals;
    @Node.Child
    private AllocExternalSymbolNode allocExternalSymbol;

    public InitializeExternalNode(LLVMParserResult result) {
        this.allocExternalSymbol = new AllocExternalSymbolNode(result);
        LLVMScope fileScope = result.getRuntime().getFileScope();
        ArrayList<LLVMFunction> functionList = new ArrayList<LLVMFunction>();
        ArrayList<LLVMGlobal> globalList = new ArrayList<LLVMGlobal>();
        ArrayList<LLVMThreadLocalSymbol> threadLocalList = new ArrayList<LLVMThreadLocalSymbol>();
        for (FunctionSymbol functionSymbol : result.getExternalFunctions()) {
            String name = functionSymbol.getName();
            LLVMFunction function = fileScope.getFunction(name);
            if (name.startsWith("llvm.") || name.startsWith("__builtin_") || name.equals("polyglot_get_arg") || name.equals("polyglot_get_arg_count")) continue;
            functionList.add(function);
        }
        for (GlobalVariable globalVariable : result.getExternalGlobals()) {
            if (globalVariable.isThreadLocal()) {
                threadLocalList.add(fileScope.getThreadLocalVariable(globalVariable.getName()));
                continue;
            }
            globalList.add(fileScope.getGlobalVariable(globalVariable.getName()));
        }
        this.functions = functionList.toArray(LLVMFunction.EMPTY);
        this.globals = globalList.toArray(LLVMGlobal.EMPTY);
        this.threadLocals = threadLocalList.toArray(LLVMThreadLocalSymbol.EMPTY);
    }

    public void execute(LLVMContext context, LLVMScopeChain localScope, LLVMDLOpen.RTLDFlags rtldFlags) {
        LLVMPointer pointer;
        LLVMScopeChain globalScope = context.getGlobalScopeChain();
        LLVMIntrinsicProvider intrinsicProvider = this.getLanguage().getCapability(LLVMIntrinsicProvider.class);
        NativeContextExtension nativeContextExtension = InitializeExternalNode.getNativeContextExtension(context);
        for (LLVMGlobal lLVMGlobal : this.globals) {
            pointer = this.allocExternalSymbol.execute(localScope, globalScope, nativeContextExtension, context, rtldFlags, lLVMGlobal);
            if (pointer == null) continue;
            context.initializeSymbol(lLVMGlobal, pointer);
        }
        for (LLVMSymbol lLVMSymbol : this.threadLocals) {
            pointer = this.allocExternalSymbol.execute(localScope, globalScope, context, rtldFlags, (LLVMThreadLocalSymbol)lLVMSymbol);
            if (pointer == null) continue;
            context.initializeSymbol(lLVMSymbol, pointer);
        }
        for (LLVMSymbol lLVMSymbol : this.functions) {
            pointer = this.allocExternalSymbol.execute(localScope, globalScope, intrinsicProvider, nativeContextExtension, context, rtldFlags, (LLVMFunction)lLVMSymbol);
            if (pointer == null) continue;
            context.initializeSymbol(lLVMSymbol, pointer);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static NativeContextExtension getNativeContextExtension(LLVMContext context) {
        return context.getContextExtensionOrNull(NativeContextExtension.class);
    }
}

