/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.initialization.DataSectionFactory;
import com.oracle.truffle.llvm.initialization.InitializeExternalNode;
import com.oracle.truffle.llvm.initialization.InitializeGlobalNode;
import com.oracle.truffle.llvm.initialization.InitializeModuleNode;
import com.oracle.truffle.llvm.initialization.InitializeOverwriteNode;
import com.oracle.truffle.llvm.initialization.InitializeSymbolsNode;
import com.oracle.truffle.llvm.initialization.LoadDependencyNode;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMScopeChain;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMUnsupportedException;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.SulongLibrary;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRootNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMDLOpen;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public final class LoadModulesNode
extends LLVMRootNode {
    private static final String MAIN_METHOD_NAME = "main";
    @CompilerDirectives.CompilationFinal
    RootCallTarget mainFunctionCallTarget = null;
    final String libraryName;
    final IDGenerater.BitcodeID bitcodeID;
    final Source source;
    @Node.Child
    LLVMStatementNode initContext;
    @Node.Child
    InitializeSymbolsNode initSymbols;
    @Node.Child
    InitializeExternalNode initExternals;
    @Node.Child
    InitializeGlobalNode initGlobals;
    @Node.Child
    InitializeOverwriteNode initOverwrite;
    @Node.Child
    InitializeModuleNode initModules;
    @Node.Child
    IndirectCallNode indirectCall;
    @Node.Child
    IndirectCallNode callDependencies;
    @Node.Children
    final LoadDependencyNode[] libraryDependencies;
    final LLVMParserRuntime parserRuntime;
    final LLVMLanguage language;
    private boolean hasInitialised;
    @CompilerDirectives.CompilationFinal
    private SulongLibrary.CachedMainFunction main;

    private LoadModulesNode(String name, LLVMParserResult parserResult, boolean isInternalSulongLibrary, FrameDescriptor rootFrame, boolean lazyParsing, List<LoadDependencyNode> libraryDependencies, Source source, LLVMLanguage language) throws Type.TypeOverflowException {
        super(language, rootFrame, parserResult.getRuntime().getNodeFactory().createStackAccess());
        this.libraryName = name;
        this.source = source;
        this.bitcodeID = parserResult.getRuntime().getBitcodeID();
        this.parserRuntime = parserResult.getRuntime();
        this.libraryDependencies = libraryDependencies.toArray(LoadDependencyNode.EMPTY);
        this.language = language;
        this.hasInitialised = false;
        this.initContext = null;
        DataSectionFactory dataSectionFactory = new DataSectionFactory(parserResult);
        this.initSymbols = new InitializeSymbolsNode(parserResult, lazyParsing, isInternalSulongLibrary, this.libraryName, dataSectionFactory, language);
        this.initExternals = new InitializeExternalNode(parserResult);
        this.initGlobals = new InitializeGlobalNode(parserResult, this.libraryName, dataSectionFactory);
        this.initOverwrite = new InitializeOverwriteNode(parserResult);
        this.initModules = new InitializeModuleNode(language, parserResult, this.libraryName);
        this.indirectCall = IndirectCallNode.create();
        this.callDependencies = IndirectCallNode.create();
    }

    @Override
    public String getName() {
        return "<" + ((Object)((Object)this)).getClass().getSimpleName() + "/" + this.libraryName + "/" + this.bitcodeID.getId() + ">";
    }

    public SourceSection getSourceSection() {
        return this.source.createUnavailableSection();
    }

    public static LoadModulesNode create(String soName, LLVMParserResult parserResult, boolean lazyParsing, boolean isInternalSulongLibrary, List<LoadDependencyNode> libraryDependencies, Source source, LLVMLanguage language) {
        try {
            FrameDescriptor.Builder builder = FrameDescriptor.newBuilder();
            int stackId = builder.addSlot(FrameSlotKind.Object, null, null);
            assert (stackId == 0);
            int uniquesRegionId = builder.addSlot(FrameSlotKind.Object, null, null);
            assert (uniquesRegionId == 1);
            int basePointerId = builder.addSlot(FrameSlotKind.Long, null, null);
            assert (basePointerId == 2);
            return new LoadModulesNode(soName, parserResult, isInternalSulongLibrary, builder.build(), lazyParsing, libraryDependencies, source, language);
        }
        catch (Type.TypeOverflowException e) {
            throw new LLVMUnsupportedException(null, LLVMUnsupportedException.UnsupportedReason.UNSUPPORTED_VALUE_RANGE, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(VirtualFrame frame) {
        LLVMContext context;
        LLVMContext lLVMContext = context = this.getContext();
        synchronized (lLVMContext) {
            if (!this.hasInitialised) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                LLVMFunction mainFunction = this.findMainFunction();
                this.main = mainFunction != null ? new SulongLibrary.CachedMainFunction(mainFunction) : null;
                this.initContext = (LLVMStatementNode)this.insert(this.language.createInitializeContextNode());
                this.hasInitialised = true;
            }
            LLVMScopeChain firstScopeChain = this.loadModule(frame, context);
            context.addCalltargetForLoadedLibrary(this.libraryName, (CallTarget)this.getCallTarget());
            if (firstScopeChain != null) {
                SulongLibrary library = new SulongLibrary(this.libraryName, firstScopeChain, this.main, context, this.parserRuntime.getLocator(), this.parserRuntime.getBitcodeID());
                if (this.main != null) {
                    context.setMainLibrary(library);
                }
                return library;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLVMScopeChain loadModule(VirtualFrame frame, LLVMContext context) {
        this.stackAccess.executeEnter(frame, this.getContext().getThreadingStack().getStack((Node)this));
        try {
            int id2;
            LLVMLoadingPhase phase;
            LLVMScopeChain headLocalScopeChain = null;
            LLVMScopeChain tailLocalScopeChain = null;
            BitSet visited = null;
            ArrayDeque que = null;
            ArrayList<CallTarget> dependencies = null;
            LLVMScopeChain headResultScopeChain = null;
            LLVMScopeChain tailResultScopeChain = null;
            LLVMDLOpen.RTLDFlags localOrGlobal = LLVMDLOpen.RTLDFlags.RTLD_OPEN_DEFAULT;
            if (frame.getArguments().length > 0 && frame.getArguments()[0] instanceof LLVMDLOpen.RTLDFlags) {
                localOrGlobal = (LLVMDLOpen.RTLDFlags)((Object)frame.getArguments()[0]);
            }
            if (frame.getArguments().length > 0 && frame.getArguments()[0] instanceof LLVMLoadingPhase) {
                phase = (LLVMLoadingPhase)((Object)frame.getArguments()[0]);
                if (phase == LLVMLoadingPhase.BUILD_SCOPES || phase == LLVMLoadingPhase.BUILD_DEPENDENCY) {
                    visited = (BitSet)frame.getArguments()[1];
                }
                if (phase == LLVMLoadingPhase.INIT_EXTERNALS || phase == LLVMLoadingPhase.INIT_OVERWRITE) {
                    localOrGlobal = (LLVMDLOpen.RTLDFlags)((Object)frame.getArguments()[1]);
                    headLocalScopeChain = (LLVMScopeChain)frame.getArguments()[2];
                }
                if (phase == LLVMLoadingPhase.BUILD_SCOPES) {
                    localOrGlobal = (LLVMDLOpen.RTLDFlags)((Object)frame.getArguments()[2]);
                }
                if (phase == LLVMLoadingPhase.BUILD_DEPENDENCY) {
                    dependencies = (ArrayList<CallTarget>)frame.getArguments()[2];
                }
                if (phase == LLVMLoadingPhase.BUILD_SCOPES) {
                    tailLocalScopeChain = (LLVMScopeChain)frame.getArguments()[3];
                    que = (ArrayDeque)frame.getArguments()[4];
                    tailResultScopeChain = (LLVMScopeChain)frame.getArguments()[5];
                }
            } else if (frame.getArguments().length == 0 || !(frame.getArguments()[0] instanceof LLVMLoadingPhase)) {
                phase = LLVMLoadingPhase.ALL;
                tailResultScopeChain = headResultScopeChain = new LLVMScopeChain(this.bitcodeID, this.parserRuntime.getFileScope());
                tailLocalScopeChain = headLocalScopeChain = new LLVMScopeChain(this.bitcodeID, this.parserRuntime.getPublicFileScope());
                visited = LoadModulesNode.createBitset(this.libraryDependencies.length);
                que = new ArrayDeque();
                dependencies = new ArrayList<CallTarget>();
            } else {
                throw new LLVMParserException("LoadModulesNode is called with unexpected arguments");
            }
            if (LLVMLoadingPhase.BUILD_SCOPES.isActive(phase) && !visited.get(id2 = this.bitcodeID.getId())) {
                visited.set(id2);
                if (LLVMLoadingPhase.ALL.isActive(phase)) {
                    context.addGlobalScope(new LLVMScopeChain(this.bitcodeID, this.parserRuntime.getPublicFileScope()));
                } else {
                    LLVMScopeChain currentLocalScopeChain = new LLVMScopeChain(this.bitcodeID, this.parserRuntime.getPublicFileScope());
                    LLVMScopeChain currentResultScopeChain = new LLVMScopeChain(this.bitcodeID, this.parserRuntime.getFileScope());
                    if (LLVMDLOpen.RTLDFlags.RTLD_OPEN_DEFAULT.isActive(localOrGlobal)) {
                        context.addGlobalScope(new LLVMScopeChain(this.bitcodeID, this.parserRuntime.getPublicFileScope()));
                        tailLocalScopeChain.concatNextChain(currentLocalScopeChain);
                        tailResultScopeChain.concatNextChain(currentResultScopeChain);
                    } else if (LLVMDLOpen.RTLDFlags.RTLD_LOCAL.isActive(localOrGlobal)) {
                        tailLocalScopeChain.concatNextChain(currentLocalScopeChain);
                    } else if (LLVMDLOpen.RTLDFlags.RTLD_GLOBAL.isActive(localOrGlobal)) {
                        tailLocalScopeChain.concatNextChain(currentLocalScopeChain);
                        context.addGlobalScope(new LLVMScopeChain(this.bitcodeID, this.parserRuntime.getPublicFileScope()));
                    } else {
                        throw new LLVMParserException((Node)this, "Toplevel executable %s does not contain bitcode", new Object[0]);
                    }
                }
                for (int i = 0; i < this.libraryDependencies.length; ++i) {
                    CallTarget callTarget;
                    if (LibraryLocator.loggingEnabled()) {
                        LibraryLocator.traceStaticInits(context, "building scope", this.libraryDependencies[i].getLibraryName());
                    }
                    if ((callTarget = this.libraryDependencies[i].execute()) == null) continue;
                    LoadModulesNode.queAdd(que, callTarget);
                }
                if (LLVMLoadingPhase.ALL.isActive(phase)) {
                    while (!que.isEmpty()) {
                        while (tailLocalScopeChain != null && tailLocalScopeChain.getNext() != null) {
                            tailLocalScopeChain = tailLocalScopeChain.getNext();
                        }
                        while (tailResultScopeChain != null && tailResultScopeChain.getNext() != null) {
                            tailResultScopeChain = tailResultScopeChain.getNext();
                        }
                        this.indirectCall.call(LoadModulesNode.quePoll(que), new Object[]{LLVMLoadingPhase.BUILD_SCOPES, visited, localOrGlobal, tailLocalScopeChain, que, tailResultScopeChain});
                    }
                }
            }
            if (context.isLibraryAlreadyLoaded(this.bitcodeID)) {
                if (LLVMDLOpen.RTLDFlags.RTLD_OPEN_DEFAULT.isActive(localOrGlobal)) {
                    LLVMScopeChain id2 = headResultScopeChain;
                    return id2;
                }
                LLVMScopeChain id2 = headLocalScopeChain;
                return id2;
            }
            if (LLVMLoadingPhase.BUILD_DEPENDENCY.isActive(phase)) {
                if (LLVMLoadingPhase.ALL == phase) {
                    visited.clear();
                }
                if (!visited.get(id2 = this.bitcodeID.getId())) {
                    visited.set(id2);
                    for (LoadDependencyNode libraryDependency : this.libraryDependencies) {
                        CallTarget lib;
                        if (LibraryLocator.loggingEnabled()) {
                            LibraryLocator.traceStaticInits(context, "building library dependency", libraryDependency.getLibraryName());
                        }
                        if ((lib = libraryDependency.execute()) == null) continue;
                        this.callDependencies.call(lib, new Object[]{LLVMLoadingPhase.BUILD_DEPENDENCY, visited, dependencies});
                    }
                    dependencies.add((CallTarget)this.getCallTarget());
                }
            }
            switch (phase.ordinal()) {
                case 1: 
                case 2: {
                    break;
                }
                case 0: {
                    assert (dependencies != null);
                    this.executeInitialiseAllPhase(dependencies, localOrGlobal, headLocalScopeChain);
                    break;
                }
                case 3: {
                    this.executeInitialiseSymbolPhase(context);
                    break;
                }
                case 4: {
                    this.initExternals.execute(context, headLocalScopeChain, localOrGlobal);
                    break;
                }
                case 5: {
                    this.initGlobals.execute(frame, context.getReadOnlyGlobals(this.bitcodeID));
                    break;
                }
                case 8: {
                    this.initOverwrite.execute(context, headLocalScopeChain, localOrGlobal);
                    break;
                }
                case 7: {
                    this.initContext.execute(frame);
                    break;
                }
                case 6: {
                    this.initModules.execute(frame, context);
                    break;
                }
                case 9: {
                    context.markLibraryLoaded(this.bitcodeID);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere((String)"Unknown loading phase");
                }
            }
            if (LLVMLoadingPhase.ALL == phase) {
                if (LLVMDLOpen.RTLDFlags.RTLD_OPEN_DEFAULT.isActive(localOrGlobal)) {
                    LLVMScopeChain lLVMScopeChain = headResultScopeChain;
                    return lLVMScopeChain;
                }
                LLVMScopeChain lLVMScopeChain = headLocalScopeChain;
                return lLVMScopeChain;
            }
            LLVMScopeChain lLVMScopeChain = null;
            return lLVMScopeChain;
        }
        finally {
            this.stackAccess.executeExit(frame);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void executeInitialiseAllPhase(ArrayList<CallTarget> dependencies, LLVMDLOpen.RTLDFlags rtldFlags, LLVMScopeChain scopeChain) {
        assert (dependencies != null);
        for (CallTarget callTarget : dependencies) {
            this.callDependencies.call(callTarget, new Object[]{LLVMLoadingPhase.INIT_SYMBOLS});
        }
        for (CallTarget callTarget : dependencies) {
            this.callDependencies.call(callTarget, new Object[]{LLVMLoadingPhase.INIT_EXTERNALS, rtldFlags, scopeChain});
        }
        for (CallTarget callTarget : dependencies) {
            this.callDependencies.call(callTarget, new Object[]{LLVMLoadingPhase.INIT_GLOBALS});
        }
        for (CallTarget callTarget : dependencies) {
            this.callDependencies.call(callTarget, new Object[]{LLVMLoadingPhase.INIT_OVERWRITE, rtldFlags, scopeChain});
        }
        for (CallTarget callTarget : dependencies) {
            this.callDependencies.call(callTarget, new Object[]{LLVMLoadingPhase.INIT_CONTEXT});
        }
        for (CallTarget callTarget : dependencies) {
            this.callDependencies.call(callTarget, new Object[]{LLVMLoadingPhase.INIT_MODULE});
        }
        for (CallTarget callTarget : dependencies) {
            this.callDependencies.call(callTarget, new Object[]{LLVMLoadingPhase.INIT_DONE});
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void executeInitialiseSymbolPhase(LLVMContext context) {
        this.initSymbols.initializeSymbolTable(context);
        this.initSymbols.execute(context);
    }

    @CompilerDirectives.TruffleBoundary
    private static void queAdd(ArrayDeque<CallTarget> que, CallTarget callTarget) {
        que.add(callTarget);
    }

    @CompilerDirectives.TruffleBoundary
    private static CallTarget quePoll(ArrayDeque<CallTarget> que) {
        return que.poll();
    }

    @CompilerDirectives.TruffleBoundary
    private static BitSet createBitset(int length) {
        return new BitSet(length);
    }

    private LLVMFunction findMainFunction() {
        LLVMFunction mainFunction;
        LLVMScope fileScope = this.parserRuntime.getFileScope();
        LLVMSymbol mainSymbol = fileScope.get(MAIN_METHOD_NAME);
        if (mainSymbol != null && mainSymbol.isFunction() && ((mainFunction = mainSymbol.asFunction()).getFunction() instanceof LLVMFunctionCode.LLVMIRFunction || mainFunction.getFunction() instanceof LLVMFunctionCode.LazyLLVMIRFunction)) {
            return mainFunction;
        }
        return null;
    }

    protected static enum LLVMLoadingPhase {
        ALL,
        BUILD_SCOPES,
        BUILD_DEPENDENCY,
        INIT_SYMBOLS,
        INIT_EXTERNALS,
        INIT_GLOBALS,
        INIT_MODULE,
        INIT_CONTEXT,
        INIT_OVERWRITE,
        INIT_DONE;


        boolean isActive(LLVMLoadingPhase phase) {
            return phase == this || phase == ALL;
        }
    }
}

