/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.listeners;

import com.oracle.truffle.llvm.parser.listeners.ParserListener;
import com.oracle.truffle.llvm.parser.model.ModelModule;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.OpaqueType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VectorType;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class Types
implements ParserListener,
Iterable<Type> {
    private static final int TYPE_NUMBER_OF_ENTRIES = 1;
    private static final int TYPE_VOID = 2;
    private static final int TYPE_FLOAT = 3;
    private static final int TYPE_DOUBLE = 4;
    private static final int TYPE_LABEL = 5;
    private static final int TYPE_OPAQUE = 6;
    private static final int TYPE_INTEGER = 7;
    private static final int TYPE_POINTER = 8;
    private static final int TYPE_FUNCTION_OLD = 9;
    private static final int TYPE_HALF = 10;
    private static final int TYPE_ARRAY = 11;
    private static final int TYPE_VECTOR = 12;
    private static final int TYPE_X86_FP80 = 13;
    private static final int TYPE_FP128 = 14;
    private static final int TYPE_PPC_FP128 = 15;
    private static final int TYPE_METADATA = 16;
    private static final int TYPE_X86_MMX = 17;
    private static final int TYPE_STRUCT_ANON = 18;
    private static final int TYPE_STRUCT_NAME = 19;
    private static final int TYPE_STRUCT_NAMED = 20;
    private static final int TYPE_FUNCTION = 21;
    private static final int TYPE_TOKEN = 22;
    private static final int TYPE_OPAQUE_POINTER = 25;
    private final ModelModule module;
    private Type[] table = Type.EMPTY_ARRAY;
    private String structName = null;
    private int size = 0;

    Types(ModelModule module) {
        this.module = module;
    }

    @Override
    public Iterator<Type> iterator() {
        return Collections.unmodifiableList(Arrays.asList(this.table)).iterator();
    }

    @Override
    public void record(RecordBuffer buffer) {
        Type type;
        int id = buffer.getId();
        switch (id) {
            case 1: {
                this.table = new Type[buffer.readInt()];
                return;
            }
            case 2: {
                type = VoidType.INSTANCE;
                break;
            }
            case 3: {
                type = PrimitiveType.FLOAT;
                break;
            }
            case 4: {
                type = PrimitiveType.DOUBLE;
                break;
            }
            case 5: {
                type = MetaType.LABEL;
                break;
            }
            case 6: {
                if (this.structName != null) {
                    type = new OpaqueType(this.structName);
                    this.structName = null;
                    this.module.addGlobalType(type);
                    break;
                }
                type = new OpaqueType();
                break;
            }
            case 7: {
                type = Type.getIntegerType(buffer.readInt());
                break;
            }
            case 8: {
                PointerType pointerType = new PointerType(null);
                this.setType(buffer.readInt(), pointerType::setPointeeType);
                type = pointerType;
                break;
            }
            case 25: {
                type = PointerType.PTR;
                break;
            }
            case 9: {
                boolean isVarargs = buffer.readBoolean();
                buffer.skip();
                int index = buffer.readInt();
                int numArguments = buffer.remaining();
                FunctionType functionType = new FunctionType(null, numArguments, isVarargs ? numArguments : -1);
                this.setTypes(buffer, numArguments, functionType::setArgumentType);
                this.setType(index, functionType::setReturnType);
                type = functionType;
                break;
            }
            case 10: {
                type = PrimitiveType.HALF;
                break;
            }
            case 11: {
                ArrayType arrayType = new ArrayType(null, buffer.read());
                this.setType(buffer.readInt(), arrayType::setElementType);
                type = arrayType;
                break;
            }
            case 12: {
                VectorType vectorType = new VectorType(null, buffer.readInt());
                this.setType(buffer.readInt(), vectorType::setElementType);
                type = vectorType;
                break;
            }
            case 13: {
                type = PrimitiveType.X86_FP80;
                break;
            }
            case 14: {
                type = PrimitiveType.F128;
                break;
            }
            case 15: {
                type = PrimitiveType.PPC_FP128;
                break;
            }
            case 16: {
                type = MetaType.METADATA;
                break;
            }
            case 17: {
                type = MetaType.X86MMX;
                break;
            }
            case 19: {
                this.structName = buffer.readString();
                return;
            }
            case 18: 
            case 20: {
                StructureType structureType;
                boolean isPacked = buffer.readBoolean();
                int numMembers = buffer.remaining();
                if (this.structName != null) {
                    structureType = new StructureType(this.structName, isPacked, numMembers);
                    this.structName = null;
                    this.module.addGlobalType(structureType);
                } else {
                    structureType = new StructureType(isPacked, numMembers);
                }
                this.setTypes(buffer, numMembers, structureType::setElementType);
                type = structureType;
                break;
            }
            case 21: {
                boolean isVarargs = buffer.readBoolean();
                int index = buffer.readInt();
                int numArguments = buffer.remaining();
                FunctionType functionType = new FunctionType(null, numArguments, isVarargs ? numArguments : -1);
                this.setTypes(buffer, numArguments, functionType::setArgumentType);
                this.setType(index, functionType::setReturnType);
                type = functionType;
                break;
            }
            case 22: {
                type = MetaType.TOKEN;
                break;
            }
            default: {
                type = MetaType.UNKNOWN;
            }
        }
        if (this.table[this.size] != null) {
            ((UnresolvedType)this.table[this.size]).dependent.accept(type);
        }
        this.table[this.size++] = type;
    }

    private void setType(int typeIndex, Consumer<Type> typeFieldSetter) {
        if (typeIndex < this.size) {
            typeFieldSetter.accept(this.table[typeIndex]);
        } else if (this.table[typeIndex] == null) {
            this.table[typeIndex] = new UnresolvedType(typeFieldSetter);
        } else {
            ((UnresolvedType)this.table[typeIndex]).addDependent(typeFieldSetter);
        }
    }

    void setTypes(RecordBuffer buffer, int numTypes, BiConsumer<Integer, Type> indexSetter) {
        assert (numTypes == buffer.remaining());
        for (int i = 0; i < numTypes; ++i) {
            int typeIndex = buffer.readInt();
            if (typeIndex < this.size) {
                indexSetter.accept(i, this.table[typeIndex]);
                continue;
            }
            MemberDependent setter = new MemberDependent(i, indexSetter);
            if (this.table[typeIndex] == null) {
                this.table[typeIndex] = new UnresolvedType(setter);
                continue;
            }
            ((UnresolvedType)this.table[typeIndex]).addDependent(setter);
        }
    }

    public Type get(long index) {
        return this.table[(int)index];
    }

    public String toString() {
        return "Typetable (size: " + this.table.length + ", currentIndex: " + this.size + ")";
    }

    static AggregateType castToAggregate(Type type) {
        if (type instanceof AggregateType) {
            return (AggregateType)type;
        }
        throw new LLVMParserException("Expected AggregateType, but received: " + String.valueOf(type));
    }

    static FunctionType castToFunction(Type type) {
        if (type instanceof FunctionType) {
            return (FunctionType)type;
        }
        throw new LLVMParserException("Expected FunctionType, but received: " + String.valueOf(type));
    }

    static PointerType castToPointer(Type type) {
        if (type instanceof PointerType) {
            return (PointerType)type;
        }
        throw new LLVMParserException("Expected PointerType, but received: " + String.valueOf(type));
    }

    static VectorType castToVector(Type type) {
        if (type instanceof VectorType) {
            return (VectorType)type;
        }
        throw new LLVMParserException("Expected VectorType, but received: " + String.valueOf(type));
    }

    private static final class UnresolvedType
    extends Type {
        private Consumer<Type> dependent;

        UnresolvedType(Consumer<Type> dependent) {
            this.dependent = dependent;
        }

        private void addDependent(Consumer<Type> newDependent) {
            this.dependent = this.dependent.andThen(newDependent);
        }

        @Override
        public void accept(TypeVisitor visitor) {
            throw new LLVMParserException("Unresolved Forward-Referenced Type!");
        }

        @Override
        public long getBitSize() {
            throw new LLVMParserException("Unresolved Forward-Referenced Type!");
        }

        @Override
        public int getAlignment(DataLayout targetDataLayout) {
            throw new LLVMParserException("Unresolved Forward-Referenced Type!");
        }

        @Override
        public long getSize(DataLayout targetDataLayout) {
            throw new LLVMParserException("Unresolved Forward-Referenced Type!");
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public LLVMExpressionNode createNullConstant(NodeFactory nodeFactory, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
            throw new LLVMParserException("Unresolved Forward-Referenced Type!");
        }
    }

    private static final class MemberDependent
    implements Consumer<Type> {
        private final int index;
        private final BiConsumer<Integer, Type> setter;

        private MemberDependent(int index, BiConsumer<Integer, Type> setter) {
            this.index = index;
            this.setter = setter;
        }

        @Override
        public void accept(Type type) {
            this.setter.accept(this.index, type);
        }
    }
}

