/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.nodes;

import com.oracle.truffle.llvm.parser.LLVMLivenessAnalysis;
import com.oracle.truffle.llvm.parser.LLVMPhiManager;
import com.oracle.truffle.llvm.parser.metadata.DwarfOpcode;
import com.oracle.truffle.llvm.parser.metadata.MDExpression;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceVariable;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.ValueFragment;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.attributes.Attribute;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesGroup;
import com.oracle.truffle.llvm.parser.model.enums.AsmDialect;
import com.oracle.truffle.llvm.parser.model.enums.ReadModifyWriteOperator;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.InlineAsmConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.NullConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.UndefinedConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.integer.IntegerConstant;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalValueSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.AllocateInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.BinaryOperationInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.BranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CallInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CastInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CatchPadInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CatchRetInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CatchSwitchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CleanupPadInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CleanupRetInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CompareExchangeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CompareInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ConditionalBranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgDeclareInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgNoaliasScopeDeclInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DebugTrapInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ExtractElementInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ExtractValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.FenceInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.FreezeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.GetElementPointerInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.IndirectBranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.InsertElementInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.InsertValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Instruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.InvokeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.LandingpadInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.LoadInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.OperandBundle;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.PhiInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ReadModifyWriteInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ResumeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ReturnInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.SelectInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ShuffleVectorInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.StoreInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.SwitchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.SwitchOldInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.TerminatingInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.UnaryOperationInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.UnreachableInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VaArgInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidCallInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInvokeInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.parser.nodes.LLVMCatchSwitchAddConditionFunctionModifier;
import com.oracle.truffle.llvm.parser.nodes.LLVMFunctionModifier;
import com.oracle.truffle.llvm.parser.nodes.LLVMRuntimeDebugInformation;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.parser.util.LLVMBitcodeTypeHelper;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMFrameNullerExpressionNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMFrameNullerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMInstrumentableNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMVoidStatementNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCatchPadNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCatchSwitchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCleanupPadNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMAssume;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMWriteNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.symbols.SSAValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class LLVMBitcodeInstructionVisitor
implements SymbolVisitor {
    private final LLVMContext context;
    private final NodeFactory nodeFactory;
    private final List<LLVMPhiManager.Phi> blockPhis;
    private final int argCount;
    private final LLVMSymbolReadResolver symbols;
    private final ArrayList<LLVMLivenessAnalysis.NullerInformation> nullerInfos;
    private final LLVMStack.UniquesRegion uniquesRegion;
    private final DataLayout dataLayout;
    private final HashSet<SSAValue> neededForDebug;
    private final List<LLVMFunctionModifier> functionModifiers;
    private final ArrayList<LLVMNode> instructionNodes;
    private final ArrayList<SSAValue> instructionTargets;
    private final ArrayList<LLVMRuntimeDebugInformation.LocalVarDebugInfo> debugInfo;
    private SSAValue[] nullerInfo;
    private LLVMControlFlowNode controlFlowNode;
    private LLVMSourceLocation lastLocation;
    private final boolean optimizeFrameSlots;
    private final int exceptionSlot;

    public LLVMBitcodeInstructionVisitor(int exceptionSlot, LLVMStack.UniquesRegion uniquesRegion, List<LLVMPhiManager.Phi> blockPhis, int argCount, LLVMSymbolReadResolver symbols, LLVMContext context, ArrayList<LLVMLivenessAnalysis.NullerInformation> nullerInfos, HashSet<SSAValue> neededForDebug, DataLayout dataLayout, NodeFactory nodeFactory, List<LLVMFunctionModifier> functionModifiers) {
        this.exceptionSlot = exceptionSlot;
        this.context = context;
        this.neededForDebug = neededForDebug;
        this.nodeFactory = nodeFactory;
        this.blockPhis = blockPhis;
        this.argCount = argCount;
        this.symbols = symbols;
        this.nullerInfos = nullerInfos;
        this.uniquesRegion = uniquesRegion;
        this.dataLayout = dataLayout;
        this.functionModifiers = functionModifiers;
        this.instructionNodes = new ArrayList();
        this.instructionTargets = new ArrayList();
        this.debugInfo = new ArrayList();
        this.optimizeFrameSlots = (Boolean)context.getEnv().getOptions().get(SulongEngineOption.OPTIMIZE_FRAME_SLOTS) != false && (Boolean)context.getEnv().getOptions().get(SulongEngineOption.LL_DEBUG) == false;
    }

    private static long getIntegerConstant(SymbolImpl symbol) {
        if (symbol instanceof NullConstant) {
            return 0L;
        }
        if (symbol instanceof IntegerConstant) {
            return ((IntegerConstant)symbol).getValue();
        }
        throw new LLVMParserException("Expected integer constant symbol, but found: " + symbol.toString());
    }

    public LLVMControlFlowNode getControlFlowNode() {
        return this.controlFlowNode;
    }

    public void setInstructionIndex(int instructionIndex) {
        assert (this.instructionNodes.size() == this.instructionTargets.size());
        if (!this.nullerInfos.isEmpty()) {
            int last;
            assert (this.nullerInfos.get(this.nullerInfos.size() - 1).getInstructionIndex() >= instructionIndex) : "we either missed an instruction or the nuller information is not sorted correctly";
            for (last = this.nullerInfos.size(); last > 0 && this.nullerInfos.get(last - 1).getInstructionIndex() == instructionIndex; --last) {
            }
            if (last < this.nullerInfos.size()) {
                SSAValue[] slots = new SSAValue[this.nullerInfos.size() - last];
                for (int i = slots.length - 1; i >= 0; --i) {
                    slots[i] = this.nullerInfos.get(last + i).getIdentifier();
                    this.nullerInfos.remove(last + i);
                }
                this.nullerInfo = slots;
                return;
            }
        }
        this.nullerInfo = null;
    }

    public LLVMStatementNode[] finish() {
        for (int i = 0; i < this.instructionNodes.size(); ++i) {
            LLVMNode node = this.instructionNodes.get(i);
            SSAValue target = this.instructionTargets.get(i);
            if (target == null) {
                assert (node instanceof LLVMStatementNode);
                continue;
            }
            assert (node instanceof LLVMExpressionNode);
            this.instructionNodes.set(i, CommonNodeFactory.createFrameWrite(target.getType(), (LLVMExpressionNode)node, this.symbols.findOrAddFrameSlot(target)));
        }
        return this.instructionNodes.toArray(LLVMStatementNode.NO_STATEMENTS);
    }

    public LLVMRuntimeDebugInformation.LocalVarDebugInfo[] getDebugInfo() {
        return this.debugInfo.toArray(new LLVMRuntimeDebugInformation.LocalVarDebugInfo[this.debugInfo.size()]);
    }

    private int[] createNullerSlots(SSAValue[] stackValues) {
        if (stackValues != null) {
            int count = 0;
            for (SSAValue value : stackValues) {
                if (value == null) continue;
                ++count;
            }
            if (count > 0) {
                int pos = 0;
                int[] result = new int[count];
                for (SSAValue value : stackValues) {
                    if (value == null) continue;
                    result[pos++] = this.symbols.findOrAddFrameSlot(value);
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public void defaultAction(SymbolImpl symbol) {
        throw new LLVMParserException("Instruction not implemented: " + symbol.getClass().getSimpleName());
    }

    private LLVMExpressionNode resolveOptimized(SymbolImpl symbol, int excludeOtherIndex, SymbolImpl other, SymbolImpl ... others) {
        if (this.optimizeFrameSlots && this.nullerInfo != null && symbol instanceof SSAValue) {
            int i;
            if (symbol == other || this.neededForDebug.contains((SSAValue)((Object)symbol))) {
                return this.symbols.resolve(symbol);
            }
            for (i = 0; i < others.length; ++i) {
                SymbolImpl o = others[i];
                if (i == excludeOtherIndex || symbol != o) continue;
                return this.symbols.resolve(symbol);
            }
            for (i = 0; i < this.nullerInfo.length; ++i) {
                LLVMExpressionNode node;
                if (this.nullerInfo[i] != symbol) continue;
                if (SSAValue.isFrameSlotAllocated(this.nullerInfo[i]) || (node = this.extractNulledValue(this.nullerInfo[i])) == null) break;
                this.nullerInfo[i] = null;
                return node;
            }
        }
        return this.symbols.resolve(symbol);
    }

    private LLVMExpressionNode resolveOptimized(SymbolImpl symbol, SymbolImpl ... other) {
        return this.resolveOptimized(symbol, -1, null, other);
    }

    private LLVMExpressionNode extractNulledValue(SSAValue slot) {
        assert (slot != null);
        if (this.instructionNodes.isEmpty()) {
            return null;
        }
        SSAValue target = this.instructionTargets.get(this.instructionTargets.size() - 1);
        if (target == slot) {
            LLVMExpressionNode expression = (LLVMExpressionNode)this.instructionNodes.get(this.instructionNodes.size() - 1);
            this.instructionNodes.remove(this.instructionNodes.size() - 1);
            this.instructionTargets.remove(this.instructionTargets.size() - 1);
            return expression;
        }
        return null;
    }

    @Override
    public void visit(AllocateInstruction allocate) {
        LLVMExpressionNode result;
        SymbolImpl count;
        Type type = allocate.getPointeeType();
        int alignment = allocate.getAlign() == 0 ? type.getAlignment(this.dataLayout) : 1 << allocate.getAlign() - 1;
        if (alignment == 0) {
            alignment = 1;
        }
        if ((count = allocate.getCount()) instanceof NullConstant) {
            result = this.nodeFactory.createAlloca(type, alignment);
        } else if (count instanceof IntegerConstant) {
            long numElements = ((IntegerConstant)count).getValue();
            if (numElements == 1L) {
                result = this.nodeFactory.createAlloca(type, alignment);
            } else {
                ArrayType arrayType = new ArrayType(type, numElements);
                result = this.nodeFactory.createAlloca(arrayType, alignment);
            }
        } else {
            LLVMExpressionNode num = this.resolveOptimized(count, new SymbolImpl[0]);
            result = this.nodeFactory.createAllocaArray(type, num, alignment);
        }
        SourceInstrumentationStrategy intention = (Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.LL_DEBUG) != false ? SourceInstrumentationStrategy.FORCED : SourceInstrumentationStrategy.DISABLED;
        this.createFrameWrite(result, allocate, intention);
    }

    @Override
    public void visit(BinaryOperationInstruction operation) {
        SymbolImpl rhs = operation.getRHS();
        SymbolImpl lhs = operation.getLHS();
        LLVMExpressionNode rhsNode = this.resolveOptimized(rhs, lhs);
        LLVMExpressionNode lhsNode = this.resolveOptimized(lhs, rhs);
        LLVMExpressionNode result = LLVMBitcodeTypeHelper.createArithmeticInstruction(lhsNode, rhsNode, operation.getOperator(), operation.getType(), this.nodeFactory);
        this.createFrameWrite(result, operation);
    }

    @Override
    public void visit(UnaryOperationInstruction operation) {
        SymbolImpl operand = operation.getOperand();
        LLVMExpressionNode operandNode = this.resolveOptimized(operand, new SymbolImpl[0]);
        LLVMExpressionNode result = LLVMBitcodeTypeHelper.createUnaryInstruction(operandNode, operation.getOperator(), operation.getType(), this.nodeFactory);
        this.createFrameWrite(result, operation);
    }

    @Override
    public void visit(BranchInstruction branch) {
        LLVMControlFlowNode unconditionalBranchNode = this.nodeFactory.createUnconditionalBranch(branch.getSuccessor().getBlockIndex(), this.getPhiWriteNodes(branch)[0]);
        this.setControlFlowNode(unconditionalBranchNode, branch);
    }

    @Override
    public void visit(CallInstruction call) {
        Type targetType = call.getType();
        int argumentCount = LLVMBitcodeInstructionVisitor.getArgumentCount(call.getArgumentCount(), targetType);
        LLVMExpressionNode[] argNodes = new LLVMExpressionNode[argumentCount];
        Type.TypeArrayBuilder argTypes = new Type.TypeArrayBuilder(argumentCount);
        int argIndex = 0;
        argNodes[argIndex] = this.nodeFactory.createGetStackFromFrame();
        argTypes.set(argIndex, new PointerType(null));
        ++argIndex;
        if (targetType instanceof StructureType || targetType instanceof ArrayType) {
            argTypes.set(argIndex, new PointerType(targetType));
            argNodes[argIndex] = this.nodeFactory.createGetUniqueStackSpace(targetType, this.uniquesRegion);
            ++argIndex;
        }
        FunctionType functionType = call.getFunctionType();
        int realArgumentCount = functionType.getNumberOfArguments();
        SymbolImpl target = call.getCallTarget();
        for (int i = call.getArgumentCount() - 1; i >= 0; --i) {
            argNodes[argIndex + i] = this.resolveOptimized(call.getArgument(i), i, target, call.getArguments());
            argTypes.set(argIndex + i, call.getArgument(i).getType());
            boolean isVarArg = i >= realArgumentCount;
            AttributesGroup paramAttr = call.getParameterAttributesGroup(i);
            if (LLVMBitcodeInstructionVisitor.isByValue(paramAttr)) {
                argNodes[argIndex + i] = this.capsuleAddressByValue(argNodes[argIndex + i], argTypes.get(argIndex + i), paramAttr);
                continue;
            }
            if (!isVarArg || !LLVMBitcodeInstructionVisitor.isArrayByValue(argTypes.get(argIndex + i), argNodes[argIndex + i])) continue;
            argNodes[argIndex + i] = this.capsuleArrayByValue(argNodes[argIndex + i], argTypes.get(argIndex + i));
        }
        LLVMExpressionNode result = this.nodeFactory.createLLVMBuiltin(target, argNodes, argTypes, this.argCount);
        if (!(result instanceof LLVMAssume)) {
            LLVMBitcodeInstructionVisitor.ensureSupportedOperandBundle(target, call.getOperandBundle());
        }
        SourceInstrumentationStrategy intent = SourceInstrumentationStrategy.ONLY_FIRST_STATEMENT_ON_LOCATION;
        if (result == null) {
            if (target instanceof InlineAsmConstant) {
                InlineAsmConstant inlineAsmConstant = (InlineAsmConstant)target;
                result = this.createInlineAssemblerNode(inlineAsmConstant, argNodes, argTypes, targetType);
            } else {
                LLVMExpressionNode function = this.symbols.resolve(target);
                int fixedArgsPos = LLVMBitcodeInstructionVisitor.computeVaArgsPosition(functionType);
                result = CommonNodeFactory.createFunctionCall(function, argNodes, new FunctionType(targetType, argTypes, fixedArgsPos));
                intent = SourceInstrumentationStrategy.FORCED;
            }
        }
        this.createFrameWrite(result, call, intent);
    }

    private static int computeVaArgsPosition(FunctionType ft) {
        int fixedArgs = -1;
        if (ft.isVarargs()) {
            fixedArgs = ft.getArgumentTypes().size();
            assert (ft.getFixedArgs() == fixedArgs);
        }
        return fixedArgs;
    }

    @Override
    public void visit(LandingpadInstruction landingpadInstruction) {
        Type type = landingpadInstruction.getType();
        LLVMExpressionNode allocateLandingPadValue = this.nodeFactory.createGetUniqueStackSpace(type, this.uniquesRegion);
        LLVMExpressionNode[] entries = new LLVMExpressionNode[landingpadInstruction.getClauseSymbols().length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = this.symbols.resolve(landingpadInstruction.getClauseSymbols()[i]);
        }
        LLVMExpressionNode getStack = this.nodeFactory.createGetStackFromFrame();
        LLVMExpressionNode landingPad = this.nodeFactory.createLandingPad(allocateLandingPadValue, this.exceptionSlot, landingpadInstruction.isCleanup(), landingpadInstruction.getClauseTypes(), entries, getStack);
        this.createFrameWrite(landingPad, landingpadInstruction);
    }

    @Override
    public void visit(ResumeInstruction resumeInstruction) {
        LLVMControlFlowNode resume = this.nodeFactory.createResumeInstruction(this.exceptionSlot);
        this.setControlFlowNode(resume, resumeInstruction);
    }

    @Override
    public void visit(CompareExchangeInstruction cmpxchg) {
        SymbolImpl ptr = cmpxchg.getPtr();
        SymbolImpl cmp = cmpxchg.getCmp();
        SymbolImpl replace = cmpxchg.getReplace();
        LLVMExpressionNode newNode = this.resolveOptimized(replace, ptr, cmp);
        LLVMExpressionNode cmpNode = this.resolveOptimized(cmp, ptr, replace);
        LLVMExpressionNode ptrNode = this.resolveOptimized(ptr, cmp, replace);
        LLVMExpressionNode result = this.nodeFactory.createCompareExchangeInstruction(cmpxchg.getAggregateType(), cmp.getType(), ptrNode, cmpNode, newNode);
        this.createFrameWrite(result, cmpxchg);
    }

    @Override
    public void visit(VaArgInstruction vaArgInst) {
        LLVMExpressionNode source = this.resolveOptimized(vaArgInst.getSource(), new SymbolImpl[0]);
        LLVMExpressionNode result = CommonNodeFactory.createVaArg(vaArgInst.getType(), source);
        this.createFrameWrite(result, vaArgInst);
    }

    public void initializeAggregateLocalVariable(SourceVariable variable) {
        assert (this.instructionNodes.size() == 0);
        this.debugInfo.add(new LLVMRuntimeDebugInformation.InitAggreateLocalVariable(0, variable));
    }

    private void handleDebugIntrinsic(SymbolImpl value, SourceVariable variable, MDExpression expression, long index, boolean isDeclaration) {
        boolean mustDereference;
        if (index != 0L) {
            return;
        }
        int valueFrameSlot = -1;
        LLVMExpressionNode valueObject = null;
        if (value instanceof UndefinedConstant) {
            valueObject = this.symbols.resolve(new NullConstant(MetaType.DEBUG));
        } else if (value instanceof AbstractConstant) {
            valueObject = this.symbols.resolve(value);
        } else if (value instanceof GlobalValueSymbol) {
            valueObject = this.symbols.resolve(value);
        } else if (value instanceof SSAValue) {
            valueFrameSlot = this.symbols.findOrAddFrameSlot((SSAValue)((Object)value));
        } else {
            return;
        }
        if (valueObject == null && valueFrameSlot == -1) {
            return;
        }
        int partIndex = -1;
        int[] clearParts = null;
        if (ValueFragment.describesFragment(expression)) {
            ValueFragment fragment = ValueFragment.parse(expression);
            List<ValueFragment> siblings = variable.getFragments();
            ArrayList<Integer> clearSiblings = new ArrayList<Integer>(siblings.size());
            partIndex = ValueFragment.getPartIndex(fragment, siblings, clearSiblings);
            if (!clearSiblings.isEmpty()) {
                clearParts = clearSiblings.stream().mapToInt(Integer::intValue).toArray();
            }
        }
        if (partIndex < 0 && variable.hasFragments()) {
            int i;
            partIndex = variable.getFragmentIndex(0, (int)variable.getSymbol().getType().getSize());
            if (partIndex < 0) {
                throw new LLVMParserException("Cannot find index of value fragment!");
            }
            clearParts = new int[variable.getFragments().size() - 1];
            for (i = 0; i < partIndex; ++i) {
                clearParts[i] = i;
            }
            for (i = partIndex; i < clearParts.length; ++i) {
                clearParts[i] = i + 1;
            }
        }
        boolean bl = mustDereference = isDeclaration || LLVMBitcodeInstructionVisitor.mustDereferenceValue(expression, variable.getSourceType(), value);
        if (clearParts != null && clearParts.length != 0) {
            this.debugInfo.add(new LLVMRuntimeDebugInformation.ClearLocalVariableParts(this.instructionNodes.size(), variable.getSymbol(), clearParts));
        }
        if (partIndex < 0 && clearParts == null) {
            if (value instanceof UndefinedConstant && expression.isOperandEmpty()) {
                this.debugInfo.add(new LLVMRuntimeDebugInformation.UnavailableLocalVariable(this.instructionNodes.size(), variable.getSymbol()));
            } else {
                this.debugInfo.add(new LLVMRuntimeDebugInformation.SimpleLocalVariable(this.instructionNodes.size(), mustDereference, (Object)valueObject, valueFrameSlot, variable.getSymbol()));
            }
        } else if (partIndex >= 0) {
            this.debugInfo.add(new LLVMRuntimeDebugInformation.SetLocalVariablePart(this.instructionNodes.size(), mustDereference, (Object)valueObject, valueFrameSlot, variable.getSymbol(), partIndex));
        }
    }

    private static boolean mustDereferenceValue(MDExpression expr, LLVMSourceType type, SymbolImpl value) {
        return DwarfOpcode.isDeref(expr) || type != null && !type.isPointer() && value instanceof AllocateInstruction;
    }

    @Override
    public void visit(DbgDeclareInstruction inst) {
        this.handleDebugIntrinsic(inst.getValue(), inst.getVariable(), inst.getExpression(), 0L, true);
        this.handleNullerInfo();
    }

    @Override
    public void visit(DbgValueInstruction inst) {
        this.handleDebugIntrinsic(inst.getValue(), inst.getVariable(), inst.getExpression(), inst.getIndex(), false);
        this.handleNullerInfo();
    }

    @Override
    public void visit(DbgNoaliasScopeDeclInstruction inst) {
    }

    @Override
    public void visit(DebugTrapInstruction inst) {
        this.addStatement(CommonNodeFactory.createDebugTrap(), (Instruction)inst, SourceInstrumentationStrategy.FORCED);
    }

    @Override
    public void visit(VoidCallInstruction call) {
        int argumentCount = call.getArgumentCount() + 1;
        LLVMExpressionNode[] argNodes = new LLVMExpressionNode[argumentCount];
        Type.TypeArrayBuilder argTypes = new Type.TypeArrayBuilder(argumentCount);
        int argIndex = 0;
        argNodes[argIndex] = this.nodeFactory.createGetStackFromFrame();
        argTypes.set(argIndex, new PointerType(null));
        ++argIndex;
        SymbolImpl target = call.getCallTarget();
        FunctionType functionType = call.getFunctionType();
        int realArgumentCount = functionType.getNumberOfArguments();
        for (int i = call.getArgumentCount() - 1; i >= 0; --i) {
            boolean isVarArg;
            argNodes[argIndex + i] = this.resolveOptimized(call.getArgument(i), i, target, call.getArguments());
            argTypes.set(argIndex + i, call.getArgument(i).getType());
            AttributesGroup paramAttr = call.getParameterAttributesGroup(i);
            boolean bl = isVarArg = i >= realArgumentCount;
            if (LLVMBitcodeInstructionVisitor.isByValue(paramAttr)) {
                argNodes[argIndex + i] = this.capsuleAddressByValue(argNodes[argIndex + i], argTypes.get(argIndex + i), paramAttr);
                continue;
            }
            if (!isVarArg || !LLVMBitcodeInstructionVisitor.isArrayByValue(argTypes.get(argIndex + i), argNodes[argIndex + i])) continue;
            argNodes[argIndex + i] = this.capsuleArrayByValue(argNodes[argIndex + i], argTypes.get(argIndex + i));
        }
        LLVMExpressionNode result = this.nodeFactory.createLLVMBuiltin(target, argNodes, argTypes, this.argCount);
        if (!(result instanceof LLVMAssume)) {
            LLVMBitcodeInstructionVisitor.ensureSupportedOperandBundle(target, call.getOperandBundle());
        }
        SourceInstrumentationStrategy intent = SourceInstrumentationStrategy.ONLY_FIRST_STATEMENT_ON_LOCATION;
        if (result == null) {
            if (target instanceof InlineAsmConstant) {
                InlineAsmConstant inlineAsmConstant = (InlineAsmConstant)target;
                result = this.createInlineAssemblerNode(inlineAsmConstant, argNodes, argTypes, call.getType());
                this.assignSourceLocation(result, call);
            } else {
                LLVMExpressionNode function = this.resolveOptimized(target, call.getArguments());
                int fixedArgsPos = LLVMBitcodeInstructionVisitor.computeVaArgsPosition(functionType);
                FunctionType realType = new FunctionType(call.getType(), argTypes, fixedArgsPos);
                result = CommonNodeFactory.createFunctionCall(function, argNodes, realType);
                intent = SourceInstrumentationStrategy.FORCED;
            }
        }
        this.addStatement(result, (Instruction)call, intent);
    }

    @Override
    public void visit(InvokeInstruction call) {
        Type targetType = call.getType();
        int argumentCount = LLVMBitcodeInstructionVisitor.getArgumentCount(call.getArgumentCount(), targetType);
        LLVMExpressionNode[] argNodes = new LLVMExpressionNode[argumentCount];
        Type.TypeArrayBuilder argTypes = new Type.TypeArrayBuilder(argumentCount);
        int argIndex = 0;
        argNodes[argIndex] = this.nodeFactory.createGetStackFromFrame();
        argTypes.set(argIndex, new PointerType(null));
        ++argIndex;
        SymbolImpl target = call.getCallTarget();
        LLVMBitcodeInstructionVisitor.ensureSupportedOperandBundle(target, call.getOperandBundle());
        if (targetType instanceof StructureType || targetType instanceof ArrayType) {
            argTypes.set(argIndex, new PointerType(targetType));
            argNodes[argIndex] = this.nodeFactory.createGetUniqueStackSpace(targetType, this.uniquesRegion);
            ++argIndex;
        }
        FunctionType functionType = call.getFunctionType();
        int realArgumentCount = functionType.getNumberOfArguments();
        for (int i = call.getArgumentCount() - 1; i >= 0; --i) {
            boolean isVarArg;
            argNodes[argIndex + i] = this.resolveOptimized(call.getArgument(i), i, target, call.getArguments());
            argTypes.set(argIndex + i, call.getArgument(i).getType());
            AttributesGroup paramAttr = call.getParameterAttributesGroup(i);
            boolean bl = isVarArg = i >= realArgumentCount;
            if (LLVMBitcodeInstructionVisitor.isByValue(paramAttr)) {
                argNodes[argIndex + i] = this.capsuleAddressByValue(argNodes[argIndex + i], argTypes.get(argIndex + i), paramAttr);
                continue;
            }
            if (!isVarArg || !LLVMBitcodeInstructionVisitor.isArrayByValue(argTypes.get(argIndex + i), argNodes[argIndex + i])) continue;
            argNodes[argIndex + i] = this.capsuleArrayByValue(argNodes[argIndex + i], argTypes.get(argIndex + i));
        }
        int regularIndex = call.normalSuccessor().getBlockIndex();
        int unwindIndex = call.unwindSuccessor().getBlockIndex();
        ArrayList<LLVMPhiManager.Phi> normalTo = new ArrayList<LLVMPhiManager.Phi>();
        ArrayList<LLVMPhiManager.Phi> unwindTo = new ArrayList<LLVMPhiManager.Phi>();
        if (this.blockPhis != null) {
            for (LLVMPhiManager.Phi phi : this.blockPhis) {
                if (call.normalSuccessor() == phi.getBlock()) {
                    normalTo.add(phi);
                    continue;
                }
                unwindTo.add(phi);
            }
        }
        LLVMStatementNode normalPhi = this.createPhiWriteNodes(normalTo);
        LLVMStatementNode unwindPhi = this.createPhiWriteNodes(unwindTo);
        LLVMExpressionNode function = this.symbols.resolve(target);
        LLVMControlFlowNode result = this.nodeFactory.createFunctionInvoke(CommonNodeFactory.createFrameWrite(targetType, null, this.symbols.findOrAddFrameSlot(call)), function, argNodes, new FunctionType(targetType, argTypes, LLVMBitcodeInstructionVisitor.computeVaArgsPosition(functionType)), regularIndex, unwindIndex, normalPhi, unwindPhi);
        this.setControlFlowNode(result, call, SourceInstrumentationStrategy.FORCED);
    }

    @Override
    public void visit(VoidInvokeInstruction call) {
        SymbolImpl target = call.getCallTarget();
        LLVMBitcodeInstructionVisitor.ensureSupportedOperandBundle(target, call.getOperandBundle());
        int argumentCount = call.getArgumentCount() + 1;
        LLVMExpressionNode[] args = new LLVMExpressionNode[argumentCount];
        Type.TypeArrayBuilder argsType = new Type.TypeArrayBuilder(argumentCount);
        int argIndex = 0;
        args[argIndex] = this.nodeFactory.createGetStackFromFrame();
        argsType.set(argIndex, new PointerType(null));
        ++argIndex;
        FunctionType functionType = call.getFunctionType();
        int realArgumentCount = functionType.getNumberOfArguments();
        for (int i = call.getArgumentCount() - 1; i >= 0; --i) {
            boolean isVarArg;
            args[argIndex + i] = this.symbols.resolve(call.getArgument(i));
            argsType.set(argIndex + i, call.getArgument(i).getType());
            AttributesGroup paramAttr = call.getParameterAttributesGroup(i);
            boolean bl = isVarArg = i >= realArgumentCount;
            if (LLVMBitcodeInstructionVisitor.isByValue(paramAttr)) {
                args[argIndex + i] = this.capsuleAddressByValue(args[argIndex + i], argsType.get(argIndex + i), paramAttr);
                continue;
            }
            if (!isVarArg || !LLVMBitcodeInstructionVisitor.isArrayByValue(argsType.get(argIndex + i), args[argIndex + i])) continue;
            args[argIndex + i] = this.capsuleArrayByValue(args[argIndex + i], argsType.get(argIndex + i));
        }
        int regularIndex = call.normalSuccessor().getBlockIndex();
        int unwindIndex = call.unwindSuccessor().getBlockIndex();
        ArrayList<LLVMPhiManager.Phi> normalTo = new ArrayList<LLVMPhiManager.Phi>();
        ArrayList<LLVMPhiManager.Phi> unwindTo = new ArrayList<LLVMPhiManager.Phi>();
        if (this.blockPhis != null) {
            for (LLVMPhiManager.Phi phi : this.blockPhis) {
                if (call.normalSuccessor() == phi.getBlock()) {
                    normalTo.add(phi);
                    continue;
                }
                unwindTo.add(phi);
            }
        }
        LLVMStatementNode normalPhi = this.createPhiWriteNodes(normalTo);
        LLVMStatementNode unwindPhi = this.createPhiWriteNodes(unwindTo);
        LLVMExpressionNode function = this.resolveOptimized(target, call.getArguments());
        LLVMControlFlowNode result = this.nodeFactory.createFunctionInvoke(null, function, args, new FunctionType(call.getType(), argsType, LLVMBitcodeInstructionVisitor.computeVaArgsPosition(functionType)), regularIndex, unwindIndex, normalPhi, unwindPhi);
        this.setControlFlowNode(result, call, SourceInstrumentationStrategy.FORCED);
    }

    private static int getArgumentCount(int argumentCount, Type targetType) {
        int count = argumentCount;
        if (targetType instanceof StructureType || targetType instanceof ArrayType) {
            ++count;
        }
        return ++count;
    }

    @Override
    public void visit(CastInstruction cast) {
        LLVMExpressionNode fromNode = this.resolveOptimized(cast.getValue(), new SymbolImpl[0]);
        Type from = cast.getValue().getType();
        Type to = cast.getType();
        LLVMExpressionNode result = LLVMBitcodeTypeHelper.createCast(fromNode, to, from, cast.getOperator(), this.nodeFactory);
        this.createFrameWrite(result, cast);
    }

    @Override
    public void visit(CompareInstruction compare) {
        SymbolImpl rhs = compare.getRHS();
        SymbolImpl lhs = compare.getLHS();
        LLVMExpressionNode rhsNode = this.resolveOptimized(rhs, lhs);
        LLVMExpressionNode lhsNode = this.resolveOptimized(lhs, rhs);
        LLVMExpressionNode result = CommonNodeFactory.createComparison(compare.getOperator(), lhs.getType(), lhsNode, rhsNode);
        this.createFrameWrite(result, compare);
    }

    @Override
    public void visit(ConditionalBranchInstruction branch) {
        LLVMExpressionNode conditionNode = this.symbols.resolve(branch.getCondition());
        int trueIndex = branch.getTrueSuccessor().getBlockIndex();
        int falseIndex = branch.getFalseSuccessor().getBlockIndex();
        LLVMStatementNode[] phiWriteNodes = this.getPhiWriteNodes(branch);
        LLVMControlFlowNode node = this.nodeFactory.createConditionalBranch(trueIndex, falseIndex, conditionNode, phiWriteNodes[0], phiWriteNodes[1]);
        this.setControlFlowNode(node, branch);
    }

    @Override
    public void visit(ExtractElementInstruction extract) {
        SymbolImpl index = extract.getIndex();
        SymbolImpl vector = extract.getVector();
        LLVMExpressionNode indexNode = this.resolveOptimized(index, vector);
        LLVMExpressionNode vectorNode = this.resolveOptimized(vector, index);
        LLVMExpressionNode result = this.nodeFactory.createExtractElement(extract.getType(), vectorNode, indexNode);
        this.createFrameWrite(result, extract);
    }

    @Override
    public void visit(ExtractValueInstruction extract) {
        if (!(extract.getAggregate().getType() instanceof ArrayType || extract.getAggregate().getType() instanceof StructureType || extract.getAggregate().getType() instanceof PointerType)) {
            throw new LLVMParserException("'extractvalue' can only extract elements of arrays and structs!");
        }
        LLVMExpressionNode baseAddress = this.resolveOptimized(extract.getAggregate(), new SymbolImpl[0]);
        Type baseType = extract.getAggregate().getType();
        Collection<Long> targetIndices = extract.getIndices();
        Type resultType = extract.getType();
        LLVMExpressionNode targetAddress = CommonNodeFactory.getTargetAddress(baseAddress, baseType, targetIndices, this.nodeFactory, this.dataLayout);
        LLVMExpressionNode result = this.nodeFactory.createExtractValue(resultType, targetAddress);
        this.createFrameWrite(result, extract);
    }

    @Override
    public void visit(GetElementPointerInstruction gep) {
        this.createFrameWrite(this.symbols.resolveElementPointer(gep.getBaseType(), gep.getBasePointer(), gep.getIndices(), this::resolveOptimized), gep);
    }

    @Override
    public void visit(IndirectBranchInstruction branch) {
        if (branch.getSuccessorCount() > 1) {
            int[] labelTargets = new int[branch.getSuccessorCount()];
            for (int i = 0; i < labelTargets.length; ++i) {
                labelTargets[i] = branch.getSuccessor(i).getBlockIndex();
            }
            LLVMExpressionNode value = this.symbols.resolve(branch.getAddress());
            LLVMControlFlowNode node = this.nodeFactory.createIndirectBranch(value, labelTargets, this.getPhiWriteNodes(branch));
            this.setControlFlowNode(node, branch);
        } else {
            assert (branch.getSuccessorCount() == 1);
            LLVMControlFlowNode node = this.nodeFactory.createUnconditionalBranch(branch.getSuccessor(0).getBlockIndex(), this.getPhiWriteNodes(branch)[0]);
            this.setControlFlowNode(node, branch);
        }
    }

    @Override
    public void visit(InsertElementInstruction insert) {
        SymbolImpl index = insert.getIndex();
        SymbolImpl value = insert.getValue();
        SymbolImpl vector = insert.getVector();
        LLVMExpressionNode indexNode = this.resolveOptimized(index, index, vector);
        LLVMExpressionNode elementNode = this.resolveOptimized(value, value, vector);
        LLVMExpressionNode vectorNode = this.resolveOptimized(vector, value, index);
        LLVMExpressionNode result = this.nodeFactory.createInsertElement(insert.getType(), vectorNode, elementNode, indexNode);
        this.createFrameWrite(result, insert);
    }

    @Override
    public void visit(InsertValueInstruction insert) {
        LLVMExpressionNode result;
        if (!(insert.getAggregate().getType() instanceof StructureType) && !(insert.getAggregate().getType() instanceof ArrayType)) {
            throw new LLVMParserException("'insertvalue' can only insert values into arrays and structs!");
        }
        AggregateType sourceType = (AggregateType)insert.getAggregate().getType();
        LLVMExpressionNode sourceAggregate = this.symbols.resolve(insert.getAggregate());
        LLVMExpressionNode valueToInsert = this.symbols.resolve(insert.getValue());
        Type valueType = insert.getValue().getType();
        int targetIndex = insert.getIndex();
        LLVMExpressionNode resultAggregate = this.nodeFactory.createGetUniqueStackSpace(sourceType, this.uniquesRegion);
        try {
            long offset = sourceType.getOffsetOf(targetIndex, this.dataLayout);
            result = this.nodeFactory.createInsertValue(resultAggregate, sourceAggregate, sourceType.getSize(this.dataLayout), offset, valueToInsert, valueType);
        }
        catch (Type.TypeOverflowException e) {
            result = Type.handleOverflowExpression(e);
        }
        this.createFrameWrite(result, insert);
    }

    @Override
    public void visit(LoadInstruction load) {
        LLVMExpressionNode source = this.resolveOptimized(load.getSource(), new SymbolImpl[0]);
        LLVMExpressionNode result = this.nodeFactory.createLoad(load.getType(), source);
        this.createFrameWrite(result, load);
    }

    @Override
    public void visit(PhiInstruction phi) {
        this.handleNullerInfo();
    }

    @Override
    public void visit(ReturnInstruction ret) {
        LLVMControlFlowNode node;
        if (ret.getValue() == null) {
            node = this.nodeFactory.createRetVoid();
        } else {
            Type type = ret.getValue().getType();
            LLVMExpressionNode value = this.symbols.resolve(ret.getValue());
            node = this.nodeFactory.createNonVoidRet(value, type);
        }
        this.setControlFlowNode(node, ret);
    }

    @Override
    public void visit(SelectInstruction select) {
        LLVMExpressionNode condition = this.symbols.resolve(select.getCondition());
        LLVMExpressionNode trueValue = this.symbols.resolve(select.getTrueValue());
        LLVMExpressionNode falseValue = this.symbols.resolve(select.getFalseValue());
        Type type = select.getType();
        LLVMExpressionNode result = this.nodeFactory.createSelect(type, condition, trueValue, falseValue);
        this.createFrameWrite(result, select);
    }

    @Override
    public void visit(ShuffleVectorInstruction shuffle) {
        LLVMExpressionNode vector1 = this.symbols.resolve(shuffle.getVector1());
        LLVMExpressionNode vector2 = this.symbols.resolve(shuffle.getVector2());
        LLVMExpressionNode mask = this.symbols.resolve(shuffle.getMask());
        Type type = shuffle.getType();
        LLVMExpressionNode result = this.nodeFactory.createShuffleVector(type, vector1, vector2, mask);
        this.createFrameWrite(result, shuffle);
    }

    @Override
    public void visit(StoreInstruction store) {
        SymbolImpl value = store.getSource();
        SymbolImpl pointer = store.getDestination();
        LLVMExpressionNode valueNode = this.resolveOptimized(value, pointer);
        LLVMExpressionNode pointerNode = this.resolveOptimized(pointer, value);
        SourceInstrumentationStrategy intention = SourceInstrumentationStrategy.DISABLED;
        if (!(store.getSource() instanceof CallInstruction) && !(store.getSource() instanceof InvokeInstruction) || ((Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.LL_DEBUG)).booleanValue()) {
            intention = SourceInstrumentationStrategy.ONLY_FIRST_STATEMENT_ON_LOCATION;
        }
        Type type = value.getType();
        LLVMStatementNode node = this.nodeFactory.createStore(pointerNode, valueNode, type);
        this.addStatement(node, (Instruction)store, intention);
    }

    @Override
    public void visit(ReadModifyWriteInstruction rmw) {
        SymbolImpl value = rmw.getValue();
        SymbolImpl pointer = rmw.getPtr();
        LLVMExpressionNode valueNode = this.resolveOptimized(value, pointer);
        LLVMExpressionNode pointerNode = this.resolveOptimized(pointer, value);
        Type type = rmw.getValue().getType();
        LLVMExpressionNode result = this.createReadModifyWrite(rmw.getOperator(), pointerNode, valueNode, type);
        this.createFrameWrite(result, rmw);
    }

    private LLVMExpressionNode createReadModifyWrite(ReadModifyWriteOperator op, LLVMExpressionNode pointerNode, LLVMExpressionNode valueNode, Type type) {
        switch (op) {
            case SUB: {
                return this.nodeFactory.createRMWSub(pointerNode, valueNode, type);
            }
            case XCHG: {
                return this.nodeFactory.createRMWXchg(pointerNode, valueNode, type);
            }
            case ADD: {
                return this.nodeFactory.createRMWAdd(pointerNode, valueNode, type);
            }
            case AND: {
                return this.nodeFactory.createRMWAnd(pointerNode, valueNode, type);
            }
            case NAND: {
                return this.nodeFactory.createRMWNand(pointerNode, valueNode, type);
            }
            case OR: {
                return this.nodeFactory.createRMWOr(pointerNode, valueNode, type);
            }
            case XOR: {
                return this.nodeFactory.createRMWXor(pointerNode, valueNode, type);
            }
        }
        throw new LLVMParserException("Unsupported read-modify-write operation: " + String.valueOf((Object)op));
    }

    @Override
    public void visit(FenceInstruction fence) {
        this.addStatement(this.nodeFactory.createFence(), fence);
    }

    @Override
    public void visit(FreezeInstruction freeze) {
        LLVMExpressionNode fromNode = this.resolveOptimized(freeze.getValue(), new SymbolImpl[0]);
        this.createFrameWrite(fromNode, freeze);
    }

    @Override
    public void visit(CatchSwitchInstruction catchSwitch) {
        int[] successors = new int[catchSwitch.getSuccessorCount()];
        for (int i = 0; i < successors.length; ++i) {
            successors[i] = catchSwitch.getSuccessor(i).getBlockIndex();
        }
        LLVMExpressionNode getStack = this.nodeFactory.createGetStackFromFrame();
        LLVMControlFlowNode node = catchSwitch.hasUnwindBlock() ? this.nodeFactory.createCatchSwitch(this.exceptionSlot, successors, catchSwitch.getUnwindBlock().getBlockIndex(), getStack, this.getPhiWriteNodes(catchSwitch)) : this.nodeFactory.createCatchSwitch(this.exceptionSlot, successors, getStack, this.getPhiWriteNodes(catchSwitch));
        this.setControlFlowNode(node, catchSwitch);
    }

    @Override
    public void visit(CatchRetInstruction catchRet) {
        LLVMExpressionNode getStack = this.nodeFactory.createGetStackFromFrame();
        LLVMControlFlowNode node = catchRet.getSuccessorCount() > 0 ? this.nodeFactory.createCatchReturn(catchRet.getSuccessor(0).getBlockIndex(), getStack, this.getPhiWriteNodes(catchRet)[0]) : this.nodeFactory.createResumeInstruction(this.exceptionSlot);
        this.setControlFlowNode(node, catchRet);
    }

    @Override
    public void visit(CatchPadInstruction catchPad) {
        assert (catchPad.getClauseSymbols().length == 3);
        LLVMExpressionNode clauseNode = this.symbols.resolve(catchPad.getClauseSymbols()[0]);
        int attributes = (int)LLVMBitcodeInstructionVisitor.getIntegerConstant(catchPad.getClauseSymbols()[1]);
        Type exceptionType = catchPad.getClauseSymbols()[2].getType();
        LLVMExpressionNode getExceptionSlot = this.symbols.resolve(catchPad.getClauseSymbols()[2]);
        LLVMCatchSwitchNode.CatchPadEntryNode conditionNode = LLVMCatchSwitchNode.createCatchPadEntryNode(clauseNode, attributes, getExceptionSlot, (PointerType)exceptionType);
        assert (catchPad.getWithinSymbol() instanceof CatchSwitchInstruction);
        CatchSwitchInstruction catchSwitch = (CatchSwitchInstruction)catchPad.getWithinSymbol();
        this.addFunctionModifier(new LLVMCatchSwitchAddConditionFunctionModifier(conditionNode, catchSwitch.getInstructionBlock().getBlockIndex()));
        this.createFrameWrite(LLVMCatchPadNode.create(this.exceptionSlot), catchPad);
    }

    @Override
    public void visit(CleanupPadInstruction catchPad) {
        this.createFrameWrite(LLVMCleanupPadNode.create(this.exceptionSlot), catchPad);
    }

    @Override
    public void visit(CleanupRetInstruction cleanupRet) {
        LLVMExpressionNode getStack = this.nodeFactory.createGetStackFromFrame();
        LLVMControlFlowNode node = cleanupRet.getSuccessorCount() > 0 ? this.nodeFactory.createCleanupReturn(cleanupRet.getSuccessor(0).getBlockIndex(), getStack, this.getPhiWriteNodes(cleanupRet)[0]) : this.nodeFactory.createResumeInstruction(this.exceptionSlot);
        this.setControlFlowNode(node, cleanupRet);
    }

    @Override
    public void visit(SwitchInstruction zwitch) {
        LLVMExpressionNode cond = this.symbols.resolve(zwitch.getCondition());
        int[] successors = new int[zwitch.getCaseCount() + 1];
        for (int i = 0; i < successors.length - 1; ++i) {
            successors[i] = zwitch.getCaseBlock(i).getBlockIndex();
        }
        successors[successors.length - 1] = zwitch.getDefaultBlock().getBlockIndex();
        Type llvmType = zwitch.getCondition().getType();
        LLVMExpressionNode[] cases = new LLVMExpressionNode[zwitch.getCaseCount()];
        for (int i = 0; i < cases.length; ++i) {
            cases[i] = this.symbols.resolve(zwitch.getCaseValue(i));
        }
        LLVMControlFlowNode node = this.nodeFactory.createSwitch(cond, successors, cases, llvmType, this.getPhiWriteNodes(zwitch));
        this.setControlFlowNode(node, zwitch);
    }

    private LLVMStatementNode[] getPhiWriteNodes(TerminatingInstruction terminatingInstruction) {
        if (this.blockPhis != null) {
            ArrayList<LLVMPhiManager.Phi>[] phisPerSuccessor = LLVMPhiManager.getPhisForSuccessors(terminatingInstruction, this.blockPhis);
            return this.createPhiWriteNodes(phisPerSuccessor);
        }
        return new LLVMStatementNode[terminatingInstruction.getSuccessorCount()];
    }

    private LLVMStatementNode[] createPhiWriteNodes(ArrayList<LLVMPhiManager.Phi>[] phisPerSuccessor) {
        if (phisPerSuccessor.length == 0) {
            return LLVMStatementNode.NO_STATEMENTS;
        }
        LLVMStatementNode[] result = new LLVMStatementNode[phisPerSuccessor.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.createPhiWriteNodes(phisPerSuccessor[i]);
        }
        return result;
    }

    private LLVMStatementNode createPhiWriteNodes(ArrayList<LLVMPhiManager.Phi> phis) {
        LLVMPhiManager.Phi phi;
        int i;
        if (phis.size() == 0) {
            return null;
        }
        if (phis.size() == 1) {
            LLVMPhiManager.Phi phi2 = phis.get(0);
            return CommonNodeFactory.createFrameWrite(phi2.getValue().getType(), this.symbols.resolve(phi2.getValue()), this.symbols.findOrAddFrameSlot(phi2.getPhiValue()));
        }
        HashMap<PhiInstruction, LLVMPhiManager.Phi> pendingPhis = new HashMap<PhiInstruction, LLVMPhiManager.Phi>();
        for (LLVMPhiManager.Phi phi3 : phis) {
            pendingPhis.put(phi3.getPhiValue(), phi3);
        }
        ArrayList<LLVMPhiManager.Phi> ordinary = new ArrayList<LLVMPhiManager.Phi>();
        ArrayList<LLVMPhiManager.Phi> cycles = new ArrayList<LLVMPhiManager.Phi>();
        while (!pendingPhis.isEmpty()) {
            LLVMPhiManager.Phi phi4;
            boolean progress = false;
            Iterator iter = pendingPhis.entrySet().iterator();
            while (iter.hasNext()) {
                phi4 = (LLVMPhiManager.Phi)iter.next().getValue();
                if (pendingPhis.containsKey(phi4.getValue())) continue;
                iter.remove();
                ordinary.add(phi4);
                progress = true;
            }
            if (progress) continue;
            iter = pendingPhis.entrySet().iterator();
            phi4 = (LLVMPhiManager.Phi)iter.next().getValue();
            iter.remove();
            cycles.add(phi4);
        }
        LLVMExpressionNode[] cycleFrom = new LLVMExpressionNode[cycles.size()];
        LLVMWriteNode[] cycleWrites = new LLVMWriteNode[cycles.size()];
        LLVMWriteNode[] ordinaryWrites = new LLVMWriteNode[ordinary.size()];
        for (i = 0; i < cycles.size(); ++i) {
            phi = (LLVMPhiManager.Phi)cycles.get(i);
            cycleFrom[i] = this.symbols.resolve(phi.getValue());
            cycleWrites[i] = CommonNodeFactory.createFrameWrite(phi.getValue().getType(), null, this.symbols.findOrAddFrameSlot(phi.getPhiValue()));
        }
        for (i = 0; i < ordinary.size(); ++i) {
            phi = (LLVMPhiManager.Phi)ordinary.get(ordinary.size() - 1 - i);
            ordinaryWrites[i] = CommonNodeFactory.createFrameWrite(phi.getValue().getType(), this.symbols.resolve(phi.getValue()), this.symbols.findOrAddFrameSlot(phi.getPhiValue()));
        }
        return this.nodeFactory.createPhi(cycleFrom, cycleWrites, ordinaryWrites);
    }

    @Override
    public void visit(SwitchOldInstruction zwitch) {
        LLVMExpressionNode cond = this.symbols.resolve(zwitch.getCondition());
        int[] successors = new int[zwitch.getCaseCount() + 1];
        for (int i = 0; i < successors.length - 1; ++i) {
            successors[i] = zwitch.getCaseBlock(i).getBlockIndex();
        }
        successors[successors.length - 1] = zwitch.getDefaultBlock().getBlockIndex();
        PrimitiveType llvmType = (PrimitiveType)zwitch.getCondition().getType();
        LLVMExpressionNode[] cases = new LLVMExpressionNode[zwitch.getCaseCount()];
        block6: for (int i = 0; i < cases.length; ++i) {
            switch (llvmType.getPrimitiveKind()) {
                case I8: {
                    cases[i] = CommonNodeFactory.createLiteral((byte)zwitch.getCaseValue(i), llvmType);
                    continue block6;
                }
                case I16: {
                    cases[i] = CommonNodeFactory.createLiteral((short)zwitch.getCaseValue(i), llvmType);
                    continue block6;
                }
                case I32: {
                    cases[i] = CommonNodeFactory.createLiteral((int)zwitch.getCaseValue(i), llvmType);
                    continue block6;
                }
                default: {
                    cases[i] = CommonNodeFactory.createLiteral(zwitch.getCaseValue(i), llvmType);
                }
            }
        }
        LLVMControlFlowNode node = this.nodeFactory.createSwitch(cond, successors, cases, llvmType, this.getPhiWriteNodes(zwitch));
        this.setControlFlowNode(node, zwitch);
    }

    @Override
    public void visit(UnreachableInstruction ui) {
        LLVMControlFlowNode node = this.nodeFactory.createUnreachableNode();
        this.setControlFlowNode(node, ui);
    }

    public void handleNullerInfo() {
        int[] frameSlots = this.createNullerSlots(this.nullerInfo);
        this.nullerInfo = null;
        if (frameSlots != null) {
            if (this.instructionNodes.isEmpty()) {
                this.instructionNodes.add(LLVMFrameNullerNodeGen.create(frameSlots, null));
                this.instructionTargets.add(null);
            } else {
                int index = this.instructionNodes.size() - 1;
                LLVMNode node = this.instructionNodes.get(index);
                node = node instanceof LLVMStatementNode ? LLVMFrameNullerNodeGen.create(frameSlots, (LLVMStatementNode)node) : LLVMFrameNullerExpressionNodeGen.create(frameSlots, (LLVMExpressionNode)node);
                this.instructionNodes.set(this.instructionNodes.size() - 1, node);
            }
        }
    }

    private void addNode(LLVMNode node, ValueInstruction target) {
        this.instructionNodes.add(node);
        this.instructionTargets.add(target);
    }

    private void createFrameWrite(LLVMExpressionNode result, ValueInstruction source) {
        this.createFrameWrite(result, source, SourceInstrumentationStrategy.ONLY_FIRST_STATEMENT_ON_LOCATION);
    }

    private void createFrameWrite(LLVMExpressionNode result, ValueInstruction source, SourceInstrumentationStrategy intention) {
        this.assignSourceLocation(result, source, intention);
        this.addNode(result, source);
        this.handleNullerInfo();
    }

    private LLVMExpressionNode createInlineAssemblerNode(InlineAsmConstant inlineAsmConstant, LLVMExpressionNode[] argNodes, Type.TypeArrayBuilder argsType, Type retType) {
        if (inlineAsmConstant.needsAlignedStack()) {
            throw new LLVMParserException("Assembly Expressions that require an aligned Stack are not supported yet!");
        }
        if (inlineAsmConstant.getDialect() != AsmDialect.AT_T) {
            throw new LLVMParserException("Unsupported Assembly Dialect: " + String.valueOf((Object)inlineAsmConstant.getDialect()));
        }
        return this.nodeFactory.createInlineAssemblerExpression(inlineAsmConstant.getAsmExpression(), inlineAsmConstant.getAsmFlags(), argNodes, argsType, retType);
    }

    private void addFunctionModifier(LLVMFunctionModifier modifier) {
        this.functionModifiers.add(modifier);
    }

    private void addStatement(LLVMStatementNode node, Instruction instruction) {
        this.addStatement(node, instruction, SourceInstrumentationStrategy.ONLY_FIRST_STATEMENT_ON_LOCATION);
    }

    private void addStatement(LLVMExpressionNode node, Instruction instruction, SourceInstrumentationStrategy intention) {
        this.assignSourceLocation(node, instruction, intention);
        this.addNode(LLVMVoidStatementNodeGen.create(node), null);
        this.handleNullerInfo();
    }

    private void addStatement(LLVMStatementNode node, Instruction instruction, SourceInstrumentationStrategy intention) {
        this.assignSourceLocation(node, instruction, intention);
        this.addNode(node, null);
        this.handleNullerInfo();
    }

    private void setControlFlowNode(LLVMControlFlowNode controlFlowNode, Instruction sourceInstruction) {
        this.setControlFlowNode(controlFlowNode, sourceInstruction, SourceInstrumentationStrategy.ONLY_FIRST_STATEMENT_ON_LOCATION);
    }

    private void setControlFlowNode(LLVMControlFlowNode controlFlowNode, Instruction sourceInstruction, SourceInstrumentationStrategy intention) {
        assert (this.controlFlowNode == null);
        this.controlFlowNode = controlFlowNode;
        this.assignSourceLocation(controlFlowNode, sourceInstruction, intention);
    }

    private LLVMExpressionNode capsuleAddressByValue(LLVMExpressionNode child, Type type, AttributesGroup paramAttr) {
        try {
            Type pointee = null;
            int alignment = -1;
            for (Attribute attr : paramAttr.getAttributes()) {
                if (attr instanceof Attribute.KnownTypedAttribute && ((Attribute.KnownTypedAttribute)attr).getAttr() == Attribute.Kind.BYVAL) {
                    pointee = ((Attribute.KnownTypedAttribute)attr).getType();
                }
                if (!(attr instanceof Attribute.KnownIntegerValueAttribute) || ((Attribute.KnownIntegerValueAttribute)attr).getAttr() != Attribute.Kind.ALIGN) continue;
                alignment = ((Attribute.KnownIntegerValueAttribute)attr).getValue();
            }
            if (pointee == null) {
                assert (!((PointerType)type).isOpaque());
                pointee = ((PointerType)type).getPointeeType();
            }
            long size = pointee.getSize(this.dataLayout);
            if (alignment < 0) {
                alignment = pointee.getAlignment(this.dataLayout);
            }
            return this.nodeFactory.createVarArgCompoundValue(size, alignment, type, child);
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
    }

    private static void ensureSupportedOperandBundle(SymbolImpl target, OperandBundle operandBundle) {
        if (operandBundle != null && !operandBundle.isFunclet()) {
            throw new LLVMParserException(String.format("Unsupported operand bundle '%s' on call of %s", operandBundle.getTag(), target.toString()));
        }
    }

    private LLVMExpressionNode capsuleArrayByValue(LLVMExpressionNode child, Type type) {
        try {
            long size = type.getSize(this.dataLayout);
            int alignment = type.getAlignment(this.dataLayout);
            return this.nodeFactory.createVarArgCompoundValue(size, alignment, type, child);
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
    }

    private static boolean isByValue(AttributesGroup parameter) {
        if (parameter == null) {
            return false;
        }
        for (Attribute a : parameter.getAttributes()) {
            if (!(a instanceof Attribute.KnownAttribute) || ((Attribute.KnownAttribute)a).getAttr() != Attribute.Kind.BYVAL) continue;
            return true;
        }
        return false;
    }

    private static boolean isArrayByValue(Type type, LLVMExpressionNode exprNode) {
        return type instanceof ArrayType;
    }

    private void assignSourceLocation(LLVMInstrumentableNode node, Instruction sourceInstruction) {
        this.assignSourceLocation(node, sourceInstruction, SourceInstrumentationStrategy.ONLY_FIRST_STATEMENT_ON_LOCATION);
    }

    private void assignSourceLocation(LLVMInstrumentableNode node, Instruction sourceInstruction, SourceInstrumentationStrategy instrumentationStrategy) {
        if (node == null) {
            return;
        }
        if (!node.isAdoptable()) {
            return;
        }
        LLVMSourceLocation location = sourceInstruction.getSourceLocation();
        if (location == null) {
            return;
        }
        node.setSourceLocation(location);
        assert (instrumentationStrategy != null);
        switch (instrumentationStrategy.ordinal()) {
            case 0: {
                node.setHasStatementTag(true);
                this.lastLocation = location;
                break;
            }
            case 1: {
                if (this.lastLocation == location || this.lastLocation != null && Objects.equals(this.lastLocation.describeFile(), location.describeFile()) && this.lastLocation.getLine() == location.getLine()) break;
                node.setHasStatementTag(true);
                this.lastLocation = location;
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new LLVMParserException("Unknown instrumentation strategy: " + String.valueOf((Object)instrumentationStrategy));
            }
        }
    }

    private static enum SourceInstrumentationStrategy {
        FORCED,
        ONLY_FIRST_STATEMENT_ON_LOCATION,
        DISABLED;

    }
}

