/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.text;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import java.nio.file.Paths;

final class LLSourceSection
extends LLVMSourceLocation.LazySourceSection {
    private final SourceSection section;

    LLSourceSection(SourceSection section) {
        this.section = section;
    }

    @Override
    public SourceSection get() {
        return this.section;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getPath() {
        return Paths.get(this.section.getSource().getPath(), new String[0]).toString();
    }

    @Override
    public int getLine() {
        return this.section.getStartLine();
    }

    @Override
    public int getColumn() {
        return this.section.getStartColumn();
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.section.getSource().getName() + ":" + this.getLine();
    }
}

