/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprBitFlipNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=DebugExprBitFlipNode.class)
public final class DebugExprBitFlipNodeGen
extends DebugExprBitFlipNode
implements GenerateAOT.Provider {
    @Node.Child
    private LLVMExpressionNode child_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private DebugExprBitFlipNodeGen(LLVMExpressionNode child) {
        this.child_ = child;
    }

    private boolean fallbackGuard_(int state_0, Object childValue) {
        if ((state_0 & 2) == 0 && childValue instanceof Boolean) {
            return false;
        }
        if ((state_0 & 4) == 0 && childValue instanceof Byte) {
            return false;
        }
        if ((state_0 & 8) == 0 && childValue instanceof Short) {
            return false;
        }
        if ((state_0 & 0x10) == 0 && childValue instanceof Character) {
            return false;
        }
        if ((state_0 & 0x20) == 0 && childValue instanceof Integer) {
            return false;
        }
        return (state_0 & 0x40) != 0 || !(childValue instanceof Long);
    }

    @Override
    public Object executeWithTarget(Object childValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(childValue);
        }
        if ((state_0 & 0xFE) != 0) {
            if ((state_0 & 2) != 0 && childValue instanceof Boolean) {
                boolean childValue_ = (Boolean)childValue;
                return this.flip(childValue_);
            }
            if ((state_0 & 4) != 0 && childValue instanceof Byte) {
                byte childValue_ = (Byte)childValue;
                return this.flip(childValue_);
            }
            if ((state_0 & 8) != 0 && childValue instanceof Short) {
                short childValue_ = (Short)childValue;
                return this.flip(childValue_);
            }
            if ((state_0 & 0x10) != 0 && childValue instanceof Character) {
                char childValue_ = ((Character)childValue).charValue();
                return Character.valueOf(this.flip(childValue_));
            }
            if ((state_0 & 0x20) != 0 && childValue instanceof Integer) {
                int childValue_ = (Integer)childValue;
                return this.flip(childValue_);
            }
            if ((state_0 & 0x40) != 0 && childValue instanceof Long) {
                long childValue_ = (Long)childValue;
                return this.flip(childValue_);
            }
            if ((state_0 & 0x80) != 0 && this.fallbackGuard_(state_0, childValue)) {
                return this.typeError(childValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(childValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0xFC) == 0 && (state_0 & 0xFE) != 0) {
            return this.executeGeneric_boolean0(state_0, frameValue);
        }
        if ((state_0 & 0xFA) == 0 && (state_0 & 0xFE) != 0) {
            return this.executeGeneric_byte1(state_0, frameValue);
        }
        if ((state_0 & 0xF6) == 0 && (state_0 & 0xFE) != 0) {
            return this.executeGeneric_short2(state_0, frameValue);
        }
        if ((state_0 & 0xDE) == 0 && (state_0 & 0xFE) != 0) {
            return this.executeGeneric_int3(state_0, frameValue);
        }
        if ((state_0 & 0xBE) == 0 && (state_0 & 0xFE) != 0) {
            return this.executeGeneric_long4(state_0, frameValue);
        }
        return this.executeGeneric_generic5(state_0, frameValue);
    }

    private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
        boolean childValue_;
        int state_0 = state_0__;
        try {
            childValue_ = this.child_.executeI1(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(childValue_);
        }
        assert ((state_0 & 2) != 0);
        return this.flip(childValue_);
    }

    private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
        byte childValue_;
        int state_0 = state_0__;
        try {
            childValue_ = this.child_.executeI8(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(childValue_);
        }
        assert ((state_0 & 4) != 0);
        return this.flip(childValue_);
    }

    private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
        short childValue_;
        int state_0 = state_0__;
        try {
            childValue_ = this.child_.executeI16(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(childValue_);
        }
        assert ((state_0 & 8) != 0);
        return this.flip(childValue_);
    }

    private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
        int childValue_;
        int state_0 = state_0__;
        try {
            childValue_ = this.child_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(childValue_);
        }
        assert ((state_0 & 0x20) != 0);
        return this.flip(childValue_);
    }

    private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
        long childValue_;
        int state_0 = state_0__;
        try {
            childValue_ = this.child_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(childValue_);
        }
        assert ((state_0 & 0x40) != 0);
        return this.flip(childValue_);
    }

    private Object executeGeneric_generic5(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object childValue_ = this.child_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(childValue_);
        }
        if ((state_0 & 0xFE) != 0) {
            if ((state_0 & 2) != 0 && childValue_ instanceof Boolean) {
                boolean childValue__ = (Boolean)childValue_;
                return this.flip(childValue__);
            }
            if ((state_0 & 4) != 0 && childValue_ instanceof Byte) {
                byte childValue__ = (Byte)childValue_;
                return this.flip(childValue__);
            }
            if ((state_0 & 8) != 0 && childValue_ instanceof Short) {
                short childValue__ = (Short)childValue_;
                return this.flip(childValue__);
            }
            if ((state_0 & 0x10) != 0 && childValue_ instanceof Character) {
                char childValue__ = ((Character)childValue_).charValue();
                return Character.valueOf(this.flip(childValue__));
            }
            if ((state_0 & 0x20) != 0 && childValue_ instanceof Integer) {
                int childValue__ = (Integer)childValue_;
                return this.flip(childValue__);
            }
            if ((state_0 & 0x40) != 0 && childValue_ instanceof Long) {
                long childValue__ = (Long)childValue_;
                return this.flip(childValue__);
            }
            if ((state_0 & 0x80) != 0 && this.fallbackGuard_(state_0, childValue_)) {
                return this.typeError(childValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(childValue_);
    }

    @Override
    public boolean executeI1(VirtualFrame frameValue) throws UnexpectedResultException {
        boolean childValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 0x80) != 0) {
            return LLVMTypesGen.expectBoolean(this.executeGeneric(frameValue));
        }
        try {
            childValue_ = this.child_.executeI1(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectBoolean(this.executeAndSpecialize(ex.getResult()));
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return LLVMTypesGen.expectBoolean(this.executeAndSpecialize(childValue_));
        }
        if ((state_0 & 2) != 0) {
            return this.flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectBoolean(this.executeAndSpecialize(childValue_));
    }

    @Override
    public byte executeI8(VirtualFrame frameValue) throws UnexpectedResultException {
        byte childValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 0x80) != 0) {
            return LLVMTypesGen.expectByte(this.executeGeneric(frameValue));
        }
        try {
            childValue_ = this.child_.executeI8(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectByte(this.executeAndSpecialize(ex.getResult()));
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return LLVMTypesGen.expectByte(this.executeAndSpecialize(childValue_));
        }
        if ((state_0 & 4) != 0) {
            return this.flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectByte(this.executeAndSpecialize(childValue_));
    }

    @Override
    public int executeI32(VirtualFrame frameValue) throws UnexpectedResultException {
        int childValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 0x80) != 0) {
            return LLVMTypesGen.expectInteger(this.executeGeneric(frameValue));
        }
        try {
            childValue_ = this.child_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult()));
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return LLVMTypesGen.expectInteger(this.executeAndSpecialize(childValue_));
        }
        if ((state_0 & 0x20) != 0) {
            return this.flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectInteger(this.executeAndSpecialize(childValue_));
    }

    @Override
    public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
        long childValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 0x80) != 0) {
            return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
        }
        try {
            childValue_ = this.child_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(childValue_));
        }
        if ((state_0 & 0x40) != 0) {
            return this.flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectLong(this.executeAndSpecialize(childValue_));
    }

    @Override
    public short executeI16(VirtualFrame frameValue) throws UnexpectedResultException {
        short childValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 0x80) != 0) {
            return LLVMTypesGen.expectShort(this.executeGeneric(frameValue));
        }
        try {
            childValue_ = this.child_.executeI16(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectShort(this.executeAndSpecialize(ex.getResult()));
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return LLVMTypesGen.expectShort(this.executeAndSpecialize(childValue_));
        }
        if ((state_0 & 8) != 0) {
            return this.flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectShort(this.executeAndSpecialize(childValue_));
    }

    private Object executeAndSpecialize(Object childValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (childValue instanceof Boolean) {
            boolean childValue_ = (Boolean)childValue;
            this.state_0_ = state_0 |= 2;
            return this.flip(childValue_);
        }
        if (childValue instanceof Byte) {
            byte childValue_ = (Byte)childValue;
            this.state_0_ = state_0 |= 4;
            return this.flip(childValue_);
        }
        if (childValue instanceof Short) {
            short childValue_ = (Short)childValue;
            this.state_0_ = state_0 |= 8;
            return this.flip(childValue_);
        }
        if (childValue instanceof Character) {
            char childValue_ = ((Character)childValue).charValue();
            this.state_0_ = state_0 |= 0x10;
            return Character.valueOf(this.flip(childValue_));
        }
        if (childValue instanceof Integer) {
            int childValue_ = (Integer)childValue;
            this.state_0_ = state_0 |= 0x20;
            return this.flip(childValue_);
        }
        if (childValue instanceof Long) {
            long childValue_ = (Long)childValue;
            this.state_0_ = state_0 |= 0x40;
            return this.flip(childValue_);
        }
        this.state_0_ = state_0 |= 0x80;
        return this.typeError(childValue);
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0xFE) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0xFE & (state_0 & 0xFE) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        this.state_0_ |= 4;
        this.state_0_ |= 8;
        this.state_0_ |= 0x10;
        this.state_0_ |= 0x20;
        this.state_0_ |= 0x40;
        this.state_0_ |= 0x80;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static DebugExprBitFlipNode create(LLVMExpressionNode child) {
        return new DebugExprBitFlipNodeGen(child);
    }
}

