/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.export;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GenerateUncached
public abstract class LLVMForeignWriteNode
extends LLVMNode {
    static final int VALUE_KIND_COUNT = LLVMInteropType.ValueKind.values().length;

    public abstract void execute(LLVMPointer var1, LLVMInteropType var2, Object var3) throws UnsupportedMessageException;

    @Specialization(guards={"type.kind == cachedKind"}, limit="VALUE_KIND_COUNT")
    @GenerateAOT.Exclude
    static void doValue(LLVMPointer ptr, LLVMInteropType.Value type, Object value, @Cached(value="type.kind", allowUncached=true) LLVMInteropType.ValueKind cachedKind, @Cached(parameters={"cachedKind"}) LLVMOffsetStoreNode store, @Cached(value="createForeignToLLVM(type)", uncached="getSlowPath()") ForeignToLLVM toLLVM) {
        Object llvmValue = toLLVM.executeWithForeignToLLVMType(value, type.baseType, cachedKind.foreignToLLVMType);
        store.executeWithTargetGeneric(ptr, 0L, llvmValue);
    }

    @Specialization
    static void doStructured(LLVMPointer ptr, LLVMInteropType.Structured type, Object value) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    protected ForeignToLLVM createForeignToLLVM(LLVMInteropType.Value type) {
        return CommonNodeFactory.createForeignToLLVM(type);
    }
}

