/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMManagedReadLibrary.class)
final class LLVMManagedReadLibraryGen
extends LibraryFactory<LLVMManagedReadLibrary> {
    private static final Class<LLVMManagedReadLibrary> LIBRARY_CLASS = LLVMManagedReadLibraryGen.lazyLibraryClass();
    private static final Message IS_READABLE = new MessageImpl("isReadable", 0, false, Boolean.TYPE, Object.class);
    private static final Message READ_I8 = new MessageImpl("readI8", 1, false, Byte.TYPE, Object.class, Long.TYPE);
    private static final Message READ_I16 = new MessageImpl("readI16", 2, false, Short.TYPE, Object.class, Long.TYPE);
    private static final Message READ_I32 = new MessageImpl("readI32", 3, false, Integer.TYPE, Object.class, Long.TYPE);
    private static final Message READ_FLOAT = new MessageImpl("readFloat", 4, false, Float.TYPE, Object.class, Long.TYPE);
    private static final Message READ_I64 = new MessageImpl("readI64", 5, false, Long.TYPE, Object.class, Long.TYPE);
    private static final Message READ_DOUBLE = new MessageImpl("readDouble", 6, false, Double.TYPE, Object.class, Long.TYPE);
    private static final Message READ_POINTER = new MessageImpl("readPointer", 7, false, LLVMPointer.class, Object.class, Long.TYPE);
    private static final Message READ_GENERIC_I64 = new MessageImpl("readGenericI64", 8, false, Object.class, Object.class, Long.TYPE);
    private static final LLVMManagedReadLibraryGen INSTANCE = new LLVMManagedReadLibraryGen();

    private LLVMManagedReadLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(IS_READABLE, READ_I8, READ_I16, READ_I32, READ_FLOAT, READ_I64, READ_DOUBLE, READ_POINTER, READ_GENERIC_I64)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof byte[]) {
            return LLVMManagedAccessDefaults.VirtualAlloc.class;
        }
        return LLVMManagedAccessDefaults.FallbackRead.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected LLVMManagedReadLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected LLVMManagedReadLibrary createDelegate(LLVMManagedReadLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        LLVMManagedReadLibrary lib = (LLVMManagedReadLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.isReadable(receiver);
            }
            case 1: {
                return lib.readI8(receiver, (Long)args[offset]);
            }
            case 2: {
                return lib.readI16(receiver, (Long)args[offset]);
            }
            case 3: {
                return lib.readI32(receiver, (Long)args[offset]);
            }
            case 4: {
                return Float.valueOf(lib.readFloat(receiver, (Long)args[offset]));
            }
            case 5: {
                return lib.readI64(receiver, (Long)args[offset]);
            }
            case 6: {
                return lib.readDouble(receiver, (Long)args[offset]);
            }
            case 7: {
                return lib.readPointer(receiver, (Long)args[offset]);
            }
            case 8: {
                return lib.readGenericI64(receiver, (Long)args[offset]);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected LLVMManagedReadLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected LLVMManagedReadLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<LLVMManagedReadLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary", false, LLVMManagedReadLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    private static final class Proxy
    extends LLVMManagedReadLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isReadable(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_READABLE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public byte readI8(Object receiver_, long offset) {
            try {
                return (Byte)this.lib.send(receiver_, READ_I8, new Object[]{offset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public short readI16(Object receiver_, long offset) {
            try {
                return (Short)this.lib.send(receiver_, READ_I16, new Object[]{offset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int readI32(Object receiver_, long offset) {
            try {
                return (Integer)this.lib.send(receiver_, READ_I32, new Object[]{offset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public float readFloat(Object receiver_, long offset) {
            try {
                return ((Float)this.lib.send(receiver_, READ_FLOAT, new Object[]{offset})).floatValue();
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long readI64(Object receiver_, long offset) throws UnexpectedResultException {
            try {
                return (Long)this.lib.send(receiver_, READ_I64, new Object[]{offset});
            }
            catch (UnexpectedResultException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public double readDouble(Object receiver_, long offset) {
            try {
                return (Double)this.lib.send(receiver_, READ_DOUBLE, new Object[]{offset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public LLVMPointer readPointer(Object receiver_, long offset) {
            try {
                return (LLVMPointer)this.lib.send(receiver_, READ_POINTER, new Object[]{offset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object readGenericI64(Object receiver_, long offset) {
            try {
                return this.lib.send(receiver_, READ_GENERIC_I64, new Object[]{offset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    private static final class Delegate
    extends LLVMManagedReadLibrary {
        @Node.Child
        private LLVMManagedReadLibrary delegateLibrary;

        Delegate(LLVMManagedReadLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isReadable(Object receiver_) {
            if (LLVMManagedReadLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = LLVMManagedReadLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMManagedReadLibrary)LLVMManagedReadLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isReadable(delegate);
            }
            return this.delegateLibrary.isReadable(receiver_);
        }

        @Override
        public byte readI8(Object receiver_, long offset) {
            if (LLVMManagedReadLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = LLVMManagedReadLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMManagedReadLibrary)LLVMManagedReadLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readI8(delegate, offset);
            }
            return this.delegateLibrary.readI8(receiver_, offset);
        }

        @Override
        public short readI16(Object receiver_, long offset) {
            if (LLVMManagedReadLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = LLVMManagedReadLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMManagedReadLibrary)LLVMManagedReadLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readI16(delegate, offset);
            }
            return this.delegateLibrary.readI16(receiver_, offset);
        }

        @Override
        public int readI32(Object receiver_, long offset) {
            if (LLVMManagedReadLibraryGen.isDelegated((Library)this.delegateLibrary, (int)3)) {
                Object delegate = LLVMManagedReadLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMManagedReadLibrary)LLVMManagedReadLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readI32(delegate, offset);
            }
            return this.delegateLibrary.readI32(receiver_, offset);
        }

        @Override
        public float readFloat(Object receiver_, long offset) {
            if (LLVMManagedReadLibraryGen.isDelegated((Library)this.delegateLibrary, (int)4)) {
                Object delegate = LLVMManagedReadLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMManagedReadLibrary)LLVMManagedReadLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readFloat(delegate, offset);
            }
            return this.delegateLibrary.readFloat(receiver_, offset);
        }

        @Override
        public long readI64(Object receiver_, long offset) throws UnexpectedResultException {
            if (LLVMManagedReadLibraryGen.isDelegated((Library)this.delegateLibrary, (int)5)) {
                Object delegate = LLVMManagedReadLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMManagedReadLibrary)LLVMManagedReadLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readI64(delegate, offset);
            }
            return this.delegateLibrary.readI64(receiver_, offset);
        }

        @Override
        public double readDouble(Object receiver_, long offset) {
            if (LLVMManagedReadLibraryGen.isDelegated((Library)this.delegateLibrary, (int)6)) {
                Object delegate = LLVMManagedReadLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMManagedReadLibrary)LLVMManagedReadLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readDouble(delegate, offset);
            }
            return this.delegateLibrary.readDouble(receiver_, offset);
        }

        @Override
        public LLVMPointer readPointer(Object receiver_, long offset) {
            if (LLVMManagedReadLibraryGen.isDelegated((Library)this.delegateLibrary, (int)7)) {
                Object delegate = LLVMManagedReadLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMManagedReadLibrary)LLVMManagedReadLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readPointer(delegate, offset);
            }
            return this.delegateLibrary.readPointer(receiver_, offset);
        }

        @Override
        public Object readGenericI64(Object receiver_, long offset) {
            if (LLVMManagedReadLibraryGen.isDelegated((Library)this.delegateLibrary, (int)8)) {
                Object delegate = LLVMManagedReadLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMManagedReadLibrary)LLVMManagedReadLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readGenericI64(delegate, offset);
            }
            return this.delegateLibrary.readGenericI64(receiver_, offset);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch
    implements GenerateAOT.Provider {
        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(LLVMManagedReadLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport export : INSTANCE.getAOTExports()) {
                LLVMManagedReadLibrary exportLibrary = (LLVMManagedReadLibrary)INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = (LLVMManagedReadLibrary)this.insert((Node)exportLibrary);
                    continue;
                }
                this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext(exportLibrary, this.next));
            }
            this.aot_ = true;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    private static abstract class CachedDispatch
    extends LLVMManagedReadLibrary {
        @Node.Child
        LLVMManagedReadLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(LLVMManagedReadLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean var1);

        @Override
        @ExplodeLoop
        public boolean isReadable(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isReadable(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public byte readI8(Object receiver_, long offset) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readI8(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public short readI16(Object receiver_, long offset) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readI16(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int readI32(Object receiver_, long offset) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readI32(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public float readFloat(Object receiver_, long offset) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readFloat(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long readI64(Object receiver_, long offset) throws UnexpectedResultException {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readI64(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public double readDouble(Object receiver_, long offset) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readDouble(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public LLVMPointer readPointer(Object receiver_, long offset) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readPointer(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object readGenericI64(Object receiver_, long offset) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readGenericI64(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                if (this.isAOT()) {
                    this.library = null;
                    this.next = null;
                    this.setAOT(false);
                }
                CachedDispatch current = this;
                LLVMManagedReadLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (LLVMManagedReadLibrary)this.insert((Node)((LLVMManagedReadLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        LLVMManagedReadLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (LLVMManagedReadLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((LLVMManagedReadLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends LLVMManagedReadLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isReadable(Object receiver_) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).isReadable(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public byte readI8(Object receiver_, long offset) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI8(receiver_, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public short readI16(Object receiver_, long offset) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI16(receiver_, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int readI32(Object receiver_, long offset) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI32(receiver_, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public float readFloat(Object receiver_, long offset) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readFloat(receiver_, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long readI64(Object receiver_, long offset) throws UnexpectedResultException {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI64(receiver_, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public double readDouble(Object receiver_, long offset) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readDouble(receiver_, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public LLVMPointer readPointer(Object receiver_, long offset) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readPointer(receiver_, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readGenericI64(Object receiver_, long offset) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readGenericI64(receiver_, offset);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(LLVMManagedReadLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    private static final class CachedToUncachedDispatch
    extends LLVMManagedReadLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isReadable(Object receiver_) {
            assert (LLVMManagedReadLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).isReadable(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public byte readI8(Object receiver_, long offset) {
            assert (LLVMManagedReadLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                byte by = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI8(receiver_, offset);
                return by;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public short readI16(Object receiver_, long offset) {
            assert (LLVMManagedReadLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                short s = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI16(receiver_, offset);
                return s;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int readI32(Object receiver_, long offset) {
            assert (LLVMManagedReadLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI32(receiver_, offset);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public float readFloat(Object receiver_, long offset) {
            assert (LLVMManagedReadLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                float f = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readFloat(receiver_, offset);
                return f;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long readI64(Object receiver_, long offset) throws UnexpectedResultException {
            assert (LLVMManagedReadLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI64(receiver_, offset);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public double readDouble(Object receiver_, long offset) {
            assert (LLVMManagedReadLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                double d = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readDouble(receiver_, offset);
                return d;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public LLVMPointer readPointer(Object receiver_, long offset) {
            assert (LLVMManagedReadLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                LLVMPointer lLVMPointer = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readPointer(receiver_, offset);
                return lLVMPointer;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readGenericI64(Object receiver_, long offset) {
            assert (LLVMManagedReadLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readGenericI64(receiver_, offset);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

