/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMWindowsInitThreadIntrinsics;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMWindowsInitThreadIntrinsics.class)
public final class LLVMWindowsInitThreadIntrinsicsFactory {

    @GeneratedBy(value=LLVMWindowsInitThreadIntrinsics.InitThreadNotify.class)
    public static final class InitThreadNotifyNodeGen
    extends LLVMWindowsInitThreadIntrinsics.InitThreadNotify
    implements GenerateAOT.Provider {
        private InitThreadNotifyNodeGen() {
        }

        @Override
        Object execute() {
            return this.doWait();
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doWait();
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMWindowsInitThreadIntrinsics.InitThreadNotify create() {
            return new InitThreadNotifyNodeGen();
        }
    }

    @GeneratedBy(value=LLVMWindowsInitThreadIntrinsics.InitThreadWait.class)
    public static final class InitThreadWaitNodeGen
    extends LLVMWindowsInitThreadIntrinsics.InitThreadWait
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode timeout_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private InitThreadWaitNodeGen(LLVMExpressionNode timeout) {
            this.timeout_ = timeout;
        }

        @Override
        Object execute(int timeoutValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(timeoutValue);
            }
            if ((state_0 & 2) != 0) {
                return this.doWait(timeoutValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(timeoutValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int timeoutValue_;
            int state_0 = this.state_0_;
            try {
                timeoutValue_ = this.timeout_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(timeoutValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doWait(timeoutValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(timeoutValue_);
        }

        private Object executeAndSpecialize(Object timeoutValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (timeoutValue instanceof Integer) {
                int timeoutValue_ = (Integer)timeoutValue;
                this.state_0_ = state_0 |= 2;
                return this.doWait(timeoutValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.timeout_}, new Object[]{timeoutValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMWindowsInitThreadIntrinsics.InitThreadWait create(LLVMExpressionNode timeout) {
            return new InitThreadWaitNodeGen(timeout);
        }
    }

    @GeneratedBy(value=LLVMWindowsInitThreadIntrinsics.InitThreadUnlock.class)
    public static final class InitThreadUnlockNodeGen
    extends LLVMWindowsInitThreadIntrinsics.InitThreadUnlock
    implements GenerateAOT.Provider {
        private InitThreadUnlockNodeGen() {
        }

        @Override
        Object execute() {
            return this.doUnlock();
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doUnlock();
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMWindowsInitThreadIntrinsics.InitThreadUnlock create() {
            return new InitThreadUnlockNodeGen();
        }
    }

    @GeneratedBy(value=LLVMWindowsInitThreadIntrinsics.InitThreadLock.class)
    public static final class InitThreadLockNodeGen
    extends LLVMWindowsInitThreadIntrinsics.InitThreadLock
    implements GenerateAOT.Provider {
        private InitThreadLockNodeGen() {
        }

        @Override
        Object execute() {
            return this.doLock();
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doLock();
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMWindowsInitThreadIntrinsics.InitThreadLock create() {
            return new InitThreadLockNodeGen();
        }
    }
}

