/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.aarch64.darwin;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMVarArgCompoundValue;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMSourceTypeFactory;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.memory.NativeProfiledMemMove;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDoubleLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMMaybeVaPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

@ExportLibrary.Repeat(value={@ExportLibrary(value=LLVMManagedReadLibrary.class, useForAOT=true, useForAOTPriority=3), @ExportLibrary(value=LLVMVaListLibrary.class, useForAOT=true, useForAOTPriority=2), @ExportLibrary(value=NativeTypeLibrary.class, useForAOT=true, useForAOTPriority=1), @ExportLibrary(value=InteropLibrary.class)})
public final class LLVMDarwinAarch64VaListStorage
extends LLVMVaListStorage {
    public static final PointerType VA_LIST_TYPE = PointerType.I8;
    DarwinAArch64ArgsArea argsArea;
    private int consumedBytes;

    public LLVMDarwinAarch64VaListStorage() {
        super(null);
    }

    @ExportMessage
    static void initialize(LLVMDarwinAarch64VaListStorage self, Object[] realArguments, int numberOfExplicitArguments, Frame frame, @Cached.Exclusive @Cached(parameters={"KEEP_32BIT_PRIMITIVES_IN_STRUCTS"}) LLVMVaListStorage.ArgumentListExpander argsExpander, @Cached.Exclusive @Cached LLVMVaListStorage.StackAllocationNode stackAllocationNode) {
        Object[][][] expansionsOutArg = new Object[1][][];
        self.realArguments = argsExpander.expand(realArguments, expansionsOutArg);
        self.numberOfExplicitArguments = numberOfExplicitArguments;
        self.argsArea = new DarwinAArch64ArgsArea(self.realArguments, numberOfExplicitArguments);
        long stackSize = 0L;
        for (int i = numberOfExplicitArguments; i < self.realArguments.length; ++i) {
            Object o = self.realArguments[i];
            if (o instanceof LLVMVarArgCompoundValue) {
                stackSize += LLVMDarwinAarch64VaListStorage.alignUp(((LLVMVarArgCompoundValue)o).getSize());
                continue;
            }
            stackSize += 8L;
        }
        self.vaListStackPtr = stackAllocationNode.executeWithTarget(stackSize, frame);
        self.nativized = false;
    }

    private static long alignUp(long address) {
        long mask = 7L;
        return address + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @ExportMessage
    boolean hasNativeType() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getNativeType() {
        return LLVMLanguage.get(null).getInteropType(LLVMSourceTypeFactory.resolveType(VA_LIST_TYPE, LLVMDarwinAarch64VaListStorage.findDataLayoutFromCurrentFrame()));
    }

    @ExportMessage
    boolean isReadable() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void toNative(@Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64RegSaveAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32RegSaveAreaStore, @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitRegSaveAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerRegSaveAreaStore, @Cached NativeProfiledMemMove memMove, @Cached BranchProfile nativizedProfile) {
        if (this.isNativized()) {
            nativizedProfile.enter();
            return;
        }
        this.nativized = true;
        int vaLength = this.realArguments.length - this.numberOfExplicitArguments;
        assert (vaLength >= 0) : vaLength;
        long offset = 0L;
        for (int i = this.numberOfExplicitArguments; i < this.realArguments.length; ++i) {
            Object object = this.realArguments[i];
            long size = LLVMDarwinAarch64VaListStorage.storeArgument(this.vaListStackPtr, offset, memMove, i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, object, 4);
            assert (size <= 8L);
            offset += 8L;
        }
    }

    @ExportMessage
    void cleanup(Frame frame) {
        throw CompilerDirectives.shouldNotReachHere((String)"should only be called on LLVMMaybeVaPointer");
    }

    @ExportMessage
    void copy(Object dest, Frame frame) {
        throw CompilerDirectives.shouldNotReachHere((String)"should never be called directly");
    }

    @ExportMessage
    Object shift(Type type, Frame frame, @CachedLibrary(limit="1") LLVMManagedReadLibrary readLib) {
        try {
            if (type instanceof PrimitiveType) {
                switch (((PrimitiveType)type).getPrimitiveKind()) {
                    case DOUBLE: {
                        Double d = readLib.readDouble(this, this.consumedBytes);
                        return d;
                    }
                    case FLOAT: {
                        Float f = Float.valueOf(readLib.readFloat(this, this.consumedBytes));
                        return f;
                    }
                    case I1: {
                        Boolean bl = readLib.readI8(this, this.consumedBytes) != 0;
                        return bl;
                    }
                    case I16: {
                        Short s = readLib.readI16(this, this.consumedBytes);
                        return s;
                    }
                    case I32: {
                        Integer n = readLib.readI32(this, this.consumedBytes);
                        return n;
                    }
                    case I64: {
                        Object object = readLib.readGenericI64(this, this.consumedBytes);
                        return object;
                    }
                    case I8: {
                        Byte by = readLib.readI8(this, this.consumedBytes);
                        return by;
                    }
                }
                throw CompilerDirectives.shouldNotReachHere((String)"not implemented");
            }
            if (type instanceof PointerType) {
                LLVMPointer lLVMPointer = readLib.readPointer(this, this.consumedBytes);
                return lLVMPointer;
            }
            throw CompilerDirectives.shouldNotReachHere((String)"not implemented");
        }
        finally {
            this.consumedBytes += 8;
        }
    }

    static final class DarwinAArch64ArgsArea
    extends LLVMVaListStorage.ArgsArea {
        private final int numOfExpArgs;

        DarwinAArch64ArgsArea(Object[] args, int numOfExpArgs) {
            super(args);
            this.numOfExpArgs = numOfExpArgs;
        }

        @Override
        protected long offsetToIndex(long offset) {
            if (offset < 0L) {
                return -1L;
            }
            long argIndex = offset / 8L + (long)this.numOfExpArgs;
            long argOffset = offset % 8L;
            return argIndex + (argOffset << 32);
        }
    }

    @GenerateUncached
    public static abstract class Aarch64VAListPointerWrapperFactory
    extends LLVMVaListStorage.VAListPointerWrapperFactory {
        public abstract Object execute(Object var1);

        @Specialization(guards={"!isManagedPointer(p)"})
        Object createNativeWrapper(LLVMPointer p) {
            return LLVMMaybeVaPointer.createWithHeap(p);
        }

        @Specialization(limit="3", guards={"isManagedPointer(p)", "isGlobal(p)"})
        @GenerateAOT.Exclude
        Object extractFromGlobal(LLVMManagedPointer p, @Bind(value="getGlobal(p)") Object global, @CachedLibrary(value="global") LLVMManagedReadLibrary readLibrary) {
            Object ret = readLibrary.readGenericI64(global, 0L);
            if (ret instanceof LLVMDarwinAarch64VaListStorage) {
                return LLVMMaybeVaPointer.createWithStorage(p, ret);
            }
            if (ret instanceof LLVMMaybeVaPointer) {
                return ret;
            }
            assert (LLVMManagedPointer.isInstance(p));
            return LLVMMaybeVaPointer.createWithHeap(p);
        }

        @Specialization(guards={"isManagedPointer(p)", "!isGlobal(p)"})
        Object extractFromManaged(LLVMManagedPointer p) {
            assert (p.getObject() instanceof LLVMMaybeVaPointer);
            return p.getObject();
        }

        static boolean isManagedPointer(Object o) {
            return LLVMManagedPointer.isInstance(o);
        }

        static boolean isGlobal(Object o) {
            return LLVMManagedPointer.cast(o).getObject() instanceof LLVMGlobalContainer;
        }

        static Object getGlobal(Object o) {
            return LLVMManagedPointer.cast(o).getObject();
        }
    }

    @ExportMessage
    static class ReadGenericI64 {
        ReadGenericI64() {
        }

        @Specialization(guards={"vaList.isNativized()"})
        @GenerateAOT.Exclude
        static Object readNativeGenericI64(LLVMDarwinAarch64VaListStorage vaList, long offset, @Cached LLVMI64LoadNode.LLVMI64OffsetLoadNode llvmi64OffsetLoadNode) {
            return llvmi64OffsetLoadNode.executeWithTargetGeneric(vaList.vaListStackPtr, offset);
        }

        @Specialization(guards={"!vaList.isNativized()"}, limit="1")
        static Object readI64Managed(LLVMDarwinAarch64VaListStorage vaList, long offset, @CachedLibrary(value="vaList.argsArea") LLVMManagedReadLibrary readLibrary) {
            return readLibrary.readGenericI64(vaList.argsArea, offset);
        }
    }

    @ExportMessage
    static class ReadDouble {
        ReadDouble() {
        }

        @Specialization(guards={"vaList.isNativized()"})
        @GenerateAOT.Exclude
        static double readNativeDouble(LLVMDarwinAarch64VaListStorage vaList, long offset, @Cached LLVMDoubleLoadNode.LLVMDoubleOffsetLoadNode doubleOffsetLoadNode) {
            return doubleOffsetLoadNode.executeWithTarget(vaList.vaListStackPtr, offset);
        }

        @Specialization(guards={"!vaList.isNativized()"}, limit="1")
        static double readDoubleManaged(LLVMDarwinAarch64VaListStorage vaList, long offset, @CachedLibrary(value="vaList.argsArea") LLVMManagedReadLibrary readLibrary) {
            return readLibrary.readDouble(vaList.argsArea, offset);
        }
    }

    @ExportMessage
    static class ReadPointer {
        ReadPointer() {
        }

        @Specialization(guards={"vaList.isNativized()"})
        @GenerateAOT.Exclude
        static LLVMPointer readNativePointer(LLVMDarwinAarch64VaListStorage vaList, long offset, @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(vaList.vaListStackPtr, offset);
        }

        @Specialization(guards={"!vaList.isNativized()"}, limit="1")
        static LLVMPointer readPointerManaged(LLVMDarwinAarch64VaListStorage vaList, long offset, @CachedLibrary(value="vaList.argsArea") LLVMManagedReadLibrary readLibrary) {
            return readLibrary.readPointer(vaList.argsArea, offset);
        }
    }

    @ExportMessage
    static class ReadI32 {
        ReadI32() {
        }

        @Specialization(guards={"vaList.isNativized()"})
        @GenerateAOT.Exclude
        static int readNativeI32(LLVMDarwinAarch64VaListStorage vaList, long offset, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(vaList.vaListStackPtr, offset);
        }

        @Specialization(guards={"!vaList.isNativized()"}, limit="1")
        static int readI32Managed(LLVMDarwinAarch64VaListStorage vaList, long offset, @CachedLibrary(value="vaList.argsArea") LLVMManagedReadLibrary readLibrary) {
            return readLibrary.readI32(vaList.argsArea, offset);
        }
    }

    @ExportMessage
    static class ReadI16 {
        ReadI16() {
        }

        @Specialization(guards={"vaList.isNativized()"})
        @GenerateAOT.Exclude
        static short readNativeI16(LLVMDarwinAarch64VaListStorage vaList, long offset, @Cached LLVMI16LoadNode.LLVMI16OffsetLoadNode offsetLoadNode) {
            return offsetLoadNode.executeWithTarget(vaList.vaListStackPtr, offset);
        }

        @Specialization(guards={"!vaList.isNativized()"}, limit="1")
        static short readI16Managed(LLVMDarwinAarch64VaListStorage vaList, long offset, @CachedLibrary(value="vaList.argsArea") LLVMManagedReadLibrary readLibrary) {
            return readLibrary.readI16(vaList.argsArea, offset);
        }
    }

    @ExportMessage
    static class ReadI8 {
        ReadI8() {
        }

        @Specialization(guards={"vaList.isNativized()"})
        @GenerateAOT.Exclude
        static byte readNativeI8(LLVMDarwinAarch64VaListStorage vaList, long offset, @Cached LLVMI8LoadNode.LLVMI8OffsetLoadNode offsetLoadNode) {
            return offsetLoadNode.executeWithTarget(vaList.vaListStackPtr, offset);
        }

        @Specialization(guards={"!vaList.isNativized()"}, limit="1")
        static byte readI8Managed(LLVMDarwinAarch64VaListStorage vaList, long offset, @CachedLibrary(value="vaList.argsArea") LLVMManagedReadLibrary readLibrary) {
            return readLibrary.readI8(vaList.argsArea, offset);
        }
    }
}

