/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vars;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMWriteNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMWriteNode.class)
public final class LLVMWriteNodeFactory {

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteVectorNode.class)
    public static final class LLVMWriteVectorNodeGen
    extends LLVMWriteNode.LLVMWriteVectorNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteVectorNodeGen(int slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue);
                return;
            }
            if ((state_0 & 2) != 0 && valueNodeValue instanceof LLVMVector) {
                LLVMVector valueNodeValue_ = (LLVMVector)valueNodeValue;
                this.writeVector(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue_);
                return;
            }
            if ((state_0 & 2) != 0 && valueNodeValue_ instanceof LLVMVector) {
                LLVMVector valueNodeValue__ = (LLVMVector)valueNodeValue_;
                this.writeVector(frameValue, valueNodeValue__);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueNodeValue instanceof LLVMVector) {
                LLVMVector valueNodeValue_ = (LLVMVector)valueNodeValue;
                this.state_0_ = state_0 |= 2;
                this.writeVector(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMWriteNode.LLVMWriteVectorNode create(int slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteVectorNodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWritePointerNode.class)
    public static final class LLVMWritePointerNodeGen
    extends LLVMWriteNode.LLVMWritePointerNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWritePointerNodeGen(int slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        private boolean fallbackGuard_(int state_0, Object valueNodeValue) {
            return (state_0 & 2) != 0 || !(valueNodeValue instanceof Long);
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue);
                return;
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && valueNodeValue instanceof Long) {
                    long valueNodeValue_ = (Long)valueNodeValue;
                    this.writeLong(frameValue, valueNodeValue_);
                    return;
                }
                if ((state_0 & 4) != 0 && this.fallbackGuard_(state_0, valueNodeValue)) {
                    this.writeObject(frameValue, valueNodeValue);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                this.execute_long0(state_0, frameValue);
                return;
            }
            this.execute_generic1(state_0, frameValue);
        }

        private void execute_long0(int state_0__, VirtualFrame frameValue) {
            long valueNodeValue_;
            int state_0 = state_0__;
            try {
                valueNodeValue_ = this.valueNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue_);
                return;
            }
            assert ((state_0 & 2) != 0);
            this.writeLong(frameValue, valueNodeValue_);
        }

        private void execute_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue_);
                return;
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && valueNodeValue_ instanceof Long) {
                    long valueNodeValue__ = (Long)valueNodeValue_;
                    this.writeLong(frameValue, valueNodeValue__);
                    return;
                }
                if ((state_0 & 4) != 0 && this.fallbackGuard_(state_0, valueNodeValue_)) {
                    this.writeObject(frameValue, valueNodeValue_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueNodeValue instanceof Long) {
                long valueNodeValue_ = (Long)valueNodeValue;
                this.state_0_ = state_0 |= 2;
                this.writeLong(frameValue, valueNodeValue_);
                return;
            }
            this.state_0_ = state_0 |= 4;
            this.writeObject(frameValue, valueNodeValue);
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMWriteNode.LLVMWritePointerNode create(int slot, LLVMExpressionNode valueNode) {
            return new LLVMWritePointerNodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWrite128BitFloatingNode.class)
    public static final class LLVMWrite128BitFloatingNodeGen
    extends LLVMWriteNode.LLVMWrite128BitFloatingNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWrite128BitFloatingNodeGen(int slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue);
                return;
            }
            if ((state_0 & 2) != 0 && valueNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat valueNodeValue_ = (LLVM128BitFloat)valueNodeValue;
                this.write128BitFloat(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue_);
                return;
            }
            if ((state_0 & 2) != 0 && valueNodeValue_ instanceof LLVM128BitFloat) {
                LLVM128BitFloat valueNodeValue__ = (LLVM128BitFloat)valueNodeValue_;
                this.write128BitFloat(frameValue, valueNodeValue__);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat valueNodeValue_ = (LLVM128BitFloat)valueNodeValue;
                this.state_0_ = state_0 |= 2;
                this.write128BitFloat(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMWriteNode.LLVMWrite128BitFloatingNode create(int slot, LLVMExpressionNode valueNode) {
            return new LLVMWrite128BitFloatingNodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWrite80BitFloatingNode.class)
    public static final class LLVMWrite80BitFloatingNodeGen
    extends LLVMWriteNode.LLVMWrite80BitFloatingNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWrite80BitFloatingNodeGen(int slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue);
                return;
            }
            if ((state_0 & 2) != 0 && valueNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat valueNodeValue_ = (LLVM80BitFloat)valueNodeValue;
                this.write80BitFloat(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue_);
                return;
            }
            if ((state_0 & 2) != 0 && valueNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat valueNodeValue__ = (LLVM80BitFloat)valueNodeValue_;
                this.write80BitFloat(frameValue, valueNodeValue__);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat valueNodeValue_ = (LLVM80BitFloat)valueNodeValue;
                this.state_0_ = state_0 |= 2;
                this.write80BitFloat(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMWriteNode.LLVMWrite80BitFloatingNode create(int slot, LLVMExpressionNode valueNode) {
            return new LLVMWrite80BitFloatingNodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteDoubleNode.class)
    public static final class LLVMWriteDoubleNodeGen
    extends LLVMWriteNode.LLVMWriteDoubleNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteDoubleNodeGen(int slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue);
                return;
            }
            if ((state_0 & 2) != 0 && valueNodeValue instanceof Double) {
                double valueNodeValue_ = (Double)valueNodeValue;
                this.writeDouble(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            double valueNodeValue_;
            int state_0 = this.state_0_;
            try {
                valueNodeValue_ = this.valueNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue_);
                return;
            }
            if ((state_0 & 2) != 0) {
                this.writeDouble(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueNodeValue instanceof Double) {
                double valueNodeValue_ = (Double)valueNodeValue;
                this.state_0_ = state_0 |= 2;
                this.writeDouble(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMWriteNode.LLVMWriteDoubleNode create(int slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteDoubleNodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteFloatNode.class)
    public static final class LLVMWriteFloatNodeGen
    extends LLVMWriteNode.LLVMWriteFloatNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteFloatNodeGen(int slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue);
                return;
            }
            if ((state_0 & 2) != 0 && valueNodeValue instanceof Float) {
                float valueNodeValue_ = ((Float)valueNodeValue).floatValue();
                this.writeFloat(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            float valueNodeValue_;
            int state_0 = this.state_0_;
            try {
                valueNodeValue_ = this.valueNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, Float.valueOf(valueNodeValue_));
                return;
            }
            if ((state_0 & 2) != 0) {
                this.writeFloat(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, Float.valueOf(valueNodeValue_));
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueNodeValue instanceof Float) {
                float valueNodeValue_ = ((Float)valueNodeValue).floatValue();
                this.state_0_ = state_0 |= 2;
                this.writeFloat(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMWriteNode.LLVMWriteFloatNode create(int slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteFloatNodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteIVarBitNode.class)
    public static final class LLVMWriteIVarBitNodeGen
    extends LLVMWriteNode.LLVMWriteIVarBitNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteIVarBitNodeGen(int slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue);
                return;
            }
            if ((state_0 & 2) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x1C) >>> 2, valueNodeValue)) {
                LLVMIVarBit valueNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x1C) >>> 2, valueNodeValue);
                this.writeIVarBit(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue_);
                return;
            }
            if ((state_0 & 2) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x1C) >>> 2, valueNodeValue_)) {
                LLVMIVarBit valueNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x1C) >>> 2, valueNodeValue_);
                this.writeIVarBit(frameValue, valueNodeValue__);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int lLVMIVarBitCast0;
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if ((lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(valueNodeValue)) != 0) {
                LLVMIVarBit valueNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, valueNodeValue);
                state_0 |= lLVMIVarBitCast0 << 2;
                this.state_0_ = state_0 |= 2;
                this.writeIVarBit(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            state_0 |= 1;
            this.state_0_ = state_0 |= 0x1C;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMWriteNode.LLVMWriteIVarBitNode create(int slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteIVarBitNodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteI64Node.class)
    public static final class LLVMWriteI64NodeGen
    extends LLVMWriteNode.LLVMWriteI64Node
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteI64NodeGen(int slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue);
                return;
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && valueNodeValue instanceof Long) {
                    long valueNodeValue_ = (Long)valueNodeValue;
                    this.writeI64(frameValue, valueNodeValue_);
                    return;
                }
                if ((state_0 & 4) != 0) {
                    this.writePointer(frameValue, valueNodeValue);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                this.execute_long0(state_0, frameValue);
                return;
            }
            this.execute_generic1(state_0, frameValue);
        }

        private void execute_long0(int state_0__, VirtualFrame frameValue) {
            long valueNodeValue_;
            int state_0 = state_0__;
            try {
                valueNodeValue_ = this.valueNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue_);
                return;
            }
            assert ((state_0 & 2) != 0);
            this.writeI64(frameValue, valueNodeValue_);
        }

        private void execute_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue_);
                return;
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && valueNodeValue_ instanceof Long) {
                    long valueNodeValue__ = (Long)valueNodeValue_;
                    this.writeI64(frameValue, valueNodeValue__);
                    return;
                }
                if ((state_0 & 4) != 0) {
                    this.writePointer(frameValue, valueNodeValue_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if ((state_0 & 4) == 0 && valueNodeValue instanceof Long) {
                long valueNodeValue_ = (Long)valueNodeValue;
                this.state_0_ = state_0 |= 2;
                this.writeI64(frameValue, valueNodeValue_);
                return;
            }
            state_0 &= 0xFFFFFFFD;
            this.state_0_ = state_0 |= 4;
            this.writePointer(frameValue, valueNodeValue);
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMWriteNode.LLVMWriteI64Node create(int slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteI64NodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteI32Node.class)
    public static final class LLVMWriteI32NodeGen
    extends LLVMWriteNode.LLVMWriteI32Node
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteI32NodeGen(int slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue);
                return;
            }
            if ((state_0 & 2) != 0 && valueNodeValue instanceof Integer) {
                int valueNodeValue_ = (Integer)valueNodeValue;
                this.writeI32(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int valueNodeValue_;
            int state_0 = this.state_0_;
            try {
                valueNodeValue_ = this.valueNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue_);
                return;
            }
            if ((state_0 & 2) != 0) {
                this.writeI32(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueNodeValue instanceof Integer) {
                int valueNodeValue_ = (Integer)valueNodeValue;
                this.state_0_ = state_0 |= 2;
                this.writeI32(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMWriteNode.LLVMWriteI32Node create(int slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteI32NodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteI16Node.class)
    public static final class LLVMWriteI16NodeGen
    extends LLVMWriteNode.LLVMWriteI16Node
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteI16NodeGen(int slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue);
                return;
            }
            if ((state_0 & 2) != 0 && valueNodeValue instanceof Short) {
                short valueNodeValue_ = (Short)valueNodeValue;
                this.writeI16(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            short valueNodeValue_;
            int state_0 = this.state_0_;
            try {
                valueNodeValue_ = this.valueNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue_);
                return;
            }
            if ((state_0 & 2) != 0) {
                this.writeI16(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueNodeValue instanceof Short) {
                short valueNodeValue_ = (Short)valueNodeValue;
                this.state_0_ = state_0 |= 2;
                this.writeI16(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMWriteNode.LLVMWriteI16Node create(int slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteI16NodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteI8Node.class)
    public static final class LLVMWriteI8NodeGen
    extends LLVMWriteNode.LLVMWriteI8Node
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteI8NodeGen(int slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue);
                return;
            }
            if ((state_0 & 2) != 0 && valueNodeValue instanceof Byte) {
                byte valueNodeValue_ = (Byte)valueNodeValue;
                this.writeI8(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            byte valueNodeValue_;
            int state_0 = this.state_0_;
            try {
                valueNodeValue_ = this.valueNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue_);
                return;
            }
            if ((state_0 & 2) != 0) {
                this.writeI8(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueNodeValue instanceof Byte) {
                byte valueNodeValue_ = (Byte)valueNodeValue;
                this.state_0_ = state_0 |= 2;
                this.writeI8(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMWriteNode.LLVMWriteI8Node create(int slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteI8NodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteI1Node.class)
    public static final class LLVMWriteI1NodeGen
    extends LLVMWriteNode.LLVMWriteI1Node
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteI1NodeGen(int slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue);
                return;
            }
            if ((state_0 & 2) != 0 && valueNodeValue instanceof Boolean) {
                boolean valueNodeValue_ = (Boolean)valueNodeValue;
                this.writeI1(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            boolean valueNodeValue_;
            int state_0 = this.state_0_;
            try {
                valueNodeValue_ = this.valueNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, valueNodeValue_);
                return;
            }
            if ((state_0 & 2) != 0) {
                this.writeI1(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueNodeValue instanceof Boolean) {
                boolean valueNodeValue_ = (Boolean)valueNodeValue;
                this.state_0_ = state_0 |= 2;
                this.writeI1(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMWriteNode.LLVMWriteI1Node create(int slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteI1NodeGen(slot, valueNode);
        }
    }
}

