/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.except.LLVMMemoryException;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVAListNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86_win.LLVMX86_64_WinVaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDoubleLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMFloatStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class, delegateTo="address"), @ExportLibrary(value=LLVMVaListLibrary.class, useForAOT=true, useForAOTPriority=0), @ExportLibrary(value=LLVMManagedReadLibrary.class, useForAOT=true, useForAOTPriority=1), @ExportLibrary(value=LLVMManagedWriteLibrary.class, useForAOT=true, useForAOTPriority=2), @ExportLibrary(value=LLVMAsForeignLibrary.class, useForAOT=true, useForAOTPriority=3)})
public final class LLVMMaybeVaPointer
extends LLVMInternalTruffleObject {
    private final Assumption allocVAPointerAssumption;
    private final LLVMVAListNode allocaNode;
    private boolean wasVAListPointer = false;
    protected final LLVMPointer address;
    protected LLVMManagedPointer vaList;

    public static LLVMMaybeVaPointer createWithAlloca(LLVMPointer address, LLVMVAListNode allocaNode) {
        return new LLVMMaybeVaPointer(address, allocaNode, null);
    }

    public static LLVMMaybeVaPointer createWithStorage(LLVMPointer address, Object vaListStorage) {
        return new LLVMMaybeVaPointer(address, null, vaListStorage);
    }

    public static LLVMMaybeVaPointer createWithHeap(LLVMPointer address) {
        return new LLVMMaybeVaPointer(address, null, null);
    }

    private LLVMMaybeVaPointer(LLVMPointer address, LLVMVAListNode allocaNode, Object vaListStorage) {
        this.allocaNode = allocaNode;
        this.allocVAPointerAssumption = allocaNode == null ? null : allocaNode.getAssumption();
        this.address = address;
        if (vaListStorage != null) {
            this.vaList = LLVMManagedPointer.create(vaListStorage);
        }
    }

    @ExportMessage
    public boolean isPointer() {
        return this.vaList == null;
    }

    boolean isStoredOnHeap() {
        return this.allocaNode == null;
    }

    boolean isManagedStorage() {
        return LLVMManagedPointer.isInstance(this.address);
    }

    @ExportMessage
    public long asPointer() throws UnsupportedMessageException {
        if (this.isPointer()) {
            return this.getAddress();
        }
        throw UnsupportedMessageException.create();
    }

    public long getAddress() {
        assert (this.isPointer());
        return LLVMNativePointer.cast(this.address).asNative();
    }

    private static Object createVaListStorage(LLVMNode dummyNode) {
        return LLVMLanguage.get(dummyNode).getCapability(PlatformCapability.class).createActualVAListStorage();
    }

    Object initializeBase(Object[] realArguments, int numberOfExplicitArguments, Frame frame, LLVMVaListLibrary vaListLibrary, LLVMNode dummyNode) {
        assert (numberOfExplicitArguments <= realArguments.length);
        Object vaListInstance = LLVMMaybeVaPointer.createVaListStorage(dummyNode);
        vaListLibrary.initialize(vaListInstance, realArguments, numberOfExplicitArguments, frame);
        this.vaList = LLVMManagedPointer.create(vaListInstance);
        this.wasVAListPointer = true;
        return vaListInstance;
    }

    protected void nativeObjectAccess() {
        if (this.isStoredOnHeap() || this.wasVAListPointer) {
            return;
        }
        if (this.allocVAPointerAssumption.isValid()) {
            this.allocVAPointerAssumption.invalidate();
        }
    }

    @ExportMessage
    void cleanup(Frame frame) {
        this.vaList = null;
    }

    public int getSize() {
        return 1;
    }

    @ExportMessage
    public boolean hasArrayElements() {
        return !this.isPointer();
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isReadable"), @ExportMessage(name="isWritable")})
    boolean isAccessible() {
        return true;
    }

    @ExportMessage
    public boolean hasMembers() {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return String.format("LLVMMaybeVAPointer (address = %s, contents = %s)", this.address, this.vaList);
    }

    @ExportMessage
    static class AsForeign {
        AsForeign() {
        }

        @Specialization(guards={"!self.isPointer()"})
        static Object asForeignVaList(LLVMMaybeVaPointer self) {
            return self;
        }

        @Specialization(guards={"self.isPointer()"})
        static Object asForeign(LLVMMaybeVaPointer self) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @ExportMessage
    static class IsForeign {
        IsForeign() {
        }

        @Specialization(guards={"!self.isPointer()"})
        static boolean isForeignVaList(LLVMMaybeVaPointer self) {
            return true;
        }

        @Specialization(guards={"self.isPointer()"})
        static boolean isForeign(LLVMMaybeVaPointer self) {
            return false;
        }
    }

    @ExportMessage
    static class WriteGenericI64 {
        WriteGenericI64() {
        }

        static boolean isVaListStorage(Object obj) {
            if (!LLVMManagedPointer.isInstance(obj)) {
                return false;
            }
            LLVMManagedPointer ptr = LLVMManagedPointer.cast(obj);
            return ptr.getObject() instanceof LLVMVaListStorage || ptr.getObject() instanceof LLVMX86_64_WinVaListStorage;
        }

        @Specialization(guards={"isVaListStorage(value)", "offset == 0"})
        static void writeVAList(LLVMMaybeVaPointer self, long offset, LLVMManagedPointer value) {
            assert (offset == 0L);
            self.wasVAListPointer = true;
            self.vaList = value;
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMMaybeVaPointer self, long offset, Object value, @Cached.Shared(value="storeNode") @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode storeNode) {
            assert (offset == 0L);
            storeNode.executeWithTargetGeneric(self.address, offset, value);
        }

        @Specialization(guards={"!self.isPointer()", "offset != 0"})
        @GenerateAOT.Exclude
        static void writeFallback(LLVMMaybeVaPointer self, long offset, Object value) {
            throw new LLVMMemoryException((Node)self.allocaNode, "Unsupported write from VA list pointer.");
        }
    }

    @ExportMessage
    static class WriteI64 {
        WriteI64() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMMaybeVaPointer self, long offset, long value, @Cached.Shared(value="storeNode") @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode storeNode) {
            self.nativeObjectAccess();
            storeNode.executeWithTarget(self.address, offset, value);
        }

        @Specialization(guards={"!self.isPointer()"})
        @GenerateAOT.Exclude
        static void writeFallback(LLVMMaybeVaPointer self, long offset, long value) {
            throw new LLVMMemoryException((Node)self.allocaNode, "Unsupported write from VA list pointer.");
        }
    }

    @ExportMessage
    static class WriteDouble {
        WriteDouble() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMMaybeVaPointer self, long offset, double value, @Cached LLVMDoubleStoreNode.LLVMDoubleOffsetStoreNode storeNode) {
            self.nativeObjectAccess();
            storeNode.executeWithTarget(self.address, offset, value);
        }

        @Specialization(guards={"!self.isPointer()"})
        @GenerateAOT.Exclude
        static void writeManaged(LLVMMaybeVaPointer self, long offset, double value) {
            assert (offset == 0L);
            throw new LLVMMemoryException((Node)self.allocaNode, "Unsupported write from VA list pointer.");
        }
    }

    @ExportMessage
    static class WriteFloat {
        WriteFloat() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMMaybeVaPointer self, long offset, float value, @Cached LLVMFloatStoreNode.LLVMFloatOffsetStoreNode storeNode) {
            self.nativeObjectAccess();
            storeNode.executeWithTarget(self.address, offset, value);
        }

        @Specialization(guards={"!self.isPointer()"})
        @GenerateAOT.Exclude
        static void writeManaged(LLVMMaybeVaPointer self, long offset, float value) {
            assert (offset == 0L);
            throw new LLVMMemoryException((Node)self.allocaNode, "Unsupported write from VA list pointer.");
        }
    }

    @ExportMessage
    static class WriteI32 {
        WriteI32() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMMaybeVaPointer self, long offset, int value, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode storeNode) {
            self.nativeObjectAccess();
            storeNode.executeWithTarget(self.address, offset, value);
        }

        @Specialization(guards={"!self.isPointer()"})
        @GenerateAOT.Exclude
        static void writeManaged(LLVMMaybeVaPointer self, long offset, int value) {
            assert (offset == 0L);
            throw new LLVMMemoryException((Node)self.allocaNode, "Unsupported write from VA list pointer.");
        }
    }

    @ExportMessage
    static class WriteI16 {
        WriteI16() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMMaybeVaPointer self, long offset, short value, @Cached LLVMI16StoreNode.LLVMI16OffsetStoreNode storeNode) {
            self.nativeObjectAccess();
            storeNode.executeWithTarget(self.address, offset, value);
        }

        @Specialization(guards={"!self.isPointer()"})
        @GenerateAOT.Exclude
        static void writeManaged(LLVMMaybeVaPointer self, long offset, short value) {
            assert (offset == 0L);
            throw new LLVMMemoryException((Node)self.allocaNode, "Unsupported write from VA list pointer.");
        }
    }

    @ExportMessage
    static class WriteI8 {
        WriteI8() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMMaybeVaPointer self, long offset, byte value, @Cached LLVMI8StoreNode.LLVMI8OffsetStoreNode storeNode) {
            self.nativeObjectAccess();
            storeNode.executeWithTarget(self.address, offset, value);
        }

        @Specialization(guards={"!self.isPointer()"})
        @GenerateAOT.Exclude
        static void writeManaged(LLVMMaybeVaPointer self, long offset, byte value) {
            assert (offset == 0L);
            throw new LLVMMemoryException((Node)self.allocaNode, "Unsupported write from VA list pointer.");
        }
    }

    @ExportMessage
    static class ReadPointer {
        ReadPointer() {
        }

        @Specialization(guards={"self.isPointer()"})
        static LLVMPointer readNative(LLVMMaybeVaPointer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            self.nativeObjectAccess();
            return LLVMLanguage.get((Node)location).getLLVMMemory().getPointer((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"!self.isPointer()", "offset == 0"})
        static LLVMPointer readManaged(LLVMMaybeVaPointer self, long offset) {
            assert (offset == 0L);
            return self.vaList;
        }

        @Specialization(guards={"!self.isPointer()", "offset != 0"})
        @GenerateAOT.Exclude
        static LLVMPointer readFallback(LLVMMaybeVaPointer self, long offset) {
            assert (offset == 0L);
            throw new LLVMMemoryException((Node)self.allocaNode, "Unsupported read from VA list pointer.");
        }
    }

    @ExportMessage
    static class ReadGenericI64 {
        ReadGenericI64() {
        }

        @Specialization(guards={"self.isPointer()"})
        static long readNative(LLVMMaybeVaPointer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            self.nativeObjectAccess();
            return LLVMLanguage.get((Node)location).getLLVMMemory().getI64((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"!self.isPointer()", "offset == 0"})
        static Object readI64Managed(LLVMMaybeVaPointer self, long offset) {
            assert (offset == 0L);
            return self.vaList;
        }

        @Specialization(guards={"!self.isPointer()", "offset != 0"})
        @GenerateAOT.Exclude
        static Object readFallback(LLVMMaybeVaPointer self, long offset) {
            assert (offset == 0L);
            throw new LLVMMemoryException((Node)self.allocaNode, "Unsupported read from VA list pointer.");
        }
    }

    @ExportMessage
    static class ReadDouble {
        ReadDouble() {
        }

        @Specialization(guards={"self.isPointer()"})
        static double readNative(LLVMMaybeVaPointer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            self.nativeObjectAccess();
            return LLVMLanguage.get((Node)location).getLLVMMemory().getDouble((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"!self.isPointer()"})
        @GenerateAOT.Exclude
        static double readManaged(LLVMMaybeVaPointer self, long offset) {
            assert (false);
            throw new LLVMMemoryException((Node)self.allocaNode, "Unsupported read from VA list pointer.");
        }
    }

    @ExportMessage
    static class ReadFloat {
        ReadFloat() {
        }

        @Specialization(guards={"self.isPointer()"})
        static float readNative(LLVMMaybeVaPointer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            self.nativeObjectAccess();
            return LLVMLanguage.get((Node)location).getLLVMMemory().getFloat((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"!self.isPointer()"})
        @GenerateAOT.Exclude
        static float readManaged(LLVMMaybeVaPointer self, long offset) {
            assert (false);
            throw new LLVMMemoryException((Node)self.allocaNode, "Unsupported read from VA list pointer.");
        }
    }

    @ExportMessage
    static class ReadI32 {
        ReadI32() {
        }

        @Specialization(guards={"self.isPointer()"})
        static int readNative(LLVMMaybeVaPointer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            self.nativeObjectAccess();
            return LLVMLanguage.get((Node)location).getLLVMMemory().getI32((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"!self.isPointer()"})
        @GenerateAOT.Exclude
        static int readManaged(LLVMMaybeVaPointer self, long offset) {
            assert (false);
            throw new LLVMMemoryException((Node)self.allocaNode, "Unsupported read from VA list pointer.");
        }
    }

    @ExportMessage
    static class ReadI16 {
        ReadI16() {
        }

        @Specialization(guards={"self.isPointer()"})
        static short readNative(LLVMMaybeVaPointer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            self.nativeObjectAccess();
            return LLVMLanguage.get((Node)location).getLLVMMemory().getI16((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"!self.isPointer()"})
        @GenerateAOT.Exclude
        static short readManaged(LLVMMaybeVaPointer self, long offset) {
            assert (false);
            throw new LLVMMemoryException((Node)self.allocaNode, "Unsupported read from VA list pointer.");
        }
    }

    @ExportMessage
    static class ReadI8 {
        ReadI8() {
        }

        @Specialization(guards={"self.isPointer()"})
        static byte readNative(LLVMMaybeVaPointer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            self.nativeObjectAccess();
            return LLVMLanguage.get((Node)location).getLLVMMemory().getI8((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"!self.isPointer()"})
        @GenerateAOT.Exclude
        static byte readManaged(LLVMMaybeVaPointer self, long offset) {
            assert (false);
            throw new LLVMMemoryException((Node)self.allocaNode, "Unsupported read from VA list pointer.");
        }
    }

    @ExportMessage
    static class InvokeMember {
        InvokeMember() {
        }

        @Specialization(limit="1", guards={"!self.isPointer()"})
        static Object invokeMember(LLVMMaybeVaPointer self, String member, Object[] arguments, @CachedLibrary(value="self.vaList.getObject()") InteropLibrary interop) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException, ArityException {
            return interop.invokeMember(self.vaList.getObject(), member, arguments);
        }
    }

    @ExportMessage
    static class IsMemberInvocable {
        IsMemberInvocable() {
        }

        @Specialization(limit="1", guards={"!self.isPointer()"})
        static boolean isMemberInvocable(LLVMMaybeVaPointer self, String member, @CachedLibrary(value="self.vaList.getObject()") InteropLibrary interopLibrary) {
            return interopLibrary.isMemberInvocable(self.vaList.getObject(), member);
        }
    }

    @ExportMessage
    static class GetMembers {
        GetMembers() {
        }

        @Specialization(limit="1", guards={"!self.isPointer()"})
        static Object getMembers(LLVMMaybeVaPointer self, boolean includeInternal, @CachedLibrary(value="self.vaList.getObject()") InteropLibrary interopLibrary) throws UnsupportedMessageException {
            return interopLibrary.getMembers(self.vaList.getObject(), includeInternal);
        }
    }

    @ExportMessage
    static class ReadArrayElement {
        ReadArrayElement() {
        }

        @Specialization(limit="1", guards={"!self.isPointer()"})
        static Object readArrayElementVaList(LLVMMaybeVaPointer self, long index, @CachedLibrary(value="self.vaList.getObject()") InteropLibrary interop) throws InvalidArrayIndexException, UnsupportedMessageException {
            return interop.readArrayElement(self.vaList.getObject(), index);
        }
    }

    @ExportMessage
    static class IsArrayElementReadable {
        IsArrayElementReadable() {
        }

        @Specialization(limit="1", guards={"!self.isPointer()"})
        static boolean isArrayElementReadableVaList(LLVMMaybeVaPointer self, long index, @CachedLibrary(value="self.vaList.getObject()") InteropLibrary interopLibrary) {
            return interopLibrary.isArrayElementReadable(self.vaList.getObject(), index);
        }
    }

    @ExportMessage
    static class GetArraySize {
        GetArraySize() {
        }

        @Specialization(limit="1", guards={"!self.isPointer()"})
        static long getArraySizeVaList(LLVMMaybeVaPointer self, @CachedLibrary(value="self.vaList.getObject()") InteropLibrary interopLibrary) throws UnsupportedMessageException {
            return interopLibrary.getArraySize(self.vaList.getObject());
        }
    }

    @ExportMessage
    static class Copy {
        Copy() {
        }

        @Specialization
        static void copy(LLVMMaybeVaPointer self, LLVMMaybeVaPointer other, Frame frame, @Cached.Exclusive @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode offsetLoadNode, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode offsetStoreNode) {
            LLVMPointer vaListPtr = offsetLoadNode.executeWithTarget(self.address, 0L);
            offsetStoreNode.executeWithTarget(other.address, 0L, vaListPtr);
            other.vaList = self.vaList;
        }
    }

    @ExportMessage
    static class Shift {
        Shift() {
        }

        @Specialization(guards={"self.isPointer()"})
        static Object shiftNative(LLVMMaybeVaPointer self, Type type, Frame frame, @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode baseAddrLoadNode, @Cached.Exclusive @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode pointerOffsetLoadNode, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerOffsetStoreNode, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode i32OffsetLoadNode, @Cached LLVMI64LoadNode.LLVMI64OffsetLoadNode i64OffsetLoadNode, @Cached LLVMDoubleLoadNode.LLVMDoubleOffsetLoadNode doubleOffsetLoadNode) {
            Object ret = null;
            LLVMPointer baseAddr = baseAddrLoadNode.executeWithTarget(self.address, 0L);
            if (PrimitiveType.DOUBLE == type) {
                ret = doubleOffsetLoadNode.executeWithTarget(baseAddr, 0L);
            } else if (PrimitiveType.I32 == type) {
                ret = i32OffsetLoadNode.executeWithTarget(baseAddr, 0L);
            } else if (PrimitiveType.I64 == type) {
                ret = i64OffsetLoadNode.executeWithTargetGeneric(baseAddr, 0L);
            } else if (type instanceof PointerType) {
                ret = pointerOffsetLoadNode.executeWithTarget(baseAddr, 0L);
            } else {
                CompilerDirectives.transferToInterpreter();
                CompilerDirectives.shouldNotReachHere((String)("MaybeVaPointer.shift: not implemented: " + String.valueOf(type)));
            }
            pointerOffsetStoreNode.executeWithTarget(self.address, 0L, baseAddr.increment(8L));
            return ret;
        }

        @Specialization(guards={"!self.isPointer()"})
        @GenerateAOT.Exclude
        static Object shiftStorage(LLVMMaybeVaPointer self, Type type, Frame frame, @CachedLibrary(limit="3") LLVMManagedReadLibrary readLibrary) {
            Object vaListStorage = self.vaList.getObject();
            Object ret = null;
            long offset = self.vaList.getOffset();
            if (PrimitiveType.DOUBLE == type) {
                ret = readLibrary.readDouble(vaListStorage, offset);
            } else if (PrimitiveType.I32 == type) {
                ret = readLibrary.readI32(vaListStorage, offset);
            } else if (PrimitiveType.I64 == type) {
                ret = readLibrary.readGenericI64(vaListStorage, offset);
            } else if (type instanceof PointerType) {
                ret = readLibrary.readPointer(vaListStorage, offset);
            } else {
                CompilerDirectives.transferToInterpreter();
                CompilerDirectives.shouldNotReachHere((String)("MaybeVaPointer.shift: not implemented: " + String.valueOf(type)));
            }
            self.vaList = self.vaList.increment(8L);
            return ret;
        }
    }

    @ExportMessage
    static class Initialize {
        Initialize() {
        }

        @Specialization(guards={"self.isStoredOnHeap()", "self.isManagedStorage()"})
        static void initializeOnHeapManaged(LLVMMaybeVaPointer self, Object[] realArguments, int numberOfExplicitArguments, Frame frame, @Cached.Shared(value="storeAddressNode") @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode storeAddressNode, @CachedLibrary(limit="3") LLVMManagedWriteLibrary writeLibrary, @CachedLibrary(limit="3") LLVMVaListLibrary vaListLibrary) {
            Object vaListInstance = self.initializeBase(realArguments, numberOfExplicitArguments, frame, vaListLibrary, storeAddressNode);
            writeLibrary.writeGenericI64(LLVMManagedPointer.cast(self.address).getObject(), 0L, vaListInstance);
        }

        @Specialization(guards={"self.isStoredOnHeap()", "!self.isManagedStorage()"})
        static void initializeOnHeapNative(LLVMMaybeVaPointer self, Object[] realArguments, int numberOfExplicitArguments, Frame frame, @Cached.Shared(value="storeAddressNode") @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode storeAddressNode, @CachedLibrary(limit="3") LLVMVaListLibrary vaListLibrary) {
            Object vaListInstance = self.initializeBase(realArguments, numberOfExplicitArguments, frame, vaListLibrary, storeAddressNode);
            storeAddressNode.executeWithTarget(self.address, 0L, vaListInstance);
        }

        @Specialization(guards={"!self.isStoredOnHeap()", "!self.isManagedStorage()"})
        static void initializeStack(LLVMMaybeVaPointer self, Object[] realArguments, int numberOfExplicitArguments, Frame frame, @Cached.Shared(value="storeAddressNode") @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode storeAddressNode, @CachedLibrary(limit="3") LLVMVaListLibrary vaListLibrary) {
            self.initializeBase(realArguments, numberOfExplicitArguments, frame, vaListLibrary, storeAddressNode);
        }
    }

    @ExportMessage
    static class ToNative {
        ToNative() {
        }

        @Specialization(guards={"!self.isStoredOnHeap()"})
        static void toNativeVaList(LLVMMaybeVaPointer self, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode storeAddressNode) {
            assert (self.vaList.getOffset() == 0L);
            storeAddressNode.executeWithTarget(self.address, 0L, self.vaList.getObject());
            self.vaList = null;
        }

        @Specialization(guards={"self.isStoredOnHeap()", "!self.isPointer()"})
        static void toNativeVaList(LLVMMaybeVaPointer self, @CachedLibrary(limit="1") InteropLibrary interopLibrary) {
            interopLibrary.toNative((Object)self.address);
            self.vaList = null;
        }
    }
}

