// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode.LLVMPointerDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNodeFactory.LLVMPointerDataEscapeNodeGen;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(LLVMScopeChain.class)
@SuppressWarnings("javadoc")
public final class LLVMScopeChainGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(LLVMScopeChain.class, new InteropLibraryExports());
    }

    private LLVMScopeChainGen() {
    }

    @GeneratedBy(LLVMScopeChain.class)
    public static class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMScopeChain.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof LLVMScopeChain;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof LLVMScopeChain;
            return new Cached(receiver);
        }

        @GeneratedBy(LLVMScopeChain.class)
        public static class Cached extends InteropLibrary {

            private final Class<? extends LLVMScopeChain> receiverClass_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link LLVMScopeChain#readMember(LLVMScopeChain, String, BranchProfile, LLVMPointerDataEscapeNode, InteropLibrary)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMScopeChain#readMember(LLVMScopeChain, String, BranchProfile, LLVMPointerDataEscapeNode, InteropLibrary)}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal private BranchProfile exception_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMScopeChain#readMember(LLVMScopeChain, String, BranchProfile, LLVMPointerDataEscapeNode, InteropLibrary)}
             *   Parameter: {@link LLVMPointerDataEscapeNode} escape</pre>
             */
            @Child private LLVMPointerDataEscapeNode escape_;

            protected Cached(Object receiver) {
                LLVMScopeChain castReceiver = ((LLVMScopeChain) receiver) ;
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).getLanguage();
            }

            @Override
            public boolean isScope(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).isScope();
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).toDisplayString(allowSideEffects);
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).getMembers(includeInternal);
            }

            @Override
            public boolean isMemberReadable(Object receiver, String member) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).isMemberReadable(member);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link LLVMScopeChain#readMember(LLVMScopeChain, String, BranchProfile, LLVMPointerDataEscapeNode, InteropLibrary)}
             *     Activation probability: 1.00000
             *     With/without class size: 28/8 bytes
             * </pre>
             */
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                LLVMScopeChain arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[LLVMScopeChain.readMember(LLVMScopeChain, String, BranchProfile, LLVMPointerDataEscapeNode, InteropLibrary)] */) {
                    {
                        BranchProfile exception__ = this.exception_;
                        if (exception__ != null) {
                            LLVMPointerDataEscapeNode escape__ = this.escape_;
                            if (escape__ != null) {
                                InteropLibrary self__ = (this);
                                return arg0Value.readMember(arg1Value, exception__, escape__, self__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(LLVMScopeChain arg0Value, String arg1Value) throws UnknownIdentifierException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary self__ = null;
                    BranchProfile exception__ = (BranchProfile.create());
                    Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.exception_ = exception__;
                    LLVMPointerDataEscapeNode escape__ = this.insert((LLVMPointerDataEscapeNodeGen.create()));
                    Objects.requireNonNull(escape__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.escape_ = escape__;
                    self__ = (this);
                    state_0 = state_0 | 0b1 /* add SpecializationActive[LLVMScopeChain.readMember(LLVMScopeChain, String, BranchProfile, LLVMPointerDataEscapeNode, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return arg0Value.readMember(arg1Value, exception__, escape__, self__);
                }
            }

        }
        @GeneratedBy(LLVMScopeChain.class)
        public static class Uncached extends InteropLibrary implements UnadoptableNode {

            private final Class<? extends LLVMScopeChain> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((LLVMScopeChain) receiver).getClass();
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMScopeChain) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMScopeChain) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public boolean isScope(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMScopeChain) receiver) .isScope();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMScopeChain) receiver) .toDisplayString(allowSideEffects);
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMScopeChain) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMScopeChain) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object receiver, String member) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMScopeChain) receiver) .isMemberReadable(member);
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException, UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMScopeChain arg0Value = ((LLVMScopeChain) arg0Value_);
                return arg0Value.readMember(arg1Value, (BranchProfile.getUncached()), (LLVMPointerDataEscapeNodeGen.getUncached()), (this));
            }

        }
    }
}
