// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.SulongLibrary.CachedMainFunction;
import com.oracle.truffle.llvm.runtime.SulongLibrary.Execute;
import com.oracle.truffle.llvm.runtime.SulongLibrary.LookupNode;
import com.oracle.truffle.llvm.runtime.SulongLibraryFactory.LookupNodeGen;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(SulongLibrary.class)
@SuppressWarnings("javadoc")
final class SulongLibraryGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(SulongLibrary.class, new InteropLibraryExports());
    }

    private SulongLibraryGen() {
    }

    @GeneratedBy(SulongLibrary.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, SulongLibrary.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof SulongLibrary;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof SulongLibrary;
            return new Cached();
        }

        @GeneratedBy(SulongLibrary.class)
        private static final class Cached extends InteropLibrary {

            static final ReferenceField<ExecuteCachedData> EXECUTE_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "execute_cached_cache", ExecuteCachedData.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link Execute#doCached}
             *   1: SpecializationActive {@link Execute#doGeneric}
             *   2: SpecializationActive {@link Execute#doUnsupported}
             *   3: SpecializationActive {@link SulongLibrary#readMember(SulongLibrary, String, LookupNode, BranchProfile)}
             *   4: SpecializationActive {@link SulongLibrary#invokeMember(SulongLibrary, String, Object[], LookupNode, InteropLibrary, BranchProfile)}
             *   5: SpecializationActive {@link SulongLibrary#memberExists(SulongLibrary, String, LookupNode)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SulongLibrary#readMember}
             *   Parameter: {@link LookupNode} lookup</pre>
             */
            @Child private LookupNode lookup;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SulongLibrary#readMember}
             *   Parameter: {@link BranchProfile} notFound</pre>
             */
            @CompilationFinal private BranchProfile notFound;
            @UnsafeAccessedField @Child private ExecuteCachedData execute_cached_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link Execute#doGeneric}
             *   Parameter: {@link IndirectCallNode} call</pre>
             */
            @Child private IndirectCallNode execute_generic_call_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SulongLibrary#invokeMember(SulongLibrary, String, Object[], LookupNode, InteropLibrary, BranchProfile)}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child private InteropLibrary invokeMemberNode__invokeMember_interop_;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof SulongLibrary) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SulongLibrary;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Execute#doCached}
             *     Activation probability: 0.09667
             *     With/without class size: 6/8 bytes
             *   Specialization {@link Execute#doGeneric}
             *     Activation probability: 0.06667
             *     With/without class size: 5/4 bytes
             *   Specialization {@link Execute#doUnsupported}
             *     Activation probability: 0.03667
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @ExplodeLoop
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                SulongLibrary arg0Value = ((SulongLibrary) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[SulongLibrary.Execute.doCached(SulongLibrary, Object[], CachedMainFunction, DirectCallNode)] || SpecializationActive[SulongLibrary.Execute.doGeneric(SulongLibrary, Object[], IndirectCallNode)] || SpecializationActive[SulongLibrary.Execute.doUnsupported(SulongLibrary, Object[])] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[SulongLibrary.Execute.doCached(SulongLibrary, Object[], CachedMainFunction, DirectCallNode)] */) {
                        ExecuteCachedData s0_ = this.execute_cached_cache;
                        while (s0_ != null) {
                            if ((arg0Value.main == s0_.cachedMain_)) {
                                assert DSLSupport.assertIdempotence((s0_.cachedMain_ != null));
                                return Execute.doCached(arg0Value, arg1Value, s0_.cachedMain_, s0_.call_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SulongLibrary.Execute.doGeneric(SulongLibrary, Object[], IndirectCallNode)] */) {
                        {
                            IndirectCallNode call__ = this.execute_generic_call_;
                            if (call__ != null) {
                                if ((arg0Value.main != null)) {
                                    return Execute.doGeneric(arg0Value, arg1Value, call__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[SulongLibrary.Execute.doUnsupported(SulongLibrary, Object[])] */) {
                        if ((arg0Value.main == null)) {
                            return Execute.doUnsupported(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(SulongLibrary arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[SulongLibrary.Execute.doGeneric(SulongLibrary, Object[], IndirectCallNode)] */) {
                    while (true) {
                        int count0_ = 0;
                        ExecuteCachedData s0_ = EXECUTE_CACHED_CACHE_UPDATER.getVolatile(this);
                        ExecuteCachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((arg0Value.main == s0_.cachedMain_)) {
                                assert DSLSupport.assertIdempotence((s0_.cachedMain_ != null));
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                CachedMainFunction cachedMain__ = (arg0Value.main);
                                // assert (arg0Value.main == s0_.cachedMain_);
                                if ((cachedMain__ != null) && count0_ < (3)) {
                                    s0_ = this.insert(new ExecuteCachedData(s0_original));
                                    s0_.cachedMain_ = cachedMain__;
                                    s0_.call_ = s0_.insert((DirectCallNode.create(cachedMain__.getMainCallTarget())));
                                    if (!EXECUTE_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[SulongLibrary.Execute.doCached(SulongLibrary, Object[], CachedMainFunction, DirectCallNode)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return Execute.doCached(arg0Value, arg1Value, s0_.cachedMain_, s0_.call_);
                        }
                        break;
                    }
                }
                if ((arg0Value.main != null)) {
                    VarHandle.storeStoreFence();
                    this.execute_generic_call_ = this.insert((IndirectCallNode.create()));
                    this.execute_cached_cache = null;
                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[SulongLibrary.Execute.doCached(SulongLibrary, Object[], CachedMainFunction, DirectCallNode)] */;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[SulongLibrary.Execute.doGeneric(SulongLibrary, Object[], IndirectCallNode)] */;
                    this.state_0_ = state_0;
                    return Execute.doGeneric(arg0Value, arg1Value, this.execute_generic_call_);
                }
                if ((arg0Value.main == null)) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[SulongLibrary.Execute.doUnsupported(SulongLibrary, Object[])] */;
                    this.state_0_ = state_0;
                    return Execute.doUnsupported(arg0Value, arg1Value);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link SulongLibrary#readMember(SulongLibrary, String, LookupNode, BranchProfile)}
             *     Activation probability: 0.20000
             *     With/without class size: 6/0 bytes
             * </pre>
             */
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                SulongLibrary arg0Value = ((SulongLibrary) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[SulongLibrary.readMember(SulongLibrary, String, LookupNode, BranchProfile)] */) {
                    {
                        LookupNode lookup_ = this.lookup;
                        if (lookup_ != null) {
                            BranchProfile notFound_ = this.notFound;
                            if (notFound_ != null) {
                                return arg0Value.readMember(arg1Value, lookup_, notFound_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(SulongLibrary arg0Value, String arg1Value) throws UnknownIdentifierException {
                int state_0 = this.state_0_;
                LookupNode lookup_;
                LookupNode lookup__shared = this.lookup;
                if (lookup__shared != null) {
                    lookup_ = lookup__shared;
                } else {
                    lookup_ = this.insert((LookupNodeGen.create()));
                    if (lookup_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.lookup == null) {
                    VarHandle.storeStoreFence();
                    this.lookup = lookup_;
                }
                BranchProfile notFound_;
                BranchProfile notFound__shared = this.notFound;
                if (notFound__shared != null) {
                    notFound_ = notFound__shared;
                } else {
                    notFound_ = (BranchProfile.create());
                    if (notFound_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.notFound == null) {
                    VarHandle.storeStoreFence();
                    this.notFound = notFound_;
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[SulongLibrary.readMember(SulongLibrary, String, LookupNode, BranchProfile)] */;
                this.state_0_ = state_0;
                return arg0Value.readMember(arg1Value, lookup_, notFound_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link SulongLibrary#invokeMember(SulongLibrary, String, Object[], LookupNode, InteropLibrary, BranchProfile)}
             *     Activation probability: 0.20000
             *     With/without class size: 8/4 bytes
             * </pre>
             */
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                SulongLibrary arg0Value = ((SulongLibrary) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[SulongLibrary.invokeMember(SulongLibrary, String, Object[], LookupNode, InteropLibrary, BranchProfile)] */) {
                    {
                        LookupNode lookup_ = this.lookup;
                        if (lookup_ != null) {
                            InteropLibrary interop__ = this.invokeMemberNode__invokeMember_interop_;
                            if (interop__ != null) {
                                BranchProfile notFound_ = this.notFound;
                                if (notFound_ != null) {
                                    return arg0Value.invokeMember(arg1Value, arg2Value, lookup_, interop__, notFound_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(SulongLibrary arg0Value, String arg1Value, Object[] arg2Value) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
                int state_0 = this.state_0_;
                LookupNode lookup_;
                LookupNode lookup__shared = this.lookup;
                if (lookup__shared != null) {
                    lookup_ = lookup__shared;
                } else {
                    lookup_ = this.insert((LookupNodeGen.create()));
                    if (lookup_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.lookup == null) {
                    VarHandle.storeStoreFence();
                    this.lookup = lookup_;
                }
                InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(1)));
                Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.invokeMemberNode__invokeMember_interop_ = interop__;
                BranchProfile notFound_;
                BranchProfile notFound__shared = this.notFound;
                if (notFound__shared != null) {
                    notFound_ = notFound__shared;
                } else {
                    notFound_ = (BranchProfile.create());
                    if (notFound_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.notFound == null) {
                    VarHandle.storeStoreFence();
                    this.notFound = notFound_;
                }
                state_0 = state_0 | 0b10000 /* add SpecializationActive[SulongLibrary.invokeMember(SulongLibrary, String, Object[], LookupNode, InteropLibrary, BranchProfile)] */;
                this.state_0_ = state_0;
                return arg0Value.invokeMember(arg1Value, arg2Value, lookup_, interop__, notFound_);
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((SulongLibrary) receiver)).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((SulongLibrary) receiver)).getMembers(includeInternal);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link SulongLibrary#memberExists(SulongLibrary, String, LookupNode)}
             *     Activation probability: 0.20000
             *     With/without class size: 6/0 bytes
             * </pre>
             */
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                SulongLibrary arg0Value = ((SulongLibrary) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[SulongLibrary.memberExists(SulongLibrary, String, LookupNode)] */) {
                    {
                        LookupNode lookup_ = this.lookup;
                        if (lookup_ != null) {
                            return arg0Value.memberExists(arg1Value, lookup_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return memberExistsNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean memberExistsNode_AndSpecialize(SulongLibrary arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                LookupNode lookup_;
                LookupNode lookup__shared = this.lookup;
                if (lookup__shared != null) {
                    lookup_ = lookup__shared;
                } else {
                    lookup_ = this.insert((LookupNodeGen.create()));
                    if (lookup_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.lookup == null) {
                    VarHandle.storeStoreFence();
                    this.lookup = lookup_;
                }
                state_0 = state_0 | 0b100000 /* add SpecializationActive[SulongLibrary.memberExists(SulongLibrary, String, LookupNode)] */;
                this.state_0_ = state_0;
                return arg0Value.memberExists(arg1Value, lookup_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link SulongLibrary#memberExists(SulongLibrary, String, LookupNode)}
             *     Activation probability: 0.20000
             *     With/without class size: 6/0 bytes
             * </pre>
             */
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                SulongLibrary arg0Value = ((SulongLibrary) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[SulongLibrary.memberExists(SulongLibrary, String, LookupNode)] */) {
                    {
                        LookupNode lookup_ = this.lookup;
                        if (lookup_ != null) {
                            return arg0Value.memberExists(arg1Value, lookup_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return memberExistsNode_AndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public boolean isExecutable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((SulongLibrary) receiver)).isExecutable();
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((SulongLibrary) receiver)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((SulongLibrary) receiver)).getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((SulongLibrary) receiver)).toDisplayString(allowSideEffects);
            }

            @GeneratedBy(SulongLibrary.class)
            @DenyReplace
            private static final class ExecuteCachedData extends Node implements SpecializationDataNode {

                @Child ExecuteCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Execute#doCached}
                 *   Parameter: {@link CachedMainFunction} cachedMain</pre>
                 */
                @CompilationFinal CachedMainFunction cachedMain_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Execute#doCached}
                 *   Parameter: {@link DirectCallNode} call</pre>
                 */
                @Child DirectCallNode call_;

                ExecuteCachedData(ExecuteCachedData next_) {
                    this.next_ = next_;
                }

            }
        }
        @GeneratedBy(SulongLibrary.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof SulongLibrary) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SulongLibrary;
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SulongLibrary arg0Value = ((SulongLibrary) arg0Value_);
                if ((arg0Value.main != null)) {
                    return Execute.doGeneric(arg0Value, arg1Value, (IndirectCallNode.getUncached()));
                }
                if ((arg0Value.main == null)) {
                    return Execute.doUnsupported(arg0Value, arg1Value);
                }
                throw newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SulongLibrary arg0Value = ((SulongLibrary) arg0Value_);
                return arg0Value.readMember(arg1Value, (LookupNodeGen.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SulongLibrary arg0Value = ((SulongLibrary) arg0Value_);
                return arg0Value.invokeMember(arg1Value, arg2Value, (LookupNodeGen.getUncached()), (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongLibrary) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongLibrary) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SulongLibrary arg0Value = ((SulongLibrary) arg0Value_);
                return arg0Value.memberExists(arg1Value, (LookupNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SulongLibrary arg0Value = ((SulongLibrary) arg0Value_);
                return arg0Value.memberExists(arg1Value, (LookupNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongLibrary) receiver) .isExecutable();
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongLibrary) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongLibrary) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongLibrary) receiver) .toDisplayString(allowSideEffects);
            }

            @TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
            }

        }
    }
}
