// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.provider.EagerExportProvider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

@GeneratedBy(LLVMTypedForeignObject.class)
public final class LLVMTypedForeignObjectGen {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(LLVMTypedForeignObject.class, new InteropLibraryExports(), new NativeTypeLibraryExports(), new LLVMAsForeignLibraryExports());
    }

    private LLVMTypedForeignObjectGen() {
    }

    private static void init() {
        // This method is intended to ensure class initialization.
    }

    @GeneratedBy(LLVMTypedForeignObject.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        static final FinalBitSet ENABLED_MESSAGES = createMessageBitSet(INTEROP_LIBRARY_, "hasLanguage", "getLanguage", "toDisplayString");
        private static final Uncached UNCACHED = new Uncached();

        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMTypedForeignObject.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof LLVMTypedForeignObject;
            InteropLibrary uncached = createDelegate(INTEROP_LIBRARY_, InteropLibraryExports.UNCACHED);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof LLVMTypedForeignObject;
            return createDelegate(INTEROP_LIBRARY_, new Cached(receiver));
        }

        @GeneratedBy(LLVMTypedForeignObject.class)
        private static final class Cached extends InteropLibrary implements DelegateExport {

            @Child private InteropLibrary receiverForeignInteropLibrary_;

            protected Cached(Object receiver) {
                LLVMTypedForeignObject castReceiver = ((LLVMTypedForeignObject) receiver) ;
                this.receiverForeignInteropLibrary_ = INTEROP_LIBRARY_.create((castReceiver.foreign));
            }

            @Override
            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            @Override
            public Object readDelegateExport(Object receiver_) {
                return ((LLVMTypedForeignObject) receiver_).foreign;
            }

            @Override
            public Library getDelegateExportLibrary(Object delegate) {
                return this.receiverForeignInteropLibrary_;
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMTypedForeignObject) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof LLVMTypedForeignObject)) {
                    return false;
                } else if (!this.receiverForeignInteropLibrary_.accepts((((LLVMTypedForeignObject) receiver).foreign))) {
                    return false;
                } else {
                    return true;
                }
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert receiver instanceof LLVMTypedForeignObject : "Invalid library usage. Library does not accept given receiver.";
                return (((LLVMTypedForeignObject) receiver)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert receiver instanceof LLVMTypedForeignObject : "Invalid library usage. Library does not accept given receiver.";
                return (((LLVMTypedForeignObject) receiver)).getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert receiver instanceof LLVMTypedForeignObject : "Invalid library usage. Library does not accept given receiver.";
                return (((LLVMTypedForeignObject) receiver)).toDisplayString(allowSideEffects);
            }

        }
        @GeneratedBy(LLVMTypedForeignObject.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary implements DelegateExport, UnadoptableNode {

            protected Uncached() {
            }

            @Override
            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            @Override
            public Object readDelegateExport(Object receiver_) {
                return (((LLVMTypedForeignObject) receiver_)).foreign;
            }

            @Override
            public Library getDelegateExportLibrary(Object delegate_) {
                return INTEROP_LIBRARY_.getUncached(delegate_);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMTypedForeignObject) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                // declared: false
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInternalTruffleObject) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                // declared: false
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInternalTruffleObject) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                // declared: false
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInternalTruffleObject) receiver) .toDisplayString(allowSideEffects);
            }

        }
    }
    @GeneratedBy(LLVMTypedForeignObject.class)
    private static final class NativeTypeLibraryExports extends LibraryExport<NativeTypeLibrary> {

        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private NativeTypeLibraryExports() {
            super(NativeTypeLibrary.class, LLVMTypedForeignObject.class, false, false, 0);
        }

        @Override
        protected NativeTypeLibrary createUncached(Object receiver) {
            assert receiver instanceof LLVMTypedForeignObject;
            NativeTypeLibrary uncached = NativeTypeLibraryExports.UNCACHED;
            return uncached;
        }

        @Override
        protected NativeTypeLibrary createCached(Object receiver) {
            assert receiver instanceof LLVMTypedForeignObject;
            return NativeTypeLibraryExports.CACHE;
        }

        @GeneratedBy(LLVMTypedForeignObject.class)
        private static final class Cached extends NativeTypeLibrary implements UnadoptableNode {

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMTypedForeignObject) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            @Override
            public boolean hasNativeType(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((LLVMTypedForeignObject) receiver)).hasNativeType();
            }

            @Override
            public Object getNativeType(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((LLVMTypedForeignObject) receiver)).getNativeType();
            }

        }
        @GeneratedBy(LLVMTypedForeignObject.class)
        @DenyReplace
        private static final class Uncached extends NativeTypeLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMTypedForeignObject) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            @TruffleBoundary
            @Override
            public boolean hasNativeType(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject) receiver) .hasNativeType();
            }

            @TruffleBoundary
            @Override
            public Object getNativeType(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject) receiver) .getNativeType();
            }

        }
    }
    @GeneratedBy(LLVMTypedForeignObject.class)
    public static final class LLVMAsForeignLibraryEagerProvider implements EagerExportProvider {

        @Override
        public void ensureRegistered() {
            LLVMTypedForeignObjectGen.init();
        }

        @Override
        public String getLibraryClassName() {
            return "com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary";
        }

    }
    @GeneratedBy(LLVMTypedForeignObject.class)
    private static final class LLVMAsForeignLibraryExports extends LibraryExport<LLVMAsForeignLibrary> {

        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private LLVMAsForeignLibraryExports() {
            super(LLVMAsForeignLibrary.class, LLVMTypedForeignObject.class, false, true, 1);
        }

        @Override
        protected LLVMAsForeignLibrary createUncached(Object receiver) {
            assert receiver instanceof LLVMTypedForeignObject;
            LLVMAsForeignLibrary uncached = LLVMAsForeignLibraryExports.UNCACHED;
            return uncached;
        }

        @Override
        protected LLVMAsForeignLibrary createCached(Object receiver) {
            assert receiver instanceof LLVMTypedForeignObject || receiver instanceof LibraryExport<?>;
            return LLVMAsForeignLibraryExports.CACHE;
        }

        @GeneratedBy(LLVMTypedForeignObject.class)
        private static final class Cached extends LLVMAsForeignLibrary implements UnadoptableNode {

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMTypedForeignObject) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            @Override
            public boolean isForeign(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((LLVMTypedForeignObject) receiver)).isForeign();
            }

            @Override
            public Object asForeign(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((LLVMTypedForeignObject) receiver)).asForeign();
            }

        }
        @GeneratedBy(LLVMTypedForeignObject.class)
        @DenyReplace
        private static final class Uncached extends LLVMAsForeignLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMTypedForeignObject) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            @TruffleBoundary
            @Override
            public boolean isForeign(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject) receiver) .isForeign();
            }

            @TruffleBoundary
            @Override
            public Object asForeign(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject) receiver) .asForeign();
            }

        }
    }
}
