// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMAccessForeignObjectNode.GetForeignTypeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMAccessForeignObjectNode.ResolveNativePointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport.AsPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport.IsPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory.AsPointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory.IsPointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMAccessForeignObjectNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMAccessForeignObjectNodeFactory {

    private static final LibraryFactory<NativeTypeLibrary> NATIVE_TYPE_LIBRARY_ = LibraryFactory.resolve(NativeTypeLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * Debug Info: <pre>
     *   Specialization {@link ResolveNativePointerNode#doPointer}
     *     Activation probability: 0.48333
     *     With/without class size: 17/8 bytes
     *   Specialization {@link ResolveNativePointerNode#doDerefHandle}
     *     Activation probability: 0.33333
     *     With/without class size: 14/12 bytes
     *   Specialization {@link ResolveNativePointerNode#doManaged}
     *     Activation probability: 0.18333
     *     With/without class size: 8/4 bytes
     * </pre>
     */
    @GeneratedBy(ResolveNativePointerNode.class)
    @SuppressWarnings("javadoc")
    static final class ResolveNativePointerNodeGen extends ResolveNativePointerNode implements GenerateAOT.Provider {

        static final ReferenceField<PointerData> POINTER_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "pointer_cache", PointerData.class);
        static final ReferenceField<DerefHandleData> DEREF_HANDLE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "derefHandle_cache", DerefHandleData.class);
        static final ReferenceField<ManagedData> MANAGED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "managed_cache", ManagedData.class);
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ResolveNativePointerNode#doPointer}
         *   2: SpecializationActive {@link ResolveNativePointerNode#doDerefHandle}
         *   3: SpecializationActive {@link ResolveNativePointerNode#doManaged}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private PointerData pointer_cache;
        @UnsafeAccessedField @Child private DerefHandleData derefHandle_cache;
        @UnsafeAccessedField @Child private ManagedData managed_cache;

        private ResolveNativePointerNodeGen() {
        }

        @ExplodeLoop
        @Override
        public LLVMPointer execute(Object arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVMAccessForeignObjectNode.ResolveNativePointerNode.doPointer(Object, long, IsPointerNode, AsPointerNode)] || SpecializationActive[LLVMAccessForeignObjectNode.ResolveNativePointerNode.doDerefHandle(Object, long, LLVMDerefHandleGetReceiverNode, IsPointerNode, AsPointerNode)] || SpecializationActive[LLVMAccessForeignObjectNode.ResolveNativePointerNode.doManaged(Object, long, IsPointerNode)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAccessForeignObjectNode.ResolveNativePointerNode.doPointer(Object, long, IsPointerNode, AsPointerNode)] */) {
                    PointerData s0_ = this.pointer_cache;
                    while (s0_ != null) {
                        if ((s0_.isPointerNode_.execute(arg0Value)) && (!(isWrappedAutoDerefHandle(s0_.isPointerNode_, s0_.asPointerNode_, arg0Value)))) {
                            return doPointer(arg0Value, arg1Value, s0_.isPointerNode_, s0_.asPointerNode_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAccessForeignObjectNode.ResolveNativePointerNode.doDerefHandle(Object, long, LLVMDerefHandleGetReceiverNode, IsPointerNode, AsPointerNode)] */) {
                    DerefHandleData s1_ = this.derefHandle_cache;
                    while (s1_ != null) {
                        if ((s1_.isPointerNode_.execute(arg0Value)) && (isWrappedAutoDerefHandle(s1_.isPointerNode_, s1_.asPointerNode_, arg0Value))) {
                            return doDerefHandle(arg0Value, arg1Value, s1_.receiverNode_, s1_.isPointerNode_, s1_.asPointerNode_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAccessForeignObjectNode.ResolveNativePointerNode.doManaged(Object, long, IsPointerNode)] */) {
                    ManagedData s2_ = this.managed_cache;
                    while (s2_ != null) {
                        if ((!(s2_.isPointerNode_.execute(arg0Value)))) {
                            return doManaged(arg0Value, arg1Value, s2_.isPointerNode_);
                        }
                        s2_ = s2_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @SuppressWarnings("unused")
        private LLVMPointer executeAndSpecialize(Object arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            while (true) {
                int count0_ = 0;
                PointerData s0_ = POINTER_CACHE_UPDATER.getVolatile(this);
                PointerData s0_original = s0_;
                while (s0_ != null) {
                    if ((s0_.isPointerNode_.execute(arg0Value)) && (!(isWrappedAutoDerefHandle(s0_.isPointerNode_, s0_.asPointerNode_, arg0Value)))) {
                        break;
                    }
                    count0_++;
                    s0_ = s0_.next_;
                }
                if (s0_ == null) {
                    {
                        IsPointerNode isPointerNode__ = this.insert((IsPointerNodeGen.create()));
                        if ((isPointerNode__.execute(arg0Value))) {
                            AsPointerNode asPointerNode__ = this.insert((AsPointerNodeGen.create()));
                            if ((!(isWrappedAutoDerefHandle(isPointerNode__, asPointerNode__, arg0Value))) && count0_ < (3)) {
                                s0_ = this.insert(new PointerData(s0_original));
                                Objects.requireNonNull(s0_.insert(isPointerNode__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s0_.isPointerNode_ = isPointerNode__;
                                Objects.requireNonNull(s0_.insert(asPointerNode__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s0_.asPointerNode_ = asPointerNode__;
                                if (!POINTER_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAccessForeignObjectNode.ResolveNativePointerNode.doPointer(Object, long, IsPointerNode, AsPointerNode)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                }
                if (s0_ != null) {
                    return doPointer(arg0Value, arg1Value, s0_.isPointerNode_, s0_.asPointerNode_);
                }
                break;
            }
            while (true) {
                int count1_ = 0;
                DerefHandleData s1_ = DEREF_HANDLE_CACHE_UPDATER.getVolatile(this);
                DerefHandleData s1_original = s1_;
                while (s1_ != null) {
                    if ((s1_.isPointerNode_.execute(arg0Value)) && (isWrappedAutoDerefHandle(s1_.isPointerNode_, s1_.asPointerNode_, arg0Value))) {
                        break;
                    }
                    count1_++;
                    s1_ = s1_.next_;
                }
                if (s1_ == null) {
                    {
                        IsPointerNode isPointerNode__1 = this.insert((IsPointerNodeGen.create()));
                        if ((isPointerNode__1.execute(arg0Value))) {
                            AsPointerNode asPointerNode__1 = this.insert((AsPointerNodeGen.create()));
                            if ((isWrappedAutoDerefHandle(isPointerNode__1, asPointerNode__1, arg0Value)) && count1_ < (3)) {
                                s1_ = this.insert(new DerefHandleData(s1_original));
                                LLVMDerefHandleGetReceiverNode receiverNode__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                                Objects.requireNonNull(receiverNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s1_.receiverNode_ = receiverNode__;
                                Objects.requireNonNull(s1_.insert(isPointerNode__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s1_.isPointerNode_ = isPointerNode__1;
                                Objects.requireNonNull(s1_.insert(asPointerNode__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s1_.asPointerNode_ = asPointerNode__1;
                                if (!DEREF_HANDLE_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAccessForeignObjectNode.ResolveNativePointerNode.doDerefHandle(Object, long, LLVMDerefHandleGetReceiverNode, IsPointerNode, AsPointerNode)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                }
                if (s1_ != null) {
                    return doDerefHandle(arg0Value, arg1Value, s1_.receiverNode_, s1_.isPointerNode_, s1_.asPointerNode_);
                }
                break;
            }
            while (true) {
                int count2_ = 0;
                ManagedData s2_ = MANAGED_CACHE_UPDATER.getVolatile(this);
                ManagedData s2_original = s2_;
                while (s2_ != null) {
                    if ((!(s2_.isPointerNode_.execute(arg0Value)))) {
                        break;
                    }
                    count2_++;
                    s2_ = s2_.next_;
                }
                if (s2_ == null) {
                    {
                        IsPointerNode isPointerNode__2 = this.insert((IsPointerNodeGen.create()));
                        if ((!(isPointerNode__2.execute(arg0Value))) && count2_ < (3)) {
                            s2_ = this.insert(new ManagedData(s2_original));
                            Objects.requireNonNull(s2_.insert(isPointerNode__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.isPointerNode_ = isPointerNode__2;
                            if (!MANAGED_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMAccessForeignObjectNode.ResolveNativePointerNode.doManaged(Object, long, IsPointerNode)] */;
                            this.state_0_ = state_0;
                        }
                    }
                }
                if (s2_ != null) {
                    return doManaged(arg0Value, arg1Value, s2_.isPointerNode_);
                }
                break;
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                PointerData s0_ = this.insert(new PointerData(this.pointer_cache));
                IsPointerNode isPointerNode__ = s0_.insert((IsPointerNodeGen.create()));
                Objects.requireNonNull(isPointerNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.isPointerNode_ = isPointerNode__;
                AsPointerNode asPointerNode__ = s0_.insert((AsPointerNodeGen.create()));
                Objects.requireNonNull(asPointerNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.asPointerNode_ = asPointerNode__;
                VarHandle.storeStoreFence();
                this.pointer_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.isPointerNode_, 1);
                ((GenerateAOT.Provider) s0_.isPointerNode_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s0_.asPointerNode_, 1);
                ((GenerateAOT.Provider) s0_.asPointerNode_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAccessForeignObjectNode.ResolveNativePointerNode.doPointer(Object, long, IsPointerNode, AsPointerNode)] */;
            }
            {
                DerefHandleData s1_ = this.insert(new DerefHandleData(this.derefHandle_cache));
                LLVMDerefHandleGetReceiverNode receiverNode__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(receiverNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s1_.receiverNode_ = receiverNode__;
                IsPointerNode isPointerNode__1 = s1_.insert((IsPointerNodeGen.create()));
                Objects.requireNonNull(isPointerNode__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s1_.isPointerNode_ = isPointerNode__1;
                AsPointerNode asPointerNode__1 = s1_.insert((AsPointerNodeGen.create()));
                Objects.requireNonNull(asPointerNode__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s1_.asPointerNode_ = asPointerNode__1;
                VarHandle.storeStoreFence();
                this.derefHandle_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.receiverNode_, 1);
                ((GenerateAOT.Provider) s1_.receiverNode_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s1_.isPointerNode_, 1);
                ((GenerateAOT.Provider) s1_.isPointerNode_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s1_.asPointerNode_, 1);
                ((GenerateAOT.Provider) s1_.asPointerNode_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAccessForeignObjectNode.ResolveNativePointerNode.doDerefHandle(Object, long, LLVMDerefHandleGetReceiverNode, IsPointerNode, AsPointerNode)] */;
            }
            {
                ManagedData s2_ = this.insert(new ManagedData(this.managed_cache));
                IsPointerNode isPointerNode__2 = s2_.insert((IsPointerNodeGen.create()));
                Objects.requireNonNull(isPointerNode__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s2_.isPointerNode_ = isPointerNode__2;
                VarHandle.storeStoreFence();
                this.managed_cache = s2_;
                assert NodeUtil.assertRecursion(s2_.isPointerNode_, 1);
                ((GenerateAOT.Provider) s2_.isPointerNode_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMAccessForeignObjectNode.ResolveNativePointerNode.doManaged(Object, long, IsPointerNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
            this.derefHandle_cache = null;
            this.managed_cache = null;
        }

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException2LJ(Node thisNode_, Object arg0Value, long arg1Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
        }

        @NeverDefault
        public static ResolveNativePointerNode create() {
            return new ResolveNativePointerNodeGen();
        }

        @NeverDefault
        public static ResolveNativePointerNode getUncached() {
            return ResolveNativePointerNodeGen.UNCACHED;
        }

        @GeneratedBy(ResolveNativePointerNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            @Child PointerData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ResolveNativePointerNode#doPointer}
             *   Parameter: {@link IsPointerNode} isPointerNode</pre>
             */
            @Child IsPointerNode isPointerNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ResolveNativePointerNode#doPointer}
             *   Parameter: {@link AsPointerNode} asPointerNode</pre>
             */
            @Child AsPointerNode asPointerNode_;

            PointerData(PointerData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ResolveNativePointerNode.class)
        @DenyReplace
        private static final class DerefHandleData extends Node implements SpecializationDataNode {

            @Child DerefHandleData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ResolveNativePointerNode#doDerefHandle}
             *   Parameter: {@link LLVMDerefHandleGetReceiverNode} receiverNode</pre>
             */
            @Child LLVMDerefHandleGetReceiverNode receiverNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ResolveNativePointerNode#doDerefHandle}
             *   Parameter: {@link IsPointerNode} isPointerNode</pre>
             */
            @Child IsPointerNode isPointerNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ResolveNativePointerNode#doDerefHandle}
             *   Parameter: {@link AsPointerNode} asPointerNode</pre>
             */
            @Child AsPointerNode asPointerNode_;

            DerefHandleData(DerefHandleData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ResolveNativePointerNode.class)
        @DenyReplace
        private static final class ManagedData extends Node implements SpecializationDataNode {

            @Child ManagedData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ResolveNativePointerNode#doManaged}
             *   Parameter: {@link IsPointerNode} isPointerNode</pre>
             */
            @Child IsPointerNode isPointerNode_;

            ManagedData(ManagedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ResolveNativePointerNode.class)
        @DenyReplace
        private static final class Uncached extends ResolveNativePointerNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            public LLVMPointer execute(Object arg0Value, long arg1Value) {
                if (((IsPointerNodeGen.getUncached()).execute(arg0Value)) && (!(isWrappedAutoDerefHandle((IsPointerNodeGen.getUncached()), (AsPointerNodeGen.getUncached()), arg0Value)))) {
                    return doPointer(arg0Value, arg1Value, (IsPointerNodeGen.getUncached()), (AsPointerNodeGen.getUncached()));
                }
                if (((IsPointerNodeGen.getUncached()).execute(arg0Value)) && (isWrappedAutoDerefHandle((IsPointerNodeGen.getUncached()), (AsPointerNodeGen.getUncached()), arg0Value))) {
                    return doDerefHandle(arg0Value, arg1Value, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (IsPointerNodeGen.getUncached()), (AsPointerNodeGen.getUncached()));
                }
                if ((!((IsPointerNodeGen.getUncached()).execute(arg0Value)))) {
                    return doManaged(arg0Value, arg1Value, (IsPointerNodeGen.getUncached()));
                }
                throw newUnsupportedSpecializationException2LJ(this, arg0Value, arg1Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link GetForeignTypeNode#doNative}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link GetForeignTypeNode#doManagedWithType}
     *     Activation probability: 0.23095
     *     With/without class size: 8/4 bytes
     *   Specialization {@link GetForeignTypeNode#doManagedBuffer}
     *     Activation probability: 0.18810
     *     With/without class size: 9/8 bytes
     *   Specialization {@link GetForeignTypeNode#doManagedBuffer}
     *     Activation probability: 0.14524
     *     With/without class size: 5/0 bytes
     *   Specialization {@link GetForeignTypeNode#doManagedUnknown}
     *     Activation probability: 0.10238
     *     With/without class size: 6/8 bytes
     *   Specialization {@link GetForeignTypeNode#doManagedUnknown}
     *     Activation probability: 0.05952
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(GetForeignTypeNode.class)
    @SuppressWarnings("javadoc")
    static final class GetForeignTypeNodeGen extends GetForeignTypeNode implements GenerateAOT.Provider {

        static final ReferenceField<ManagedBuffer0Data> MANAGED_BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "managedBuffer0_cache", ManagedBuffer0Data.class);
        static final ReferenceField<ManagedUnknown0Data> MANAGED_UNKNOWN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "managedUnknown0_cache", ManagedUnknown0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link GetForeignTypeNode#doNative}
         *   2: SpecializationActive {@link GetForeignTypeNode#doManagedWithType}
         *   3: SpecializationActive {@link GetForeignTypeNode#doManagedBuffer}
         *   4: SpecializationActive {@link GetForeignTypeNode#doManagedBuffer}
         *   5: SpecializationActive {@link GetForeignTypeNode#doManagedUnknown}
         *   6: SpecializationActive {@link GetForeignTypeNode#doManagedUnknown}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link GetForeignTypeNode#doManagedWithType}
         *   Parameter: {@link NativeTypeLibrary} types</pre>
         */
        @Child private NativeTypeLibrary managedWithType_types_;
        @UnsafeAccessedField @Child private ManagedBuffer0Data managedBuffer0_cache;
        @UnsafeAccessedField @Child private ManagedUnknown0Data managedUnknown0_cache;

        private GetForeignTypeNodeGen() {
        }

        @ExplodeLoop
        @Override
        public Object execute(LLVMPointer arg0Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value);
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doNative(LLVMNativePointer)] || SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedWithType(LLVMManagedPointer, NativeTypeLibrary)] || SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedBuffer(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] || SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedBuffer(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] || SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedUnknown(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] || SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedUnknown(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doNative(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    return doNative(arg0Value_);
                }
                if ((state_0 & 0b1111100) != 0 /* is SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedWithType(LLVMManagedPointer, NativeTypeLibrary)] || SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedBuffer(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] || SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedBuffer(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] || SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedUnknown(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] || SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedUnknown(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedWithType(LLVMManagedPointer, NativeTypeLibrary)] */) {
                        {
                            NativeTypeLibrary types__ = this.managedWithType_types_;
                            if (types__ != null) {
                                if ((types__.hasNativeType(arg0Value_.getObject()))) {
                                    return doManagedWithType(arg0Value_, types__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedBuffer(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] */) {
                        ManagedBuffer0Data s2_ = this.managedBuffer0_cache;
                        while (s2_ != null) {
                            if ((s2_.types_.accepts(arg0Value_.getObject())) && (s2_.interop_.accepts(arg0Value_.getObject())) && (!(s2_.types_.hasNativeType(arg0Value_.getObject()))) && (s2_.interop_.hasBufferElements(arg0Value_.getObject()))) {
                                return doManagedBuffer(arg0Value_, s2_.types_, s2_.interop_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedBuffer(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                NativeTypeLibrary types__1 = (NATIVE_TYPE_LIBRARY_.getUncached());
                                if ((!(types__1.hasNativeType(arg0Value_.getObject())))) {
                                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__.hasBufferElements(arg0Value_.getObject()))) {
                                        return this.managedBuffer1Boundary(state_0, arg0Value_);
                                    }
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedUnknown(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] */) {
                        ManagedUnknown0Data s4_ = this.managedUnknown0_cache;
                        while (s4_ != null) {
                            if ((s4_.types_.accepts(arg0Value_.getObject())) && (s4_.interop_.accepts(arg0Value_.getObject())) && (!(s4_.types_.hasNativeType(arg0Value_.getObject()))) && (!(s4_.interop_.hasBufferElements(arg0Value_.getObject())))) {
                                return doManagedUnknown(arg0Value_, s4_.types_, s4_.interop_);
                            }
                            s4_ = s4_.next_;
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedUnknown(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                NativeTypeLibrary types__2 = (NATIVE_TYPE_LIBRARY_.getUncached());
                                if ((!(types__2.hasNativeType(arg0Value_.getObject())))) {
                                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                                    if ((!(interop__1.hasBufferElements(arg0Value_.getObject())))) {
                                        return this.managedUnknown1Boundary(state_0, arg0Value_);
                                    }
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object managedBuffer1Boundary(int state_0, LLVMManagedPointer arg0Value_) {
            {
                NativeTypeLibrary types__1 = (NATIVE_TYPE_LIBRARY_.getUncached());
                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                return doManagedBuffer(arg0Value_, types__1, interop__);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object managedUnknown1Boundary(int state_0, LLVMManagedPointer arg0Value_) {
            {
                NativeTypeLibrary types__2 = (NATIVE_TYPE_LIBRARY_.getUncached());
                InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                return doManagedUnknown(arg0Value_, types__2, interop__1);
            }
        }

        @SuppressWarnings("unused")
        private Object executeAndSpecialize(LLVMPointer arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doNative(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doNative(arg0Value_);
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                {
                    NativeTypeLibrary types__ = this.insert((NATIVE_TYPE_LIBRARY_.createDispatched(3)));
                    if ((types__.hasNativeType(arg0Value_.getObject()))) {
                        Objects.requireNonNull(this.insert(types__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.managedWithType_types_ = types__;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedWithType(LLVMManagedPointer, NativeTypeLibrary)] */;
                        this.state_0_ = state_0;
                        return doManagedWithType(arg0Value_, types__);
                    }
                }
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedBuffer(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        ManagedBuffer0Data s2_ = MANAGED_BUFFER0_CACHE_UPDATER.getVolatile(this);
                        ManagedBuffer0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.types_.accepts(arg0Value_.getObject())) && (s2_.interop_.accepts(arg0Value_.getObject())) && (!(s2_.types_.hasNativeType(arg0Value_.getObject()))) && (s2_.interop_.hasBufferElements(arg0Value_.getObject()))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            {
                                NativeTypeLibrary types__1 = this.insert((NATIVE_TYPE_LIBRARY_.create(arg0Value_.getObject())));
                                // assert (s2_.types_.accepts(arg0Value_.getObject()));
                                // assert (s2_.interop_.accepts(arg0Value_.getObject()));
                                if ((!(types__1.hasNativeType(arg0Value_.getObject())))) {
                                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg0Value_.getObject())));
                                    if ((interop__.hasBufferElements(arg0Value_.getObject())) && count2_ < (3)) {
                                        s2_ = this.insert(new ManagedBuffer0Data(s2_original));
                                        Objects.requireNonNull(s2_.insert(types__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s2_.types_ = types__1;
                                        Objects.requireNonNull(s2_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s2_.interop_ = interop__;
                                        if (!MANAGED_BUFFER0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedBuffer(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                        }
                        if (s2_ != null) {
                            return doManagedBuffer(arg0Value_, s2_.types_, s2_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__ = null;
                    NativeTypeLibrary types__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                types__1 = (NATIVE_TYPE_LIBRARY_.getUncached());
                                if ((!(types__1.hasNativeType(arg0Value_.getObject())))) {
                                    interop__ = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__.hasBufferElements(arg0Value_.getObject()))) {
                                        this.managedBuffer0_cache = null;
                                        state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedBuffer(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] */;
                                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedBuffer(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] */;
                                        this.state_0_ = state_0;
                                        return doManagedBuffer(arg0Value_, types__1, interop__);
                                    }
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedUnknown(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] */) {
                    while (true) {
                        int count4_ = 0;
                        ManagedUnknown0Data s4_ = MANAGED_UNKNOWN0_CACHE_UPDATER.getVolatile(this);
                        ManagedUnknown0Data s4_original = s4_;
                        while (s4_ != null) {
                            if ((s4_.types_.accepts(arg0Value_.getObject())) && (s4_.interop_.accepts(arg0Value_.getObject())) && (!(s4_.types_.hasNativeType(arg0Value_.getObject()))) && (!(s4_.interop_.hasBufferElements(arg0Value_.getObject())))) {
                                break;
                            }
                            count4_++;
                            s4_ = s4_.next_;
                        }
                        if (s4_ == null) {
                            {
                                NativeTypeLibrary types__2 = this.insert((NATIVE_TYPE_LIBRARY_.create(arg0Value_.getObject())));
                                // assert (s4_.types_.accepts(arg0Value_.getObject()));
                                // assert (s4_.interop_.accepts(arg0Value_.getObject()));
                                if ((!(types__2.hasNativeType(arg0Value_.getObject())))) {
                                    InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.create(arg0Value_.getObject())));
                                    if ((!(interop__1.hasBufferElements(arg0Value_.getObject()))) && count4_ < (3)) {
                                        s4_ = this.insert(new ManagedUnknown0Data(s4_original));
                                        Objects.requireNonNull(s4_.insert(types__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s4_.types_ = types__2;
                                        Objects.requireNonNull(s4_.insert(interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s4_.interop_ = interop__1;
                                        if (!MANAGED_UNKNOWN0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedUnknown(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                        }
                        if (s4_ != null) {
                            return doManagedUnknown(arg0Value_, s4_.types_, s4_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    NativeTypeLibrary types__2 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                types__2 = (NATIVE_TYPE_LIBRARY_.getUncached());
                                if ((!(types__2.hasNativeType(arg0Value_.getObject())))) {
                                    interop__1 = (INTEROP_LIBRARY_.getUncached());
                                    if ((!(interop__1.hasBufferElements(arg0Value_.getObject())))) {
                                        this.managedUnknown0_cache = null;
                                        state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedUnknown(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] */;
                                        state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedUnknown(LLVMManagedPointer, NativeTypeLibrary, InteropLibrary)] */;
                                        this.state_0_ = state_0;
                                        return doManagedUnknown(arg0Value_, types__2, interop__1);
                                    }
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doNative(LLVMNativePointer)] */;
            }
            {
                NativeTypeLibrary types__ = this.insert((NATIVE_TYPE_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(types__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.managedWithType_types_ = types__;
                if (this.managedWithType_types_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.managedWithType_types_, 1);
                    ((GenerateAOT.Provider) this.managedWithType_types_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAccessForeignObjectNode.GetForeignTypeNode.doManagedWithType(LLVMManagedPointer, NativeTypeLibrary)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.managedWithType_types_ = null;
        }

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException1(Node thisNode_, Object arg0Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value);
        }

        @NeverDefault
        public static GetForeignTypeNode create() {
            return new GetForeignTypeNodeGen();
        }

        @NeverDefault
        public static GetForeignTypeNode getUncached() {
            return GetForeignTypeNodeGen.UNCACHED;
        }

        @GeneratedBy(GetForeignTypeNode.class)
        @DenyReplace
        private static final class ManagedBuffer0Data extends Node implements SpecializationDataNode {

            @Child ManagedBuffer0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetForeignTypeNode#doManagedBuffer}
             *   Parameter: {@link NativeTypeLibrary} types</pre>
             */
            @Child NativeTypeLibrary types_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetForeignTypeNode#doManagedBuffer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            ManagedBuffer0Data(ManagedBuffer0Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(GetForeignTypeNode.class)
        @DenyReplace
        private static final class ManagedUnknown0Data extends Node implements SpecializationDataNode {

            @Child ManagedUnknown0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetForeignTypeNode#doManagedUnknown}
             *   Parameter: {@link NativeTypeLibrary} types</pre>
             */
            @Child NativeTypeLibrary types_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetForeignTypeNode#doManagedUnknown}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            ManagedUnknown0Data(ManagedUnknown0Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(GetForeignTypeNode.class)
        @DenyReplace
        private static final class Uncached extends GetForeignTypeNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            public Object execute(LLVMPointer arg0Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    return doNative(arg0Value_);
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if (((NATIVE_TYPE_LIBRARY_.getUncached()).hasNativeType(arg0Value_.getObject()))) {
                        return doManagedWithType(arg0Value_, (NATIVE_TYPE_LIBRARY_.getUncached()));
                    }
                    if ((!((NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject())).hasNativeType(arg0Value_.getObject()))) && ((INTEROP_LIBRARY_.getUncached(arg0Value_.getObject())).hasBufferElements(arg0Value_.getObject()))) {
                        return doManagedBuffer(arg0Value_, (NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject())), (INTEROP_LIBRARY_.getUncached(arg0Value_.getObject())));
                    }
                    if ((!((NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject())).hasNativeType(arg0Value_.getObject()))) && (!((INTEROP_LIBRARY_.getUncached(arg0Value_.getObject())).hasBufferElements(arg0Value_.getObject())))) {
                        return doManagedUnknown(arg0Value_, (NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject())), (INTEROP_LIBRARY_.getUncached(arg0Value_.getObject())));
                    }
                }
                throw newUnsupportedSpecializationException1(this, arg0Value);
            }

        }
    }
}
