// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Array;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Clazz;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Struct;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.StructMember;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Value;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMInteropAccessNode#doArrayCachedTypeSize}
 *     Activation probability: 0.32000
 *     With/without class size: 14/12 bytes
 *   Specialization {@link LLVMInteropAccessNode#doArray}
 *     Activation probability: 0.26000
 *     With/without class size: 9/4 bytes
 *   Specialization {@link LLVMInteropAccessNode#doClazzInheritance}
 *     Activation probability: 0.20000
 *     With/without class size: 9/8 bytes
 *   Specialization {@link LLVMInteropAccessNode#doStructMember}
 *     Activation probability: 0.14000
 *     With/without class size: 7/8 bytes
 *   Specialization {@link LLVMInteropAccessNode#doStruct}
 *     Activation probability: 0.08000
 *     With/without class size: 5/8 bytes
 * </pre>
 */
@GeneratedBy(LLVMInteropAccessNode.class)
@SuppressWarnings({"javadoc", "unused"})
final class LLVMInteropAccessNodeGen extends LLVMInteropAccessNode implements GenerateAOT.Provider {

    static final ReferenceField<ArrayCachedTypeSizeData> ARRAY_CACHED_TYPE_SIZE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "arrayCachedTypeSize_cache", ArrayCachedTypeSizeData.class);
    static final ReferenceField<ClazzInheritanceData> CLAZZ_INHERITANCE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "clazzInheritance_cache", ClazzInheritanceData.class);
    static final ReferenceField<StructMemberData> STRUCT_MEMBER_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "structMember_cache", StructMemberData.class);
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMInteropAccessNode#doArrayCachedTypeSize}
     *   2: SpecializationActive {@link LLVMInteropAccessNode#doArray}
     *   3: SpecializationActive {@link LLVMInteropAccessNode#doClazzInheritance}
     *   4: SpecializationActive {@link LLVMInteropAccessNode#doStructMember}
     *   5: SpecializationActive {@link LLVMInteropAccessNode#doStruct}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @Child private ArrayCachedTypeSizeData arrayCachedTypeSize_cache;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMInteropAccessNode#doArray}
     *   Parameter: {@link MakeAccessLocation} makeAccessLocation</pre>
     */
    @Child private MakeAccessLocation array_makeAccessLocation_;
    @UnsafeAccessedField @Child private ClazzInheritanceData clazzInheritance_cache;
    @UnsafeAccessedField @Child private StructMemberData structMember_cache;
    @Child private StructData struct_cache;

    private LLVMInteropAccessNodeGen() {
    }

    @ExplodeLoop
    @Override
    protected AccessLocation execute(Structured arg0Value, Object arg1Value, long arg2Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }
        if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMInteropAccessNode.doArrayCachedTypeSize(Array, Object, long, MakeAccessLocation, long)] || SpecializationActive[LLVMInteropAccessNode.doArray(Array, Object, long, MakeAccessLocation)] || SpecializationActive[LLVMInteropAccessNode.doClazzInheritance(Clazz, Object, long, StructMember, LLVMInteropAccessNode)] || SpecializationActive[LLVMInteropAccessNode.doStructMember(Struct, Object, long, StructMember, MakeAccessLocation)] || SpecializationActive[LLVMInteropAccessNode.doStruct(Struct, Object, long, LLVMInteropAccessNode, MakeAccessLocation)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMInteropAccessNode.doArrayCachedTypeSize(Array, Object, long, MakeAccessLocation, long)] || SpecializationActive[LLVMInteropAccessNode.doArray(Array, Object, long, MakeAccessLocation)] */ && arg0Value instanceof Array) {
                Array arg0Value_ = (Array) arg0Value;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropAccessNode.doArrayCachedTypeSize(Array, Object, long, MakeAccessLocation, long)] */) {
                    ArrayCachedTypeSizeData s0_ = this.arrayCachedTypeSize_cache;
                    while (s0_ != null) {
                        if ((s0_.cachedElementSize_ == arg0Value_.elementSize)) {
                            return doArrayCachedTypeSize(arg0Value_, arg1Value, arg2Value, s0_.makeAccessLocation_, s0_.cachedElementSize_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropAccessNode.doArray(Array, Object, long, MakeAccessLocation)] */) {
                    {
                        MakeAccessLocation makeAccessLocation__ = this.array_makeAccessLocation_;
                        if (makeAccessLocation__ != null) {
                            return doArray(arg0Value_, arg1Value, arg2Value, makeAccessLocation__);
                        }
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMInteropAccessNode.doClazzInheritance(Clazz, Object, long, StructMember, LLVMInteropAccessNode)] */ && arg0Value instanceof Clazz) {
                Clazz arg0Value_ = (Clazz) arg0Value;
                ClazzInheritanceData s2_ = this.clazzInheritance_cache;
                while (s2_ != null) {
                    if ((LLVMInteropAccessNode.checkMember(arg0Value_, s2_.cachedMember_, arg2Value))) {
                        assert DSLSupport.assertIdempotence((s2_.cachedMember_.isInheritanceMember));
                        return doClazzInheritance(arg0Value_, arg1Value, arg2Value, s2_.cachedMember_, s2_.recursiveNode_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state_0 & 0b110000) != 0 /* is SpecializationActive[LLVMInteropAccessNode.doStructMember(Struct, Object, long, StructMember, MakeAccessLocation)] || SpecializationActive[LLVMInteropAccessNode.doStruct(Struct, Object, long, LLVMInteropAccessNode, MakeAccessLocation)] */ && arg0Value instanceof Struct) {
                Struct arg0Value_ = (Struct) arg0Value;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMInteropAccessNode.doStructMember(Struct, Object, long, StructMember, MakeAccessLocation)] */) {
                    StructMemberData s3_ = this.structMember_cache;
                    while (s3_ != null) {
                        if ((LLVMInteropAccessNode.checkMember(arg0Value_, s3_.cachedMember_, arg2Value))) {
                            assert DSLSupport.assertIdempotence((!(s3_.cachedMember_.isInheritanceMember)));
                            return doStructMember(arg0Value_, arg1Value, arg2Value, s3_.cachedMember_, s3_.makeAccessLocation_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMInteropAccessNode.doStruct(Struct, Object, long, LLVMInteropAccessNode, MakeAccessLocation)] */) {
                    StructData s4_ = this.struct_cache;
                    if (s4_ != null) {
                        return doStruct(arg0Value_, arg1Value, arg2Value, s4_.recursiveNode_, s4_.makeAccessLocation_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private AccessLocation executeAndSpecialize(Structured arg0Value, Object arg1Value, long arg2Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg0Value instanceof Array) {
            Array arg0Value_ = (Array) arg0Value;
            if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMInteropAccessNode.doArray(Array, Object, long, MakeAccessLocation)] */) {
                while (true) {
                    int count0_ = 0;
                    ArrayCachedTypeSizeData s0_ = ARRAY_CACHED_TYPE_SIZE_CACHE_UPDATER.getVolatile(this);
                    ArrayCachedTypeSizeData s0_original = s0_;
                    while (s0_ != null) {
                        if ((s0_.cachedElementSize_ == arg0Value_.elementSize)) {
                            break;
                        }
                        count0_++;
                        s0_ = s0_.next_;
                    }
                    if (s0_ == null) {
                        // assert (s0_.cachedElementSize_ == arg0Value_.elementSize);
                        if (count0_ < (3)) {
                            s0_ = this.insert(new ArrayCachedTypeSizeData(s0_original));
                            MakeAccessLocation makeAccessLocation__1 = s0_.insert((MakeAccessLocationNodeGen.create()));
                            Objects.requireNonNull(makeAccessLocation__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.makeAccessLocation_ = makeAccessLocation__1;
                            s0_.cachedElementSize_ = (arg0Value_.elementSize);
                            if (!ARRAY_CACHED_TYPE_SIZE_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMInteropAccessNode.doArrayCachedTypeSize(Array, Object, long, MakeAccessLocation, long)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s0_ != null) {
                        return doArrayCachedTypeSize(arg0Value_, arg1Value, arg2Value, s0_.makeAccessLocation_, s0_.cachedElementSize_);
                    }
                    break;
                }
            }
            MakeAccessLocation makeAccessLocation__ = this.insert((MakeAccessLocationNodeGen.create()));
            Objects.requireNonNull(makeAccessLocation__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.array_makeAccessLocation_ = makeAccessLocation__;
            this.arrayCachedTypeSize_cache = null;
            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMInteropAccessNode.doArrayCachedTypeSize(Array, Object, long, MakeAccessLocation, long)] */;
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMInteropAccessNode.doArray(Array, Object, long, MakeAccessLocation)] */;
            this.state_0_ = state_0;
            return doArray(arg0Value_, arg1Value, arg2Value, makeAccessLocation__);
        }
        if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[LLVMInteropAccessNode.doStruct(Struct, Object, long, LLVMInteropAccessNode, MakeAccessLocation)] */ && arg0Value instanceof Clazz) {
            Clazz arg0Value_ = (Clazz) arg0Value;
            while (true) {
                int count2_ = 0;
                ClazzInheritanceData s2_ = CLAZZ_INHERITANCE_CACHE_UPDATER.getVolatile(this);
                ClazzInheritanceData s2_original = s2_;
                while (s2_ != null) {
                    if ((LLVMInteropAccessNode.checkMember(arg0Value_, s2_.cachedMember_, arg2Value))) {
                        assert DSLSupport.assertIdempotence((s2_.cachedMember_.isInheritanceMember));
                        break;
                    }
                    count2_++;
                    s2_ = s2_.next_;
                }
                if (s2_ == null) {
                    {
                        StructMember cachedMember__ = (LLVMInteropAccessNode.findMember(arg0Value_, arg2Value));
                        if ((LLVMInteropAccessNode.checkMember(arg0Value_, cachedMember__, arg2Value)) && (cachedMember__.isInheritanceMember) && count2_ < (3)) {
                            s2_ = this.insert(new ClazzInheritanceData(s2_original));
                            s2_.cachedMember_ = cachedMember__;
                            s2_.recursiveNode_ = s2_.insert((LLVMInteropAccessNode.create()));
                            if (!CLAZZ_INHERITANCE_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMInteropAccessNode.doClazzInheritance(Clazz, Object, long, StructMember, LLVMInteropAccessNode)] */;
                            this.state_0_ = state_0;
                        }
                    }
                }
                if (s2_ != null) {
                    return doClazzInheritance(arg0Value_, arg1Value, arg2Value, s2_.cachedMember_, s2_.recursiveNode_);
                }
                break;
            }
        }
        if (arg0Value instanceof Struct) {
            Struct arg0Value_ = (Struct) arg0Value;
            if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[LLVMInteropAccessNode.doStruct(Struct, Object, long, LLVMInteropAccessNode, MakeAccessLocation)] */) {
                while (true) {
                    int count3_ = 0;
                    StructMemberData s3_ = STRUCT_MEMBER_CACHE_UPDATER.getVolatile(this);
                    StructMemberData s3_original = s3_;
                    while (s3_ != null) {
                        if ((LLVMInteropAccessNode.checkMember(arg0Value_, s3_.cachedMember_, arg2Value))) {
                            assert DSLSupport.assertIdempotence((!(s3_.cachedMember_.isInheritanceMember)));
                            break;
                        }
                        count3_++;
                        s3_ = s3_.next_;
                    }
                    if (s3_ == null) {
                        {
                            StructMember cachedMember__1 = (LLVMInteropAccessNode.findMember(arg0Value_, arg2Value));
                            if ((LLVMInteropAccessNode.checkMember(arg0Value_, cachedMember__1, arg2Value)) && (!(cachedMember__1.isInheritanceMember)) && count3_ < (3)) {
                                s3_ = this.insert(new StructMemberData(s3_original));
                                s3_.cachedMember_ = cachedMember__1;
                                MakeAccessLocation makeAccessLocation__2 = s3_.insert((MakeAccessLocationNodeGen.create()));
                                Objects.requireNonNull(makeAccessLocation__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s3_.makeAccessLocation_ = makeAccessLocation__2;
                                if (!STRUCT_MEMBER_CACHE_UPDATER.compareAndSet(this, s3_original, s3_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMInteropAccessNode.doStructMember(Struct, Object, long, StructMember, MakeAccessLocation)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                    if (s3_ != null) {
                        return doStructMember(arg0Value_, arg1Value, arg2Value, s3_.cachedMember_, s3_.makeAccessLocation_);
                    }
                    break;
                }
            }
            StructData s4_ = this.insert(new StructData());
            s4_.recursiveNode_ = s4_.insert((LLVMInteropAccessNode.create()));
            MakeAccessLocation makeAccessLocation__3 = s4_.insert((MakeAccessLocationNodeGen.create()));
            Objects.requireNonNull(makeAccessLocation__3, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s4_.makeAccessLocation_ = makeAccessLocation__3;
            VarHandle.storeStoreFence();
            this.struct_cache = s4_;
            this.clazzInheritance_cache = null;
            this.structMember_cache = null;
            state_0 = state_0 & 0xffffffe7 /* remove SpecializationActive[LLVMInteropAccessNode.doClazzInheritance(Clazz, Object, long, StructMember, LLVMInteropAccessNode)], SpecializationActive[LLVMInteropAccessNode.doStructMember(Struct, Object, long, StructMember, MakeAccessLocation)] */;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMInteropAccessNode.doStruct(Struct, Object, long, LLVMInteropAccessNode, MakeAccessLocation)] */;
            this.state_0_ = state_0;
            return doStruct(arg0Value_, arg1Value, arg2Value, s4_.recursiveNode_, makeAccessLocation__3);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            MakeAccessLocation makeAccessLocation__ = this.insert((MakeAccessLocationNodeGen.create()));
            Objects.requireNonNull(makeAccessLocation__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.array_makeAccessLocation_ = makeAccessLocation__;
            this.arrayCachedTypeSize_cache = null;
            this.state_0_ = state_0_ & 0xfffffffd /* remove SpecializationActive[LLVMInteropAccessNode.doArrayCachedTypeSize(Array, Object, long, MakeAccessLocation, long)] */;
            assert NodeUtil.assertRecursion(this.array_makeAccessLocation_, 1);
            ((GenerateAOT.Provider) this.array_makeAccessLocation_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMInteropAccessNode.doArray(Array, Object, long, MakeAccessLocation)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.array_makeAccessLocation_ = null;
    }

    @TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException3LLJ(Node thisNode_, Object arg0Value, Object arg1Value, long arg2Value) {
        return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value);
    }

    @NeverDefault
    public static LLVMInteropAccessNode create() {
        return new LLVMInteropAccessNodeGen();
    }

    @NeverDefault
    public static LLVMInteropAccessNode getUncached() {
        return LLVMInteropAccessNodeGen.UNCACHED;
    }

    @GeneratedBy(LLVMInteropAccessNode.class)
    @DenyReplace
    private static final class ArrayCachedTypeSizeData extends Node implements SpecializationDataNode {

        @Child ArrayCachedTypeSizeData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropAccessNode#doArrayCachedTypeSize}
         *   Parameter: {@link MakeAccessLocation} makeAccessLocation</pre>
         */
        @Child MakeAccessLocation makeAccessLocation_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropAccessNode#doArrayCachedTypeSize}
         *   Parameter: long cachedElementSize</pre>
         */
        @CompilationFinal long cachedElementSize_;

        ArrayCachedTypeSizeData(ArrayCachedTypeSizeData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMInteropAccessNode.class)
    @DenyReplace
    private static final class ClazzInheritanceData extends Node implements SpecializationDataNode {

        @Child ClazzInheritanceData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropAccessNode#doClazzInheritance}
         *   Parameter: {@link StructMember} cachedMember</pre>
         */
        @CompilationFinal StructMember cachedMember_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropAccessNode#doClazzInheritance}
         *   Parameter: {@link LLVMInteropAccessNode} recursiveNode</pre>
         */
        @Child LLVMInteropAccessNode recursiveNode_;

        ClazzInheritanceData(ClazzInheritanceData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMInteropAccessNode.class)
    @DenyReplace
    private static final class StructMemberData extends Node implements SpecializationDataNode {

        @Child StructMemberData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropAccessNode#doStructMember}
         *   Parameter: {@link StructMember} cachedMember</pre>
         */
        @CompilationFinal StructMember cachedMember_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropAccessNode#doStructMember}
         *   Parameter: {@link MakeAccessLocation} makeAccessLocation</pre>
         */
        @Child MakeAccessLocation makeAccessLocation_;

        StructMemberData(StructMemberData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMInteropAccessNode.class)
    @DenyReplace
    private static final class StructData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropAccessNode#doStruct}
         *   Parameter: {@link LLVMInteropAccessNode} recursiveNode</pre>
         */
        @Child LLVMInteropAccessNode recursiveNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropAccessNode#doStruct}
         *   Parameter: {@link MakeAccessLocation} makeAccessLocation</pre>
         */
        @Child MakeAccessLocation makeAccessLocation_;

        StructData() {
        }

    }
    @GeneratedBy(LLVMInteropAccessNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMInteropAccessNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        protected AccessLocation execute(Structured arg0Value, Object arg1Value, long arg2Value) {
            if (arg0Value instanceof Array) {
                Array arg0Value_ = (Array) arg0Value;
                return doArray(arg0Value_, arg1Value, arg2Value, (MakeAccessLocationNodeGen.getUncached()));
            }
            if (arg0Value instanceof Struct) {
                Struct arg0Value_ = (Struct) arg0Value;
                return doStruct(arg0Value_, arg1Value, arg2Value, (LLVMInteropAccessNodeGen.getUncached()), (MakeAccessLocationNodeGen.getUncached()));
            }
            throw newUnsupportedSpecializationException3LLJ(this, arg0Value, arg1Value, arg2Value);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link MakeAccessLocation#doValue}
     *     Activation probability: 0.32000
     *     With/without class size: 7/0 bytes
     *   Specialization {@link MakeAccessLocation#doRecursiveObject}
     *     Activation probability: 0.26000
     *     With/without class size: 12/12 bytes
     *   Specialization {@link MakeAccessLocation#doRecursiveObject}
     *     Activation probability: 0.20000
     *     With/without class size: 8/8 bytes
     *   Specialization {@link MakeAccessLocation#doRecursiveArray}
     *     Activation probability: 0.14000
     *     With/without class size: 8/12 bytes
     *   Specialization {@link MakeAccessLocation#doRecursiveArray}
     *     Activation probability: 0.08000
     *     With/without class size: 5/8 bytes
     * </pre>
     */
    @GeneratedBy(MakeAccessLocation.class)
    @SuppressWarnings("javadoc")
    static final class MakeAccessLocationNodeGen extends MakeAccessLocation implements GenerateAOT.Provider {

        static final ReferenceField<RecursiveObject0Data> RECURSIVE_OBJECT0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "recursiveObject0_cache", RecursiveObject0Data.class);
        static final ReferenceField<RecursiveArray0Data> RECURSIVE_ARRAY0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "recursiveArray0_cache", RecursiveArray0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link MakeAccessLocation#doValue}
         *   2: SpecializationActive {@link MakeAccessLocation#doRecursiveObject}
         *   3: SpecializationActive {@link MakeAccessLocation#doRecursiveObject}
         *   4: SpecializationActive {@link MakeAccessLocation#doRecursiveArray}
         *   5: SpecializationActive {@link MakeAccessLocation#doRecursiveArray}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private RecursiveObject0Data recursiveObject0_cache;
        @Child private RecursiveObject1Data recursiveObject1_cache;
        @UnsafeAccessedField @Child private RecursiveArray0Data recursiveArray0_cache;
        @Child private RecursiveArray1Data recursiveArray1_cache;

        private MakeAccessLocationNodeGen() {
        }

        @ExplodeLoop
        @Override
        protected AccessLocation execute(Object arg0Value, Object arg1Value, LLVMInteropType arg2Value, long arg3Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }
            if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doValue(Object, Object, Value, long)] || SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveObject(Object, String, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] || SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveObject(Object, String, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] || SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveArray(Object, long, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] || SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveArray(Object, long, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doValue(Object, Object, Value, long)] */ && arg2Value instanceof Value) {
                    Value arg2Value_ = (Value) arg2Value;
                    return doValue(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                if ((state_0 & 0b111100) != 0 /* is SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveObject(Object, String, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] || SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveObject(Object, String, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] || SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveArray(Object, long, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] || SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveArray(Object, long, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */ && arg2Value instanceof Structured) {
                    Structured arg2Value_ = (Structured) arg2Value;
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveObject(Object, String, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] || SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveObject(Object, String, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */ && arg1Value instanceof String) {
                        String arg1Value_ = (String) arg1Value;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveObject(Object, String, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */) {
                            RecursiveObject0Data s1_ = this.recursiveObject0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(arg0Value))) {
                                    return doRecursiveObject(arg0Value, arg1Value_, arg2Value_, arg3Value, s1_.interop_, s1_.recursive_, s1_.notFound_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveObject(Object, String, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */) {
                            RecursiveObject1Data s2_ = this.recursiveObject1_cache;
                            if (s2_ != null) {
                                return this.recursiveObject1Boundary(state_0, s2_, arg0Value, arg1Value_, arg2Value_, arg3Value);
                            }
                        }
                    }
                    if ((state_0 & 0b110000) != 0 /* is SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveArray(Object, long, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] || SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveArray(Object, long, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */ && arg1Value instanceof Long) {
                        long arg1Value_ = (long) arg1Value;
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveArray(Object, long, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */) {
                            RecursiveArray0Data s3_ = this.recursiveArray0_cache;
                            while (s3_ != null) {
                                if ((s3_.interop_.accepts(arg0Value))) {
                                    return doRecursiveArray(arg0Value, arg1Value_, arg2Value_, arg3Value, s3_.interop_, s3_.recursive_, s3_.notFound_);
                                }
                                s3_ = s3_.next_;
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveArray(Object, long, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */) {
                            RecursiveArray1Data s4_ = this.recursiveArray1_cache;
                            if (s4_ != null) {
                                return this.recursiveArray1Boundary(state_0, s4_, arg0Value, arg1Value_, arg2Value_, arg3Value);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private AccessLocation recursiveObject1Boundary(int state_0, RecursiveObject1Data s2_, Object arg0Value, String arg1Value_, Structured arg2Value_, long arg3Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return doRecursiveObject(arg0Value, arg1Value_, arg2Value_, arg3Value, interop__, s2_.recursive_, s2_.notFound_);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private AccessLocation recursiveArray1Boundary(int state_0, RecursiveArray1Data s4_, Object arg0Value, long arg1Value_, Structured arg2Value_, long arg3Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return doRecursiveArray(arg0Value, arg1Value_, arg2Value_, arg3Value, interop__1, s4_.recursive_, s4_.notFound_);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private AccessLocation executeAndSpecialize(Object arg0Value, Object arg1Value, LLVMInteropType arg2Value, long arg3Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (arg2Value instanceof Value) {
                Value arg2Value_ = (Value) arg2Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doValue(Object, Object, Value, long)] */;
                this.state_0_ = state_0;
                return doValue(arg0Value, arg1Value, arg2Value_, arg3Value);
            }
            if (arg2Value instanceof Structured) {
                Structured arg2Value_ = (Structured) arg2Value;
                if (arg1Value instanceof String) {
                    String arg1Value_ = (String) arg1Value;
                    if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveObject(Object, String, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */) {
                        while (true) {
                            int count1_ = 0;
                            RecursiveObject0Data s1_ = RECURSIVE_OBJECT0_CACHE_UPDATER.getVolatile(this);
                            RecursiveObject0Data s1_original = s1_;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(arg0Value))) {
                                    break;
                                }
                                count1_++;
                                s1_ = s1_.next_;
                            }
                            if (s1_ == null) {
                                // assert (s1_.interop_.accepts(arg0Value));
                                if (count1_ < (3)) {
                                    s1_ = this.insert(new RecursiveObject0Data(s1_original));
                                    InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                                    Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s1_.interop_ = interop__;
                                    s1_.recursive_ = s1_.insert((LLVMInteropAccessNode.create()));
                                    BranchProfile notFound__ = (BranchProfile.create());
                                    Objects.requireNonNull(notFound__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s1_.notFound_ = notFound__;
                                    if (!RECURSIVE_OBJECT0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveObject(Object, String, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s1_ != null) {
                                return doRecursiveObject(arg0Value, arg1Value_, arg2Value_, arg3Value, s1_.interop_, s1_.recursive_, s1_.notFound_);
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                RecursiveObject1Data s2_ = this.insert(new RecursiveObject1Data());
                                interop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                                s2_.recursive_ = s2_.insert((LLVMInteropAccessNode.create()));
                                BranchProfile notFound__ = (BranchProfile.create());
                                Objects.requireNonNull(notFound__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s2_.notFound_ = notFound__;
                                VarHandle.storeStoreFence();
                                this.recursiveObject1_cache = s2_;
                                this.recursiveObject0_cache = null;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveObject(Object, String, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveObject(Object, String, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */;
                                this.state_0_ = state_0;
                                return doRecursiveObject(arg0Value, arg1Value_, arg2Value_, arg3Value, interop__, s2_.recursive_, notFound__);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveArray(Object, long, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */) {
                        while (true) {
                            int count3_ = 0;
                            RecursiveArray0Data s3_ = RECURSIVE_ARRAY0_CACHE_UPDATER.getVolatile(this);
                            RecursiveArray0Data s3_original = s3_;
                            while (s3_ != null) {
                                if ((s3_.interop_.accepts(arg0Value))) {
                                    break;
                                }
                                count3_++;
                                s3_ = s3_.next_;
                            }
                            if (s3_ == null) {
                                // assert (s3_.interop_.accepts(arg0Value));
                                if (count3_ < (3)) {
                                    s3_ = this.insert(new RecursiveArray0Data(s3_original));
                                    InteropLibrary interop__1 = s3_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                                    Objects.requireNonNull(interop__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s3_.interop_ = interop__1;
                                    s3_.recursive_ = s3_.insert((LLVMInteropAccessNode.create()));
                                    BranchProfile notFound__1 = (BranchProfile.create());
                                    Objects.requireNonNull(notFound__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s3_.notFound_ = notFound__1;
                                    if (!RECURSIVE_ARRAY0_CACHE_UPDATER.compareAndSet(this, s3_original, s3_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveArray(Object, long, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s3_ != null) {
                                return doRecursiveArray(arg0Value, arg1Value_, arg2Value_, arg3Value, s3_.interop_, s3_.recursive_, s3_.notFound_);
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__1 = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                RecursiveArray1Data s4_ = this.insert(new RecursiveArray1Data());
                                interop__1 = (INTEROP_LIBRARY_.getUncached(arg0Value));
                                s4_.recursive_ = s4_.insert((LLVMInteropAccessNode.create()));
                                BranchProfile notFound__1 = (BranchProfile.create());
                                Objects.requireNonNull(notFound__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s4_.notFound_ = notFound__1;
                                VarHandle.storeStoreFence();
                                this.recursiveArray1_cache = s4_;
                                this.recursiveArray0_cache = null;
                                state_0 = state_0 & 0xffffffef /* remove SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveArray(Object, long, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */;
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doRecursiveArray(Object, long, Structured, long, InteropLibrary, LLVMInteropAccessNode, BranchProfile)] */;
                                this.state_0_ = state_0;
                                return doRecursiveArray(arg0Value, arg1Value_, arg2Value_, arg3Value, interop__1, s4_.recursive_, notFound__1);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, arg3Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMInteropAccessNode.MakeAccessLocation.doValue(Object, Object, Value, long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException4LLLJ(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value);
        }

        @NeverDefault
        public static MakeAccessLocation create() {
            return new MakeAccessLocationNodeGen();
        }

        @NeverDefault
        public static MakeAccessLocation getUncached() {
            return MakeAccessLocationNodeGen.UNCACHED;
        }

        @GeneratedBy(MakeAccessLocation.class)
        @DenyReplace
        private static final class RecursiveObject0Data extends Node implements SpecializationDataNode {

            @Child RecursiveObject0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MakeAccessLocation#doRecursiveObject}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MakeAccessLocation#doRecursiveObject}
             *   Parameter: {@link LLVMInteropAccessNode} recursive</pre>
             */
            @Child LLVMInteropAccessNode recursive_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MakeAccessLocation#doRecursiveObject}
             *   Parameter: {@link BranchProfile} notFound</pre>
             */
            @CompilationFinal BranchProfile notFound_;

            RecursiveObject0Data(RecursiveObject0Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(MakeAccessLocation.class)
        @DenyReplace
        private static final class RecursiveObject1Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link MakeAccessLocation#doRecursiveObject}
             *   Parameter: {@link LLVMInteropAccessNode} recursive</pre>
             */
            @Child LLVMInteropAccessNode recursive_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MakeAccessLocation#doRecursiveObject}
             *   Parameter: {@link BranchProfile} notFound</pre>
             */
            @CompilationFinal BranchProfile notFound_;

            RecursiveObject1Data() {
            }

        }
        @GeneratedBy(MakeAccessLocation.class)
        @DenyReplace
        private static final class RecursiveArray0Data extends Node implements SpecializationDataNode {

            @Child RecursiveArray0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MakeAccessLocation#doRecursiveArray}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MakeAccessLocation#doRecursiveArray}
             *   Parameter: {@link LLVMInteropAccessNode} recursive</pre>
             */
            @Child LLVMInteropAccessNode recursive_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MakeAccessLocation#doRecursiveArray}
             *   Parameter: {@link BranchProfile} notFound</pre>
             */
            @CompilationFinal BranchProfile notFound_;

            RecursiveArray0Data(RecursiveArray0Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(MakeAccessLocation.class)
        @DenyReplace
        private static final class RecursiveArray1Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link MakeAccessLocation#doRecursiveArray}
             *   Parameter: {@link LLVMInteropAccessNode} recursive</pre>
             */
            @Child LLVMInteropAccessNode recursive_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MakeAccessLocation#doRecursiveArray}
             *   Parameter: {@link BranchProfile} notFound</pre>
             */
            @CompilationFinal BranchProfile notFound_;

            RecursiveArray1Data() {
            }

        }
        @GeneratedBy(MakeAccessLocation.class)
        @DenyReplace
        private static final class Uncached extends MakeAccessLocation implements UnadoptableNode {

            @TruffleBoundary
            @Override
            protected AccessLocation execute(Object arg0Value, Object arg1Value, LLVMInteropType arg2Value, long arg3Value) {
                if (arg2Value instanceof Value) {
                    Value arg2Value_ = (Value) arg2Value;
                    return doValue(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Structured) {
                    Structured arg2Value_ = (Structured) arg2Value;
                    if (arg1Value instanceof String) {
                        String arg1Value_ = (String) arg1Value;
                        return doRecursiveObject(arg0Value, arg1Value_, arg2Value_, arg3Value, (INTEROP_LIBRARY_.getUncached(arg0Value)), (LLVMInteropAccessNodeGen.getUncached()), (BranchProfile.getUncached()));
                    }
                    if (arg1Value instanceof Long) {
                        long arg1Value_ = (long) arg1Value;
                        return doRecursiveArray(arg0Value, arg1Value_, arg2Value_, arg3Value, (INTEROP_LIBRARY_.getUncached(arg0Value)), (LLVMInteropAccessNodeGen.getUncached()), (BranchProfile.getUncached()));
                    }
                }
                throw newUnsupportedSpecializationException4LLLJ(this, arg0Value, arg1Value, arg2Value, arg3Value);
            }

        }
    }
}
